/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.post11510;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JTree;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.DBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepFilter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepGenericTreeModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepTreeExpansionListener;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepCustomAPIsInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepCustomObjectsInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepCustomXGMInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepGenericTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepInDirNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepOpenInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepOtherInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepOutDirNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepProductFamiliesNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepProductNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepWFEventsInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.post11510.LocalIRepDBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.StringUtil;

public class LocalIRepTreeMaker {
    public static JTree getTree() {
        IRepGenericTreeModel treeModel = LocalIRepTreeMaker.getIRepTreeModel();
        JTree tree = new JTree(treeModel);
        tree.addTreeExpansionListener(new IRepTreeExpansionListener(treeModel));
        return tree;
    }

    public static IRepGenericTreeModel getIRepTreeModel() {
        IRepProductFamiliesNode rootNode = new IRepProductFamiliesNode("ProductFamilies", "ProductFamilies", null, null);
        IRepGenericTreeNode[] temp = LocalIRepTreeMaker.getProductFamilies(rootNode);
        rootNode.children = temp;
        return new IRepGenericTreeModel(rootNode);
    }

    public static IRepGenericTreeNode[] getProductFamilies(IRepGenericTreeNode rootNode) {
        IRepGenericTreeNode[] temp = LocalIRepDBAccess.getProductFamilies(rootNode);
        int len = temp.length;
        IRepGenericTreeNode[] pf = new IRepGenericTreeNode[len + 1];
        System.arraycopy(temp, 0, pf, 0, len);
        pf[len] = new IRepOtherInterfaceNode("Other Interfaces", "Other Interfaces", null, rootNode);
        return pf;
    }

    public static final IRepGenericTreeNode[] getProducts(IRepGenericTreeNode rootNode) {
        return LocalIRepDBAccess.getProducts(rootNode);
    }

    public static IRepGenericTreeNode[] getEntities(IRepProductNode rootNode) {
        return LocalIRepDBAccess.getEntities(rootNode);
    }

    public static IRepGenericTreeNode[] getInterfaces(IRepGenericTreeNode parent) {
        IRepGenericTreeNode[] interfaces = new IRepGenericTreeNode[]{new IRepGenericTreeNode("XMLGateway", "XMLGateway", null, parent){

            @Override
            public void loadChildren() {
                this.children = LocalIRepDBAccess.getXMLG(this.parent);
            }

            @Override
            public Icon getIcon() {
                return TABLES_ICON;
            }
        }, new IRepGenericTreeNode("EDI", "EDI", null, parent){

            @Override
            public void loadChildren() {
                this.children = LocalIRepDBAccess.getEDI(this.parent, null);
            }

            @Override
            public Icon getIcon() {
                return TABLES_ICON;
            }
        }, new IRepGenericTreeNode("PLSQL", "PLSQL", null, parent){

            @Override
            public void loadChildren() {
                this.children = LocalIRepDBAccess.getPLSQLPackages(this.parent);
            }

            @Override
            public Icon getIcon() {
                return TABLES_ICON;
            }
        }, new IRepGenericTreeNode("OpenInterfaces", "OpenInterfaces", null, parent){

            @Override
            public void loadChildren() {
                this.children = LocalIRepDBAccess.getOI(this.parent);
            }

            @Override
            public Icon getIcon() {
                return TABLES_ICON;
            }
        }, new IRepGenericTreeNode("CONCURRENT_PROGRAMS", "CONCURRENT_PROGRAMS", null, parent){

            @Override
            public void loadChildren() {
                this.children = LocalIRepDBAccess.getStandaloneCPs(this.parent);
            }

            @Override
            public Icon getIcon() {
                return TABLES_ICON;
            }
        }, new IRepGenericTreeNode("INTERFACE_VIEWS", "INTERFACE_VIEWS", null, parent){

            @Override
            public void loadChildren() {
                this.children = LocalIRepDBAccess.getStandaloneIViews(this.parent);
            }

            @Override
            public Icon getIcon() {
                return TABLES_ICON;
            }
        }};
        return interfaces;
    }

    public static IRepGenericTreeNode[] getOIInterfaces(IRepOpenInterfaceNode parent) {
        IRepGenericTreeNode[] interfaces = new IRepGenericTreeNode[]{LocalIRepDBAccess.getInterfaceTables(parent, null), LocalIRepDBAccess.getInterfaceViews(parent, null), LocalIRepDBAccess.getInterfaceCPs(parent, null)};
        return interfaces;
    }

    public static IRepGenericTreeModel getSearchTreeModel(IRepFilter filter) {
        String rawObjName = StringUtil.replaceAll(filter.getObjectName(), "\\_", "_");
        IRepGenericTreeNode rootNode = new IRepGenericTreeNode(rawObjName, rawObjName, null, null);
        LocalIRepTreeMaker.getSearchTree(filter, rootNode);
        return new IRepGenericTreeModel(rootNode);
    }

    private static void getSearchTree(IRepFilter filter, IRepGenericTreeNode rootNode) {
        System.out.println("Inside get search tree for live connection");
        IRepGenericTreeNode[] ret = new IRepGenericTreeNode[]{};
        ret = LocalIRepDBAccess.searchAPIs(rootNode, filter);
        IRepGenericTreeNode othersNode = LocalIRepTreeMaker.addOtherInterfaces(filter, rootNode);
        IRepGenericTreeNode[] pf = null;
        int len = ret.length;
        if (othersNode != null) {
            pf = new IRepGenericTreeNode[len + 1];
            System.arraycopy(ret, 0, pf, 0, len);
            pf[len] = othersNode;
        } else {
            pf = ret;
        }
        rootNode.children = pf;
    }

    private static IRepGenericTreeNode addOtherInterfaces(IRepFilter filter, IRepGenericTreeNode root) {
        ArrayList<IRepGenericTreeNode> v;
        String objName = StringUtil.replaceAll(filter.getObjectName(), "\\_", "_").toUpperCase();
        IRepGenericTreeNode otherInterfacesNode = new IRepGenericTreeNode("Other Interfaces", "Other Interfaces", null, root);
        IRepGenericTreeNode wfEventsNode = new IRepGenericTreeNode("Business Events", "Business Events", null, otherInterfacesNode);
        IRepGenericTreeNode wfEventsINNode = new IRepGenericTreeNode("Inbound(Raise Business Events into Oracle Apps)", "Inbound(Raise Business Events into Oracle Apps)", null, wfEventsNode);
        IRepGenericTreeNode wfEventsOUTNode = new IRepGenericTreeNode("Outbound(Listen to Business Events from Oracle Apps)", "Outbound(Listen to Business Events from Oracle Apps)", null, wfEventsNode);
        IRepGenericTreeNode customObjectsNode = new IRepGenericTreeNode("Custom Objects", "Custom Objects", null, otherInterfacesNode);
        IRepGenericTreeNode customPLSQLNode = new IRepGenericTreeNode("PLSQL APIs", "PLSQL APIs", null, customObjectsNode);
        IRepGenericTreeNode customXMLGNode = new IRepGenericTreeNode("XMLGateway Maps", "XMLGateway Maps", null, customObjectsNode);
        IRepGenericTreeNode customXMLGINNode = new IRepGenericTreeNode("Inbound", "Inbound", null, customXMLGNode);
        IRepGenericTreeNode customXMLGOUTNode = new IRepGenericTreeNode("Outbound", "Outbound", null, customXMLGNode);
        boolean foundotherInterfacesNode = false;
        boolean foundwfEventsNode = false;
        boolean foundwfEventsINNode = false;
        boolean foundwfEventsOUTNode = false;
        boolean foundcustomObjectsNode = false;
        boolean foundcustomPLSQLNode = false;
        boolean foundcustomXMLGNode = false;
        boolean foundcustomXMLGINNode = false;
        boolean foundcustomXMLGOUTNode = false;
        if (filter.isWfEventSelected()) {
            IRepGenericTreeNode[] inboundchildren = DBAccess.getWFEvents(wfEventsINNode, "INBOUND", "search_mode", objName);
            IRepGenericTreeNode[] outboundchildren = DBAccess.getWFEvents(wfEventsOUTNode, "OUTBOUND", "search_mode", objName);
            foundwfEventsINNode = inboundchildren != null && inboundchildren.length > 0;
            foundwfEventsOUTNode = outboundchildren != null && outboundchildren.length > 0;
            wfEventsINNode.children = inboundchildren;
            wfEventsOUTNode.children = outboundchildren;
            v = new ArrayList();
            if (foundwfEventsINNode) {
                v.add(wfEventsINNode);
            }
            if (foundwfEventsOUTNode) {
                v.add(wfEventsOUTNode);
            }
            if (v.size() > 0) {
                wfEventsNode.children = new IRepGenericTreeNode[v.size()];
                v.toArray(wfEventsNode.children);
                foundwfEventsNode = true;
            }
        }
        if (filter.isPackageSelected()) {
            IRepGenericTreeNode[] plsqlchildren = DBAccess.getPackages("search_mode", objName, customPLSQLNode);
            foundcustomPLSQLNode = plsqlchildren != null && plsqlchildren.length > 0;
            customPLSQLNode.children = plsqlchildren;
            if (foundcustomPLSQLNode) {
                IRepGenericTreeNode[] children = new IRepGenericTreeNode[]{customPLSQLNode};
                customObjectsNode.children = children;
                foundcustomObjectsNode = true;
            }
        }
        if (filter.isXmlMapSelected()) {
            IRepGenericTreeNode[] inboundMaps = LocalIRepDBAccess.searchOtherMaps(customXMLGINNode, objName, "Inbound");
            IRepGenericTreeNode[] outboundMaps = LocalIRepDBAccess.searchOtherMaps(customXMLGOUTNode, objName, "Outbound");
            foundcustomXMLGINNode = inboundMaps != null && inboundMaps.length > 0;
            foundcustomXMLGOUTNode = outboundMaps != null && outboundMaps.length > 0;
            v = new ArrayList<IRepGenericTreeNode>();
            if (foundcustomXMLGINNode) {
                v.add(customXMLGINNode);
                customXMLGINNode.children = inboundMaps;
            }
            if (foundcustomXMLGOUTNode) {
                v.add(customXMLGOUTNode);
                customXMLGOUTNode.children = outboundMaps;
            }
            if (v.size() > 0) {
                foundcustomXMLGNode = true;
                customXMLGNode.children = new IRepGenericTreeNode[v.size()];
                v.toArray(customXMLGNode.children);
            }
        }
        ArrayList<IRepGenericTreeNode> v2 = new ArrayList<IRepGenericTreeNode>();
        if (foundcustomPLSQLNode) {
            v2.add(customPLSQLNode);
        }
        if (foundcustomXMLGNode) {
            v2.add(customXMLGNode);
        }
        if (v2.size() > 0) {
            customObjectsNode.children = new IRepGenericTreeNode[v2.size()];
            v2.toArray(customObjectsNode.children);
            foundcustomObjectsNode = true;
        }
        v2 = new ArrayList();
        if (foundwfEventsNode) {
            v2.add(wfEventsNode);
        }
        if (foundcustomObjectsNode) {
            v2.add(customObjectsNode);
        }
        if (v2.size() > 0) {
            otherInterfacesNode.children = new IRepGenericTreeNode[v2.size()];
            v2.toArray(otherInterfacesNode.children);
            foundotherInterfacesNode = true;
        }
        return foundotherInterfacesNode ? otherInterfacesNode : null;
    }

    public static IRepGenericTreeNode[] getOtherInterfaces(IRepOtherInterfaceNode parent) {
        IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[]{new IRepWFEventsInterfaceNode("Business Events", null, parent), new IRepCustomObjectsInterfaceNode("Custom Objects", "Custom Objects", null, parent)};
        return childrens;
    }

    public static IRepGenericTreeNode[] getCustomObjectsInterfaces(IRepCustomObjectsInterfaceNode parent) {
        IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[]{new IRepCustomAPIsInterfaceNode("PLSQL APIs", "PLSQL APIs", null, parent), new IRepCustomXGMInterfaceNode("XMLGateway Maps", "XMLGateway Maps", null, parent)};
        return childrens;
    }

    public static IRepGenericTreeNode[] getDirs(IRepGenericTreeNode parent) {
        IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[]{new IRepInDirNode("Inbound", "Inbound", null, parent), new IRepOutDirNode("Outbound", "Outbound", null, parent)};
        return childrens;
    }
}

