/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.post11510;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.jdbc.OracleResultSet;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.ConnectionPool;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.DBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.ProcedureParam;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.SchemaObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepFilter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepEntityNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepExtraProcedureNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepGenericTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepInDirNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepMapNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepOpenInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepOutDirNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepPackageNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepProcedureNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepProductFamilyNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepProductNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepTableNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepViewNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.BgThread;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.IREPExtractor;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.MiscCPThread;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.MiscViewThread;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.PLSQLPackageThread;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.StringUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.XMLGThread;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocalIRepDBAccess
extends DBAccess {
    private static String getProductFamilies_q;
    private static String getProducts_q;
    private static String getEntities_q;
    private static String getXMLG_q;
    private static String getPLSQL_q;
    private static String getProcedure_q;
    private static String isOverloaded_q;
    private static String getParameters_q;
    private static String getOpenInterfaces_q;
    private static String getInterfaceCP_q;
    private static String getInterfaceTable_q;
    private static String getInterfaceView_q;
    private static String getStandaloneCP_q;
    private static String getStandaloneView_q;
    private static String searchPF_q;
    private static String searchProduct_q;
    private static String searchEntity_q;
    private static String searchInterfaceCP_q;
    private static String searchInterfaceApi_q;
    private static String searchInterfaceTableApi_q;
    private static String searchInterfaceViewApi_q;
    private static String searchInterfaceCPApi_q;
    private static String searchEDIApi_q;
    private static PreparedStatement getProductFamilies_ps;
    private static PreparedStatement getProducts_ps;
    private static PreparedStatement getEntities_ps;
    private static PreparedStatement getXMLG_ps;
    private static PreparedStatement getPLSQL_ps;
    private static PreparedStatement getProcedure_ps;
    private static PreparedStatement isOverloaded_ps;
    private static PreparedStatement getParameters_ps;
    private static PreparedStatement getOpenInterfaces_ps;
    private static PreparedStatement getInterfaceCP_ps;
    private static PreparedStatement getInterfaceTable_ps;
    private static PreparedStatement getInterfaceView_ps;
    private static PreparedStatement getStandaloneCP_ps;
    private static PreparedStatement getStandaloneView_ps;
    private static boolean init;
    private static HashSet hs;
    public static BgThread bgThread;
    private static ConnectionPool cPool;
    public static HashMap<String, Integer> iRepPackages;
    public static ArrayList iRepINMaps;
    public static ArrayList iRepOUTMaps;
    private static ArrayList extraMapsPresentOut;
    private static ArrayList extraMapsPresentIn;

    public static synchronized void initQueries() throws Exception {
        if (init) {
            return;
        }
        URL fileURL = IREPExtractor.class.getClassLoader().getResource("oracle/tip/tools/ide/pm/modules/bizintegration/adapter/apps/data/IRepQueries.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document queryDoc = builder.parse(fileURL.openStream());
        getProductFamilies_q = ((Element)((Element)queryDoc.getElementsByTagName("PRODUCT_FAMILY").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getProducts_q = ((Element)((Element)queryDoc.getElementsByTagName("PRODUCT").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getEntities_q = ((Element)((Element)queryDoc.getElementsByTagName("BUSINESS_ENTITY").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getXMLG_q = ((Element)((Element)queryDoc.getElementsByTagName("XMLGATEWAY").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getPLSQL_q = ((Element)((Element)queryDoc.getElementsByTagName("PLSQL").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        isOverloaded_q = ((Element)((Element)queryDoc.getElementsByTagName("ISOVERLOADED").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getParameters_q = ((Element)((Element)queryDoc.getElementsByTagName("API_PARAMETER").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getProcedure_q = ((Element)((Element)queryDoc.getElementsByTagName("PROCEDURE").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getOpenInterfaces_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getInterfaceCP_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE_CP").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getInterfaceTable_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE_TABLE").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getInterfaceView_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE_VIEW").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getStandaloneCP_q = ((Element)((Element)queryDoc.getElementsByTagName("STANDALONE_CP").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        getStandaloneView_q = ((Element)((Element)queryDoc.getElementsByTagName("STANDALONE_INTERFACE_VIEW").item(0)).getElementsByTagName("QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        searchPF_q = ((Element)((Element)queryDoc.getElementsByTagName("PRODUCT_FAMILY").item(0)).getElementsByTagName("SEARCH_QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        searchProduct_q = ((Element)((Element)queryDoc.getElementsByTagName("PRODUCT").item(0)).getElementsByTagName("SEARCH_QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        searchEntity_q = ((Element)((Element)queryDoc.getElementsByTagName("BUSINESS_ENTITY").item(0)).getElementsByTagName("SEARCH_QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        searchInterfaceCP_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE_CP").item(0)).getElementsByTagName("SEARCH_QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        searchInterfaceTableApi_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE_TABLE").item(0)).getElementsByTagName("SEARCH_QUERY2").item(0)).getChildNodes().item(0).getNodeValue();
        searchInterfaceViewApi_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE_VIEW").item(0)).getElementsByTagName("SEARCH_QUERY2").item(0)).getChildNodes().item(0).getNodeValue();
        searchInterfaceApi_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE").item(0)).getElementsByTagName("SEARCH_QUERY2").item(0)).getChildNodes().item(0).getNodeValue();
        searchInterfaceCPApi_q = ((Element)((Element)queryDoc.getElementsByTagName("OPEN_INTERFACE_CP").item(0)).getElementsByTagName("SEARCH_QUERY2").item(0)).getChildNodes().item(0).getNodeValue();
        searchEDIApi_q = ((Element)((Element)queryDoc.getElementsByTagName("EDI").item(0)).getElementsByTagName("SEARCH_QUERY").item(0)).getChildNodes().item(0).getNodeValue();
        if (connection != null) {
            getProductFamilies_ps = connection.prepareStatement(getProductFamilies_q);
            getProducts_ps = connection.prepareStatement(getProducts_q);
            getEntities_ps = connection.prepareStatement(getEntities_q);
            getXMLG_ps = connection.prepareStatement(getXMLG_q);
            getPLSQL_ps = connection.prepareStatement(getPLSQL_q);
            getProcedure_ps = connection.prepareStatement(getProcedure_q);
            isOverloaded_ps = connection.prepareStatement(isOverloaded_q);
            getParameters_ps = connection.prepareStatement(getParameters_q);
            getOpenInterfaces_ps = connection.prepareStatement(getOpenInterfaces_q);
            getInterfaceCP_ps = connection.prepareStatement(getInterfaceCP_q);
            getInterfaceTable_ps = connection.prepareStatement(getInterfaceTable_q);
            getInterfaceView_ps = connection.prepareStatement(getInterfaceView_q);
            getStandaloneCP_ps = connection.prepareStatement(getStandaloneCP_q);
            getStandaloneView_ps = connection.prepareStatement(getStandaloneView_q);
        }
        LocalIRepDBAccess.initializeEDI();
        init = true;
    }

    public ArrayList getPLSQLPkgsFromDB(String searchString, IRepGenericTreeNode rootNode) {
        return null;
    }

    public ArrayList getEcxMapsFromDB(String searchString) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IRepGenericTreeNode[] getProductFamilies(IRepGenericTreeNode rootNode) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ResultSet rs = null;
        ArrayList<IRepProductFamilyNode> v = new ArrayList<IRepProductFamilyNode>();
        IRepProductFamilyNode[] nodes = null;
        try {
            long start = System.currentTimeMillis();
            rs = getProductFamilies_ps.executeQuery();
            System.out.println("time to execute query = " + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds");
            while (rs.next()) {
                String shortName = rs.getString(1);
                String fullName = rs.getString(2);
                v.add(new IRepProductFamilyNode(shortName, fullName, null, rootNode));
            }
            nodes = new IRepProductFamilyNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepProductFamilyNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in addProductFamilies");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IRepGenericTreeNode[] getProducts(IRepGenericTreeNode rootNode) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ResultSet rs = null;
        ArrayList<IRepProductNode> v = new ArrayList<IRepProductNode>();
        IRepGenericTreeNode[] nodes = null;
        try {
            getProducts_ps.setString(1, rootNode.shortName);
            rs = getProducts_ps.executeQuery();
            while (rs.next()) {
                String shortName = rs.getString(1);
                String fullName = rs.getString(2);
                v.add(new IRepProductNode(shortName, fullName, rootNode));
            }
            nodes = new IRepProductNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepProductNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getProducts");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] getEntities(IRepGenericTreeNode rootNode) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ResultSet rs = null;
        ArrayList<IRepEntityNode> v = new ArrayList<IRepEntityNode>();
        IRepEntityNode[] nodes = null;
        try {
            getEntities_ps.setString(1, rootNode.shortName);
            getEntities_ps.setString(2, rootNode.shortName);
            rs = getEntities_ps.executeQuery();
            while (rs.next()) {
                String shortName = rs.getString(1);
                String fullName = rs.getString(2);
                v.add(new IRepEntityNode(shortName, fullName, null, rootNode));
            }
            nodes = new IRepEntityNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepEntityNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getEntities");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] getXMLG(IRepGenericTreeNode parent) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ResultSet rs = null;
        ArrayList<IRepMapNode> v = new ArrayList<IRepMapNode>();
        IRepMapNode[] nodes = null;
        String iface = "XMLGATEWAY";
        String entityName = parent.shortName;
        try {
            getXMLG_ps.setString(1, iface);
            getXMLG_ps.setString(2, entityName);
            getXMLG_ps.setString(3, entityName);
            rs = getXMLG_ps.executeQuery();
            while (rs.next()) {
                String mapCode = rs.getString(1);
                String fullName = rs.getString(2);
                String direction = rs.getString(3);
                String description = rs.getString(4);
                v.add(new IRepMapNode(mapCode, fullName, description, direction, null, parent));
            }
            nodes = new IRepMapNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepMapNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getXMLG");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] getEDI(IRepGenericTreeNode parent, String searchString) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ResultSet rs = null;
        ResultSet inner = null;
        ArrayList<IRepProcedureNode> v = new ArrayList<IRepProcedureNode>();
        IRepProcedureNode[] nodes = null;
        String entityName = parent.shortName;
        PreparedStatement ps = null;
        try {
            getOpenInterfaces_ps.setString(1, entityName);
            getOpenInterfaces_ps.setString(2, entityName);
            rs = getOpenInterfaces_ps.executeQuery();
            while (rs.next()) {
                int classid = rs.getInt(1);
                if (searchString != null && !searchString.equals("")) {
                    ps = connection.prepareStatement(searchInterfaceCP_q);
                    ps.setInt(1, classid);
                    ps.setString(2, searchString);
                } else {
                    ps = getInterfaceCP_ps;
                    ps.setInt(1, classid);
                }
                inner = ps.executeQuery();
                while (inner.next()) {
                    String shortName = inner.getString(1);
                    String fullName = inner.getString(2);
                    String description = inner.getString(3);
                    if (!hs.contains(shortName)) continue;
                    v.add(new IRepProcedureNode(shortName, fullName, description, null, parent, "CONCURRENT_PROGRAM", 0));
                }
            }
            nodes = new IRepProcedureNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepProcedureNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getEDI");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                if (inner != null) {
                    inner.close();
                }
            }
            catch (Exception ex) {}
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getEDIApis(String searchString) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        Connection conn = null;
        Statement ps = null;
        ResultSet rset = null;
        ArrayList<String> ediApis = new ArrayList<String>();
        try {
            conn = LocalIRepDBAccess.getConnPool().getConnection();
            StringBuffer ediQuery = new StringBuffer(searchEDIApi_q);
            ediQuery.append("\n AND FndIrepDocumentsInterfacesEO.IREP_NAME in (");
            Iterator ediApisIt = hs.iterator();
            while (ediApisIt.hasNext()) {
                ediQuery.append(" '" + ediApisIt.next() + "',");
            }
            ediQuery.deleteCharAt(ediQuery.length() - 1);
            ediQuery.append(")\n");
            ps = conn.prepareStatement(ediQuery.toString());
            ps.setString(1, searchString);
            rset = ps.executeQuery();
            while (rset.next()) {
                ediApis.add(rset.getString(2));
                ediApis.add(rset.getString(3));
                ediApis.add(rset.getString(4));
                ediApis.add(rset.getString(5));
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        finally {
            try {
                rset.close();
                ps.close();
            }
            catch (SQLException sqle) {}
            LocalIRepDBAccess.getConnPool().free(conn);
        }
        return ediApis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] getPLSQLPackages(IRepGenericTreeNode parent) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ResultSet rs = null;
        ArrayList<IRepPackageNode> v = new ArrayList<IRepPackageNode>();
        IRepPackageNode[] nodes = null;
        String iface = "PLSQL";
        String entityName = parent.shortName;
        try {
            getPLSQL_ps.setString(1, iface);
            getPLSQL_ps.setString(2, entityName);
            getPLSQL_ps.setString(3, entityName);
            rs = getPLSQL_ps.executeQuery();
            while (rs.next()) {
                int classId = rs.getInt(1);
                String packageName = rs.getString(2);
                String fullName = rs.getString(3);
                String description = rs.getString(4);
                v.add(new IRepPackageNode(packageName, fullName, description, null, parent, classId));
            }
            nodes = new IRepPackageNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepPackageNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getPLSQLPackages");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] getOI(IRepGenericTreeNode parent) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ResultSet rs = null;
        ArrayList<IRepOpenInterfaceNode> v = new ArrayList<IRepOpenInterfaceNode>();
        IRepOpenInterfaceNode[] nodes = null;
        String entityName = parent.shortName;
        try {
            getOpenInterfaces_ps.setString(1, entityName);
            getOpenInterfaces_ps.setString(2, entityName);
            rs = getOpenInterfaces_ps.executeQuery();
            while (rs.next()) {
                int classid = rs.getInt(1);
                String shortName = rs.getString(2);
                String fullName = rs.getString(3);
                String description = rs.getString(4);
                v.add(new IRepOpenInterfaceNode(shortName, fullName, description, null, parent, classid));
            }
            nodes = new IRepOpenInterfaceNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepOpenInterfaceNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getOI");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] getStandaloneCPs(IRepGenericTreeNode parent) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ResultSet rs = null;
        ArrayList<IRepProcedureNode> v = new ArrayList<IRepProcedureNode>();
        IRepProcedureNode[] nodes = null;
        String entityName = parent.shortName;
        try {
            getStandaloneCP_ps.setString(1, entityName);
            getStandaloneCP_ps.setString(2, entityName);
            rs = getStandaloneCP_ps.executeQuery();
            while (rs.next()) {
                String shortName = rs.getString(1);
                String fullName = rs.getString(2);
                String description = rs.getString(3);
                v.add(new IRepProcedureNode(shortName, fullName, description, null, parent, "CONCURRENT_PROGRAM", 0));
            }
            nodes = new IRepProcedureNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepProcedureNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getStandAloneCP");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] getStandaloneIViews(IRepGenericTreeNode parent) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ResultSet rs = null;
        ArrayList<IRepViewNode> v = new ArrayList<IRepViewNode>();
        IRepViewNode[] nodes = null;
        String entityName = parent.shortName;
        try {
            getStandaloneView_ps.setString(1, entityName);
            getStandaloneView_ps.setString(2, entityName);
            rs = getStandaloneView_ps.executeQuery();
            while (rs.next()) {
                String shortName = rs.getString(1);
                String fullName = rs.getString(2);
                String description = rs.getString(3);
                String schema = DBAccess.getAppsSchema();
                v.add(new IRepViewNode(shortName, fullName, description, schema, null, parent));
            }
            nodes = new IRepViewNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepViewNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getIViews");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return nodes;
    }

    public static final void initializeEDI() {
        String[] ediprogs = new String[]{"ECEGPOI", "ECEPOI875", "ECEINI", "ECCATI", "ECEPOCI", "ECEPOI", "ECERRQI", "ECASNI", "ECESBNI", "ECESPSI", "ECEPSQI", "ECESSSI", "ECEPOO", "ECEINO", "ECEPOCO", "ECSSSO", "ECEADVO", "ECSPSO", "ECECDMO", "ECMVSTO", "ECEGASNO", "ECEGPOAO", "ECEPOAO", "ECEPOCAO", "ECEDSNO"};
        hs = new HashSet();
        for (int i = 0; i < ediprogs.length; ++i) {
            hs.add(ediprogs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] getProcedures(IRepPackageNode parent) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ResultSet rs = null;
        ArrayList<IRepProcedureNode> v = new ArrayList<IRepProcedureNode>();
        IRepGenericTreeNode[] nodes = null;
        int classId = parent.getClassID();
        String pkgName = parent.shortName;
        try {
            getProcedure_ps.setInt(1, classId);
            rs = getProcedure_ps.executeQuery();
            while (rs.next()) {
                String fullName = rs.getString(1);
                String functionName = rs.getString(2);
                String description = rs.getString(3);
                int sequence = rs.getInt(4);
                int functionID = rs.getInt(5);
                int overload = LocalIRepDBAccess.isOverloaded(pkgName, functionName) ? sequence : 0;
                v.add(new IRepProcedureNode(functionName, fullName, description, null, parent, pkgName, overload, functionID));
            }
            nodes = new IRepProcedureNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepProcedureNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getIViews");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return nodes;
    }

    public static final boolean isOverloaded(String packageName, String functionName) throws Exception {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ResultSet rs = null;
        try {
            isOverloaded_ps.setString(1, packageName);
            isOverloaded_ps.setString(2, LocalIRepDBAccess.getAppsSchema());
            isOverloaded_ps.setString(3, LocalIRepDBAccess.getAppsSchema());
            isOverloaded_ps.setString(4, functionName);
            isOverloaded_ps.setString(5, packageName);
            rs = isOverloaded_ps.executeQuery();
            if (rs.next()) {
                if (rs.getInt(1) > 0) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in isOverloaded");
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcedureParam[] getProcAttributes(IRepProcedureNode procNode) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ProcedureParam[] params = null;
        ArrayList<ProcedureParam> v = new ArrayList<ProcedureParam>();
        ResultSet rs = null;
        Object param = null;
        int functionId = procNode.getFunctionID();
        int sequence = procNode.overload;
        String packageName = procNode.packageName;
        String functionName = procNode.shortName;
        try {
            getParameters_ps.setInt(1, functionId);
            getParameters_ps.setInt(2, sequence);
            getParameters_ps.setString(3, packageName);
            getParameters_ps.setString(4, LocalIRepDBAccess.getAppsSchema());
            getParameters_ps.setString(5, LocalIRepDBAccess.getAppsSchema());
            getParameters_ps.setString(6, functionName);
            getParameters_ps.setString(7, packageName);
            rs = getParameters_ps.executeQuery();
            while (rs.next()) {
                String paramName = rs.getString(1);
                String owner = rs.getString(2);
                String dataType = rs.getString(3);
                String type = rs.getString(4);
                String dir = rs.getString(5);
                int position = rs.getInt(6);
                int seq = rs.getInt(7);
                boolean out = dir.indexOf("OUT") >= 0;
                boolean in = dir.indexOf("IN") >= 0;
                SchemaObject otype = new SchemaObject(owner, type);
                SchemaObject eltype = null;
                if (!otype.isPrimitive()) {
                    eltype = DBAccess.getEltype(otype.getName(), otype.getSchema());
                }
                ProcedureParam col = new ProcedureParam(paramName, otype, eltype, in, out, dir, position, seq, dataType, 1);
                v.add(col);
            }
            if (v.size() > 0) {
                params = new ProcedureParam[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    params[i] = (ProcedureParam)v.get(i);
                }
            }
            ProcedureParam[] i = params;
            return i;
        }
        catch (Exception e) {
            System.out.println("Exception in getProcAttributes");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode getInterfaceTables(IRepOpenInterfaceNode parent, String searchString) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        IRepGenericTreeNode node = new IRepGenericTreeNode("Tables", "Tables", null, parent);
        ResultSet rs = null;
        ArrayList<IRepTableNode> v = new ArrayList<IRepTableNode>();
        IRepTableNode[] nodes = null;
        int classId = parent.getClassID();
        try {
            getInterfaceTable_ps.setInt(1, classId);
            rs = getInterfaceTable_ps.executeQuery();
            while (rs.next()) {
                String shortName;
                String fullName = shortName = rs.getString(1);
                String description = rs.getString(2);
                String owner = rs.getString(4);
                v.add(new IRepTableNode(shortName, fullName, description, owner, null, node));
            }
            nodes = new IRepTableNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepTableNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getIViews");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        node.children = nodes;
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode getInterfaceViews(IRepOpenInterfaceNode parent, String searchString) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        IRepGenericTreeNode node = new IRepGenericTreeNode("Views", "Views", null, parent);
        ResultSet rs = null;
        ArrayList<IRepViewNode> v = new ArrayList<IRepViewNode>();
        IRepViewNode[] nodes = null;
        int classId = parent.getClassID();
        try {
            getInterfaceView_ps.setInt(1, classId);
            rs = getInterfaceView_ps.executeQuery();
            while (rs.next()) {
                String shortName;
                String fullName = shortName = rs.getString(1);
                String description = rs.getString(2);
                String owner = DBAccess.getAppsSchema();
                v.add(new IRepViewNode(shortName, fullName, description, owner, null, node));
            }
            nodes = new IRepViewNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepViewNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getIViews");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        node.children = nodes;
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode getInterfaceCPs(IRepOpenInterfaceNode parent, String searchString) {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        IRepGenericTreeNode node = new IRepGenericTreeNode("ConcurrentPrograms", "ConcurrentPrograms", null, parent);
        ResultSet rs = null;
        ArrayList<IRepProcedureNode> v = new ArrayList<IRepProcedureNode>();
        IRepProcedureNode[] nodes = null;
        int classId = parent.getClassID();
        try {
            getInterfaceCP_ps.setInt(1, classId);
            rs = getInterfaceCP_ps.executeQuery();
            while (rs.next()) {
                String shortName;
                String fullName = shortName = rs.getString(1);
                String description = rs.getString(2);
                v.add(new IRepProcedureNode(shortName, fullName, description, null, node, "CONCURRENT_PROGRAM", 0));
            }
            nodes = new IRepProcedureNode[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                nodes[i] = (IRepProcedureNode)v.get(i);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getIViews");
            try {
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        node.children = nodes;
        return node;
    }

    public static void initBgJob(AdapterWizardContext context) {
        LocalIRepDBAccess.resetStaticStructures();
        bgThread = new BgThread(context);
        bgThread.start();
    }

    public static void cleanUp() {
        bgThread = null;
        cPool.closeAllConnections();
        cPool = null;
        LocalIRepDBAccess.resetStaticStructures();
    }

    public static ConnectionPool getConnPool() {
        return cPool;
    }

    public static void setConnPool(ConnectionPool pool) {
        cPool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createIRepPackagesList() {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Statement stmt = null;
        Connection conn = null;
        iRepPackages = new HashMap();
        try {
            conn = LocalIRepDBAccess.getConnPool().getConnection();
            stmt = conn.prepareStatement(getPLSQL_q);
            stmt.setString(1, "PLSQL");
            stmt.setString(2, "%");
            stmt.setString(3, "%");
            stmt.setFetchSize(1000);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int classId = rs.getInt(1);
                String packageName = rs.getString(2);
                iRepPackages.put(packageName, classId);
            }
        }
        catch (SQLException e) {
        }
        finally {
            try {
                stmt.close();
                LocalIRepDBAccess.getConnPool().free(conn);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void resetStaticStructures() {
        iRepPackages = null;
        iRepOUTMaps = null;
        iRepINMaps = null;
        extraMapsPresentIn = null;
        extraMapsPresentOut = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createIRepXmlgList() {
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Statement stmt = null;
        Connection conn = null;
        iRepINMaps = new ArrayList();
        iRepOUTMaps = new ArrayList();
        try {
            conn = LocalIRepDBAccess.getConnPool().getConnection();
            stmt = conn.prepareStatement(getXMLG_q);
            stmt.setString(1, "XMLGATEWAY");
            stmt.setString(2, "%");
            stmt.setString(3, "%");
            stmt.setFetchSize(1000);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String mapName = rs.getString(1);
                String direction = rs.getString(3);
                if (direction.equals("O")) {
                    iRepOUTMaps.add(mapName);
                    continue;
                }
                iRepINMaps.add(mapName);
            }
        }
        catch (SQLException e) {
        }
        finally {
            try {
                stmt.close();
                LocalIRepDBAccess.getConnPool().free(conn);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] getExtraPackagedProcs(String packageName, IRepGenericTreeNode parent) {
        ArrayList<Object> procSet = new ArrayList<Object>();
        ResultSet rs = null;
        LocalIRepDBAccess.waitForBgThread();
        if (iRepPackages.containsKey(packageName)) {
            int classId = iRepPackages.get(packageName);
            try {
                getProcedure_ps.setInt(1, classId);
                rs = getProcedure_ps.executeQuery();
                while (rs.next()) {
                    String fullName = rs.getString(1);
                    String functionName = rs.getString(2);
                    String description = rs.getString(3);
                    int sequence = rs.getInt(4);
                    int functionID = rs.getInt(5);
                    int overload = LocalIRepDBAccess.isOverloaded(packageName, functionName) ? sequence : 0;
                    procSet.add(functionName);
                    procSet.add(overload);
                }
            }
            catch (Exception e) {
                System.out.println("Exception");
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
        }
        rs = null;
        Statement stmt = null;
        try {
            String query = "select object_name, overload from all_arguments where object_id in (select object_id from user_objects where object_name=:1 and object_type='PACKAGE') group by object_name, overload order by object_name";
            ArrayList<IRepExtraProcedureNode> v = new ArrayList<IRepExtraProcedureNode>();
            stmt = connection.prepareStatement(query);
            LocalIRepDBAccess.traceQuery(query + ":" + packageName);
            stmt.setString(1, packageName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String overloadStr = rs.getString(2);
                int overload = 0;
                if (overloadStr != null) {
                    overload = Integer.valueOf(overloadStr);
                }
                String procName = rs.getString(1);
                boolean found = false;
                for (int i = 0; i < procSet.size(); i += 2) {
                    if (!procName.equals(procSet.get(i)) || !procSet.get(i + 1).equals("" + overload)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                v.add(new IRepExtraProcedureNode(procName, procName, " ", null, parent, packageName, overload));
            }
            if (v.size() > 0) {
                IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[]{};
                childrens = new IRepGenericTreeNode[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    childrens[i] = (IRepGenericTreeNode)v.get(i);
                }
                System.out.println("returning children");
                IRepGenericTreeNode[] i = childrens;
                return i;
            }
            IRepGenericTreeNode[] iRepGenericTreeNodeArray = null;
            return iRepGenericTreeNodeArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void waitForBgThread() {
        try {
            System.out.println("Waiting for background thread to end");
            if (bgThread != null) {
                bgThread.join();
            }
            System.out.println("background thread completed processing");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] searchOtherMaps(IRepGenericTreeNode parent, String objectName, String direction) {
        PreparedStatement stmt = null;
        OracleResultSet rs = null;
        int dir = -1;
        dir = direction.equalsIgnoreCase("Outbound") ? 1 : 2;
        HashSet<String> fromDB = new HashSet<String>();
        ArrayList result = new ArrayList();
        try {
            String query1 = "select map.map_code from ecx_mappings map, ecx_objects obj where obj.object_id=:1 and obj.object_type='DB' and map.map_id=obj.map_id and lower(map.map_code) like lower(:2) order by map.map_code";
            stmt = connection.prepareStatement(query1);
            LocalIRepDBAccess.traceQuery(query1 + ":" + dir + ":" + objectName);
            stmt.setInt(1, dir);
            stmt.setString(2, objectName);
            rs = (OracleResultSet)stmt.executeQuery();
            while (rs.next()) {
                String mapName = rs.getString(1);
                fromDB.add(mapName);
            }
            result = new ArrayList(fromDB);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList v_in = result;
        int size = v_in.size();
        String dir_s = dir == 1 ? "O" : "I";
        IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[size];
        int i = 0;
        int j = 0;
        for (i = 0; i < v_in.size(); ++i) {
            childrens[j++] = new IRepMapNode((String)v_in.get(i), (String)v_in.get(i), null, dir_s, null, parent);
        }
        System.out.println("searchOtherMaps : got children");
        return childrens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] getExtraMapsIn(IRepInDirNode parent) {
        if (extraMapsPresentIn == null) {
            LocalIRepDBAccess.waitForBgThread();
            Statement stmt = null;
            OracleResultSet rs = null;
            try {
                String mapName;
                StringBuffer query = new StringBuffer();
                query.append("select map.map_code from ecx_mappings map, ecx_objects obj ");
                query.append("where obj.object_id=2  and obj.object_type = 'DB' and obj.map_id ");
                query.append("= map.map_id and map.map_id in( ");
                query.append("select distinct map.map_id from ecx_mappings map, ecx_objects obj, ecx_dtds dtd where map.map_code not in ( ");
                for (int j = 0; j < iRepINMaps.size(); ++j) {
                    mapName = (String)iRepINMaps.get(j);
                    query.append("'" + mapName + "'");
                    if (j == iRepINMaps.size() - 1) continue;
                    query.append(", ");
                }
                query.append(" ) ");
                query.append("and map.map_id = obj.map_id ");
                query.append("and dtd.root_element = obj.root_element ");
                query.append("and obj.runtime_location = dtd.version ");
                query.append("and obj.fullpath = dtd.filename) ");
                query.append("order by map.map_code ");
                String query1 = query.toString();
                stmt = connection.createStatement();
                LocalIRepDBAccess.traceQuery(query1);
                rs = (OracleResultSet)stmt.executeQuery(query1);
                extraMapsPresentIn = new ArrayList();
                while (rs.next()) {
                    mapName = rs.getString(1);
                    extraMapsPresentIn.add(mapName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList v_in = extraMapsPresentIn;
        int size = v_in.size();
        IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[size];
        int i = 0;
        int j = 0;
        for (i = 0; i < v_in.size(); ++i) {
            childrens[j++] = new IRepMapNode((String)v_in.get(i), (String)v_in.get(i), null, "I", null, parent);
        }
        System.out.println("getExtraMaps: Maps Obtained In ");
        return childrens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepGenericTreeNode[] getExtraMapsOut(IRepOutDirNode parent) {
        if (extraMapsPresentOut == null) {
            LocalIRepDBAccess.waitForBgThread();
            Statement stmt = null;
            OracleResultSet rs = null;
            try {
                String mapName;
                StringBuffer query = new StringBuffer();
                query.append("select map.map_code from ecx_mappings map, ecx_objects obj ");
                query.append("where obj.object_id=1  and obj.object_type = 'DB' and obj.map_id ");
                query.append("= map.map_id and map.map_id in( ");
                query.append("select distinct map.map_id from ecx_mappings map, ecx_objects obj, ecx_dtds dtd where map.map_code not in ( ");
                for (int j = 0; j < iRepOUTMaps.size(); ++j) {
                    mapName = (String)iRepOUTMaps.get(j);
                    query.append("'" + mapName + "'");
                    if (j == iRepOUTMaps.size() - 1) continue;
                    query.append(", ");
                }
                query.append(" ) ");
                query.append("and map.map_id = obj.map_id ");
                query.append("and dtd.root_element = obj.root_element ");
                query.append("and obj.runtime_location = dtd.version ");
                query.append("and obj.fullpath = dtd.filename) ");
                query.append("order by map.map_code ");
                String query1 = query.toString();
                stmt = connection.createStatement();
                LocalIRepDBAccess.traceQuery(query1);
                rs = (OracleResultSet)stmt.executeQuery(query1);
                extraMapsPresentOut = new ArrayList();
                while (rs.next()) {
                    mapName = rs.getString(1);
                    extraMapsPresentOut.add(mapName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList v_out = extraMapsPresentOut;
        int size = v_out.size();
        IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[size];
        int i = 0;
        int j = 0;
        for (i = 0; i < v_out.size(); ++i) {
            childrens[j++] = new IRepMapNode((String)v_out.get(i), (String)v_out.get(i), null, "O", null, parent);
        }
        System.out.println("getExtraMaps: Maps Obtained Out ");
        return childrens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IRepGenericTreeNode[] searchAPIs(IRepGenericTreeNode rootNode, IRepFilter filter) {
        ResultSet rset;
        PreparedStatement ps;
        Connection conn;
        String lookupCode;
        String description;
        String fullName;
        String lookupCode2;
        String description2;
        String fullName2;
        String shortName;
        ArrayList<String> list;
        if (!init) {
            try {
                LocalIRepDBAccess.initQueries();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        String searchString = StringUtil.replaceAll(filter.getObjectName(), "\\_", "_").toUpperCase();
        XMLGThread xmlgO = null;
        MiscCPThread miscCPO = null;
        MiscViewThread miscViewO = null;
        PLSQLPackageThread plsqlO = null;
        Thread xmlgT = null;
        Thread miscCPT = null;
        Thread miscViewT = null;
        Thread plsqlT = null;
        if (LocalIRepDBAccess.getConnPool() == null) {
            LocalIRepDBAccess.waitForBgThread();
        }
        if (filter.isPackageSelected()) {
            plsqlO = new PLSQLPackageThread(searchString, LocalIRepDBAccess.getConnPool(), true);
            plsqlT = new Thread(plsqlO);
            plsqlT.start();
        }
        if (filter.isXmlMapSelected()) {
            xmlgO = new XMLGThread(searchString, LocalIRepDBAccess.getConnPool(), true);
            xmlgT = new Thread(xmlgO);
            xmlgT.start();
        }
        if (filter.isCPSelected()) {
            miscCPO = new MiscCPThread(searchString, LocalIRepDBAccess.getConnPool(), true);
            miscCPT = new Thread(miscCPO);
            miscCPT.start();
        }
        if (filter.isViewSelected()) {
            miscViewO = new MiscViewThread(searchString, LocalIRepDBAccess.getConnPool(), true);
            miscViewT = new Thread(miscViewO);
            miscViewT.start();
        }
        Hashtable businessEntities = new Hashtable();
        Hashtable<String, Vector<IRepGenericTreeNode>> products = new Hashtable<String, Vector<IRepGenericTreeNode>>();
        Hashtable<String, Vector<IRepGenericTreeNode>> productFamilies = new Hashtable<String, Vector<IRepGenericTreeNode>>();
        if (filter.isTableSelected() || filter.isViewSelected() || filter.isCPSelected()) {
            String oiClassId;
            ResultSet rset2;
            PreparedStatement ps2;
            Connection conn2;
            Hashtable openInterfaces = new Hashtable();
            if (filter.isTableSelected()) {
                conn2 = null;
                try {
                    conn2 = LocalIRepDBAccess.getConnPool().getConnection();
                    ps2 = conn2.prepareStatement(searchInterfaceTableApi_q);
                    ps2.setString(1, searchString);
                    rset2 = ps2.executeQuery();
                    while (rset2.next()) {
                        String tableShortName;
                        String tableFullName = tableShortName = rset2.getString(1);
                        String tableDescription = rset2.getString(2);
                        String tableOwner = rset2.getString(4);
                        oiClassId = rset2.getString(5);
                        LocalIRepDBAccess.populateElement(openInterfaces, oiClassId, "Tables", new IRepTableNode(tableShortName, tableFullName, tableDescription, tableOwner, null, null));
                    }
                    rset2.close();
                    ps2.close();
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
                finally {
                    LocalIRepDBAccess.getConnPool().free(conn2);
                }
            }
            if (filter.isViewSelected()) {
                conn2 = null;
                try {
                    conn2 = LocalIRepDBAccess.getConnPool().getConnection();
                    ps2 = conn2.prepareStatement(searchInterfaceViewApi_q);
                    ps2.setString(1, searchString);
                    rset2 = ps2.executeQuery();
                    while (rset2.next()) {
                        String viewShortName;
                        String viewFullName = viewShortName = rset2.getString(1);
                        String viewDescription = rset2.getString(2);
                        String viewOwner = LocalIRepDBAccess.getAppsSchema();
                        oiClassId = rset2.getString(5);
                        LocalIRepDBAccess.populateElement(openInterfaces, oiClassId, "Views", new IRepViewNode(viewShortName, viewFullName, viewDescription, viewOwner, null, null));
                    }
                    rset2.close();
                    ps2.close();
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
                finally {
                    LocalIRepDBAccess.getConnPool().free(conn2);
                }
            }
            if (filter.isCPSelected()) {
                conn2 = null;
                try {
                    conn2 = LocalIRepDBAccess.getConnPool().getConnection();
                    ps2 = conn2.prepareStatement(searchInterfaceCPApi_q);
                    ps2.setString(1, searchString);
                    rset2 = ps2.executeQuery();
                    while (rset2.next()) {
                        String oiClassId2 = rset2.getString(1);
                        String cpShortName = rset2.getString(2);
                        String cpFullName = rset2.getString(3);
                        String cpDescription = rset2.getString(4);
                        LocalIRepDBAccess.populateElement(openInterfaces, oiClassId2, "Concurrent Programs", new IRepProcedureNode(cpShortName, cpFullName, cpDescription, null, null, "CONCURRENT_PROGRAM", 0));
                    }
                    rset2.close();
                    ps2.close();
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
                finally {
                    LocalIRepDBAccess.getConnPool().free(conn2);
                }
            }
            Enumeration oiEnumeration = openInterfaces.keys();
            while (oiEnumeration.hasMoreElements()) {
                String oiClassId3 = (String)oiEnumeration.nextElement();
                int oiClassIdInt = Integer.parseInt(oiClassId3);
                Connection conn3 = null;
                try {
                    conn3 = LocalIRepDBAccess.getConnPool().getConnection();
                    PreparedStatement ps3 = conn3.prepareStatement(searchInterfaceApi_q);
                    ps3.setInt(1, oiClassIdInt);
                    ResultSet rset3 = ps3.executeQuery();
                    String shortName2 = null;
                    String fullName3 = null;
                    String lookupCode3 = null;
                    if (rset3.next()) {
                        shortName2 = rset3.getString(2);
                        fullName3 = rset3.getString(3);
                        lookupCode3 = rset3.getString(5);
                    }
                    Hashtable oiChildHash = (Hashtable)openInterfaces.get(oiClassId3);
                    Enumeration oiChildEnum = oiChildHash.keys();
                    Vector<IRepGenericTreeNode> oiTypesVector = new Vector<IRepGenericTreeNode>();
                    while (oiChildEnum.hasMoreElements()) {
                        String oiChildIType = (String)oiChildEnum.nextElement();
                        Object[] typeElement = (Object[])oiChildHash.get(oiChildIType);
                        IRepGenericTreeNode typeNode = (IRepGenericTreeNode)typeElement[0];
                        Vector typeChildren = (Vector)typeElement[1];
                        typeNode.children = new IRepGenericTreeNode[typeChildren.size()];
                        typeChildren.toArray(typeNode.children);
                        oiTypesVector.add(typeNode);
                    }
                    IRepGenericTreeNode openInterfaceNode = new IRepGenericTreeNode(shortName2, fullName3 + "(" + shortName2 + ")", null, null);
                    openInterfaceNode.children = new IRepGenericTreeNode[oiTypesVector.size()];
                    oiTypesVector.toArray(openInterfaceNode.children);
                    if (lookupCode3 == null) continue;
                    LocalIRepDBAccess.populateElement(businessEntities, lookupCode3, "Open Interfaces", openInterfaceNode);
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
                finally {
                    LocalIRepDBAccess.getConnPool().free(conn3);
                }
            }
        }
        if (filter.isEdiProgSelected()) {
            list = LocalIRepDBAccess.getEDIApis(searchString);
            for (int ediC = 0; ediC < list.size(); ediC += 4) {
                shortName = list.get(ediC);
                fullName2 = list.get(ediC + 1);
                description2 = list.get(ediC + 2);
                lookupCode2 = list.get(ediC + 3);
                LocalIRepDBAccess.populateElement(businessEntities, lookupCode2, "EDI", new IRepProcedureNode(shortName, fullName2, description2, null, null, "CONCURRENT_PROGRAM", 0));
            }
            list = null;
        }
        if (filter.isPackageSelected()) {
            try {
                plsqlT.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            list = plsqlO.list;
            for (int plsqlC = 0; plsqlC < list.size(); plsqlC += 5) {
                int classId = Integer.parseInt(list.get(plsqlC));
                String packageName = list.get(plsqlC + 1);
                fullName = list.get(plsqlC + 2);
                description = list.get(plsqlC + 3);
                lookupCode = list.get(plsqlC + 4);
                LocalIRepDBAccess.populateElement(businessEntities, lookupCode, "PLSQL", new IRepPackageNode(packageName, fullName, description, null, null, classId));
            }
            list = null;
            plsqlO.cleanup();
            plsqlT = null;
            plsqlO = null;
        }
        if (filter.isXmlMapSelected()) {
            try {
                xmlgT.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            list = xmlgO.list;
            for (int xmlgC = 0; xmlgC < list.size(); xmlgC += 5) {
                String mapCode = list.get(xmlgC);
                fullName2 = list.get(xmlgC + 1);
                String direction = list.get(xmlgC + 2);
                description = list.get(xmlgC + 3);
                lookupCode = list.get(xmlgC + 4);
                LocalIRepDBAccess.populateElement(businessEntities, lookupCode, "XML Gateway", new IRepMapNode(mapCode, fullName2, description, direction, null, null));
            }
            list = null;
            xmlgO.cleanup();
            xmlgT = null;
            xmlgO = null;
        }
        if (filter.isCPSelected()) {
            try {
                miscCPT.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            list = miscCPO.list;
            for (int miscCPC = 0; miscCPC < list.size(); miscCPC += 4) {
                shortName = list.get(miscCPC);
                fullName2 = list.get(miscCPC + 1);
                description2 = list.get(miscCPC + 2);
                lookupCode2 = list.get(miscCPC + 3);
                LocalIRepDBAccess.populateElement(businessEntities, lookupCode2, "Concurrent Programs", new IRepProcedureNode(shortName, fullName2, description2, null, null, "CONCURRENT_PROGRAM", 0));
            }
            list = null;
            miscCPO.cleanup();
            miscCPT = null;
            miscCPO = null;
        }
        if (filter.isViewSelected()) {
            try {
                miscViewT.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            list = miscViewO.list;
            for (int miscViewC = 0; miscViewC < list.size(); miscViewC += 5) {
                shortName = list.get(miscViewC);
                fullName2 = list.get(miscViewC + 1);
                description2 = list.get(miscViewC + 2);
                lookupCode2 = list.get(miscViewC + 4);
                String owner = LocalIRepDBAccess.getAppsSchema();
                LocalIRepDBAccess.populateElement(businessEntities, lookupCode2, "Views", new IRepViewNode(shortName, fullName2, description2, owner, null, null));
            }
            list = null;
            miscViewO.cleanup();
            miscViewT = null;
            miscViewO = null;
        }
        Enumeration beEnum = businessEntities.keys();
        beEnum = LocalIRepDBAccess.sortEnumeration(beEnum);
        while (beEnum.hasMoreElements()) {
            String businessEnt = (String)beEnum.nextElement();
            Hashtable apisPerBusinessEnt = (Hashtable)businessEntities.get(businessEnt);
            Enumeration apisEnum = apisPerBusinessEnt.keys();
            fullName = null;
            String productLookupCode = null;
            conn = null;
            ps = null;
            rset = null;
            try {
                conn = LocalIRepDBAccess.getConnPool().getConnection();
                ps = conn.prepareStatement(searchEntity_q);
                ps.setString(1, businessEnt);
                rset = ps.executeQuery();
                IRepGenericTreeNode entnode = new IRepGenericTreeNode(businessEnt, fullName + "(" + businessEnt + ")", null, null);
                Vector<IRepGenericTreeNode> entChildren = new Vector<IRepGenericTreeNode>();
                while (apisEnum.hasMoreElements()) {
                    String apisLabel = (String)apisEnum.nextElement();
                    Object[] apiTypeHolder = (Object[])apisPerBusinessEnt.get(apisLabel);
                    IRepGenericTreeNode cNode = (IRepGenericTreeNode)apiTypeHolder[0];
                    cNode.parent = entnode;
                    Vector labelChildren = (Vector)apiTypeHolder[1];
                    cNode.children = new IRepGenericTreeNode[labelChildren.size()];
                    labelChildren.toArray(cNode.children);
                    entChildren.add(cNode);
                }
                entnode.children = new IRepGenericTreeNode[entChildren.size()];
                entChildren.toArray(entnode.children);
                Vector<IRepGenericTreeNode> product = null;
                while (rset.next()) {
                    fullName = rset.getString(1);
                    productLookupCode = rset.getString(2);
                    entnode.fullName = fullName + "(" + businessEnt + ")";
                    product = (Vector<IRepGenericTreeNode>)products.get(productLookupCode);
                    if (product == null) {
                        product = new Vector<IRepGenericTreeNode>();
                        products.put(productLookupCode, product);
                    }
                    product.add(entnode);
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            finally {
                try {
                    rset.close();
                    ps.close();
                }
                catch (Exception ex) {}
                LocalIRepDBAccess.getConnPool().free(conn);
            }
        }
        Enumeration productsEnum = products.keys();
        productsEnum = LocalIRepDBAccess.sortEnumeration(productsEnum);
        while (productsEnum.hasMoreElements()) {
            String productElement = (String)productsEnum.nextElement();
            String productName = null;
            String pfLookupCode = null;
            Connection conn4 = null;
            PreparedStatement ps4 = null;
            ResultSet rset4 = null;
            try {
                conn4 = LocalIRepDBAccess.getConnPool().getConnection();
                ps4 = conn4.prepareStatement(searchProduct_q);
                ps4.setString(1, productElement);
                rset4 = ps4.executeQuery();
                IRepGenericTreeNode pdnode = null;
                Vector productChildren = null;
                Vector<IRepGenericTreeNode> productFamily = null;
                while (rset4.next()) {
                    productName = rset4.getString(1);
                    pfLookupCode = rset4.getString(2);
                    pdnode = new IRepGenericTreeNode(productElement, productName, null, null);
                    productChildren = (Vector)products.get(productElement);
                    pdnode.children = new IRepGenericTreeNode[productChildren.size()];
                    productChildren.toArray(pdnode.children);
                    productFamily = (Vector<IRepGenericTreeNode>)productFamilies.get(pfLookupCode);
                    if (productFamily == null) {
                        productFamily = new Vector<IRepGenericTreeNode>();
                        productFamilies.put(pfLookupCode, productFamily);
                    }
                    productFamily.add(pdnode);
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            finally {
                try {
                    rset4.close();
                    ps4.close();
                }
                catch (Exception ex) {}
                LocalIRepDBAccess.getConnPool().free(conn4);
            }
        }
        Vector<IRepGenericTreeNode> productFamiliesV = new Vector<IRepGenericTreeNode>();
        Enumeration pfEnumer = productFamilies.keys();
        pfEnumer = LocalIRepDBAccess.sortEnumeration(pfEnumer);
        while (pfEnumer.hasMoreElements()) {
            String pfElement = (String)pfEnumer.nextElement();
            String pfName = null;
            conn = null;
            ps = null;
            rset = null;
            try {
                conn = LocalIRepDBAccess.getConnPool().getConnection();
                ps = conn.prepareStatement(searchPF_q);
                ps.setString(1, pfElement);
                rset = ps.executeQuery();
                IRepGenericTreeNode pfnode = null;
                Vector pfChildren = null;
                while (rset.next()) {
                    pfName = rset.getString(1);
                    pfnode = new IRepGenericTreeNode(pfElement, pfName, null, rootNode);
                    pfChildren = (Vector)productFamilies.get(pfElement);
                    pfnode.children = new IRepGenericTreeNode[pfChildren.size()];
                    pfChildren.toArray(pfnode.children);
                    productFamiliesV.add(pfnode);
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            finally {
                try {
                    rset.close();
                    ps.close();
                }
                catch (Exception ex) {}
                LocalIRepDBAccess.getConnPool().free(conn);
            }
        }
        IRepGenericTreeNode[] retPFs = new IRepGenericTreeNode[productFamiliesV.size()];
        productFamiliesV.toArray(retPFs);
        return retPFs;
    }

    public static void populateElement(Hashtable elements, String lookupCode, String apiType, IRepGenericTreeNode apiToAdd) {
        Object[] apiTypes;
        Hashtable<String, Object[]> element = (Hashtable<String, Object[]>)elements.get(lookupCode);
        if (element == null) {
            element = new Hashtable<String, Object[]>();
            elements.put(lookupCode, element);
        }
        if ((apiTypes = (Object[])element.get(apiType)) == null) {
            apiTypes = new Object[]{new IRepGenericTreeNode(apiType, apiType, null, null), new Vector()};
            element.put(apiType, apiTypes);
        }
        apiToAdd.parent = (IRepGenericTreeNode)apiTypes[0];
        ((Vector)apiTypes[1]).add(apiToAdd);
    }

    public static Enumeration sortEnumeration(Enumeration toSort) {
        Vector sortVector = new Vector();
        while (toSort.hasMoreElements()) {
            sortVector.add(toSort.nextElement());
        }
        Collections.sort(sortVector);
        return sortVector.elements();
    }

    static {
        init = false;
        hs = null;
        bgThread = null;
        cPool = null;
        iRepPackages = null;
        iRepINMaps = null;
        iRepOUTMaps = null;
        extraMapsPresentOut = null;
        extraMapsPresentIn = null;
    }
}

