/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.i11510;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.AppsAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.DBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.ProcedureParam;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.SchemaObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepFilter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepGenericTreeModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepTreeExpansionListener;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepCustomAPIsInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepCustomObjectsInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepCustomXGMInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepEntityNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepGenericTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepInDirNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepMapNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepObjectsCountNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepOpenInterfaceCountNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepOpenInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepOtherInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepOutDirNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepPackageNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepProcedureNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepProductFamiliesNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepProductFamilyNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepProductNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepTableNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepViewNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepWFEventsInterfaceNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HostedIRepFileTreeMaker {
    public static Document doc = null;
    static HostedIRepFileTreeMaker irepFileAccess = null;
    static HashSet mapsActuallyPresent = null;
    private static ArrayList extraMapsPresentOut = null;
    private static ArrayList extraMapsPresentIn = null;
    IRepGenericTreeModel treeModel = null;

    public static JTree getTree() {
        IRepGenericTreeModel treeModel = HostedIRepFileTreeMaker.getIRepTreeModel();
        JTree tree = new JTree(treeModel);
        tree.addTreeExpansionListener(new IRepTreeExpansionListener(treeModel));
        return tree;
    }

    public static void initDoc() {
        doc = null;
    }

    public static IRepGenericTreeModel getIRepTreeModel() {
        IRepProductFamiliesNode rootNode = new IRepProductFamiliesNode("ProductFamilies", "ProductFamilies", null, null);
        IRepGenericTreeNode[] temp = HostedIRepFileTreeMaker.getProductFamilies(rootNode);
        rootNode.children = temp;
        return new IRepGenericTreeModel(rootNode);
    }

    public static IRepGenericTreeModel getSearchTreeModel(IRepFilter filter) {
        String rawObjName = StringUtil.replaceAll(filter.getObjectName(), "\\_", "_");
        IRepGenericTreeNode rootNode = new IRepGenericTreeNode(rawObjName, rawObjName, null, null);
        HostedIRepFileTreeMaker.getSearchTree(filter, rootNode);
        return new IRepGenericTreeModel(rootNode);
    }

    private static void buildDoc() {
        long init = System.currentTimeMillis();
        try {
            irepFileAccess = new HostedIRepFileTreeMaker();
            URL fileURL = AppsAdapterContext.getIrepDumpFile();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(fileURL.openStream());
            HostedIRepFileTreeMaker.initializeMapsFromDB();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Erro in building doc : " + e);
        }
        System.out.println("Total time in loading document = " + (init - System.currentTimeMillis()));
    }

    public static IRepGenericTreeNode[] getProductFamilies(IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        NodeList familyList = doc.getElementsByTagName("Productfamily");
        ArrayList<Object> v = new ArrayList<Object>();
        for (int i = 0; i < familyList.getLength(); ++i) {
            Node familyNode = familyList.item(i);
            if (!"Productfamily".equalsIgnoreCase(familyNode.getNodeName())) continue;
            NamedNodeMap nodeMap = familyNode.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            v.add(shortNameNode.getNodeValue());
            v.add(fullNameNode.getNodeValue());
            v.add(familyNode);
        }
        IRepGenericTreeNode[] productFamily = new IRepGenericTreeNode[v.size() / 3 + 1];
        int i = 0;
        for (int j = 0; j < v.size(); ++j) {
            productFamily[i++] = new IRepProductFamilyNode((String)v.get(j), (String)v.get(j + 1), (Node)v.get(j + 2), parent);
            j += 2;
        }
        productFamily[i] = new IRepOtherInterfaceNode("Other Interfaces", "Other Interfaces", null, parent);
        return productFamily;
    }

    public static IRepGenericTreeNode[] getProducts(IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        ArrayList<Object> v = new ArrayList<Object>();
        Node familyNode = parent.currentNode;
        NodeList productList = familyNode.getChildNodes();
        for (int i = 0; i < productList.getLength(); ++i) {
            Node productNode = productList.item(i);
            if (!"Product".equalsIgnoreCase(productNode.getNodeName())) continue;
            NamedNodeMap nodeMap = productNode.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            v.add(shortNameNode.getNodeValue());
            v.add(fullNameNode.getNodeValue());
            v.add(productNode);
        }
        IRepGenericTreeNode[] products = new IRepProductNode[v.size() / 3];
        int i = 0;
        for (int j = 0; j < v.size(); ++j) {
            products[i++] = new IRepProductNode((String)v.get(j), (String)v.get(j + 1), (Node)v.get(j + 2), parent);
            j += 2;
        }
        return products;
    }

    public static IRepGenericTreeNode[] getEntities(IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        ArrayList<Object> v = new ArrayList<Object>();
        Node productNode = parent.currentNode;
        NodeList entityList = productNode.getChildNodes();
        for (int i = 0; i < entityList.getLength(); ++i) {
            Node entityNode = entityList.item(i);
            if (!"BusinessEntity".equalsIgnoreCase(entityNode.getNodeName())) continue;
            NamedNodeMap nodeMap = entityNode.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            v.add(shortNameNode.getNodeValue());
            v.add(fullNameNode.getNodeValue());
            v.add(entityNode);
        }
        IRepGenericTreeNode[] entities = new IRepEntityNode[v.size() / 3];
        int i = 0;
        for (int j = 0; j < v.size(); ++j) {
            entities[i++] = new IRepEntityNode((String)v.get(j), (String)v.get(j + 1), (Node)v.get(j + 2), parent);
            j += 2;
        }
        return entities;
    }

    public static IRepGenericTreeNode[] getInterfaces(IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        IRepGenericTreeNode[] interfaces = new IRepGenericTreeNode[]{HostedIRepFileTreeMaker.getInterface(parent, "XMLGateway", "xmlgatewaymap"), HostedIRepFileTreeMaker.getInterface(parent, "EDI", "edigateway"), HostedIRepFileTreeMaker.getInterface(parent, "PLSQL", "package"), HostedIRepFileTreeMaker.getOpenInterfaceCountNode(parent), HostedIRepFileTreeMaker.getInterface(parent, "CONCURRENT_PROGRAMS", "StandaloneCP"), HostedIRepFileTreeMaker.getInterface(parent, "INTERFACE_VIEWS", "StandaloneView")};
        return interfaces;
    }

    public static IRepGenericTreeNode[] getOIInterfaces(IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        IRepGenericTreeNode[] interfaces = new IRepGenericTreeNode[]{HostedIRepFileTreeMaker.getInterface(parent, "OpenInterfaceTable", "InterfaceTable"), HostedIRepFileTreeMaker.getInterface(parent, "OpenInterfaceView", "InterfaceView"), HostedIRepFileTreeMaker.getInterface(parent, "ConcurrentPrograms", "concurrentprogram")};
        return interfaces;
    }

    static IRepObjectsCountNode getInterface(IRepGenericTreeNode parent, String type, String typeTag) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        Node entityNode = parent.currentNode;
        NodeList interfaceList = entityNode.getChildNodes();
        for (int j = 0; j < interfaceList.getLength(); ++j) {
            Node typeNode = interfaceList.item(j);
            if (!type.equalsIgnoreCase(typeNode.getNodeName())) continue;
            IRepObjectsCountNode interfaceNode = new IRepObjectsCountNode(type, " ", typeNode, parent, type, typeTag);
            int count = HostedIRepFileTreeMaker.getObjectsCount(interfaceNode, typeTag);
            interfaceNode.setCount(count);
            return interfaceNode;
        }
        return null;
    }

    static IRepOpenInterfaceCountNode getOpenInterfaceCountNode(IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        Node entityNode = parent.currentNode;
        NodeList interfaceList = entityNode.getChildNodes();
        for (int j = 0; j < interfaceList.getLength(); ++j) {
            Node typeNode = interfaceList.item(j);
            if (!"OpenInterfaces".equalsIgnoreCase(typeNode.getNodeName())) continue;
            IRepOpenInterfaceCountNode interfaceNode = new IRepOpenInterfaceCountNode("OpenInterfaces", "OpenInterface", typeNode, parent);
            int count = HostedIRepFileTreeMaker.getOpenInterfaceCountNode1(interfaceNode);
            interfaceNode.setCount(count);
            return interfaceNode;
        }
        return null;
    }

    static int getObjectsCount(IRepGenericTreeNode parent, String typeTag) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        int objectCount = 0;
        Node typeNode = parent.currentNode;
        NodeList objectsList = typeNode.getChildNodes();
        for (int j = 0; j < objectsList.getLength(); ++j) {
            Node objectNode = objectsList.item(j);
            if (typeTag.equalsIgnoreCase("xmlgatewaymap") && typeTag.equalsIgnoreCase(objectNode.getNodeName())) {
                NamedNodeMap nodeMap = objectNode.getAttributes();
                Node shortNameNode = nodeMap.getNamedItem("shortname");
                if (!mapsActuallyPresent.contains(shortNameNode.getNodeValue())) continue;
                ++objectCount;
                continue;
            }
            if (typeTag.equalsIgnoreCase("xmlgatewaymap") || !typeTag.equalsIgnoreCase(objectNode.getNodeName())) continue;
            ++objectCount;
        }
        return objectCount;
    }

    static int getOpenInterfaceCountNode1(IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        int objectCount = 0;
        Node typeNode = parent.currentNode;
        NodeList objectsList = typeNode.getChildNodes();
        for (int j = 0; j < objectsList.getLength(); ++j) {
            Node objectNode = objectsList.item(j);
            if (!"OpenInterface".equalsIgnoreCase(objectNode.getNodeName())) continue;
            ++objectCount;
        }
        return objectCount;
    }

    public static IRepGenericTreeNode[] getObjects(IRepGenericTreeNode parent, String typeTag) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        ArrayList<Object> v = new ArrayList<Object>();
        Node typeNode = parent.currentNode;
        NodeList objectsList = typeNode.getChildNodes();
        for (int j = 0; j < objectsList.getLength(); ++j) {
            Node objectNode = objectsList.item(j);
            if (!typeTag.equalsIgnoreCase(objectNode.getNodeName())) continue;
            NamedNodeMap nodeMap = objectNode.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            NodeList descList = ((Element)objectNode).getElementsByTagName("description");
            Node desc = descList.item(0);
            if (typeTag.equalsIgnoreCase("xmlgatewaymap") && mapsActuallyPresent.contains(shortNameNode.getNodeValue())) {
                v.add(shortNameNode.getNodeValue());
                v.add(fullNameNode.getNodeValue());
                v.add(desc.getFirstChild().getNodeValue());
                Node directionNode = nodeMap.getNamedItem("direction");
                v.add(directionNode.getNodeValue());
                v.add(objectNode);
                continue;
            }
            if (typeTag.equalsIgnoreCase("InterfaceTable")) {
                Node ownerNode = nodeMap.getNamedItem("owner");
                v.add(shortNameNode.getNodeValue());
                v.add(fullNameNode.getNodeValue());
                v.add(ownerNode.getNodeValue());
                v.add(objectNode);
                continue;
            }
            if (typeTag.equalsIgnoreCase("InterfaceView")) {
                v.add(shortNameNode.getNodeValue());
                v.add(fullNameNode.getNodeValue());
                v.add(DBAccess.getAppsSchema());
                v.add(objectNode);
                continue;
            }
            if (typeTag.equalsIgnoreCase("StandaloneView")) {
                v.add(shortNameNode.getNodeValue());
                v.add(fullNameNode.getNodeValue());
                v.add(DBAccess.getAppsSchema());
                v.add(objectNode);
                continue;
            }
            if (typeTag.equalsIgnoreCase("xmlgatewaymap")) continue;
            v.add(shortNameNode.getNodeValue());
            v.add(fullNameNode.getNodeValue());
            v.add("Desc: ");
            v.add(objectNode);
        }
        IRepGenericTreeNode[] objects = null;
        if (typeTag.equalsIgnoreCase("xmlgatewaymap")) {
            objects = new IRepMapNode[v.size() / 5];
        } else if (typeTag.equalsIgnoreCase("InterfaceTable")) {
            objects = new IRepTableNode[v.size() / 4];
        } else if (typeTag.equalsIgnoreCase("InterfaceView")) {
            objects = new IRepViewNode[v.size() / 4];
        } else if (typeTag.equalsIgnoreCase("package")) {
            objects = new IRepPackageNode[v.size() / 4];
        } else if (typeTag.equalsIgnoreCase("concurrentprogram")) {
            objects = new IRepProcedureNode[v.size() / 4];
        } else if (typeTag.equalsIgnoreCase("edigateway")) {
            objects = new IRepProcedureNode[v.size() / 4];
        } else if (typeTag.equalsIgnoreCase("StandaloneView")) {
            objects = new IRepViewNode[v.size() / 4];
        } else if (typeTag.equalsIgnoreCase("StandaloneCP")) {
            objects = new IRepProcedureNode[v.size() / 4];
        }
        int i = 0;
        for (int j = 0; j < v.size(); ++j) {
            if (typeTag.equalsIgnoreCase("xmlgatewaymap")) {
                objects[i++] = new IRepMapNode((String)v.get(j), (String)v.get(j + 1), (String)v.get(j + 2), (String)v.get(j + 3), (Node)v.get(j + 4), parent);
                ++j;
            } else if (typeTag.equalsIgnoreCase("InterfaceTable")) {
                objects[i++] = new IRepTableNode((String)v.get(j), (String)v.get(j + 1), " ", (String)v.get(j + 2), (Node)v.get(j + 3), parent);
            } else if (typeTag.equalsIgnoreCase("InterfaceView")) {
                objects[i++] = new IRepViewNode((String)v.get(j), (String)v.get(j + 1), " ", (String)v.get(j + 2), (Node)v.get(j + 3), parent);
            } else if (typeTag.equalsIgnoreCase("package")) {
                objects[i++] = new IRepPackageNode((String)v.get(j), (String)v.get(j + 1), (String)v.get(j + 2), (Node)v.get(j + 3), parent);
            } else if (typeTag.equalsIgnoreCase("concurrentprogram") || typeTag.equalsIgnoreCase("edigateway") || typeTag.equalsIgnoreCase("StandaloneCP")) {
                objects[i++] = new IRepProcedureNode((String)v.get(j), (String)v.get(j + 1), (String)v.get(j + 2), (Node)v.get(j + 3), parent, "CONCURRENT_PROGRAM", 0);
            } else if (typeTag.equalsIgnoreCase("StandaloneView")) {
                objects[i++] = new IRepViewNode((String)v.get(j), (String)v.get(j + 1), " ", (String)v.get(j + 2), (Node)v.get(j + 3), parent);
            }
            j += 3;
        }
        return objects;
    }

    public static IRepGenericTreeNode[] getPackagedProcs(IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        ArrayList<Object> v = new ArrayList<Object>();
        String packageName = parent.shortName;
        Node typeNode = parent.currentNode;
        NodeList objectsList = typeNode.getChildNodes();
        for (int j = 0; j < objectsList.getLength(); ++j) {
            Node objectNode = objectsList.item(j);
            if (!"procedure".equalsIgnoreCase(objectNode.getNodeName())) continue;
            NamedNodeMap nodeMap = objectNode.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            Node overloadNode = nodeMap.getNamedItem("overload");
            v.add(shortNameNode.getNodeValue());
            v.add(fullNameNode.getNodeValue());
            v.add("Desc :  ");
            v.add(objectNode);
            String overloadVal = null;
            if (overloadNode != null) {
                overloadVal = overloadNode.getNodeValue();
            }
            v.add(overloadVal);
        }
        IRepGenericTreeNode[] objects = new IRepProcedureNode[v.size() / 5];
        int i = 0;
        int currentOverload = 0;
        for (int j = 0; j < v.size(); ++j) {
            currentOverload = 0;
            String currentOverloadStr = (String)v.get(j + 4);
            if (currentOverloadStr != null) {
                currentOverload = Integer.valueOf(currentOverloadStr);
            }
            objects[i++] = new IRepProcedureNode((String)v.get(j), (String)v.get(j + 1), (String)v.get(j + 2), (Node)v.get(j + 3), parent, packageName, currentOverload);
            j += 4;
        }
        return objects;
    }

    public static boolean areParametersPresentInFile(IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        Node procNode = parent.currentNode;
        NodeList paramsList = procNode.getChildNodes();
        for (int j = 0; j < paramsList.getLength(); ++j) {
            Node paramNode = paramsList.item(j);
            if (!"parameter".equalsIgnoreCase(paramNode.getNodeName())) continue;
            return true;
        }
        return false;
    }

    public static ProcedureParam[] getProcedureParameters(IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        ArrayList<ProcedureParam> v = new ArrayList<ProcedureParam>();
        ProcedureParam[] params = null;
        Node typeNode = parent.currentNode;
        NodeList objectsList = typeNode.getChildNodes();
        String[] tokens = new String[7];
        for (int j = 0; j < objectsList.getLength(); ++j) {
            Node objectNode = objectsList.item(j);
            if (!"parameter".equalsIgnoreCase(objectNode.getNodeName())) continue;
            StringTokenizer st = new StringTokenizer(objectNode.getFirstChild().getNodeValue(), "@");
            int i = 0;
            while (st.hasMoreTokens()) {
                String temp = st.nextToken();
                if (!"null".equalsIgnoreCase(temp)) {
                    tokens[i++] = temp;
                    continue;
                }
                ++i;
            }
            String name = tokens[0];
            String owner = tokens[1];
            String datatype = tokens[2];
            String type = tokens[3];
            String inoutstr = tokens[4];
            int position = Integer.parseInt(tokens[5]);
            int sequence = Integer.parseInt(tokens[6]);
            boolean out = inoutstr.indexOf("OUT") >= 0;
            boolean in = inoutstr.indexOf("IN") >= 0;
            SchemaObject otype = new SchemaObject(owner, type);
            SchemaObject eltype = null;
            if (!otype.isPrimitive()) {
                eltype = DBAccess.getEltype(otype.getName(), otype.getSchema());
            }
            ProcedureParam col = new ProcedureParam(name, otype, eltype, in, out, inoutstr, position, sequence, datatype, 1);
            v.add(col);
        }
        if (v.size() > 0) {
            params = new ProcedureParam[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                params[i] = (ProcedureParam)v.get(i);
            }
        }
        return params;
    }

    public static IRepGenericTreeNode[] getOpenInterfaces(IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        ArrayList<Object> v = new ArrayList<Object>();
        Node typeNode = parent.currentNode;
        NodeList objectsList = typeNode.getChildNodes();
        for (int j = 0; j < objectsList.getLength(); ++j) {
            Node objectNode = objectsList.item(j);
            if (!"OpenInterface".equalsIgnoreCase(objectNode.getNodeName())) continue;
            NamedNodeMap nodeMap = objectNode.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            Node descNameNode = nodeMap.getNamedItem("description");
            v.add(shortNameNode.getNodeValue());
            v.add(fullNameNode.getNodeValue());
            v.add(descNameNode.getNodeValue());
            v.add(objectNode);
        }
        IRepGenericTreeNode[] objects = new IRepOpenInterfaceNode[v.size() / 4];
        int i = 0;
        for (int j = 0; j < v.size(); ++j) {
            objects[i++] = new IRepOpenInterfaceNode((String)v.get(j), (String)v.get(j + 1), (String)v.get(j + 2), (Node)v.get(j + 3), parent);
            j += 3;
        }
        return objects;
    }

    public static IRepGenericTreeNode[] getSearchObjects(String typeTag, String searchName, IRepGenericTreeNode parent) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        ArrayList<Object> v = new ArrayList<Object>();
        NodeList objectsList = doc.getElementsByTagName(typeTag);
        for (int j = 0; j < objectsList.getLength(); ++j) {
            NamedNodeMap nodeMap;
            Node shortNameNode;
            Node objectNode = objectsList.item(j);
            if (!typeTag.equalsIgnoreCase(objectNode.getNodeName()) || (shortNameNode = (nodeMap = objectNode.getAttributes()).getNamedItem("shortname")).getNodeValue().indexOf(searchName) == -1) continue;
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            NodeList descList = ((Element)objectNode).getElementsByTagName("description");
            Node desc = descList.item(0);
            v.add(shortNameNode.getNodeValue());
            v.add(fullNameNode.getNodeValue());
            v.add(desc.getFirstChild().getNodeValue());
            if (typeTag.equalsIgnoreCase("xmlgatewaymap")) {
                Node directionNode = nodeMap.getNamedItem("direction");
                v.add(directionNode.getNodeValue());
            }
            v.add(objectNode);
        }
        IRepGenericTreeNode[] objects = null;
        if (typeTag.equalsIgnoreCase("xmlgatewaymap")) {
            objects = new IRepMapNode[v.size() / 5];
        } else if (typeTag.equalsIgnoreCase("InterfaceTable")) {
            objects = new IRepTableNode[v.size() / 4];
        } else if (typeTag.equalsIgnoreCase("InterfaceView")) {
            objects = new IRepViewNode[v.size() / 4];
        } else if (typeTag.equalsIgnoreCase("package")) {
            objects = new IRepPackageNode[v.size() / 4];
        } else if (typeTag.equalsIgnoreCase("concurrentprogram")) {
            objects = new IRepProcedureNode[v.size() / 4];
        } else if (typeTag.equalsIgnoreCase("edigateway")) {
            objects = new IRepProcedureNode[v.size() / 4];
        }
        int i = 0;
        for (int j = 0; j < v.size(); ++j) {
            if (typeTag.equalsIgnoreCase("xmlgatewaymap")) {
                objects[i++] = new IRepMapNode((String)v.get(j), (String)v.get(j + 1), (String)v.get(j + 2), (String)v.get(j + 3), (Node)v.get(j + 4), parent);
                ++j;
            } else if (typeTag.equalsIgnoreCase("InterfaceTable")) {
                objects[i++] = new IRepTableNode((String)v.get(j), (String)v.get(j + 1), (String)v.get(j + 2), (Node)v.get(j + 3), parent);
            } else if (typeTag.equalsIgnoreCase("InterfaceView")) {
                objects[i++] = new IRepViewNode((String)v.get(j), (String)v.get(j + 1), (String)v.get(j + 2), (Node)v.get(j + 3), parent);
            } else if (typeTag.equalsIgnoreCase("package")) {
                objects[i++] = new IRepPackageNode((String)v.get(j), (String)v.get(j + 1), (String)v.get(j + 2), (Node)v.get(j + 3), parent);
            } else if (typeTag.equalsIgnoreCase("concurrentprogram")) {
                objects[i++] = new IRepProcedureNode((String)v.get(j), (String)v.get(j + 1), (String)v.get(j + 2), (Node)v.get(j + 3), parent, "CONCURRENT_PROGRAM", 0);
            } else if (typeTag.equalsIgnoreCase("edigateway")) {
                objects[i++] = new IRepProcedureNode((String)v.get(j), (String)v.get(j + 1), (String)v.get(j + 2), (Node)v.get(j + 3), parent, "CONCURRENT_PROGRAM", 0);
            }
            j += 3;
        }
        return objects;
    }

    static void getSearchTree(IRepFilter filter, IRepGenericTreeNode root) {
        System.out.println("addSearchTree starts. " + root.shortName);
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        ArrayList<IRepGenericTreeNode> v = new ArrayList<IRepGenericTreeNode>();
        NodeList familyList = doc.getElementsByTagName("Productfamily");
        for (int i = 0; i < familyList.getLength(); ++i) {
            Element familyNode = (Element)familyList.item(i);
            if (!"Productfamily".equalsIgnoreCase(familyNode.getNodeName())) continue;
            NamedNodeMap nodeMap = familyNode.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            IRepGenericTreeNode genFamily = new IRepGenericTreeNode(shortNameNode.getNodeValue(), fullNameNode.getNodeValue(), familyNode, root);
            boolean atleastOneProductFound = HostedIRepFileTreeMaker.searchProducts(filter, genFamily);
            if (!atleastOneProductFound) continue;
            v.add(genFamily);
        }
        IRepGenericTreeNode otherNode = HostedIRepFileTreeMaker.addOtherInterfaces(filter, root);
        if (otherNode != null) {
            v.add(otherNode);
        }
        IRepGenericTreeNode[] productFamily = new IRepGenericTreeNode[v.size()];
        for (int j = 0; j < v.size(); ++j) {
            productFamily[j] = (IRepGenericTreeNode)v.get(j);
        }
        root.children = productFamily;
        System.out.println("addSearchTree ends. " + root.shortName);
    }

    static boolean searchProducts(IRepFilter filter, IRepGenericTreeNode family) {
        System.out.println("searchProducts starts. " + family.shortName);
        boolean atleastOneProductFound = false;
        ArrayList<IRepGenericTreeNode> v = new ArrayList<IRepGenericTreeNode>();
        NodeList productList = ((Element)family.currentNode).getElementsByTagName("Product");
        for (int i = 0; i < productList.getLength(); ++i) {
            Element productNode = (Element)productList.item(i);
            if (!"Product".equalsIgnoreCase(productNode.getNodeName())) continue;
            NamedNodeMap nodeMap = productNode.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            IRepGenericTreeNode genProduct = new IRepGenericTreeNode(shortNameNode.getNodeValue(), fullNameNode.getNodeValue(), productNode, family);
            boolean atleastOneEntityFound = HostedIRepFileTreeMaker.searchEntities(filter, genProduct);
            if (!atleastOneEntityFound) continue;
            v.add(genProduct);
            atleastOneProductFound = true;
        }
        IRepGenericTreeNode[] products = new IRepGenericTreeNode[v.size()];
        for (int j = 0; j < v.size(); ++j) {
            products[j] = (IRepGenericTreeNode)v.get(j);
        }
        family.children = products;
        System.out.println("searchProducts ends " + family.shortName);
        return atleastOneProductFound;
    }

    static boolean searchEntities(IRepFilter filter, IRepGenericTreeNode product) {
        System.out.println("searchEntities starts. " + product.shortName);
        boolean atleastOneEntityFound = false;
        ArrayList<IRepGenericTreeNode> v = new ArrayList<IRepGenericTreeNode>();
        NodeList entityList = ((Element)product.currentNode).getElementsByTagName("BusinessEntity");
        for (int i = 0; i < entityList.getLength(); ++i) {
            Element entityNode = (Element)entityList.item(i);
            if (!"BusinessEntity".equalsIgnoreCase(entityNode.getNodeName())) continue;
            NamedNodeMap nodeMap = entityNode.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            IRepGenericTreeNode genEntity = new IRepGenericTreeNode(shortNameNode.getNodeValue(), fullNameNode.getNodeValue(), entityNode, product);
            boolean atleastOneInterfaceFound = HostedIRepFileTreeMaker.searchInterfaces(filter, genEntity);
            if (!atleastOneInterfaceFound) continue;
            v.add(genEntity);
            atleastOneEntityFound = true;
        }
        IRepGenericTreeNode[] entities = new IRepGenericTreeNode[v.size()];
        for (int j = 0; j < v.size(); ++j) {
            entities[j] = (IRepGenericTreeNode)v.get(j);
        }
        product.children = entities;
        System.out.println("searchEntities ends. " + product.shortName);
        return atleastOneEntityFound;
    }

    static boolean searchInterfaces(IRepFilter filter, IRepGenericTreeNode entity) {
        IRepGenericTreeNode interfaceNode;
        System.out.println("searchInterfaces starts. " + entity.shortName);
        boolean xmlgFound = false;
        boolean edigFound = false;
        boolean standaloneCPFound = false;
        boolean standaloneViewFound = false;
        boolean apiFound = false;
        boolean oiFound = false;
        ArrayList<IRepObjectsCountNode> v = new ArrayList<IRepObjectsCountNode>();
        if (filter.isXmlMapSelected() && (xmlgFound = HostedIRepFileTreeMaker.searchInterface(filter, entity, interfaceNode = new IRepObjectsCountNode("XMLGateway", " ", null, entity, "XMLGateway", "xmlgatewaymap"), "XMLGateway", "xmlgatewaymap"))) {
            v.add((IRepObjectsCountNode)interfaceNode);
        }
        if (filter.isPackageSelected() && (apiFound = HostedIRepFileTreeMaker.searchInterface(filter, entity, interfaceNode = new IRepObjectsCountNode("PLSQL", " ", null, entity, "PLSQL", "package"), "PLSQL", "package"))) {
            v.add((IRepObjectsCountNode)interfaceNode);
        }
        if (filter.isCPSelected() || filter.isViewSelected() || filter.isTableSelected()) {
            IRepObjectsCountNode interfaceNodeView;
            IRepObjectsCountNode interfaceNodeCP;
            interfaceNode = new IRepOpenInterfaceCountNode("OpenInterfaces", "OpenInterfaces", null, entity);
            oiFound = HostedIRepFileTreeMaker.searchOInterface(filter, entity, (IRepOpenInterfaceCountNode)interfaceNode);
            if (oiFound) {
                v.add((IRepObjectsCountNode)interfaceNode);
            }
            if (filter.isCPSelected() && (standaloneCPFound = HostedIRepFileTreeMaker.searchInterface(filter, entity, interfaceNodeCP = new IRepObjectsCountNode("CONCURRENT_PROGRAMS", " ", null, entity, "CONCURRENT_PROGRAMS", "StandaloneCP"), "CONCURRENT_PROGRAMS", "StandaloneCP"))) {
                v.add(interfaceNodeCP);
            }
            if (filter.isViewSelected() && (standaloneViewFound = HostedIRepFileTreeMaker.searchInterface(filter, entity, interfaceNodeView = new IRepObjectsCountNode("INTERFACE_VIEWS", " ", null, entity, "INTERFACE_VIEWS", "StandaloneView"), "INTERFACE_VIEWS", "StandaloneView"))) {
                v.add(interfaceNodeView);
            }
        }
        if (filter.isEdiProgSelected() && (edigFound = HostedIRepFileTreeMaker.searchInterface(filter, entity, interfaceNode = new IRepObjectsCountNode("EDI", " ", null, entity, "EDI", "edigateway"), "EDI", "edigateway"))) {
            v.add((IRepObjectsCountNode)interfaceNode);
        }
        IRepGenericTreeNode[] interfaces = new IRepGenericTreeNode[v.size()];
        for (int j = 0; j < v.size(); ++j) {
            interfaces[j] = (IRepGenericTreeNode)v.get(j);
        }
        entity.children = interfaces;
        boolean result = false;
        result = xmlgFound || apiFound || oiFound || edigFound || standaloneCPFound || standaloneViewFound;
        System.out.println("searchInterfaces ends result = " + result + " EntityName= " + entity.shortName);
        return result;
    }

    static boolean searchInterface(IRepFilter filter, IRepGenericTreeNode entity, IRepObjectsCountNode interfaceNode, String type, String typeTag) {
        System.out.println("searchInterface starts. " + interfaceNode.shortName);
        Node entityNode = entity.currentNode;
        NodeList interfaceList = entityNode.getChildNodes();
        for (int j = 0; j < interfaceList.getLength(); ++j) {
            Node typeNode = interfaceList.item(j);
            if (!type.equalsIgnoreCase(typeNode.getNodeName())) continue;
            interfaceNode.currentNode = typeNode;
            int count = HostedIRepFileTreeMaker.searchObjectsCount(filter, interfaceNode, typeTag);
            interfaceNode.setCount(count);
            if (count == 0) {
                return false;
            }
            System.out.println("searchInterface ends true" + interfaceNode.shortName);
            return true;
        }
        System.out.println("searchInterface starts. false" + interfaceNode.shortName);
        return false;
    }

    static int searchObjectsCount(IRepFilter filter, IRepObjectsCountNode interfaceNode, String typeTag) {
        System.out.println("searchObjectsCount starts. " + interfaceNode.shortName);
        int count = 0;
        ArrayList<IRepMapNode> v = new ArrayList<IRepMapNode>();
        NodeList objectsList = interfaceNode.currentNode.getChildNodes();
        String objName = StringUtil.replaceAll(filter.getObjectName(), "\\_", "_").toUpperCase();
        objName = objName.replaceAll("\\.", "\\[\\.\\]");
        objName = objName.replaceAll("\\$", "\\[\\$\\]");
        objName = objName.replaceAll("%", "\\.\\*");
        System.out.println("Search REGEX is :" + objName);
        for (int j = 0; j < objectsList.getLength(); ++j) {
            NamedNodeMap nodeMap;
            Node shortNameNode;
            Node objectNode = objectsList.item(j);
            if (!typeTag.equalsIgnoreCase(objectNode.getNodeName()) || !(shortNameNode = (nodeMap = objectNode.getAttributes()).getNamedItem("shortname")).getNodeValue().toUpperCase().matches(objName)) continue;
            ++count;
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            NodeList descList = ((Element)objectNode).getElementsByTagName("description");
            Node desc = descList.item(0);
            IRepGenericTreeNode genObject = null;
            if (typeTag.equalsIgnoreCase("xmlgatewaymap")) {
                Node directionNode = nodeMap.getNamedItem("direction");
                genObject = new IRepMapNode(shortNameNode.getNodeValue(), fullNameNode.getNodeValue(), desc.getFirstChild().getNodeValue(), directionNode.getNodeValue(), objectNode, interfaceNode);
            }
            if (typeTag.equalsIgnoreCase("InterfaceTable")) {
                Node ownerNode = nodeMap.getNamedItem("owner");
                genObject = new IRepTableNode(shortNameNode.getNodeValue(), fullNameNode.getNodeValue(), desc.getFirstChild().getNodeValue(), ownerNode.getNodeValue(), objectNode, interfaceNode);
            }
            if (typeTag.equalsIgnoreCase("InterfaceView")) {
                genObject = new IRepViewNode(shortNameNode.getNodeValue(), fullNameNode.getNodeValue(), desc.getFirstChild().getNodeValue(), DBAccess.getAppsSchema(), objectNode, interfaceNode);
            }
            if (typeTag.equalsIgnoreCase("package")) {
                Node desNode = nodeMap.getNamedItem("description");
                genObject = new IRepPackageNode(shortNameNode.getNodeValue(), fullNameNode.getNodeValue(), desNode.getNodeValue(), objectNode, interfaceNode);
            }
            if (typeTag.equalsIgnoreCase("concurrentprogram") || typeTag.equalsIgnoreCase("edigateway") || typeTag.equalsIgnoreCase("standalonecp")) {
                genObject = new IRepProcedureNode(shortNameNode.getNodeValue(), fullNameNode.getNodeValue(), desc.getFirstChild().getNodeValue(), objectNode, interfaceNode, "CONCURRENT_PROGRAM", 0);
            }
            if (typeTag.equalsIgnoreCase("standaloneview")) {
                genObject = new IRepViewNode(shortNameNode.getNodeValue(), fullNameNode.getNodeValue(), desc.getFirstChild().getNodeValue(), DBAccess.getAppsSchema(), objectNode, interfaceNode);
            }
            v.add((IRepMapNode)genObject);
        }
        IRepGenericTreeNode[] objects = new IRepGenericTreeNode[v.size()];
        for (int j = 0; j < v.size(); ++j) {
            objects[j] = (IRepGenericTreeNode)v.get(j);
        }
        interfaceNode.children = objects;
        System.out.println("searchObjectsCount ends " + interfaceNode.shortName);
        return count;
    }

    static boolean searchOInterface(IRepFilter filter, IRepGenericTreeNode entity, IRepOpenInterfaceCountNode interfaceNode) {
        System.out.println("searchOInterface starts. " + entity.shortName);
        boolean atleastOneOIFound = false;
        ArrayList<IRepGenericTreeNode> v = new ArrayList<IRepGenericTreeNode>();
        NodeList oiList = ((Element)entity.currentNode).getElementsByTagName("OpenInterfaces");
        if (oiList == null || oiList.getLength() == 0) {
            return false;
        }
        Element oifaces = (Element)oiList.item(0);
        NodeList entityList = oifaces.getElementsByTagName("OpenInterface");
        for (int i = 0; i < entityList.getLength(); ++i) {
            Element entityNode = (Element)entityList.item(i);
            if (!"OpenInterface".equalsIgnoreCase(entityNode.getNodeName())) continue;
            NamedNodeMap nodeMap = entityNode.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            Node fullNameNode = nodeMap.getNamedItem("fullname");
            IRepGenericTreeNode genEntity = new IRepGenericTreeNode(shortNameNode.getNodeValue(), fullNameNode.getNodeValue(), entityNode, interfaceNode);
            boolean atleastOneInterfaceFound = HostedIRepFileTreeMaker.searchOIInterfaces(filter, genEntity);
            if (!atleastOneInterfaceFound) continue;
            v.add(genEntity);
            atleastOneOIFound = true;
        }
        int size = v.size();
        IRepGenericTreeNode[] oiinterfaces = new IRepGenericTreeNode[size];
        for (int j = 0; j < v.size(); ++j) {
            oiinterfaces[j] = (IRepGenericTreeNode)v.get(j);
        }
        interfaceNode.setCount(size);
        interfaceNode.children = oiinterfaces;
        System.out.println("searchOInterface starts. " + entity.shortName + " atleastOneOIFound = " + atleastOneOIFound);
        return atleastOneOIFound;
    }

    static boolean searchOIInterfaces(IRepFilter filter, IRepGenericTreeNode entity) {
        IRepObjectsCountNode interfaceNode;
        System.out.println("searchOIInterfaces starts. " + entity.shortName);
        boolean tableFound = false;
        boolean viewFound = false;
        boolean cpFound = false;
        ArrayList<IRepObjectsCountNode> v = new ArrayList<IRepObjectsCountNode>();
        if (filter.isTableSelected() && (tableFound = HostedIRepFileTreeMaker.searchInterface(filter, entity, interfaceNode = new IRepObjectsCountNode("OpenInterfaceTable", " ", null, entity, "OpenInterfaceTable", "InterfaceTable"), "OpenInterfaceTable", "InterfaceTable"))) {
            v.add(interfaceNode);
        }
        if (filter.isViewSelected() && (viewFound = HostedIRepFileTreeMaker.searchInterface(filter, entity, interfaceNode = new IRepObjectsCountNode("OpenInterfaceView", " ", null, entity, "OpenInterfaceView", "InterfaceView"), "OpenInterfaceView", "InterfaceView"))) {
            v.add(interfaceNode);
        }
        if (filter.isCPSelected() && (cpFound = HostedIRepFileTreeMaker.searchInterface(filter, entity, interfaceNode = new IRepObjectsCountNode("ConcurrentPrograms", " ", null, entity, "ConcurrentPrograms", "concurrentprogram"), "ConcurrentPrograms", "concurrentprogram"))) {
            v.add(interfaceNode);
        }
        IRepGenericTreeNode[] interfaces = new IRepGenericTreeNode[v.size()];
        for (int j = 0; j < v.size(); ++j) {
            interfaces[j] = (IRepGenericTreeNode)v.get(j);
        }
        entity.children = interfaces;
        System.out.println("searchOIInterfaces ends. " + entity.shortName);
        return tableFound || viewFound || cpFound;
    }

    static Node getProductFamily(String family) {
        if (doc == null) {
            HostedIRepFileTreeMaker.buildDoc();
        }
        NodeList familyList = doc.getElementsByTagName("Productfamily");
        for (int i = 0; i < familyList.getLength(); ++i) {
            NamedNodeMap nodeMap;
            Node shortNameNode;
            Node familyNode = familyList.item(i);
            if (!"Productfamily".equalsIgnoreCase(familyNode.getNodeName()) || !family.equalsIgnoreCase((shortNameNode = (nodeMap = familyNode.getAttributes()).getNamedItem("shortname")).getNodeValue())) continue;
            return familyNode;
        }
        return null;
    }

    static Node getProduct(String family, String product) {
        Node familyNode = HostedIRepFileTreeMaker.getProductFamily(family);
        NodeList productList = familyNode.getChildNodes();
        for (int i = 0; i < productList.getLength(); ++i) {
            Node productNode = productList.item(i);
            if (!"Product".equalsIgnoreCase(productNode.getNodeName())) continue;
            NamedNodeMap nodeMap = productNode.getAttributes();
            Node shortNameNode = nodeMap.getNamedItem("shortname");
            if (product.equalsIgnoreCase(shortNameNode.getNodeValue())) {
                // empty if block
            }
            return productNode;
        }
        return null;
    }

    static Node getEntity(String family, String product, String entity) {
        Node productNode = HostedIRepFileTreeMaker.getProduct(family, product);
        NodeList entityList = productNode.getChildNodes();
        for (int i = 0; i < entityList.getLength(); ++i) {
            NamedNodeMap nodeMap;
            Node shortNameNode;
            Node entityNode = entityList.item(i);
            if (!"BusinessEntity".equalsIgnoreCase(entityNode.getNodeName()) || !entity.equalsIgnoreCase((shortNameNode = (nodeMap = entityNode.getAttributes()).getNamedItem("shortname")).getNodeValue())) continue;
            return entityNode;
        }
        return null;
    }

    public static void initializeMapsFromDB() {
        NodeList listOfMaps = doc.getElementsByTagName("xmlgatewaymap");
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < listOfMaps.getLength(); ++i) {
            Node mapNode = listOfMaps.item(i);
            if (mapNode == null) continue;
            NamedNodeMap attributeNode = mapNode.getAttributes();
            Node shortNameNode = attributeNode.getNamedItem("shortname");
            v.add(shortNameNode.getNodeValue());
        }
        mapsActuallyPresent = DBAccess.getActualMapsPresent(v);
        DBAccess.direction = "Outbound";
        extraMapsPresentOut = DBAccess.getExtraMapsPresent(v);
        DBAccess.direction = "Inbound";
        extraMapsPresentIn = DBAccess.getExtraMapsPresent(v);
    }

    public static IRepGenericTreeNode[] getOtherInterfaces(IRepGenericTreeNode parent) {
        IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[]{new IRepWFEventsInterfaceNode("Business Events", null, parent), new IRepCustomObjectsInterfaceNode("Custom Objects", "Custom Objects", null, parent)};
        return childrens;
    }

    public static IRepGenericTreeNode[] getCustomObjectsInterfaces(IRepGenericTreeNode parent) {
        IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[]{new IRepCustomAPIsInterfaceNode("PLSQL APIs", "PLSQL APIs", null, parent), new IRepCustomXGMInterfaceNode("XMLGateway Maps", "XMLGateway Maps", null, parent)};
        return childrens;
    }

    public static IRepGenericTreeNode[] getDirs(IRepGenericTreeNode parent) {
        IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[]{new IRepInDirNode("Inbound", "Inbound", null, parent), new IRepOutDirNode("Outbound", "Outbound", null, parent)};
        return childrens;
    }

    public static IRepGenericTreeNode[] getExtraMapsIn(IRepGenericTreeNode parent) {
        ArrayList v_in = extraMapsPresentIn;
        int size = v_in.size();
        IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[size];
        int i = 0;
        int j = 0;
        for (i = 0; i < v_in.size(); ++i) {
            childrens[j++] = new IRepMapNode((String)v_in.get(i), (String)v_in.get(i), null, "I", null, parent);
        }
        System.out.println("getExtraMaps: Maps Obtained In ");
        return childrens;
    }

    public static IRepGenericTreeNode[] getExtraMapsOut(IRepGenericTreeNode parent) {
        ArrayList v_out = extraMapsPresentOut;
        int size = v_out.size();
        IRepGenericTreeNode[] childrens = new IRepGenericTreeNode[size];
        int i = 0;
        int j = 0;
        for (i = 0; i < v_out.size(); ++i) {
            childrens[j++] = new IRepMapNode((String)v_out.get(i), (String)v_out.get(i), null, "O", null, parent);
        }
        System.out.println("getExtraMaps: Maps Obtained Out ");
        return childrens;
    }

    private static IRepGenericTreeNode addOtherInterfaces(IRepFilter filter, IRepGenericTreeNode root) {
        IRepGenericTreeNode[] children;
        int i;
        IRepGenericTreeNode[] children2;
        ArrayList<IRepGenericTreeNode> v;
        String objName = StringUtil.replaceAll(filter.getObjectName(), "\\_", "_").toUpperCase();
        IRepGenericTreeNode otherInterfacesNode = new IRepGenericTreeNode("Other Interfaces", "Other Interfaces", null, root);
        IRepGenericTreeNode wfEventsNode = new IRepGenericTreeNode("Business Events", "Business Events", null, otherInterfacesNode);
        IRepGenericTreeNode wfEventsINNode = new IRepGenericTreeNode("Inbound(Raise Business Events into Oracle Apps)", "Inbound(Raise Business Events into Oracle Apps)", null, wfEventsNode);
        IRepGenericTreeNode wfEventsOUTNode = new IRepGenericTreeNode("Outbound(Listen to Business Events from Oracle Apps)", "Outbound(Listen to Business Events from Oracle Apps)", null, wfEventsNode);
        IRepGenericTreeNode customObjectsNode = new IRepGenericTreeNode("Custom Objects", "Custom Objects", null, otherInterfacesNode);
        IRepGenericTreeNode customPLSQLNode = new IRepGenericTreeNode("PLSQL APIs", "PLSQL APIs", null, customObjectsNode);
        IRepGenericTreeNode customXMLGNode = new IRepGenericTreeNode("XMLGateway Maps", "XMLGateway Maps", null, customObjectsNode);
        IRepGenericTreeNode customXMLGINNode = new IRepGenericTreeNode("Inbound", "Inbound", null, customXMLGNode);
        IRepGenericTreeNode customXMLGOUTNode = new IRepGenericTreeNode("Outbound", "Outbound", null, customXMLGNode);
        boolean foundotherInterfacesNode = false;
        boolean foundwfEventsNode = false;
        boolean foundwfEventsINNode = false;
        boolean foundwfEventsOUTNode = false;
        boolean foundcustomObjectsNode = false;
        boolean foundcustomPLSQLNode = false;
        boolean foundcustomXMLGNode = false;
        boolean foundcustomXMLGINNode = false;
        boolean foundcustomXMLGOUTNode = false;
        if (filter.isWfEventSelected()) {
            IRepGenericTreeNode[] inboundchildren = DBAccess.getWFEvents(wfEventsINNode, "INBOUND", "search_mode", objName);
            IRepGenericTreeNode[] outboundchildren = DBAccess.getWFEvents(wfEventsOUTNode, "OUTBOUND", "search_mode", objName);
            foundwfEventsINNode = inboundchildren != null && inboundchildren.length > 0;
            foundwfEventsOUTNode = outboundchildren != null && outboundchildren.length > 0;
            wfEventsINNode.children = inboundchildren;
            wfEventsOUTNode.children = outboundchildren;
            v = new ArrayList<IRepGenericTreeNode>();
            if (foundwfEventsINNode) {
                v.add(wfEventsINNode);
            }
            if (foundwfEventsOUTNode) {
                v.add(wfEventsOUTNode);
            }
            if (v.size() > 0) {
                children2 = new IRepGenericTreeNode[v.size()];
                for (i = 0; i < v.size(); ++i) {
                    children2[i] = (IRepGenericTreeNode)v.get(i);
                }
                wfEventsNode.children = children2;
                foundwfEventsNode = true;
            }
        }
        if (filter.isPackageSelected()) {
            IRepGenericTreeNode[] plsqlchildren = DBAccess.getPackages("search_mode", objName, customPLSQLNode);
            foundcustomPLSQLNode = plsqlchildren != null && plsqlchildren.length > 0;
            customPLSQLNode.children = plsqlchildren;
            if (foundcustomPLSQLNode) {
                children = new IRepGenericTreeNode[]{customPLSQLNode};
                customObjectsNode.children = children;
                foundcustomObjectsNode = true;
            }
        }
        if (filter.isXmlMapSelected()) {
            String name;
            int i2;
            objName = objName.replaceAll("\\.", "\\[\\.\\]");
            objName = objName.replaceAll("\\$", "\\[\\$\\]");
            objName = objName.replaceAll("%", "\\.\\*");
            System.out.println("Search REGEX is :" + objName);
            ArrayList inxmlg = new ArrayList();
            ArrayList outxmlg = new ArrayList();
            for (i2 = 0; i2 < extraMapsPresentIn.size(); ++i2) {
                if (!((String)extraMapsPresentIn.get(i2)).toUpperCase().matches(objName)) continue;
                inxmlg.add(extraMapsPresentIn.get(i2));
            }
            for (i2 = 0; i2 < extraMapsPresentOut.size(); ++i2) {
                if (!((String)extraMapsPresentOut.get(i2)).toUpperCase().matches(objName)) continue;
                outxmlg.add(extraMapsPresentOut.get(i2));
            }
            foundcustomXMLGINNode = inxmlg.size() > 0;
            foundcustomXMLGOUTNode = outxmlg.size() > 0;
            v = new ArrayList();
            if (foundcustomXMLGINNode) {
                children2 = new IRepGenericTreeNode[inxmlg.size()];
                for (i = 0; i < inxmlg.size(); ++i) {
                    name = (String)inxmlg.get(i);
                    children2[i] = new IRepMapNode(name, name, "", "I", null, customXMLGINNode);
                }
                customXMLGINNode.children = children2;
                v.add(customXMLGINNode);
            }
            if (foundcustomXMLGOUTNode) {
                children2 = new IRepGenericTreeNode[outxmlg.size()];
                for (i = 0; i < outxmlg.size(); ++i) {
                    name = (String)outxmlg.get(i);
                    children2[i] = new IRepMapNode(name, name, "", "O", null, customXMLGOUTNode);
                }
                customXMLGOUTNode.children = children2;
                v.add(customXMLGOUTNode);
            }
            if (v.size() > 0) {
                children2 = new IRepGenericTreeNode[v.size()];
                for (i = 0; i < v.size(); ++i) {
                    children2[i] = (IRepGenericTreeNode)v.get(i);
                }
                customXMLGNode.children = children2;
                foundcustomXMLGNode = true;
            }
        }
        ArrayList<IRepGenericTreeNode> v2 = new ArrayList<IRepGenericTreeNode>();
        if (foundcustomPLSQLNode) {
            v2.add(customPLSQLNode);
        }
        if (foundcustomXMLGNode) {
            v2.add(customXMLGNode);
        }
        if (v2.size() > 0) {
            children = new IRepGenericTreeNode[v2.size()];
            for (int i3 = 0; i3 < v2.size(); ++i3) {
                children[i3] = (IRepGenericTreeNode)v2.get(i3);
            }
            customObjectsNode.children = children;
            foundcustomObjectsNode = true;
        }
        v2 = new ArrayList();
        if (foundwfEventsNode) {
            v2.add(wfEventsNode);
        }
        if (foundcustomObjectsNode) {
            v2.add(customObjectsNode);
        }
        if (v2.size() > 0) {
            children = new IRepGenericTreeNode[v2.size()];
            for (int i4 = 0; i4 < v2.size(); ++i4) {
                children[i4] = (IRepGenericTreeNode)v2.get(i4);
            }
            otherInterfacesNode.children = children;
            foundotherInterfacesNode = true;
        }
        return foundotherInterfacesNode ? otherInterfacesNode : null;
    }
}

