/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.DBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.Attribute;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.DtdInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.ProcedureParam;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.Selection;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.WFEventInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.detailpanel.DBTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.detailpanel.DTDTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.detailpanel.EBSTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.detailpanel.ProcTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.detailpanel.WFEventTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepBrowserWindow;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepExtraProcedureNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepGenericTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepMapNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepProcedureNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepTableNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepViewNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepWFEventNode;

public class IRepDetailPanel
extends JPanel
implements TreeSelectionListener,
Selection {
    private IRepBrowserWindow browser = null;
    private JTable detailTable = null;
    private JScrollPane tableSP = null;
    private JLabel payloadL = null;
    private JTextArea payloadTA = null;
    private JScrollPane payloadTASP = null;
    private JButton doneB = null;
    private JButton cancelB = null;
    private TableModel detailTableModel = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;

    public IRepDetailPanel(IRepBrowserWindow browser) {
        this.browser = browser;
        this.jbInit();
    }

    private void jbInit() {
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.setLayout(this.gbl);
        System.out.println("jbInit starts");
        this.detailTable = new JTable();
        this.detailTable.setAutoResizeMode(4);
        this.tableSP = new JScrollPane(this.detailTable);
        this.dbsetting();
        this.add_buttons();
        System.out.println("jbInit ends");
    }

    public void xmlMapSetting() {
        this.removeAll();
        System.out.println("In xmlmap settings");
        this.tableSP.setPreferredSize(new Dimension(100, 85));
        this.gbc.fill = 2;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(10, 10, 5, 10);
        this.gbl.setConstraints(this.tableSP, this.gbc);
        this.add(this.tableSP);
        System.out.println("table added");
        this.payloadL = new JLabel("Payload");
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 1;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(5, 10, 0, 10);
        this.gbl.setConstraints(this.payloadL, this.gbc);
        this.add(this.payloadL);
        System.out.println("label added");
        this.payloadTA = new JTextArea();
        this.payloadTA.setEditable(false);
        this.payloadTASP = new JScrollPane(this.payloadTA);
        this.payloadTASP.setPreferredSize(new Dimension(100, 100));
        this.payloadTASP.setVerticalScrollBarPolicy(20);
        this.payloadTASP.setHorizontalScrollBarPolicy(30);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 100.0;
        this.gbc.fill = 1;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(0, 10, 0, 10);
        this.gbl.setConstraints(this.payloadTASP, this.gbc);
        this.add(this.payloadTASP);
        System.out.println("text area added");
        this.add_buttons();
        System.out.println("buttons added");
        this.repaint();
    }

    public void dbsetting() {
        this.removeAll();
        System.out.println("in db setting");
        this.gbc.fill = 1;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.gbl.setConstraints(this.tableSP, this.gbc);
        this.add(this.tableSP);
        System.out.println("table added");
        this.add_buttons();
        System.out.println("buttons added");
        this.repaint();
    }

    public void add_buttons() {
        AbstractAction doneAction = this.browser.getDoneAction();
        this.doneB = new JButton(doneAction);
        this.doneB.setMnemonic(StringUtils.getMnemonicKeyCode((String)IRepBrowserWindow.getTranslatedString("OA_MB_APPLY_BUTTON")));
        this.doneB.setDisplayedMnemonicIndex(IRepBrowserWindow.getTranslatedString("OA_MB_APPLY_BUTTON").indexOf("&"));
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = -1;
        this.gbc.weightx = 50.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 13;
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.gbl.setConstraints(this.doneB, this.gbc);
        this.add(this.doneB);
        this.doneB.setEnabled(false);
        this.cancelB = new JButton(this.browser.getCancelAction());
        this.cancelB.setMnemonic(27);
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 50.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.gbl.setConstraints(this.cancelB, this.gbc);
        this.add(this.cancelB);
        this.cancelB.setEnabled(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        IRepBrowserWindow.getWindow().setCursor(Cursor.getPredefinedCursor(3));
        TreePath path = e.getPath();
        Object obj = path.getLastPathComponent();
        if (((IRepGenericTreeNode)obj).isLeaf()) {
            this.clear();
        }
        this.doneB.setEnabled(true);
        if (obj instanceof IRepTableNode || obj instanceof IRepViewNode) {
            this.clear();
            this.dbsetting();
            this.doneB.setEnabled(true);
            IRepTableNode node = null;
            Attribute[] attributes = null;
            if (obj instanceof IRepViewNode) {
                node = (IRepViewNode)obj;
                attributes = DBAccess.getViewAttributes(this.getModShortName(node.shortName), node.schemaName);
            } else if (obj instanceof IRepTableNode) {
                node = (IRepTableNode)obj;
                System.out.println("IRepTableNode : " + node.shortName + " : " + node.schemaName);
                attributes = DBAccess.getTableAttributes(this.getModShortName(node.shortName), null);
            }
            this.detailTableModel = null;
            node.setAttributes(attributes);
            this.detailTableModel = new DBTableModel(node.getAttributes());
            this.setModel(this.detailTableModel);
        } else if (obj instanceof IRepExtraProcedureNode) {
            this.clear();
            this.dbsetting();
            this.doneB.setEnabled(true);
            IRepExtraProcedureNode procNode = (IRepExtraProcedureNode)obj;
            this.detailTableModel = null;
            String procName = procNode.shortName;
            String pkgName = procNode.packageName;
            String objectId = procNode.objectId;
            int overload = procNode.getOverload();
            ProcedureParam[] procParams = null;
            procParams = DBAccess.getProcAttributes(this.getModShortName(procName), pkgName, objectId, overload);
            procNode.setParams(procParams);
            this.detailTableModel = new ProcTableModel(procParams);
            this.setModel(this.detailTableModel);
        } else if (obj instanceof IRepWFEventNode) {
            this.clear();
            this.dbsetting();
            this.doneB.setEnabled(true);
            IRepWFEventNode node = (IRepWFEventNode)obj;
            this.detailTableModel = null;
            ArrayList v = DBAccess.getWFEventDetails(node.shortName);
            this.detailTableModel = new WFEventTableModel(new WFEventInfo((String)v.get(0), (String)v.get(1), (String)v.get(2), (String)v.get(3), (String)v.get(4), (String)v.get(5), (String)v.get(6), (String)v.get(7), (String)v.get(8), (String)v.get(9), node.direction));
            this.setModel(this.detailTableModel);
        } else if (obj instanceof IRepProcedureNode) {
            this.clear();
            this.dbsetting();
            this.doneB.setEnabled(true);
            IRepProcedureNode procNode = (IRepProcedureNode)obj;
            this.detailTableModel = null;
            if ("CONCURRENT_PROGRAM".equals(procNode.packageName)) {
                String procName = procNode.shortName;
                ProcedureParam[] procParams = DBAccess.getCPAttributes(this.getModShortName(procName));
                procNode.setParams(procParams);
                this.detailTableModel = new ProcTableModel(procParams);
            } else {
                String procName = procNode.shortName;
                String pkgName = procNode.packageName;
                String objectId = procNode.objectId;
                int overload = procNode.getOverload();
                ProcedureParam[] procParams = null;
                procParams = DBAccess.getProcAttributes(this.getModShortName(procName), pkgName, objectId, overload);
                procNode.setParams(procParams);
                this.detailTableModel = new ProcTableModel(procParams);
            }
            this.setModel(this.detailTableModel);
        } else if (obj instanceof IRepMapNode) {
            this.clear();
            this.xmlMapSetting();
            this.doneB.setEnabled(true);
            IRepMapNode iRepMapNode = (IRepMapNode)obj;
            String mapName = this.getModShortName(iRepMapNode.shortName);
            DtdInfo dtdInfo = DBAccess.getDtdDetailsFromMap(mapName);
            if (dtdInfo != null) {
                dtdInfo.direction = iRepMapNode.direction;
                System.out.println("shortName = " + iRepMapNode.shortName + " direction = " + iRepMapNode.direction);
                this.detailTableModel = null;
                this.detailTableModel = new DTDTableModel(dtdInfo);
                this.setModel(this.detailTableModel);
                this.payloadTA.setText(dtdInfo.payload);
                this.payloadTA.setCaretPosition(0);
            } else {
                this.clear();
                System.out.println("DTDInfo is null for : " + mapName);
            }
        } else {
            this.clear();
        }
        this.revalidate();
        IRepBrowserWindow.getWindow().setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public Attribute[] getSelectedAttributes() {
        int[] selRows = this.detailTable.getSelectedRows();
        EBSTableModel model = (EBSTableModel)this.detailTable.getModel();
        Attribute[] selAttrs = model.getSelectedAttributes(selRows);
        return selAttrs;
    }

    private void clear() {
        this.clearTable();
        if (this.payloadTA != null) {
            this.payloadTA.setText("");
        }
        this.doneB.setEnabled(false);
    }

    void clearTable() {
        this.detailTableModel = null;
        this.detailTableModel = new DefaultTableModel();
        this.setModel(this.detailTableModel);
        if (this.payloadTA != null) {
            this.payloadTA.setText("");
        }
        this.invalidate();
    }

    private void setModel(TableModel tableModel) {
        TableColumn tc;
        int numCols;
        this.detailTable.setModel(tableModel);
        TableColumnModel tcm = this.detailTable.getColumnModel();
        if (tcm != null && (numCols = tcm.getColumnCount()) > 0 && (tc = tcm.getColumn(0)) != null) {
            tc.setPreferredWidth(Math.max(300, 20));
        }
    }

    private String getModShortName(String name) {
        String modShortName = null;
        int loc = name.indexOf(":");
        modShortName = loc == -1 ? name : name.substring(loc + 1, name.length());
        return modShortName;
    }
}

