/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.util.BundleLoader;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.DBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.Attribute;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.DtdInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.ISMessageType;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.ProcedureParam;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.SchemaObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.SelectedCols;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.Selection;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.WFEventInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepDetailPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepFilter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepGenericTreeCellRenderer;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepGenericTreeModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepSearchPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.IRepTreeExpansionListener;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.i11510.HostedIRepFileTreeMaker;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepExtraProcedureNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepGenericTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepMapNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepProcedureNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepTableNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepViewNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.metadata.IRepWFEventNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.iRep.post11510.LocalIRepTreeMaker;

public class IRepBrowserWindow
extends JDialog {
    public static String[] cpArgNames;
    public static String RESOURCE_BUNDLE;
    public static ResourceBundle s_rbundle;
    private static int rowToExpand;
    private static TreePath treepath;
    public static String selectedNode;
    private IRepFilter filter = null;
    private JPanel searchPanel = null;
    private Selection selection = null;
    private IRepDetailPanel detailPanel = null;
    JScrollPane ebizTreeSP = null;
    private JTree ebizTree = null;
    private SelectedCols selCols = null;
    private static IRepBrowserWindow window;
    private ISMessageType msgType = null;
    private String m_search_string = null;
    private String m_search_type = null;

    public IRepBrowserWindow(SelectedCols selCols, Frame parentFrame, ISMessageType msgType, String title, String search_string, String search_type) {
        super(parentFrame, title, true);
        System.out.println("int called. ");
        this.init(selCols, parentFrame, msgType, search_string, search_type);
    }

    public void init(SelectedCols selCols, Frame parentFrame, ISMessageType msgType, String search_string, String search_type) {
        if (s_rbundle == null) {
            s_rbundle = BundleLoader.getBundle((String)RESOURCE_BUNDLE);
        }
        this.m_search_string = search_string;
        this.m_search_type = search_type;
        this.msgType = msgType;
        this.selCols = selCols;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                IRepBrowserWindow.this.dispose();
            }
        });
        window = this;
        System.out.println("int function ends. ");
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void setVisible(boolean show) {
        if (!show) {
            return;
        }
        System.out.println("setVisible starts . ");
        this.setSize(new Dimension(1024, 675));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.getContentPane().setLayout(gbl);
        this.searchPanel = new IRepSearchPanel(this);
        this.filter = (IRepFilter)((Object)this.searchPanel);
        if (this.m_search_type != null) {
            System.out.println("Restoring search criteria");
            ((IRepSearchPanel)this.searchPanel).setObjectName(this.m_search_string);
            ((IRepSearchPanel)this.searchPanel).setType(this.m_search_type);
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 5.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbl.setConstraints(this.searchPanel, gbc);
        this.getContentPane().add(this.searchPanel);
        this.detailPanel = this.getDetailPanel();
        this.ebizTree = this.getTree();
        this.ebizTree.getSelectionModel().setSelectionMode(1);
        this.ebizTree.addTreeSelectionListener(this.detailPanel);
        this.ebizTree.setCellRenderer(new IRepGenericTreeCellRenderer());
        this.ebizTreeSP = new JScrollPane(this.ebizTree);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerLocation(300);
        splitPane.setLeftComponent(this.ebizTreeSP);
        splitPane.setRightComponent(this.detailPanel);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbl.setConstraints(splitPane, gbc);
        this.getContentPane().add(splitPane);
        if (treepath != null && DBAccess.IS11510) {
            this.expandPath();
        }
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRepBrowserWindow.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.centerWindow();
        super.setVisible(show);
        System.out.println("setVisible finished. . ");
    }

    private JTree getTree() {
        return DBAccess.IS11510 || DBAccess.ISIRepDumpUsed ? HostedIRepFileTreeMaker.getTree() : (DBAccess.ISPOST11510 ? LocalIRepTreeMaker.getTree() : null);
    }

    public AbstractAction getSearchAction() {
        return new SearchAction(StringUtils.stripMnemonic((String)IRepBrowserWindow.getTranslatedString("OA_MB_SEARCH_BUTTON")));
    }

    public AbstractAction getModuleViewAction() {
        return new BrowseAction(StringUtils.stripMnemonic((String)IRepBrowserWindow.getTranslatedString("OA_MB_BROWSE_BUTTON")));
    }

    public AbstractAction getDoneAction() {
        return new IRepDoneAction(StringUtils.stripMnemonic((String)IRepBrowserWindow.getTranslatedString("OA_MB_APPLY_BUTTON")));
    }

    public AbstractAction getCancelAction() {
        return new CancelAction(StringUtils.stripMnemonic((String)IRepBrowserWindow.getTranslatedString("OA_MB_CANCEL_BUTTON")));
    }

    private IRepDetailPanel getDetailPanel() {
        if (this.detailPanel != null) {
            return this.detailPanel;
        }
        this.detailPanel = new IRepDetailPanel(this);
        this.selection = this.detailPanel;
        return this.detailPanel;
    }

    private JPanel getSearchPanel() {
        return new IRepSearchPanel(this);
    }

    public static IRepBrowserWindow getWindow() {
        return window;
    }

    private void importTableViewAttributes(IRepTableNode node, Attribute[] selAttrs) {
        this.selCols.createType(node.getQTableName());
        this.selCols.setToAdd(true);
        if (selAttrs != null) {
            for (int i = 0; i < selAttrs.length; ++i) {
                Attribute attr = selAttrs[i];
                this.selCols.addAttribute(node.getQTableName(), attr.name, attr.oType.toString(), attr.getArrayType());
            }
        } else {
            for (int i = 0; i < node.attributes.length; ++i) {
                Attribute attr = node.attributes[i];
                this.selCols.addAttribute(node.getQTableName(), attr.name, attr.oType.toString(), attr.getArrayType());
            }
        }
    }

    private void importProcArguments(IRepProcedureNode node, Attribute[] selAttrs) {
        if (node != null) {
            if (this.msgType != null && this.msgType.isEBSWFQ()) {
                this.selCols.createProcedureForEBSWFQ(node.toString(), node.getOverload());
            } else {
                this.selCols.createProcedure(node.getProcedureName(), node.getOverload());
            }
            this.selCols.setToAdd(true);
            int count = 0;
            if (node.packageName.equals("CONCURRENT_PROGRAM")) {
                int i;
                SchemaObject oType0 = new SchemaObject(null, "NUMBER");
                SchemaObject oType = new SchemaObject(null, "VARCHAR2");
                SchemaObject oType2 = new SchemaObject(null, "INTEGER");
                this.selCols.setToAdd(true);
                this.selCols.addArgument("REQUEST_ID", oType0.toString(), null, true, false, "OUT", 1, 0, "NUMBER", node.getOverload());
                this.selCols.addArgument("RETURN_CODE", oType.toString(), null, true, false, "OUT", 2, 0, "VARCHAR2", node.getOverload());
                this.selCols.addArgument("RETURN_MESSAGE", oType.toString(), null, true, false, "OUT", 3, 0, "VARCHAR2", node.getOverload());
                this.selCols.addArgument("APPLICATION", oType.toString(), null, false, true, "IN", 4, 0, "VARCHAR2", node.getOverload());
                this.selCols.addArgument("PROGRAM", oType.toString(), null, false, true, "IN", 5, 0, "VARCHAR2", node.getOverload());
                this.selCols.addArgument("DESCRIPTION", oType.toString(), null, false, true, "IN", 6, 0, "VARCHAR2", node.getOverload());
                this.selCols.addArgument("START_TIME", oType.toString(), null, false, true, "IN", 7, 0, "VARCHAR2", node.getOverload());
                this.selCols.addArgument("SUB_REQUEST", oType2.toString(), null, false, true, "IN", 8, 0, "INTEGER", node.getOverload());
                for (i = 1; i <= 100; ++i) {
                    String arg = "ARGUMENT" + i;
                    this.selCols.addArgument(arg, oType.toString(), null, false, true, "IN", i + 8, 0, "VARCHAR2", 0);
                }
                cpArgNames = null;
                if (node.params != null) {
                    cpArgNames = new String[node.params.length];
                    for (i = 0; i < node.params.length; ++i) {
                        IRepBrowserWindow.cpArgNames[i] = (node.params[i].name == null ? "" : node.params[i].name).replaceAll("[ ]*", "");
                        IRepBrowserWindow.cpArgNames[i] = cpArgNames[i].replaceAll("[:]", "_");
                    }
                }
                count = 105;
                return;
            }
            if (selAttrs != null) {
                int i = 0;
                for (i = 0; i < selAttrs.length; ++i) {
                    ProcedureParam attr = (ProcedureParam)selAttrs[i];
                    this.addAttributeRecursively(attr);
                    this.selCols.setToAdd(true);
                    if (node.packageName.equals("CONCURRENT_PROGRAM")) {
                        this.selCols.addArgument(attr.origName, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                        continue;
                    }
                    if (this.msgType != null && this.msgType.isEBSWFQ()) {
                        this.selCols.addArgumentForEBSWFQ(node.toString(), attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                        continue;
                    }
                    this.selCols.addArgument(attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                }
                count += i;
            } else if (node.params != null) {
                int i = 0;
                for (i = 0; i < node.params.length; ++i) {
                    ProcedureParam attr = node.params[i];
                    this.addAttributeRecursively(attr);
                    this.selCols.setToAdd(true);
                    if (node.packageName.equals("CONCURRENT_PROGRAM")) {
                        this.selCols.addArgument(attr.origName, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                        continue;
                    }
                    if (this.msgType != null && this.msgType.isEBSWFQ()) {
                        this.selCols.addArgumentForEBSWFQ(node.toString(), attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                        continue;
                    }
                    this.selCols.addArgument(attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                }
                int n = count + i;
            }
        }
    }

    private void importProcArguments(IRepExtraProcedureNode node, Attribute[] selAttrs) {
        if (node != null) {
            if (this.msgType != null && this.msgType.isEBSWFQ()) {
                this.selCols.createProcedureForEBSWFQ(node.toString(), node.getOverload());
            } else {
                this.selCols.createProcedure(node.getProcedureName(), node.getOverload());
            }
            this.selCols.setToAdd(true);
            int count = 0;
            if (selAttrs != null) {
                int i = 0;
                for (i = 0; i < selAttrs.length; ++i) {
                    ProcedureParam attr = (ProcedureParam)selAttrs[i];
                    this.addAttributeRecursively(attr);
                    this.selCols.setToAdd(true);
                    if (this.msgType != null && this.msgType.isEBSWFQ()) {
                        this.selCols.addArgumentForEBSWFQ(node.toString(), attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                        continue;
                    }
                    this.selCols.addArgument(attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                }
                count += i;
            } else if (node.params != null) {
                int i = 0;
                for (i = 0; i < node.params.length; ++i) {
                    ProcedureParam attr = node.params[i];
                    this.addAttributeRecursively(attr);
                    this.selCols.setToAdd(true);
                    if (this.msgType != null && this.msgType.isEBSWFQ()) {
                        this.selCols.addArgumentForEBSWFQ(node.toString(), attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                        continue;
                    }
                    this.selCols.addArgument(attr.name, attr.elType != null ? attr.elType.toString() : attr.oType.toString(), attr.elType != null ? attr.oType.toString() : null, attr.isOut, attr.isIn, attr.inoutstr, attr.position + count, attr.sequence, attr.datatype, attr.overload);
                }
                int n = count + i;
            }
        }
    }

    private void addAttributeRecursively(Attribute attr) {
        if (attr.isPrimitive()) {
            return;
        }
        try {
            attr.createType(this.selCols);
        }
        catch (SelectedCols.AlreadyExist ex) {
            MultiLineOptionPane.showMessageDialog((Component)JOptionPane.getRootFrame(), (Object)("Type " + attr.toString() + " already exists. Will use existing definition."), (String)"Problem", (int)2);
        }
        this.selCols.setToAdd(false);
        Attribute[] attrs = DBAccess.getAdtAttributes(attr);
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                Attribute childAttr = attrs[i];
                if (!childAttr.isPrimitive()) {
                    this.addAttributeRecursively(childAttr);
                }
                attr.addAttribute(this.selCols, childAttr);
            }
        }
    }

    private void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static String getTranslatedString(String messageKey) {
        return s_rbundle.getString(messageKey);
    }

    public void expandPath() {
        rowToExpand = 0;
        Object[] path = treepath.getPath();
        IRepGenericTreeModel gtm = (IRepGenericTreeModel)this.ebizTree.getModel();
        IRepGenericTreeNode treeNode = (IRepGenericTreeNode)gtm.getRoot();
        this.expandPathRec(treeNode, path, 1);
    }

    public void expandPathRec(IRepGenericTreeNode parent, Object[] path, int count) {
        IRepGenericTreeNode[] children = parent.children;
        IRepGenericTreeNode nodeToSearch = (IRepGenericTreeNode)path[count];
        System.out.println("Searching node " + nodeToSearch.shortName + " : " + nodeToSearch.fullName);
        int i = 0;
        for (i = 0; i < children.length; ++i) {
            if (!children[i].shortName.equalsIgnoreCase(nodeToSearch.shortName)) continue;
            System.out.println("Expanding node " + nodeToSearch.shortName + " : " + nodeToSearch.fullName);
            System.out.println("RowId " + (rowToExpand + i + 1));
            this.ebizTree.expandRow(rowToExpand + i + 1);
            this.ebizTree.scrollRowToVisible(rowToExpand + i + 1);
            break;
        }
        if (i < children.length) {
            rowToExpand += i + 1;
            if (count < path.length - 2) {
                this.expandPathRec(children[i], path, count + 1);
            }
        }
    }

    static {
        RESOURCE_BUNDLE = "oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterResource";
        s_rbundle = null;
        rowToExpand = 0;
        treepath = null;
        selectedNode = "any";
        window = null;
    }

    class CancelAction
    extends AbstractAction {
        CancelAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IRepBrowserWindow.this.dispose();
        }
    }

    class IRepDoneAction
    extends AbstractAction {
        IRepDoneAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Attribute[] params;
            IRepGenericTreeNode procNode;
            treepath = IRepBrowserWindow.this.ebizTree.getSelectionPath();
            IRepGenericTreeNode node = (IRepGenericTreeNode)IRepBrowserWindow.this.ebizTree.getSelectionPath().getLastPathComponent();
            if (node instanceof IRepTableNode || node instanceof IRepViewNode) {
                IRepTableNode tableNode = (IRepTableNode)node;
                Attribute[] selAttrs = IRepBrowserWindow.this.selection.getSelectedAttributes();
                IRepBrowserWindow.this.importTableViewAttributes(tableNode, selAttrs);
            } else if (node instanceof IRepProcedureNode) {
                procNode = (IRepProcedureNode)node;
                params = IRepBrowserWindow.this.selection.getSelectedAttributes();
                IRepBrowserWindow.this.importProcArguments(procNode, params);
            } else if (node instanceof IRepExtraProcedureNode) {
                procNode = (IRepExtraProcedureNode)node;
                params = IRepBrowserWindow.this.selection.getSelectedAttributes();
                IRepBrowserWindow.this.importProcArguments((IRepExtraProcedureNode)procNode, params);
            } else if (node instanceof IRepMapNode) {
                String mapName = node.shortName;
                DtdInfo dtdInfo = DBAccess.getDtdDetailsFromMap(mapName);
                if (dtdInfo == null) {
                    return;
                }
                IRepBrowserWindow.this.selCols.setDtdInfo(dtdInfo);
                dtdInfo.direction = ((IRepMapNode)node).direction;
                selectedNode = "xmlmap";
            } else if (node instanceof IRepWFEventNode) {
                IRepWFEventNode nod = (IRepWFEventNode)node;
                ArrayList v = DBAccess.getWFEventDetails(nod.shortName);
                WFEventInfo wfeventInfo = new WFEventInfo((String)v.get(0), (String)v.get(1), (String)v.get(2), (String)v.get(3), (String)v.get(4), (String)v.get(5), (String)v.get(6), (String)v.get(7), (String)v.get(8), (String)v.get(9), nod.direction);
                IRepBrowserWindow.this.selCols.setWFEventInfo(wfeventInfo);
                if (nod.direction.equalsIgnoreCase("INBOUND")) {
                    SchemaObject oType0 = new SchemaObject(null, "NUMBER");
                    SchemaObject oType = new SchemaObject(null, "VARCHAR2");
                    SchemaObject oType1 = new SchemaObject(null, "DATE");
                    IRepBrowserWindow.this.selCols.createProcedure("XX_BPEL_RAISE_EVENT.WF_EVENT$RAISE", 0);
                    IRepBrowserWindow.this.selCols.setToAdd(true);
                    IRepBrowserWindow.this.selCols.addArgument(null, oType0.toString(), null, true, false, "OUT", 0, 0, "VARCHAR2", 0);
                    IRepBrowserWindow.this.selCols.addArgument("EVENT_NAME", oType.toString(), null, false, true, "IN", 1, 0, "VARCHAR2", 0);
                    IRepBrowserWindow.this.selCols.addArgument("EVENT_DATA", oType.toString(), null, false, true, "IN", 2, 0, "VARCHAR2", 0);
                    int i = 1;
                    IRepBrowserWindow.this.selCols.addArgument("SEND_DATE", oType1.toString(), null, false, true, "IN", 3, 0, "DATE", 0);
                    int j = 4;
                    while (i <= 100) {
                        String arg = "PARAMETER_NAME" + i;
                        IRepBrowserWindow.this.selCols.addArgument(arg, oType.toString(), null, false, true, "IN", j, 0, "VARCHAR2", 0);
                        arg = "PARAMETER_VALUE" + i;
                        IRepBrowserWindow.this.selCols.addArgument(arg, oType.toString(), null, false, true, "IN", j + 1, 0, "VARCHAR2", 0);
                        ++i;
                        j += 2;
                    }
                }
            }
            IRepGenericTreeNode gtn = node.parent;
            IRepBrowserWindow.this.selCols.setModuleName(gtn.shortName);
            if (IRepBrowserWindow.this.searchPanel instanceof IRepSearchPanel) {
                IRepSearchPanel efp = (IRepSearchPanel)IRepBrowserWindow.this.searchPanel;
                IRepBrowserWindow.this.selCols.setSearch(efp.getObjectName(), efp.getType());
            }
            IRepBrowserWindow.this.dispose();
        }
    }

    class BrowseAction
    extends AbstractAction {
        BrowseAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IRepBrowserWindow.this.ebizTreeSP.getVerticalScrollBar().setValue(0);
            IRepBrowserWindow.this.ebizTreeSP.getHorizontalScrollBar().setValue(0);
            if (IRepBrowserWindow.this.searchPanel instanceof IRepSearchPanel) {
                IRepSearchPanel efp = (IRepSearchPanel)IRepBrowserWindow.this.searchPanel;
                efp.clearFilterPanel();
            }
            IRepGenericTreeModel irepTreeModel = DBAccess.IS11510 || DBAccess.ISIRepDumpUsed ? HostedIRepFileTreeMaker.getIRepTreeModel() : (DBAccess.ISPOST11510 ? LocalIRepTreeMaker.getIRepTreeModel() : null);
            TreeExpansionListener[] expListeners = IRepBrowserWindow.this.ebizTree.getTreeExpansionListeners();
            for (int i = 0; i < expListeners.length; ++i) {
                if (!(expListeners[i] instanceof IRepTreeExpansionListener)) continue;
                IRepBrowserWindow.this.ebizTree.removeTreeExpansionListener(expListeners[i]);
                break;
            }
            IRepBrowserWindow.this.ebizTree.setModel(irepTreeModel);
            IRepBrowserWindow.this.ebizTree.addTreeExpansionListener(new IRepTreeExpansionListener(irepTreeModel));
            IRepBrowserWindow.this.ebizTree.setShowsRootHandles(true);
            IRepBrowserWindow.this.detailPanel.clearTable();
        }
    }

    class SearchAction
    extends AbstractAction {
        SearchAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isUserInputValid()) {
                return;
            }
            IRepBrowserWindow.this.ebizTreeSP.getVerticalScrollBar().setValue(0);
            IRepBrowserWindow.this.ebizTreeSP.getHorizontalScrollBar().setValue(0);
            IRepBrowserWindow.getWindow().setCursor(Cursor.getPredefinedCursor(3));
            IRepGenericTreeModel searchTreeModel = DBAccess.IS11510 || DBAccess.ISIRepDumpUsed ? HostedIRepFileTreeMaker.getSearchTreeModel(IRepBrowserWindow.this.filter) : (DBAccess.ISPOST11510 ? LocalIRepTreeMaker.getSearchTreeModel(IRepBrowserWindow.this.filter) : null);
            TreeExpansionListener[] expListeners = IRepBrowserWindow.this.ebizTree.getTreeExpansionListeners();
            for (int i = 0; i < expListeners.length; ++i) {
                if (!(expListeners[i] instanceof IRepTreeExpansionListener)) continue;
                IRepBrowserWindow.this.ebizTree.removeTreeExpansionListener(expListeners[i]);
                break;
            }
            IRepBrowserWindow.this.ebizTree.setModel(searchTreeModel);
            IRepBrowserWindow.this.ebizTree.addTreeExpansionListener(new IRepTreeExpansionListener(searchTreeModel));
            IRepBrowserWindow.this.ebizTree.setShowsRootHandles(true);
            IRepBrowserWindow.this.detailPanel.clearTable();
            System.out.println("getting searchTreeModel ");
            IRepBrowserWindow.getWindow().setCursor(Cursor.getPredefinedCursor(0));
        }

        private boolean isUserInputValid() {
            String objName = IRepBrowserWindow.this.filter.getObjectName();
            if (objName == null) {
                return false;
            }
            if (objName != null) {
                objName = objName.trim();
            }
            if ("".equals(objName)) {
                return false;
            }
            return IRepBrowserWindow.this.filter.isTableSelected() || IRepBrowserWindow.this.filter.isViewSelected() || IRepBrowserWindow.this.filter.isPackageSelected() || IRepBrowserWindow.this.filter.isCPSelected() || IRepBrowserWindow.this.filter.isXmlMapSelected() || IRepBrowserWindow.this.filter.isEdiProgSelected() || IRepBrowserWindow.this.filter.isADTSelected() || IRepBrowserWindow.this.filter.isWfEventSelected();
        }
    }
}

