/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata;

import java.util.Vector;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.DBAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.DtdInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.WFEventInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.StringUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;

public class SelectedCols {
    public String m_objectname = null;
    public String m_procedure_name = null;
    public Vector m_proc_args = null;
    public PackageObject m_packageObject = null;
    public ProcedureObject m_procObj = null;
    public String m_selected_module_name = null;
    public String m_search_string = null;
    public String m_search_type = null;
    DtdInfo m_dtdInfo = null;
    WFEventInfo m_wfeventInfo = null;

    public void createProcedure(String name, int overload) {
        this.m_procedure_name = name;
        this.m_objectname = name;
        String package_name = this.getPackageName();
        String package_schema = DBAccess.getAppsSchema();
        this.m_packageObject = package_name != null ? new PackageObject(package_name, package_schema) : null;
        String objectID = null;
        String shortname = this.getProcedureName();
        String schema = DBAccess.getAppsSchema();
        this.m_procObj = new ProcedureObject(objectID, shortname, schema, this.m_packageObject, overload, false);
    }

    public void createProcedureForEBSWFQ(String name, int overload) {
        this.createProcedure(name, overload);
    }

    public void addArgument(String name, String attrType, String arrayType, boolean isOut, boolean isin, String inout_in, int position_in, int sequence_in, String attrDatatype, int overload) {
        if (this.m_proc_args == null) {
            this.m_proc_args = new Vector();
        }
        this.m_proc_args.add(name + " " + attrType);
        String argobjectID = null;
        String argoverload = null;
        String argumentName = name;
        String position = Integer.toString(position_in);
        String sequence = Integer.toString(sequence_in);
        String datatype = attrDatatype;
        String datatypeSchema = StringUtil.parseSchema(attrType);
        String inOut = inout_in;
        String typeName = null;
        typeName = arrayType != null ? StringUtil.parseDatatypeName(arrayType) : StringUtil.parseDatatypeName(attrType);
        if (overload > 0) {
            argoverload = String.valueOf(overload);
        }
        ArgumentObject argObj = new ArgumentObject(argobjectID, argumentName, argoverload, position, sequence, typeName, datatype, datatypeSchema, inOut, 0, 0, this.m_procObj);
        this.m_procObj.addArgument(argObj);
    }

    public void addArgumentForEBSWFQ(String parentType, String name, String attrType, String arrayType, boolean isOut, boolean isin, String inout_in, int position_in, int sequence_in, String attrDatatype, int overload) {
        this.addArgument(name, attrType, arrayType, isOut, isin, inout_in, position_in, sequence_in, attrDatatype, overload);
    }

    public void createType(String typeName) {
        this.m_objectname = typeName;
    }

    public void addAttribute(String parentType, String attrName, String attrType, String arrayType) {
        Object tempstr = null;
    }

    public void addRow(String[] colData) {
        Object tempstr = null;
    }

    public void setToAdd(boolean b) {
        Object tempstr = null;
    }

    public String getSelectedName() {
        return this.m_objectname;
    }

    public String getLongProcedureName() {
        String tempstr = this.m_procedure_name + "(";
        if (this.m_proc_args != null) {
            int argcnt = this.m_proc_args.size();
            for (int ii = 0; ii < argcnt; ++ii) {
                if (ii > 0) {
                    tempstr = tempstr + ",";
                }
                tempstr = tempstr + (String)this.m_proc_args.get(ii);
            }
        }
        tempstr = tempstr + ")";
        return tempstr;
    }

    public boolean isProcedureSelected() {
        return this.m_procedure_name != null;
    }

    public String getProcedureName() {
        int packint = this.m_procedure_name.indexOf(".");
        if (packint > 0) {
            return this.m_procedure_name.substring(packint + 1);
        }
        return this.m_procedure_name;
    }

    public String getPackageName() {
        int packint = this.m_procedure_name.indexOf(".");
        if (packint > 0) {
            return this.m_procedure_name.substring(0, packint);
        }
        return null;
    }

    public String getProcedureNameWithPackage() {
        return this.m_procedure_name;
    }

    public void setModuleName(String modin) {
        this.m_selected_module_name = modin;
    }

    public String getModuleName() {
        return this.m_selected_module_name;
    }

    public void setSearch(String sstr, String stype) {
        this.m_search_string = sstr;
        this.m_search_type = stype;
    }

    public String getSearch() {
        return this.m_search_string;
    }

    public String getSearchType() {
        return this.m_search_type;
    }

    public void setDtdInfo(DtdInfo dtdInfo) {
        this.m_dtdInfo = dtdInfo;
    }

    public DtdInfo getDtdInfo() {
        return this.m_dtdInfo;
    }

    public void setWFEventInfo(WFEventInfo wfeventInfo) {
        this.m_wfeventInfo = wfeventInfo;
    }

    public WFEventInfo getWFEventInfo() {
        return this.m_wfeventInfo;
    }

    public class AlreadyExist
    extends Exception {
    }
}

