/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata;

import java.util.Hashtable;

public final class ISMessageType {
    private static final String DATABASE_TYPE_STR = "DATABASE";
    private static final String SAP_IBP_TYPE_STR = "IBP";
    private static final String AQ_TYPE_STR = "AQ";
    private static final String XML_TYPE_STR = "XML";
    private static final String GNRC_TYPE_STR = "GENERIC";
    private static final String UNKNOWN_TYPE_STR = "UNKNOWN";
    private static final String EBS_TYPE_STR = "EBS";
    private static final String EBS_DB_TYPE_STR = "EBS_DB";
    private static final String EBS_XMLG_TYPE_STR = "EBS_XMLG";
    private static final String EBS_WFQ_TYPE_STR = "EBS_WFQ";
    private static final String EBS_CUSTOMQ_TYPE_STR = "EBS_CUSTOMQ";
    private static final String DATABASE_TYPE_UI_STR = "DATABASE";
    private static final String SAP_IBP_TYPE_UI_STR = "SAP IBP";
    private static final String AQ_TYPE_UI_STR = "AQ";
    private static final String XML_TYPE_UI_STR = "XML";
    private static final String GNRC_TYPE_UI_STR = "GENERIC";
    private static final String UNKNOWN_TYPE_UI_STR = "UNKNOWN";
    private static final String EBS_TYPE_UI_STR = "Oracle Applications";
    private static final String EBS_DB_TYPE_UI_STR = "EBS_DB";
    private static final String EBS_XMLG_TYPE_UI_STR = "EBS_XMLG";
    private static final String EBS_WFQ_TYPE_UI_STR = "EBS_WFQ";
    private static final String EBS_CUSTOMQ_TYPE_UI_STR = "EBS_CUSTOMQ";
    private static final String[] sUIStrings = new String[]{"DATABASE", "SAP IBP", "AQ", "XML", "GENERIC", "Oracle Applications"};
    public static final ISMessageType DATABASE = new ISMessageType("DATABASE", "DATABASE");
    public static final ISMessageType SAP_IBP = new ISMessageType("IBP", "SAP IBP");
    public static final ISMessageType AQ = new ISMessageType("AQ", "AQ");
    public static final ISMessageType XML = new ISMessageType("XML", "XML");
    public static final ISMessageType UNKNOWN = new ISMessageType("UNKNOWN", "UNKNOWN");
    public static final ISMessageType EBS = new ISMessageType("EBS", "Oracle Applications");
    public static final ISMessageType EBS_DB = new ISMessageType("EBS_DB", "EBS_DB");
    public static final ISMessageType EBS_XMLG = new ISMessageType("EBS_XMLG", "EBS_XMLG");
    public static final ISMessageType EBS_WFQ = new ISMessageType("EBS_WFQ", "EBS_WFQ");
    public static final ISMessageType EBS_CUSTOMQ = new ISMessageType("EBS_CUSTOMQ", "EBS_CUSTOMQ");
    static Hashtable other = new Hashtable();
    private String mMsgTypeString;
    private String mMsgTypeUIString;

    public static String[] getAllMsgTypes() {
        return sUIStrings;
    }

    public static ISMessageType getMsgType(String str) {
        if (str.equals("DATABASE") || str.equals("DATABASE")) {
            return DATABASE;
        }
        if (str.equals(SAP_IBP_TYPE_STR) || str.equals(SAP_IBP_TYPE_UI_STR)) {
            return SAP_IBP;
        }
        if (str.equals("AQ") || str.equals("AQ")) {
            return AQ;
        }
        if (str.equals("XML") || str.equals("XML")) {
            return XML;
        }
        if (str.equals(EBS_TYPE_STR) || str.equals(EBS_TYPE_UI_STR)) {
            return EBS;
        }
        if (str.equals("EBS_DB") || str.equals("EBS_DB")) {
            return EBS_DB;
        }
        if (str.equals("EBS_XMLG") || str.equals("EBS_XMLG")) {
            return EBS_XMLG;
        }
        if (str.equals("EBS_WFQ") || str.equals("EBS_WFQ")) {
            return EBS_WFQ;
        }
        if (str.equals("EBS_CUSTOMQ") || str.equals("EBS_CUSTOMQ")) {
            return EBS_CUSTOMQ;
        }
        ISMessageType msgType = (ISMessageType)other.get(str);
        if (msgType == null) {
            msgType = new ISMessageType(str, str);
            other.put(str, msgType);
        }
        return msgType;
    }

    public String toString() {
        return this.getUITypeString();
    }

    public String getTypeString() {
        return this.mMsgTypeString;
    }

    public String getUITypeString() {
        return this.mMsgTypeUIString;
    }

    public void setType(ISMessageType msgType) {
        this.mMsgTypeString = msgType.getTypeString();
        this.mMsgTypeUIString = msgType.getUITypeString();
    }

    public boolean isDB() {
        return this.mMsgTypeString.equals("DATABASE");
    }

    public boolean isIBP() {
        return this.mMsgTypeString.equals(SAP_IBP_TYPE_STR);
    }

    public boolean isAQ() {
        return this.mMsgTypeString.equals("AQ");
    }

    public boolean isXML() {
        return this.mMsgTypeString.equals("XML");
    }

    public boolean isGNRC() {
        return other.get(this.mMsgTypeString) != null;
    }

    public boolean isEBS() {
        return this.mMsgTypeString.equals(EBS_TYPE_STR) || this.mMsgTypeString.equals("EBS_DB") || this.mMsgTypeString.equals("EBS_XMLG") || this.mMsgTypeString.equals("EBS_WFQ") || this.mMsgTypeString.equals("EBS_CUSTOMQ");
    }

    public boolean isEBSDB() {
        return this.mMsgTypeString.equals("EBS_DB");
    }

    public boolean isEBSXMLG() {
        return this.mMsgTypeString.equals("EBS_XMLG");
    }

    public boolean isEBSWFQ() {
        return this.mMsgTypeString.equals("EBS_WFQ");
    }

    public boolean isEBSCUSTOMQ() {
        return this.mMsgTypeString.equals("EBS_CUSTOMQ");
    }

    private ISMessageType(String type, String uiType) {
        this.mMsgTypeString = new String(type);
        this.mMsgTypeUIString = new String(uiType);
    }
}

