/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata;

import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.SchemaObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.SelectedCols;

public class Attribute {
    public boolean isSelected = false;
    public String name;
    public SchemaObject oType;
    public SchemaObject elType = null;

    Attribute(String n, SchemaObject ot) {
        this.name = n;
        this.oType = ot;
    }

    public Attribute(String n, SchemaObject ot, SchemaObject et) {
        this(n, ot);
        if (et != null && et.getName() != null) {
            this.elType = et;
        }
    }

    public boolean isPrimitive() {
        return this.oType.isPrimitive() || this.isArray() && this.elType.isPrimitive();
    }

    public boolean isArray() {
        return this.elType != null;
    }

    public String getArrayType() {
        if (this.isArray()) {
            return this.elType.toString();
        }
        return null;
    }

    public String symbolicType() {
        return this.oType + (this.isArray() ? " [" + this.elType + "]" : "");
    }

    public String toString() {
        return this.name + "  " + this.symbolicType();
    }

    public void createType(SelectedCols selCols) throws SelectedCols.AlreadyExist {
        selCols.createType(this.isArray() ? this.elType.toString() : this.oType.toString());
    }

    public void addAttribute(SelectedCols selCols, Attribute attr) {
        selCols.addAttribute(this.isArray() ? this.elType.toString() : this.oType.toString(), attr.name, attr.isArray() ? attr.elType.toString() : attr.oType.toString(), attr.getArrayType());
    }
}

