/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;

public class ConnectionPool
implements Runnable {
    private String driver;
    private String url;
    private String username;
    private String password;
    private int maxConnections;
    private boolean waitIfBusy;
    private Vector<Connection> availableConnections;
    private Vector<Connection> busyConnections;
    private boolean connectionPending = false;

    public ConnectionPool(String driver, String url, String username, String password, int initialConnections, int maxConnections, boolean waitIfBusy) throws SQLException {
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
        this.maxConnections = maxConnections;
        this.waitIfBusy = waitIfBusy;
        if (initialConnections > maxConnections) {
            initialConnections = maxConnections;
        }
        this.availableConnections = new Vector(initialConnections);
        this.busyConnections = new Vector();
        for (int i = 0; i < initialConnections; ++i) {
            this.availableConnections.addElement(this.makeNewConnection());
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (!this.availableConnections.isEmpty()) {
            Connection existingConnection = this.availableConnections.lastElement();
            int lastIndex = this.availableConnections.size() - 1;
            this.availableConnections.removeElementAt(lastIndex);
            if (existingConnection.isClosed()) {
                this.notifyAll();
                return this.getConnection();
            }
            this.busyConnections.addElement(existingConnection);
            return existingConnection;
        }
        if (this.totalConnections() < this.maxConnections && !this.connectionPending) {
            this.makeBackgroundConnection();
        } else if (!this.waitIfBusy) {
            throw new SQLException("Connection limit reached");
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getConnection();
    }

    private void makeBackgroundConnection() {
        this.connectionPending = true;
        try {
            Thread connectThread = new Thread(this);
            connectThread.start();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Connection connection = this.makeNewConnection();
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                this.availableConnections.addElement(connection);
                this.connectionPending = false;
                this.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Connection makeNewConnection() throws SQLException {
        try {
            Class.forName(this.driver);
            Connection connection = DriverManager.getConnection(this.url, this.username, this.password);
            return connection;
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("Can't find class for driver: " + this.driver);
        }
    }

    public synchronized void free(Connection connection) {
        this.busyConnections.removeElement(connection);
        this.availableConnections.addElement(connection);
        this.notifyAll();
    }

    public synchronized int totalConnections() {
        return this.availableConnections.size() + this.busyConnections.size();
    }

    public synchronized void closeAllConnections() {
        this.closeConnections(this.availableConnections);
        this.availableConnections = new Vector();
        this.closeConnections(this.busyConnections);
        this.busyConnections = new Vector();
    }

    private void closeConnections(Vector connections) {
        try {
            for (int i = 0; i < connections.size(); ++i) {
                Connection connection = (Connection)connections.elementAt(i);
                if (connection.isClosed()) continue;
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized String toString() {
        String info = "ConnectionPool(" + this.url + "," + this.username + ")" + ", available=" + this.availableConnections.size() + ", busy=" + this.busyConnections.size() + ", max=" + this.maxConnections;
        return info;
    }
}

