/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.FocusRequester;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterOperationPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterOperationPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ftp.FtpAdapterConnectionPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ftp.FtpAdapterOperationPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.HttpOperationTypePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.HttpSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterOperationPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterOperationTypePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterOperationTypePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.wsdlcreate.CommonWsdlSelectionPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.wsdlcreate.OperationDisplay;

public class WsdlSelectionPage
extends techAdapterWizardPage
implements ActionListener,
DocumentListener {
    Context m_jcontext = null;
    ButtonGroup group = new ButtonGroup();
    private MultiLineLabel introPrompt;
    private JLabel operationTypePrompt = new JLabel();
    private JRadioButton genInterfaceRB = new JRadioButton();
    private JRadioButton existingWsdlRB = new JRadioButton();
    private CommonWsdlSelectionPanel m_wsdlPanel;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel spacerPanel = new JPanel();
    private boolean m_initDone = false;
    private String m_lastDefaultServiceName = "";

    public WsdlSelectionPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setContextAndPage(wcontext, iwp);
            if (!AdapterWizardContext.IS_STANDALONE_TESTING) {
                this.m_jcontext = Context.newIdeContext();
            } else {
                CommonWsdlSelectionPanel.MAIN_DEBUG = true;
                BPELStringTranslator.initialize();
            }
            this.jbInit();
            this.m_initDone = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = this.getTranslatedString("WS_INTRO_PROMPT");
        String opprompt = this.getTranslatedString("WS_DEFINE_ADAPTER_SERVICE_LB");
        String genInterfaceRBtext = StringUtils.stripMnemonic((String)this.getTranslatedString("WS_GENERATE_FROM_SCHEMA_RB"));
        int readMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("WS_GENERATE_FROM_SCHEMA_RB"));
        String readTip = this.getTranslatedString("FA_OP_READ_TIP");
        String existingWsdlRBtext = StringUtils.stripMnemonic((String)this.getTranslatedString("WS_DEFINE_USING_EXISTING_WSDL_RB"));
        int writeMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("WS_DEFINE_USING_EXISTING_WSDL_RB"));
        String writeTip = this.getTranslatedString("FA_OP_WRITE_TIP");
        this.setLayout(this.gridBagLayout1);
        this.introPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.operationTypePrompt.setText(opprompt);
        this.operationTypePrompt.setLabelFor(this.genInterfaceRB);
        this.genInterfaceRB.setText(genInterfaceRBtext);
        this.genInterfaceRB.setMnemonic(readMN);
        this.genInterfaceRB.setToolTipText(readTip);
        this.genInterfaceRB.getAccessibleContext().setAccessibleDescription(readTip);
        this.genInterfaceRB.getAccessibleContext().setAccessibleName(genInterfaceRBtext);
        this.existingWsdlRB.setText(existingWsdlRBtext);
        this.existingWsdlRB.setMnemonic(writeMN);
        this.existingWsdlRB.setToolTipText(writeTip);
        this.existingWsdlRB.getAccessibleContext().setAccessibleDescription(writeTip);
        this.existingWsdlRB.getAccessibleContext().setAccessibleName(existingWsdlRBtext);
        WsdlInfo updateWsdlInfo = null;
        if (this.m_wcontext._read_service != null && this.m_wcontext._importedWsdlInfo != null) {
            updateWsdlInfo = this.m_wcontext._importedWsdlInfo;
        }
        if (AdapterWizardContext.IS_STANDALONE_TESTING) {
            updateWsdlInfo = new WsdlInfo("twoPL.wsdl", new QName("http://xmlns.oracle.com/pcbpel/adapter/aq/850_X12_4010-4010/", "Enqueue_ptt"), new QName("http://xmlns.oracle.com/pcbpel/adapter/aq/850_X12_4010-4010/", "Dequeue_ptt"));
            CommonWsdlSelectionPanel.MAIN_DEBUG = true;
        }
        this.m_wsdlPanel = new CommonWsdlSelectionPanel(this.m_wcontext._parentFrame, this.m_jcontext, this.m_wcontext._project, updateWsdlInfo, null, null, this);
        this.m_wsdlPanel.m_rowsep = 10;
        this.m_wsdlPanel.replaceGenWsdlButtonActionListener(this, true);
        this.m_wsdlPanel.setServiceBrowserVisible(false);
        this.m_wsdlPanel.setWsdlGenerationVisible(false);
        this.m_wsdlPanel.setAllFieldsEnabled(false);
        this.m_wsdlPanel.showOperation(this.m_wcontext._write_operation_name, this.m_wcontext._write_operation2_name);
        this.m_wsdlPanel.m_serviceBrowserCurrentCompositeOK = true;
        if (!(this.m_wcontext._service_type.equals("MQ") || this.m_wcontext._service_type.equals("AQ") || this.m_wcontext._service_type.equals("Jms"))) {
            this.m_wsdlPanel.m_showCallbacks = false;
        }
        this.m_wsdlPanel.initLayout();
        int rowsep = this.m_wsdlPanel.m_rowsep;
        int fieldsep = this.m_wsdlPanel.m_fieldsep;
        this.add((Component)this.introPrompt, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.operationTypePrompt, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(30, 0, 0, 0), 0, 0));
        this.add((Component)this.genInterfaceRB, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(30, fieldsep, 0, 0), 0, 0));
        this.add((Component)this.existingWsdlRB, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, fieldsep, 0, 0), 0, 0));
        this.add((Component)this.m_wsdlPanel, new GridBagConstraints(1, 3, 0, 1, 1.0, 0.0, 17, 2, new Insets(rowsep, 20, 0, 0), 0, 0));
        this.add((Component)this.spacerPanel, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.genInterfaceRB.setSelected(true);
        this.group.add(this.genInterfaceRB);
        this.group.add(this.existingWsdlRB);
        this.m_page.setInitialFocus((Component)this.genInterfaceRB);
        if (this.m_wcontext._read_service != null) {
            if (this.m_wcontext._importedWsdlInfo != null) {
                this.existingWsdlRB.setSelected(true);
                this.existingWsdlRB.setEnabled(true);
                this.genInterfaceRB.setEnabled(false);
                this.m_wsdlPanel.setAllFieldsEnabled(false);
                this.checkDoc(null, false);
                this.m_page.setCanAdvance(true);
            } else {
                this.existingWsdlRB.setEnabled(false);
                this.createPagesForType();
                this.m_page.setCanAdvance(true);
            }
        } else {
            this.createPagesForType();
            this.m_page.setCanAdvance(true);
        }
        if (this.genInterfaceRB.isEnabled() && this.existingWsdlRB.isEnabled()) {
            this.genInterfaceRB.addActionListener(this);
            this.existingWsdlRB.addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.genInterfaceRB) {
            this.m_wsdlPanel.setAllFieldsEnabled(false);
            this.checkDoc(null, false);
        } else if (e.getSource() == this.existingWsdlRB) {
            this.m_wsdlPanel.setAllFieldsEnabled(true);
            this.checkDoc(null, false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        boolean wsdlChange = false;
        if (e == null) {
            wsdlChange = true;
        }
        this.checkDoc(e, wsdlChange);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e, false);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e, false);
    }

    private void checkDoc(DocumentEvent e, boolean wsdlChange) {
        if (this.existingWsdlRB.isSelected() && !this.m_wsdlPanel.checkPanel()) {
            this.m_page.setCanAdvance(false);
            return;
        }
        OperationDisplay opdis = (OperationDisplay)this.m_wsdlPanel.m_operationCB.getSelectedItem();
        if (opdis != null) {
            Operation oper1 = opdis.getOperation();
            Output out1 = oper1.getOutput();
            if (out1 != null && this.m_wcontext._service_type != "File" && this.m_wcontext._service_type != "Ftp" && this.m_wcontext._service_type != "MQ" && this.m_wcontext._service_type != "SOCKET" && this.m_wcontext._service_type != "Jms" && this.m_wcontext._service_type != "Http") {
                MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("WS_INVALID_OUTPUT_OPERATION_FOR_ADAPTER_TYPE"));
                Object[] obj = new Object[]{opdis.getName()};
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("WS_OPERATION_NOT_SUPPORTED_ERROR_TITLE"), (int)0);
                new FocusRequester(this.m_wsdlPanel.m_operationCB);
                this.m_page.setCanAdvance(false);
                return;
            }
            if (!this.checkMessage(oper1, oper1.getInput().getMessage()) || out1 != null && !this.checkMessage(oper1, out1.getMessage())) {
                new FocusRequester(this.m_wsdlPanel.m_operationCB);
                this.m_page.setCanAdvance(false);
                return;
            }
            this.m_wcontext._isOutboundRead = out1 != null;
            this.createPagesForType();
        }
        this.m_page.setCanAdvance(true);
    }

    private boolean checkMessage(Operation oper1, Message msg1) {
        Map parts = msg1.getParts();
        if (parts.size() > 1) {
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("WS_MULTI_PART_MESSAGE_NOT_SUPPORTED_ERROR"));
            Object[] obj = new Object[]{msg1.getQName().getLocalPart(), oper1.getName()};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("WS_OPERATION_NOT_SUPPORTED_ERROR_TITLE"), (int)0);
            return false;
        }
        if (parts.size() < 1) {
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("WS_INVALID_WSDL_NO_PARTS"));
            Object[] obj = new Object[]{msg1.getQName().getLocalPart(), oper1.getName()};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("WS_INVALID_WSDL_ERROR_TITLE"), (int)0);
            return false;
        }
        if (((Part)parts.values().iterator().next()).getElementName() == null) {
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("WS_COMPLEX_TYPES_NOT_SUPPORTED_ERROR"));
            Object[] obj = new Object[]{msg1.getQName().getLocalPart(), oper1.getName()};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("WS_OPERATION_NOT_SUPPORTED_ERROR_TITLE"), (int)0);
            return false;
        }
        return true;
    }

    private void createPagesForType() {
        if (this.m_initDone) {
            this.removePages();
        }
        if (this.existingWsdlRB.isSelected()) {
            OperationDisplay opdis;
            this.m_wcontext._importedWsdlInfo = this.m_wsdlPanel.getWsdlInfo();
            if (this.m_wsdlPanel.m_operationCB != null) {
                opdis = (OperationDisplay)this.m_wsdlPanel.m_operationCB.getSelectedItem();
                this.m_wcontext._write_operation_name = opdis.getName();
            }
            if ((this.m_wcontext._service_type.equals("MQ") || this.m_wcontext._service_type.equals("AQ") || this.m_wcontext._service_type.equals("Jms")) && this.m_wsdlPanel.m_callbackOperationCB != null) {
                opdis = (OperationDisplay)this.m_wsdlPanel.m_callbackOperationCB.getSelectedItem();
                this.m_wcontext._write_operation2_name = opdis != null ? opdis.getName() : null;
            }
        } else {
            this.m_wcontext._importedWsdlInfo = null;
            if (this.m_wcontext._read_service == null) {
                this.m_wcontext._write_operation_name = null;
                this.m_wcontext._write_operation2_name = null;
            }
        }
        ImageWizardPage tempwp = null;
        if (this.m_wcontext._service_type == "File") {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_OP_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_file_oper");
            }
            FileAdapterOperationPage dsp2 = new FileAdapterOperationPage(this.m_wcontext, tempwp);
        } else if (this.m_wcontext._service_type == "Ftp") {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("FTP_CN_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_ftp_servconn");
            }
            FtpAdapterConnectionPage dsp1 = new FtpAdapterConnectionPage(this.m_wcontext, tempwp);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_OP_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_ftp_oper");
            }
            FtpAdapterOperationPage dsp2 = new FtpAdapterOperationPage(this.m_wcontext, tempwp);
        } else if (this.m_wcontext._service_type == "AQ") {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_OP_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_aq_oper");
            }
            AQAdapterOperationPage dsp2 = new AQAdapterOperationPage(this.m_wcontext, tempwp);
            this.addFinishPage();
        } else if (this.m_wcontext._service_type == "Jms") {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_OP_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_jms_oper");
            }
            JmsAdapterOperationPage op = new JmsAdapterOperationPage(this.m_wcontext, tempwp);
        } else if (this.m_wcontext._service_type == "MQ") {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("MQ_OP_PAGE_TITLE"));
            MQAdapterOperationTypePage dsp2 = new MQAdapterOperationTypePage(this.m_wcontext, tempwp);
            this.addFinishPage();
        } else if (this.m_wcontext._service_type == "SOCKET") {
            if (this.m_wcontext._read_service == null) {
                tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("SOCKET_OP_PAGE_TITLE"));
                SocketAdapterOperationTypePage dsp2 = new SocketAdapterOperationTypePage(this.m_wcontext, tempwp);
            }
        } else if (this.m_wcontext._service_type == "Http") {
            ImageWizardPage httpOperationPage = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("HTTP_OP_PAGE_TITLE"));
            new HttpOperationTypePage(this.m_wcontext, httpOperationPage);
            ImageWizardPage httpSchemaPage = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("HTTP_SC_PAGE_TITLE"));
            new HttpSchemaPage(this.m_wcontext, httpSchemaPage);
            this.addFinishPage();
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        if (this.existingWsdlRB.isSelected()) {
            WsdlInfo wsdlInfo = this.m_wsdlPanel.getWsdlInfo();
            Definition def1 = this.m_wcontext._write_definition;
            Import imp = def1.createImport();
            String wsdlloc = wsdlInfo.getWsdlLocation();
            String abwsdl = WsdlInfo.getAbstractWsdlLocation((Frame)this.m_wcontext._parentFrame, (Project)this.m_wcontext._project, (WsdlInfo)wsdlInfo, null);
            if (abwsdl != null) {
                wsdlloc = abwsdl;
            }
            imp.setLocationURI(wsdlloc);
            imp.setNamespaceURI(wsdlInfo.getRequestPorttype().getNamespaceURI());
            def1.addImport(imp);
        }
    }
}

