/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.SortedListModel;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.BundleLoader;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ConnectionPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ServiceNamePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.WsdlSelectionPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.AppsAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BTypePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMAdapterDataObjectPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMAdapterNetworkProtocolPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.bam.BAMUIContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterFinish;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.HttpAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterFinish;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterProviderPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterConnectionPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterFinish;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterOperationTypePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterOperationPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardFinish;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ServiceTypePage
extends techAdapterWizardPage
implements ListSelectionListener {
    public static ImageIcon faImage;
    public static ImageIcon ftpImage;
    public static ImageIcon dbImage;
    public static ImageIcon aqImage;
    public static ImageIcon oaImage;
    public static ImageIcon jmsImage;
    public static ImageIcon mqImage;
    public static ImageIcon bamImage;
    public static ImageIcon b2bImage;
    public static ImageIcon socketImage;
    public static ImageIcon httpImage;
    private JLabel intro_label = new JLabel();
    protected JList m_imageLst;
    private MultiLineLabel description;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public ServiceTypePage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            faImage = (ImageIcon)ImageCache.getIcon("palette/adapterservice/file_adapter_palette.png");
            ftpImage = (ImageIcon)ImageCache.getIcon("palette/adapterservice/ftp_adapter_palette.png");
            dbImage = (ImageIcon)ImageCache.getIcon("palette/adapterservice/db_adapter_palette.png");
            aqImage = (ImageIcon)ImageCache.getIcon("palette/adapterservice/aq_adapter_palette.png");
            oaImage = (ImageIcon)ImageCache.getIcon("palette/adapterservice/oracle_applications_palette.png");
            jmsImage = (ImageIcon)ImageCache.getIcon("palette/adapterservice/jms_adapter_palette.png");
            mqImage = (ImageIcon)ImageCache.getIcon("palette/adapterservice/mq_adapter_palette.png");
            bamImage = (ImageIcon)ImageCache.getIcon("palette/adapterservice/bam_adapter_palette.png");
            b2bImage = (ImageIcon)ImageCache.getIcon("palette/adapterservice/b2b_palette.png");
            socketImage = (ImageIcon)ImageCache.getIcon("palette/adapterservice/socket_adapter_palette.png");
            httpImage = (ImageIcon)ImageCache.getIcon("palette/adapterservice/socket_adapter_palette.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = this.getTranslatedString("CM_ST_INTRO_PROMPT");
        String faLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_FA_RADIO_BUTTON"));
        String fa_tip = this.getTranslatedString("CM_ST_FA_SERVICE_TIP");
        int faMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_ST_FA_RADIO_BUTTON"));
        String ftpLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_FTP_RADIO_BUTTON"));
        String ftpTip = this.getTranslatedString("CM_ST_FTP_SERVICE_TIP");
        int ftpMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_ST_FTP_RADIO_BUTTON"));
        String dbLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_DB_RADIO_BUTTON"));
        String dbTip = this.getTranslatedString("CM_ST_DB_SERVICE_TIP");
        int dbMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_ST_DB_RADIO_BUTTON"));
        String aqLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_AQ_RADIO_BUTTON"));
        String aqTip = this.getTranslatedString("CM_ST_AQ_SERVICE_TIP");
        int aqMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_ST_AQ_RADIO_BUTTON"));
        String oaLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_OA_RADIO_BUTTON"));
        String oaTip = this.getTranslatedString("CM_ST_OA_SERVICE_TIP");
        int oaMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_ST_OA_RADIO_BUTTON"));
        String jmsLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_JMS_RADIO_BUTTON"));
        String jmsTip = this.getTranslatedString("CM_ST_JMS_SERVICE_TIP");
        int jmsMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_ST_JMS_RADIO_BUTTON"));
        String mqLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_MQ_RADIO_BUTTON"));
        String mqTip = this.getTranslatedString("CM_ST_MQ_SERVICE_TIP");
        int mqMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_ST_MQ_RADIO_BUTTON"));
        String socketLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_SOCKET_RADIO_BUTTON"));
        String socketTip = this.getTranslatedString("CM_ST_SOCKET_SERVICE_TIP");
        int socketMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_ST_SOCKET_RADIO_BUTTON"));
        String bamLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_BAM_RADIO_BUTTON"));
        String bamTip = this.getTranslatedString("CM_ST_BAM_SERVICE_TIP");
        int bamMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_ST_BAM_RADIO_BUTTON"));
        String b2bLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_B2B_RADIO_BUTTON"));
        String b2bTip = this.getTranslatedString("CM_ST_B2B_SERVICE_TIP");
        int b2bMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_ST_B2B_RADIO_BUTTON"));
        String httpLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_HTTP_RADIO_BUTTON"));
        String httpTip = this.getTranslatedString("CM_ST_HTTP_SERVICE_TIP");
        int httpMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_ST_HTTP_RADIO_BUTTON"));
        String descriptionLB = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_ST_TYPE_DESCRIPTION_LABEL"));
        this.setLayout(this.gridBagLayout1);
        this.intro_label.setText(intro);
        Border bord1 = BorderFactory.createLineBorder(Color.GRAY);
        this.m_imageLst = new JList(new SortedListModel());
        this.m_imageLst.setSelectionMode(0);
        this.m_imageLst.setCellRenderer(new ListRenderer());
        this.m_imageLst.addListSelectionListener(this);
        SortedListModel model = (SortedListModel)this.m_imageLst.getModel();
        ListItem fileLI = new ListItem("File", faImage, faLB, faMN, fa_tip);
        model.addElement((Object)fileLI);
        ListItem ftpLI = new ListItem("Ftp", ftpImage, ftpLB, ftpMN, ftpTip);
        model.addElement((Object)ftpLI);
        ListItem dbLI = new ListItem("DB", dbImage, dbLB, dbMN, dbTip);
        model.addElement((Object)dbLI);
        ListItem aqLI = new ListItem("AQ", aqImage, aqLB, aqMN, aqTip);
        model.addElement((Object)aqLI);
        ListItem oaLI = new ListItem("Apps", oaImage, oaLB, oaMN, oaTip);
        model.addElement((Object)oaLI);
        ListItem jmsLI = new ListItem("Jms", jmsImage, jmsLB, jmsMN, jmsTip);
        model.addElement((Object)jmsLI);
        ListItem mqLI = new ListItem("MQ", mqImage, mqLB, mqMN, mqTip);
        model.addElement((Object)mqLI);
        ListItem socketLI = new ListItem("SOCKET", socketImage, socketLB, socketMN, socketTip);
        model.addElement((Object)socketLI);
        ListItem bamLI = new ListItem("BAM", bamImage, bamLB, bamMN, bamTip);
        model.addElement((Object)bamLI);
        ListItem b2bLI = new ListItem("B2B", b2bImage, b2bLB, b2bMN, b2bTip);
        model.addElement((Object)b2bLI);
        ListItem httpLI = new ListItem("Http", httpImage, httpLB, httpMN, httpTip);
        model.addElement((Object)httpLI);
        JPanel typep = new JPanel(new GridBagLayout());
        JScrollPane isp = new JScrollPane(this.m_imageLst);
        this.description = new MultiLineLabel(WordWrapper.getTextWrapper(), "    ");
        this.description.setBorder((Border)BorderFactory.createTitledBorder(bord1, descriptionLB));
        this.description.setPreferredSize(new Dimension(20, 60));
        this.add((Component)this.intro_label, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        typep.add((Component)isp, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 100));
        this.add((Component)typep, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.75, 11, 1, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this.description, new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_page.setCanAdvance(false);
        if (this.m_wcontext._read_service != null || this.m_wcontext._service_type != null) {
            ListItem seli = null;
            if (this.m_wcontext._service_type.equals("File")) {
                seli = fileLI;
            } else if (this.m_wcontext._service_type.equals("AQ")) {
                seli = aqLI;
            } else if (this.m_wcontext._service_type.equals("DB")) {
                seli = dbLI;
            } else if (this.m_wcontext._service_type.equals("Ftp")) {
                seli = ftpLI;
            } else if (this.m_wcontext._service_type.equals("Apps")) {
                AppsAdapterContext.cnt = 0;
                AppsAdapterContext.m_name = new ArrayList<String>();
                AppsAdapterContext.m_obj = new ArrayList<String>();
                AppsAdapterContext.type = new ArrayList<String>();
                AppsAdapterContext.initpages(true, true, true);
                seli = oaLI;
            } else if (this.m_wcontext._service_type.equals("Jms")) {
                seli = jmsLI;
            } else if (this.m_wcontext._service_type.equals("MQ")) {
                seli = mqLI;
            } else if (this.m_wcontext._service_type.equals("BAM")) {
                seli = bamLI;
            } else if (this.m_wcontext._service_type.equals("B2B")) {
                seli = b2bLI;
            } else if (this.m_wcontext._service_type.equals("SOCKET")) {
                seli = socketLI;
            } else if (this.m_wcontext._service_type.equals("Http")) {
                seli = httpLI;
            }
            this.m_imageLst.setSelectedValue(seli, true);
            if (this.m_wcontext._read_definition != null || this.m_wcontext._service_type != null) {
                this.m_wizard.removePage((WizardPage)this.m_page);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (src == this.m_imageLst) {
            this.removePages();
            ListItem selitem = (ListItem)this.m_imageLst.getSelectedValue();
            this.createPagesForType(selitem);
            this.description.setText(selitem.m_hint);
        }
    }

    private void createPagesForType(ListItem selitem) {
        this.m_page.setCanAdvance(true);
        this.m_wcontext._service_type = selitem.m_service_type;
        this.m_wcontext._adapter_type_icon = selitem.m_icon;
        ImageWizardPage tempwp = null;
        ImageWizardPage wsdlSelectionPage = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("WS_PAGE_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)wsdlSelectionPage.getContent(), "bpmjdev_adp_wiz_interface");
        }
        ImageWizardPage serviceNamePage = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_SN_PAGE_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)serviceNamePage.getContent(), "bpmjdev_adp_wiz_servname");
        }
        if (selitem.m_service_type == "File") {
            this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/file/";
            this.m_wcontext._ascontext = new FileAdapterContext();
            this.m_wcontext._adapterWizardFinish = new FileAdapterFinish();
            new ServiceNamePage(this.m_wcontext, serviceNamePage);
            new WsdlSelectionPage(this.m_wcontext, wsdlSelectionPage);
        } else if (selitem.m_service_type == "Ftp") {
            this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/ftp/";
            this.m_wcontext._ascontext = new FileAdapterContext();
            this.m_wcontext._adapterWizardFinish = new FileAdapterFinish();
            new ServiceNamePage(this.m_wcontext, serviceNamePage);
            new WsdlSelectionPage(this.m_wcontext, wsdlSelectionPage);
        } else if (selitem.m_service_type == "DB") {
            this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/db/";
            this.m_wcontext._adapterWizardFinish = new XRAdapterWizardFinish();
            new ServiceNamePage(this.m_wcontext, serviceNamePage);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_CN_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_servconn");
            }
            ConnectionPage dsp1 = new ConnectionPage(this.m_wcontext, tempwp);
            if (this.m_wcontext._read_definition == null) {
                tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_OP_TITLE"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_oper");
                }
                XRAdapterOperationPage dsp2 = new XRAdapterOperationPage(this.m_wcontext, tempwp);
            } else {
                JcaOperation jop = this.m_wcontext._read_jca_operation;
                if (this.m_wcontext._adapter_sub_type == "SP") {
                    this.m_wcontext._isInboundOperation = false;
                    this.addFinishPage();
                } else {
                    tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_OP_TITLE"));
                    if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                        HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_oper");
                    }
                    XRAdapterOperationPage dsp2 = new XRAdapterOperationPage(this.m_wcontext, tempwp);
                }
            }
        } else if (selitem.m_service_type == "AQ") {
            this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/aq/";
            this.m_wcontext._ascontext = new AQAdapterContext();
            this.m_wcontext._adapterWizardFinish = new FileAdapterFinish();
            new ServiceNamePage(this.m_wcontext, serviceNamePage);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_CN_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_servconn");
            }
            ConnectionPage dsp1 = new ConnectionPage(this.m_wcontext, tempwp);
            if (this.m_wcontext._read_definition == null) {
                new WsdlSelectionPage(this.m_wcontext, wsdlSelectionPage);
            }
            this.addFinishPage();
        } else if (selitem.m_service_type == "Jms") {
            this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/jms/";
            this.m_wcontext._ascontext = new JMSContext();
            this.m_wcontext._adapterWizardFinish = new JmsAdapterFinish();
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_SN_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_servname");
            }
            ServiceNamePage snp = new ServiceNamePage(this.m_wcontext, tempwp);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_PR_PAGE_TITLE"));
            JmsAdapterProviderPage dsp = new JmsAdapterProviderPage(this.m_wcontext, tempwp);
            this.addFinishPage();
        } else if (selitem.m_service_type == "Apps") {
            this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/apps/";
            this.m_wcontext._adapterWizardFinish = new FileAdapterFinish();
            new ServiceNamePage(this.m_wcontext, serviceNamePage);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_CN_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_servconn");
            }
            ConnectionPage dsp1 = new ConnectionPage(this.m_wcontext, tempwp);
            if (this.m_wcontext._read_definition == null || this.m_wcontext._adapter_sub_type.equals("DB")) {
                tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("OA_IN_PAGE_TITLE"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_oa_ai");
                }
            }
            this.addFinishPage();
        } else if (selitem.m_service_type == "MQ") {
            this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/mq/";
            this.m_wcontext._ascontext = new MQAdapterWizardContext(this.m_wcontext);
            this.m_wcontext._adapterWizardFinish = new MQAdapterFinish();
            new ServiceNamePage(this.m_wcontext, serviceNamePage);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("MQ_CN_PAGE_TITLE"));
            MQAdapterConnectionPage dsp = new MQAdapterConnectionPage(this.m_wcontext, tempwp);
            new WsdlSelectionPage(this.m_wcontext, wsdlSelectionPage);
        } else if (selitem.m_service_type == "SOCKET") {
            this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/socket/";
            this.m_wcontext._ascontext = new SocketAdapterWizardContext(this.m_wcontext);
            new ServiceNamePage(this.m_wcontext, serviceNamePage);
            new WsdlSelectionPage(this.m_wcontext, wsdlSelectionPage);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("SOCKET_OP_PAGE_TITLE"));
            new SocketAdapterOperationTypePage(this.m_wcontext, tempwp);
        } else if (selitem.m_service_type == "BAM") {
            this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/bam/";
            this.m_wcontext._ascontext = new BAMUIContext();
            new ServiceNamePage(this.m_wcontext, serviceNamePage);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("BAM_DO_TITLE"));
            new BAMAdapterDataObjectPage(this.m_wcontext, tempwp);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("BAM_NP_TITLE"));
            new BAMAdapterNetworkProtocolPage(this.m_wcontext, tempwp);
            this.addFinishPage();
        } else if (selitem.m_service_type == "B2B") {
            this.m_wcontext._ascontext = new B2BContext();
            B2BContext b2bctx = (B2BContext)this.m_wcontext._ascontext;
            b2bctx.setResourceBundle(BundleLoader.getBundle((String)"oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BConfigWizardResource"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)serviceNamePage.getContent(), "b2bjdev_wiz_serv_name");
            }
            new ServiceNamePage(this.m_wcontext, serviceNamePage);
            tempwp = new ImageWizardPage(null, this._getImage(), b2bctx.getResourceBundle().getString("B2B_TYPE"));
            B2BTypePage typPage = new B2BTypePage(this.m_wcontext, tempwp);
            this.addFinishPage();
        } else if (selitem.m_service_type == "Http") {
            this.m_wcontext._target_namespace_prefix = "http://xmlns.oracle.com/pcbpel/adapter/http/";
            this.m_wcontext._ascontext = new HttpAdapterContext();
            new ServiceNamePage(this.m_wcontext, serviceNamePage);
            new WsdlSelectionPage(this.m_wcontext, wsdlSelectionPage);
        }
    }

    class ListItem {
        protected Icon m_icon;
        protected String m_entryName;
        protected int m_mnemonic_index;
        protected String m_hint;
        protected String m_service_type;

        public ListItem(String service_type, Icon icon, String text, int mnemonic_index, String hint) {
            this.m_service_type = service_type;
            this.m_icon = icon;
            this.m_entryName = text;
            this.m_mnemonic_index = mnemonic_index;
            this.m_hint = hint;
        }

        public String toString() {
            return this.m_entryName;
        }
    }

    class ListRenderer
    extends DefaultListCellRenderer {
        public ListRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
        }

        protected Icon getIcon(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return null;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ListItem) {
                ListItem item = (ListItem)value;
                this.setIcon(item.m_icon);
                this.setToolTipText(item.m_hint);
                this.setText(item.m_entryName);
                this.getAccessibleContext().setAccessibleDescription(item.m_hint);
                this.getAccessibleContext().setAccessibleName(item.m_entryName);
            }
            return this;
        }
    }
}

