/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.ui.NCNameField;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.api.SCAInvalidFileNameException;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.WizardWSDLUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.wsdlcreate.WsdlCreatePanel;

public class ServiceNamePage
extends techAdapterWizardPage
implements DocumentListener,
FocusListener,
ActionListener {
    private boolean m_firstDisplaySeen = false;
    private JLabel descriptLB = new JLabel();
    private JLabel serviceNameLB = new JLabel();
    private NCNameField serviceName = new NCNameField();
    private JTextField editModeServiceName = new JTextField();
    private JTextArea m_description = new JTextArea();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel introPrompt = new JLabel();
    private JLabel serviceTypeLB = new JLabel();
    private JLabel serviceTypeText = new JLabel();
    private JLabel dummy1 = new JLabel();

    public ServiceNamePage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String snprompt = this.getTranslatedString("CM_SN_SERVICE_NAME_PROMPT");
        String sname = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_SN_SERVICE_NAME_LABEL"));
        int snameMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_SN_SERVICE_NAME_LABEL"));
        String sntip = this.getTranslatedString("CM_SN_SERVICE_NAME_TIP");
        String sndescript = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_SN_SERVICE_DESCRIPTION_LABEL"));
        int descriptMnemonic = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_SN_SERVICE_DESCRIPTION_LABEL"));
        String descriptTip = this.getTranslatedString("CM_SN_SERVICE_DESCRIPTION_TIP");
        String serviceTypePrompt = this.getTranslatedString("CM_SN_SERVICE_TYPE_LABEL");
        String serviceTypeType = null;
        if (this.m_wcontext._service_type.equals("File")) {
            serviceTypeType = this.getTranslatedString("CM_SN_FA_SERVICE_TYPE");
        } else if (this.m_wcontext._service_type.equals("Ftp")) {
            serviceTypeType = this.getTranslatedString("CM_SN_FTP_SERVICE_TYPE");
        } else if (this.m_wcontext._service_type.equals("DB")) {
            serviceTypeType = this.getTranslatedString("CM_SN_DB_SERVICE_TYPE");
        } else if (this.m_wcontext._service_type.equals("AQ")) {
            serviceTypeType = this.getTranslatedString("CM_SN_AQ_SERVICE_TYPE");
        } else if (this.m_wcontext._service_type.equals("Jms")) {
            serviceTypeType = this.getTranslatedString("CM_SN_JMS_SERVICE_TYPE");
        } else if (this.m_wcontext._service_type.equals("Apps")) {
            serviceTypeType = this.getTranslatedString("CM_SN_OA_SERVICE_TYPE");
        } else if (this.m_wcontext._service_type.equals("MQ")) {
            serviceTypeType = this.getTranslatedString("CM_SN_MQ_SERVICE_TYPE");
        } else if (this.m_wcontext._service_type.equals("SOCKET")) {
            serviceTypeType = this.getTranslatedString("CM_SN_SOCKET_SERVICE_TYPE");
        } else if (this.m_wcontext._service_type.equals("BAM")) {
            serviceTypeType = this.getTranslatedString("CM_SN_BAM_SERVICE_TYPE");
        } else if (this.m_wcontext._service_type.equals("B2B")) {
            serviceTypeType = this.getTranslatedString("CM_SN_B2B_SERVICE_TYPE");
        } else if (this.m_wcontext._service_type.equals("Http")) {
            serviceTypeType = this.getTranslatedString("CM_SN_HTTP_SERVICE_TYPE");
        }
        serviceTypeType = StringUtils.stripMnemonic((String)serviceTypeType);
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(431, 326));
        this.introPrompt.setText(snprompt);
        this.serviceTypeLB.setText(serviceTypePrompt);
        this.serviceTypeText.setText(serviceTypeType);
        this.serviceNameLB.setText(sname);
        this.serviceNameLB.setLabelFor((Component)this.serviceName);
        this.serviceNameLB.setDisplayedMnemonic(snameMN);
        this.serviceName.setToolTipText(sntip);
        this.serviceName.getAccessibleContext().setAccessibleName(sname);
        this.serviceName.getAccessibleContext().setAccessibleDescription(sntip);
        this.serviceName.getDocument().addDocumentListener(this);
        this.serviceName.addFocusListener((FocusListener)this);
        this.serviceName.setMaximumCharacterLength(80);
        this.descriptLB.setText(sndescript);
        this.descriptLB.setDisplayedMnemonic(descriptMnemonic);
        this.descriptLB.setLabelFor(this.m_description);
        this.m_description.setText("");
        this.m_description.setWrapStyleWord(true);
        this.m_description.setLineWrap(true);
        this.m_description.setToolTipText(descriptTip);
        this.m_description.getAccessibleContext().setAccessibleName(sndescript);
        this.m_description.getAccessibleContext().setAccessibleDescription(descriptTip);
        JScrollPane descriptionScrollPane = new JScrollPane(this.m_description);
        this.add((Component)this.introPrompt, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.serviceTypeLB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 6), 0, 0));
        this.add((Component)this.serviceTypeText, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this.serviceNameLB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 6), 0, 0));
        this.add((Component)this.serviceName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this.editModeServiceName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this.descriptLB, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 0, 0, 6), 0, 6));
        this.add((Component)descriptionScrollPane, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 18, 2, new Insets(12, 0, 0, 1), 0, 40));
        this.add((Component)this.dummy1, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.m_page.setCanAdvance(false);
        this.descriptLB.setVisible(false);
        descriptionScrollPane.setVisible(false);
        this.m_page.setInitialFocus((Component)this.serviceName);
        if (this.m_wcontext._write_service_name != null) {
            this.serviceName.setText(this.m_wcontext._write_service_name);
        }
        this.serviceName.setVisible(true);
        this.editModeServiceName.setVisible(false);
        if (this.m_wcontext._read_service != null) {
            this.editModeServiceName.setVisible(true);
            this.serviceName.setVisible(false);
            this.introPrompt.setText(this.getTranslatedString("CM_SN_SERVICE_NAME_UPDATE_PROMPT"));
            this.editModeServiceName.setText(this.m_wcontext._read_service_name);
            this.editModeServiceName.setEditable(false);
            this.m_page.setInitialFocus((Component)this.m_description);
            if (this.m_wcontext._read_service_documentation != null) {
                this.m_description.setText(this.m_wcontext._read_service_documentation);
            }
            this.m_page.setCanAdvance(true);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!this.m_firstDisplaySeen) {
            this.m_firstDisplaySeen = true;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        String serviceNameVal = null;
        if (this.m_wcontext._read_service != null) {
            serviceNameVal = this.editModeServiceName.getText().trim();
        } else {
            this.m_wcontext._composite_service_name = serviceNameVal = this.serviceName.getText().trim();
        }
        this.m_wcontext._write_service_name = serviceNameVal;
        String encodedname = null;
        try {
            encodedname = URLEncoder.encode(ServiceNamePage.getCleanName(this.m_wcontext._write_service_name), "UTF-8").replaceAll("%", "-");
            if (encodedname.startsWith("-")) {
                encodedname = "o" + encodedname;
            }
        }
        catch (UnsupportedEncodingException eexcep) {
            eexcep.printStackTrace();
        }
        this.m_wcontext._write_encoded_service_name = encodedname;
        if (this.m_wcontext._read_definition == null) {
            this.m_wcontext._target_namespace = !AdapterWizardContext.IS_STANDALONE_TESTING ? WsdlCreatePanel.getDefaultNamespace(Context.newIdeContext(), this.m_wcontext._target_namespace_prefix, encodedname) : this.m_wcontext._target_namespace_prefix + encodedname + "/";
        }
        if (this.m_wcontext._read_definition == null && !AdapterWizardContext.IS_STANDALONE_TESTING) {
            try {
                SCAController scon = SCAControllerImpl.getController((Project)this.m_wcontext._project);
                if (!scon.isNameUniqueWithinComposite(this.m_wcontext._composite_service_name)) {
                    MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_SN_NOT_UNIQUE_COMPONENT_NAME_ERROR"));
                    Object[] obj = new Object[]{this.m_wcontext._composite_service_name};
                    MultiLineOptionPane.showMessageDialog((Component)this, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_SN_NAME_ERROR_TITLE"), (int)0);
                    this.serviceName.grabFocus();
                    ((Cancelable)event).cancel();
                } else {
                    String filepath = this.m_wcontext.getFilePath() + File.separator;
                    this.m_wcontext._write_wsdl_name = filepath + ServiceNamePage.getCleanName(this.m_wcontext._write_service_name) + ".wsdl";
                    File file = new File(this.m_wcontext._write_wsdl_name);
                    if (file.exists()) {
                        Object[] obj;
                        if (!WsdlCreatePanel.okToReplaceWsdl(this.m_wcontext._parentFrame, scon, URLFactory.newURL((String)this.m_wcontext._write_wsdl_name), this.serviceName.getText())) {
                            this.serviceName.grabFocus();
                            ((Cancelable)event).cancel();
                            return;
                        }
                        MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_SN_ALREADY_EXISTS_ERROR"));
                        int result = MultiLineOptionPane.showMessageDialog((Component)this, (Object)msgformat.format(obj = new Object[]{this.m_wcontext._write_service_name, this.m_wcontext._write_wsdl_name}), (String)this.m_wcontext._bundle.getString("CM_SN_NAME_ERROR_TITLE"), (int)2, (int)0, null);
                        if (result != 0) {
                            this.serviceName.grabFocus();
                            ((Cancelable)event).cancel();
                        }
                    }
                }
            }
            catch (SCAInvalidFileNameException scaEx) {
                MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_SN_NOT_VALID_FILE_NAME_ERROR"));
                Object[] obj = new Object[]{this.m_wcontext._write_service_name};
                MultiLineOptionPane.showMessageDialog((Component)this, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_SN_NAME_ERROR_TITLE"), (int)0);
                this.serviceName.grabFocus();
                ((Cancelable)event).cancel();
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        String serviceNameVal = this.serviceName.getText();
        if (serviceNameVal == null) {
            return;
        }
        if (serviceNameVal.trim().equals("")) {
            this.m_page.setCanAdvance(false);
            return;
        }
        this.m_page.setCanAdvance(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
    }

    public static String getCleanName(String displayName) {
        return displayName.replaceAll("[\\x2e\\s\\n\\r!\"#$%&'()*+,-./:;<=>?@[\\\\]^_`{|}~]", "_");
    }

    @Override
    public void buildWSDL() throws WSDLException {
        Definition def1 = this.m_wcontext._write_definition;
        Service serv1 = def1.createService();
        serv1.setQName(new QName(this.m_wcontext._target_namespace, this.m_wcontext._write_service_name));
        def1.addService(serv1);
        this.m_wcontext._write_service = serv1;
        String descript1 = this.m_description.getText();
        if (descript1 != null && descript1.length() > 0) {
            def1.setDocumentationElement(WizardWSDLUtil.createDocumentationElement(descript1));
        }
        Port port1 = def1.createPort();
        serv1.addPort(port1);
        this.m_wcontext._write_port = port1;
    }
}

