/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter;

import java.sql.Connection;
import java.util.Properties;
import oracle.ide.Context;
import oracle.jdeveloper.db.AppDatabaseConnections;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class DatabaseConnectionInfo {
    private String connectionName;
    private String driverClassName;
    private String username;
    private String password;
    private String connectionURL;
    private String port;
    private String hostname;
    private String sid;
    private Connection connection;

    public DatabaseConnectionInfo(String connectionName) throws Exception {
        this.connectionName = connectionName;
        DatabaseConnections dbConns = AppDatabaseConnections.getAppDatabaseConnections((Context)Context.newIdeContext());
        this.connection = dbConns.getConnection(connectionName);
        Properties props = dbConns.getProperties(connectionName);
        DatabaseProvider dbProv = (DatabaseProvider)dbConns.getReferenceable(connectionName);
        this.driverClassName = dbProv.getDriverClassName();
        this.connectionURL = dbProv.getConnectionURL();
        this.username = props.getProperty("user");
        this.password = props.getProperty("password");
        this.port = props.getProperty("port");
        this.hostname = props.getProperty("hostname");
        this.sid = props.getProperty("sid");
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setConnectionURL(String param) {
        this.connectionURL = param;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public String getPort() {
        return this.port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getSID() {
        return this.sid;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

