/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.db.panels.AppConnectionPanelUI;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.utils.PreviewUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.DatabaseConnectionInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.WsdlSelectionPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.AppsAdapterDelegatePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.AppsAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterQueueNamePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.DBAdapterSPAdvancedOptionsPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterStoredProcPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.Platform;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaAddress;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;

public class ConnectionPage
extends techAdapterWizardPage
implements DocumentListener,
ItemListener,
FocusListener {
    public static String MCF_MANAGED_CONNECTION_FACTORY = "ManagedConnectionFactory";
    public static String MCF_MANAGED_CONNECTION_FACTORY_AQ = "oracle.tip.adapter.aq.v2.jca.AQManagedConnectionFactory";
    public static String MCF_MANAGED_CONNECTION_FACTORY_APPS = "oracle.tip.adapter.apps.AppsManagedConnectionFactory";
    public static String MCF_MANAGED_CONNECTION_FACTORY_DB = "oracle.tip.adapter.db.DBManagedConnectionFactory";
    public static String MCF_DRIVER_CLASS_NAME = "mcf.DriverClassName";
    public static String MCF_PLATFORM_CLASS_NAME = "mcf.PlatformClassName";
    public static String MCF_PLATFORM_CLASS_VALUE = "org.eclipse.persistence.platform.database.oracle.Oracle9Platform";
    public static String MCF_CONNECTION_STRING = "mcf.ConnectionString";
    public static String MCF_USERNAME = "mcf.UserName";
    public static String MCF_USERNAME_LOWERCASE = "mcf.Username";
    public static String MCF_PASSWORD = "mcf.Password";
    public static String MCF_DATA_SOURCE = "mcf.DataSourceName";
    public static String MCF_XA_DATA_SOURCE = "mcf.XADataSourceName";
    public static final String MCF_MANAGED_CONNECTION_FACTORY_JMS = "oracle.tip.adapter.jms.JmsManagedConnectionFactory";
    public static final String MCF_CONNECTION_FACTORY_LOCATION = "mcf.ConnectionFactoryLocation";
    public static final String MCF_FACTORY_PROPERTIES = "mcf.FactoryProperties";
    public static final String MCF_IS_TOPIC = "mcf.IsTopic";
    public static final String MCF_IS_TRANSACTED = "mcf.IsTransacted";
    public static final String NAMING_FACTORY = "java.naming.factory.initial";
    public static final String NAMING_URL = "java.naming.provider.url";
    public static final String NAMING_PRINCIPAL = "java.naming.security.principal";
    public static final String NAMING_CREDENTIALS = "java.naming.security.credentials";
    boolean invalidConnectionNameForUpdate = false;
    private MultiLineLabel introLB;
    private MultiLineLabel jndiInstanceIntro;
    private JLabel jndiNameLB = new JLabel();
    private JTextField jndiName = new JTextField();
    private JLabel dataSourceLabel = new JLabel();
    private JTextField dataSourceTextField = new JTextField();
    private JCheckBox xaDataSourceCheckBox = new JCheckBox();
    private JPanel spacer = new JPanel();
    private AppConnectionPanelUI connPanel;
    private String previousConnName;

    public ConnectionPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String connName;
        String intro = this.getTranslatedString("CM_CN_INTRO_PROMPT");
        String jndiPrompt = this.getTranslatedString("CM_CN_JNDI_PROMPT");
        String jndiNameTip = this.getTranslatedString("CM_CN_JNDI_TIP");
        String jndiIntroText = null;
        String dataSourceText = this.getTranslatedString("CM_CN_DATA_SOURCE");
        String dataSourceTip = this.getTranslatedString("CM_CN_DATA_SOURCE_TIP");
        String xaDataSourceText = this.getTranslatedString("CM_CN_XA_DATA_SOURCE");
        String xaDataSourceTip = this.getTranslatedString("CM_CN_XA_DATA_SOURCE_TIP");
        if (this.m_wcontext._service_type.equals("AQ")) {
            jndiIntroText = this.getTranslatedString("CM_CN_AQ_JNDI_INTRO_PROMPT");
        } else if (this.m_wcontext._service_type.equals("DB")) {
            jndiIntroText = this.getTranslatedString("CM_CN_DB_JNDI_INTRO_PROMPT");
        } else if (this.m_wcontext._service_type.equals("Apps")) {
            jndiIntroText = this.getTranslatedString("CM_CN_OA_JNDI_INTRO_PROMPT");
        } else if (this.m_wcontext._service_type.equals("Jms")) {
            jndiIntroText = this.getTranslatedString("CM_CN_JMS_JNDI_INTRO_PROMPT");
        }
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(431, 326));
        this.introLB = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.jndiInstanceIntro = new MultiLineLabel(WordWrapper.getTextWrapper(), jndiIntroText);
        this.connPanel = new AppConnectionPanelUI(true);
        this.jndiNameLB.setText(StringUtils.stripMnemonic((String)jndiPrompt));
        this.jndiNameLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)jndiPrompt));
        this.jndiNameLB.setLabelFor(this.jndiName);
        this.jndiName.getDocument().addDocumentListener(this);
        this.jndiName.setSize(new Dimension(20, 20));
        this.jndiName.setPreferredSize(new Dimension(20, 20));
        this.jndiName.setToolTipText(jndiNameTip);
        this.jndiName.getAccessibleContext().setAccessibleDescription(jndiNameTip);
        this.jndiName.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)jndiPrompt));
        if (("AQ".equals(this.m_wcontext._service_type) || "DB".equals(this.m_wcontext._service_type)) && PreviewUtil.isInPreviewMode()) {
            this.dataSourceLabel.setText(StringUtils.stripMnemonic((String)dataSourceText));
            this.dataSourceLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)dataSourceText));
            this.dataSourceLabel.setLabelFor(this.dataSourceTextField);
            this.dataSourceTextField.setToolTipText(dataSourceTip);
            this.dataSourceTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)dataSourceText));
            this.dataSourceTextField.getAccessibleContext().setAccessibleDescription(dataSourceTip);
            this.dataSourceLabel.setVisible(true);
            this.dataSourceTextField.setVisible(true);
            this.xaDataSourceCheckBox.setText(StringUtils.stripMnemonic((String)xaDataSourceText));
            this.xaDataSourceCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)xaDataSourceText));
            this.xaDataSourceCheckBox.setSelected(true);
            this.xaDataSourceCheckBox.setToolTipText(xaDataSourceTip);
            this.xaDataSourceCheckBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)xaDataSourceText));
            this.xaDataSourceCheckBox.getAccessibleContext().setAccessibleDescription(xaDataSourceTip);
            this.xaDataSourceCheckBox.setVisible(true);
        } else {
            this.dataSourceLabel.setVisible(false);
            this.dataSourceTextField.setVisible(false);
            this.xaDataSourceCheckBox.setVisible(false);
        }
        this.add((Component)this.introLB, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.connPanel, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jndiInstanceIntro, new GridBagConstraints(0, 3, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jndiNameLB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.jndiName, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.dataSourceLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.dataSourceTextField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.xaDataSourceCheckBox, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.spacer, new GridBagConstraints(2, 6, 1, 1, 0.0, 2.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.connPanel.addComboListener((ItemListener)this);
        this.connPanel.getConnCombo().addFocusListener(this);
        this.connPanel.setConnectionPrompt("");
        this.m_page.setInitialFocus((Component)this.connPanel.getConnCombo());
        this.previousConnName = connName = this.connPanel.getConnectionName();
        if (connName != null && !connName.trim().equals("")) {
            this.jndiName.setText("eis/" + this.m_wcontext._service_type + "/" + connName);
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
        if (this.m_wcontext._read_service != null) {
            this.initPanelFromExistingWSDL();
        }
    }

    protected void initPanelFromExistingWSDL() {
        block8: {
            String mcfDataSourceVal;
            JcaAddress jcaa;
            block9: {
                if (this.m_wcontext._read_jca_address == null) break block8;
                String connName = this.m_wcontext._read_jca_address.getUiConnectionName();
                try {
                    this.connPanel.setConnectionName(connName);
                    this.m_wcontext.dbConnectionInfo = new DatabaseConnectionInfo(connName);
                    this.invalidConnectionNameForUpdate = false;
                    this.previousConnName = connName;
                }
                catch (Exception e) {
                    this.invalidConnectionNameForUpdate = true;
                    this.previousConnName = null;
                }
                String jcaName = this.m_wcontext._read_jca_address.getAdapterInstanceJndi();
                this.jndiName.setText(jcaName);
                jcaa = this.m_wcontext._read_jca_address;
                if (jcaa == null) break block8;
                if (this.m_wcontext._service_type.equals("AQ")) break block9;
                if (!this.m_wcontext._service_type.equals("DB")) break block8;
            }
            if ((mcfDataSourceVal = jcaa.getAttributeValue(MCF_DATA_SOURCE)) != null && !mcfDataSourceVal.trim().equals("")) {
                this.dataSourceTextField.setText(mcfDataSourceVal);
                this.xaDataSourceCheckBox.setSelected(false);
            } else {
                mcfDataSourceVal = jcaa.getAttributeValue(MCF_XA_DATA_SOURCE);
                if (mcfDataSourceVal != null && !mcfDataSourceVal.trim().equals("")) {
                    this.dataSourceTextField.setText(mcfDataSourceVal);
                    this.xaDataSourceCheckBox.setSelected(true);
                }
            }
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.m_wcontext._wizard.setCursor(new Cursor(3));
        String connName = this.connPanel.getConnectionName();
        try {
            this.m_wcontext._jndiName = this.jndiName.getText().trim();
            this.m_wcontext._uiConnectionName = connName;
            this.m_wcontext.dbConnectionInfo = new DatabaseConnectionInfo(this.m_wcontext._uiConnectionName);
            this.m_wcontext._connection = this.m_wcontext.dbConnectionInfo.getConnection();
            if (this.m_wcontext._read_definition != null) {
                this.addWizardPagesAfterOpeningDBConnection();
            } else if (this.m_wcontext._service_type == "Apps") {
                System.out.println("Adapter is of OA Adapter Type");
                if (AppsAdapterContext.conn != null && !AppsAdapterContext.conn.equalsIgnoreCase(this.m_wcontext._uiConnectionName)) {
                    AppsAdapterContext.initpages(true, true, true);
                }
                AppsAdapterContext.conn = this.m_wcontext._uiConnectionName;
                if (AppsAdapterContext.initAppsDelPage) {
                    this.removePages();
                    ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_OP_PAGE_TITLE"));
                    new AppsAdapterDelegatePage(this.m_wcontext, tempwp);
                    this.addFinishPage();
                }
                AppsAdapterContext.initAppsDelPage = false;
                System.out.println("Pages for OA Adapter Added");
            }
            if (this.m_wcontext._service_type == "AQ") {
                AQAdapterContext aqcontext = (AQAdapterContext)this.m_wcontext._ascontext;
                if (aqcontext.b2bContext != null) {
                    this.removePages();
                    ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), "Queue Name");
                    if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                        HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "b2bjdev_wiz_q_name");
                    }
                    AQAdapterQueueNamePage queuePage = new AQAdapterQueueNamePage(this.m_wcontext, tempwp);
                    this.addFinishPage();
                }
            }
        }
        catch (Exception e) {
            this.m_wcontext._wizard.setCursor(new Cursor(0));
            e.printStackTrace();
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_CN_CREATE_CONNECTION_ERROR_MSG"));
            Object[] obj = new Object[]{connName};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_CN_CONNECTION_ERROR_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        this.m_wcontext._wizard.setCursor(new Cursor(0));
    }

    public void addWizardPagesAfterOpeningDBConnection() {
        if (this.m_wcontext._service_type == "AQ") {
            this.removePages();
            ImageWizardPage wsdlSelectionPage = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("WS_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)wsdlSelectionPage.getContent(), "bpmjdev_adp_wiz_interface");
            }
            new WsdlSelectionPage(this.m_wcontext, wsdlSelectionPage);
            this.addFinishPage();
        } else if (this.m_wcontext._service_type == "Apps") {
            this.removePages();
            ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("OA_IN_PAGE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_oa_ai");
            }
            new AppsAdapterDelegatePage(this.m_wcontext, tempwp);
            this.addFinishPage();
        } else if (this.m_wcontext._service_type == "DB") {
            if (this.m_wcontext._adapter_sub_type == "SP") {
                this.removePages();
                ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_SP_SPECIFY_STORED_PROCEDURE"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_ssp");
                }
                try {
                    this.m_wcontext._isInboundOperation = false;
                    IDatabase database = Platform.getDatabase(this.m_wcontext);
                    this.m_wcontext._ascontext = database.getDBAdapterSPUserInput();
                    IDBAdapterStoredProcPage procPage = database.getDBAdapterStoredProcPage(this.m_wcontext, tempwp);
                    ImageWizardPage tempAdv = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_AO_TITLE"));
                    DBAdapterSPAdvancedOptionsPage nextPage = new DBAdapterSPAdvancedOptionsPage(this.m_wcontext, tempAdv);
                    this.addFinishPage();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JMSContext jmsContext;
        JcaAddress jcaa = (JcaAddress)this.m_wcontext._extReg.createExtension(JcaAddress.PARENT_CLASS, JcaAddress.FIELD_ELEMENT_TYPE);
        this.m_wcontext._write_port.addExtensibilityElement((ExtensibilityElement)jcaa);
        this.m_wcontext._write_jca_address = jcaa;
        jcaa.setUiConnectionName(this.m_wcontext._uiConnectionName);
        jcaa.setAdapterInstanceJndi(this.m_wcontext._jndiName);
        MessageFormat msgformat = new MessageFormat(this.getTranslatedString("CM_CN_WSDL_COMMENT"));
        if (this.m_wcontext._service_type == "AQ" && PreviewUtil.isInPreviewMode()) {
            jcaa.setAttributeValue(MCF_MANAGED_CONNECTION_FACTORY, MCF_MANAGED_CONNECTION_FACTORY_AQ);
            String dataSource = this.dataSourceTextField.getText();
            if (dataSource != null && !dataSource.trim().equals("")) {
                if (this.xaDataSourceCheckBox.isSelected()) {
                    jcaa.setAttributeValue(MCF_XA_DATA_SOURCE, dataSource);
                } else {
                    jcaa.setAttributeValue(MCF_DATA_SOURCE, dataSource);
                }
            }
            this.setCommonMCFAttributes(jcaa, this.m_wcontext.dbConnectionInfo);
            Object[] obj = new Object[]{"AqAdapter", this.m_wcontext._jndiName};
            jcaa.setComment(msgformat.format(obj));
        } else if (this.m_wcontext._service_type == "Apps" && PreviewUtil.isInPreviewMode()) {
            if (AdapterWizardContext.isOA_XMLGateway) {
                jcaa.setAttributeValue(MCF_MANAGED_CONNECTION_FACTORY, MCF_MANAGED_CONNECTION_FACTORY_AQ);
            } else {
                jcaa.setAttributeValue(MCF_MANAGED_CONNECTION_FACTORY, MCF_MANAGED_CONNECTION_FACTORY_APPS);
                jcaa.setAttributeValue(MCF_DRIVER_CLASS_NAME, this.m_wcontext.dbConnectionInfo.getDriverClassName());
                jcaa.setAttributeValue(MCF_PLATFORM_CLASS_NAME, XRAdapterUtil.guessDatabasePlatformClassName(this.m_wcontext.dbConnectionInfo));
            }
            this.setCommonMCFAttributes(jcaa, this.m_wcontext.dbConnectionInfo);
            Object[] obj = new Object[]{"AppsAdapter", this.m_wcontext._jndiName};
            jcaa.setComment(msgformat.format(obj));
        } else if (this.m_wcontext._service_type == "DB" && PreviewUtil.isInPreviewMode()) {
            jcaa.setAttributeValue(MCF_MANAGED_CONNECTION_FACTORY, MCF_MANAGED_CONNECTION_FACTORY_DB);
            jcaa.setAttributeValue(MCF_DRIVER_CLASS_NAME, this.m_wcontext.dbConnectionInfo.getDriverClassName());
            jcaa.setAttributeValue(MCF_PLATFORM_CLASS_NAME, XRAdapterUtil.guessDatabasePlatformClassName(this.m_wcontext.dbConnectionInfo));
            String dataSource = this.dataSourceTextField.getText();
            if (dataSource != null && !dataSource.trim().equals("")) {
                if (this.xaDataSourceCheckBox.isSelected()) {
                    jcaa.setAttributeValue(MCF_XA_DATA_SOURCE, dataSource);
                } else {
                    jcaa.setAttributeValue(MCF_DATA_SOURCE, dataSource);
                }
            }
            this.setCommonMCFAttributes(jcaa, this.m_wcontext.dbConnectionInfo);
            Object[] obj = new Object[]{"DbAdapter", this.m_wcontext._jndiName};
            jcaa.setComment(msgformat.format(obj));
        } else if (this.m_wcontext._service_type == "Jms" && PreviewUtil.isInPreviewMode() && (jmsContext = (JMSContext)this.m_wcontext._ascontext) != null) {
            jcaa.setAttributeValue(MCF_MANAGED_CONNECTION_FACTORY, MCF_MANAGED_CONNECTION_FACTORY_JMS);
            String connFactoryLoc = jmsContext.formConnectionFactoryLocationOJMS(jmsContext.resourceProviderName, jmsContext.selectedDestinationObject.isTopic());
            jcaa.setAttributeValue(MCF_CONNECTION_FACTORY_LOCATION, connFactoryLoc);
            String isTopicVal = "";
            isTopicVal = jmsContext.selectedDestinationObject.isTopic() ? "true" : "false";
            jcaa.setAttributeValue(MCF_IS_TOPIC, isTopicVal);
            jcaa.setAttributeValue(MCF_IS_TRANSACTED, "true");
            jcaa.setAttributeValue(MCF_FACTORY_PROPERTIES, "");
            jcaa.setAttributeValue(MCF_USERNAME_LOWERCASE, this.m_wcontext.dbConnectionInfo.getUsername());
            jcaa.setAttributeValue(MCF_PASSWORD, this.m_wcontext.dbConnectionInfo.getPassword());
            Object[] obj = new Object[]{"JMSAdapter", this.m_wcontext._jndiName};
            jcaa.setComment(msgformat.format(obj));
        }
    }

    private void setCommonMCFAttributes(JcaAddress jcaa, DatabaseConnectionInfo dbConnInfo) {
        try {
            if (dbConnInfo != null) {
                jcaa.setAttributeValue(MCF_CONNECTION_STRING, dbConnInfo.getConnectionURL());
                jcaa.setAttributeValue(MCF_USERNAME, dbConnInfo.getUsername());
                jcaa.setAttributeValue(MCF_PASSWORD, dbConnInfo.getPassword());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNewInstance(Connection con) {
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select bug_number from AD_BUGS where bug_number = '3258819' ");
            String query = sb.toString();
            ps = con.prepareStatement(query);
            rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ps.close();
                rs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                ps.close();
                rs.close();
            }
            catch (Exception ex) {}
        }
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            String jndiNameStr = this.jndiName.getText().trim();
            if (jndiNameStr == null || jndiNameStr.equals("")) {
                this.jndiName.setText("eis/" + this.m_wcontext._service_type + "/" + this.connPanel.getConnectionName());
                this.previousConnName = this.connPanel.getConnectionName();
                return;
            }
            if (this.previousConnName != null && jndiNameStr != null) {
                String matchingName = "eis/" + this.m_wcontext._service_type + "/" + this.previousConnName;
                if (matchingName.equals(jndiNameStr)) {
                    this.jndiName.setText("eis/" + this.m_wcontext._service_type + "/" + this.connPanel.getConnectionName());
                }
            }
            this.previousConnName = this.connPanel.getConnectionName();
            this.checkDoc();
        }
    }

    private void printDBConnectionInfo(DatabaseConnectionInfo dbConnInfo) {
        if (dbConnInfo != null) {
            System.out.println("\n\n\n\n\n");
            System.out.println("***********************************************");
            System.out.println("Connection Name: " + dbConnInfo.getConnectionName());
            System.out.println("Driver Class Name: " + dbConnInfo.getDriverClassName());
            System.out.println("Hostname: " + dbConnInfo.getHostname());
            System.out.println("Port: " + dbConnInfo.getPort());
            System.out.println("SID: " + dbConnInfo.getSID());
            System.out.println("Username: " + dbConnInfo.getUsername());
            System.out.println("Connection URL: " + dbConnInfo.getConnectionURL());
            System.out.println("***********************************************");
            System.out.println("\n\n\n\n\n");
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc();
    }

    private void checkDoc() {
        String jndiNameStr = this.jndiName.getText().trim();
        String connName = this.connPanel.getConnectionName();
        if (jndiNameStr != null && !jndiNameStr.trim().equals("") && connName != null && !connName.trim().equals("")) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.invalidConnectionNameForUpdate && e.getSource().equals(this.connPanel.getConnCombo())) {
            this.invalidConnectionNameForUpdate = false;
            String connName = this.m_wcontext._read_jca_address.getUiConnectionName();
            String wsdlpath = this.m_wcontext._update_wsdl_path;
            if (wsdlpath.length() > 132) {
                String temp_str = FileAdapterSchemaPage.string_replaceAll(wsdlpath, '/', '\\');
                wsdlpath = temp_str.substring(temp_str.lastIndexOf("\\") + 1);
            }
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_CN_CONNECTION_NAME_NOT_FOUND_MSG"));
            Object[] obj = new Object[]{connName, wsdlpath};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_CN_CONNECTION_ERROR_TITLE"), (int)0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

