/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.schema.OracleSchema;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.xml.schema.XmlSchemaNode;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.schema.ProjectSchemaDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.ProjectWSDLDataSource;
import oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.typeexplorer.WSDLImportHandler;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.utils.URLUtil;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardSchemaImportHandler;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.FocusRequester;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.QNameDisplay;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.aq.AQAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.WizardWSDLUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.InvokeNxsdWizard;
import oracle.tip.tools.ide.tx.addin.MapperWSDLImportHandler;
import org.w3c.dom.Document;

public class CommonSchemaPanel
extends JPanel
implements ActionListener,
FocusListener,
ItemListener,
MouseListener {
    public static final String URL_FILE_PATH_PREFIX = "file:";
    public static final String URL_RELATIVE_FILE_PATH_PREFIX = "file:./";
    public static final String HTTP_PREFIX = "http:";
    public static final String ORAMDS_PREFIX = "oramds:/";
    public static String TITLE_SOURCE_KEY = "SP_SE_SOURCE_PAGE_TITLE";
    public static String TITLE_TARGET_KEY = "SP_SE_TARGET_PAGE_TITLE";
    public AdapterWizardContext m_wcontext = null;
    public String m_projectDirectoryPath;
    public URL m_newSchemaDirUrl;
    public String m_newSchemaDirPath;
    public URL m_wsdlDirUrl;
    SCAProject m_scaProject;
    public Message m_message = null;
    public Part m_part = null;
    public ResourceBundle m_bundle;
    public Frame m_parentFrame;
    public String m_serviceName;
    public Project m_project;
    public String m_panelBorderText;
    public DocumentListener m_doclisten;
    public boolean m_hasOpaque;
    public boolean m_hasBorder;
    public Document m_wdoc;
    public boolean m_schemaHasError = false;
    public String m_lasturl = "";
    public String m_last_defaultGroupName = null;
    public String m_last_defaultEventName = null;
    public String m_last_defaultDisplayName = null;
    public GridBagLayout gridBagLayout1 = new GridBagLayout();
    public GridBagLayout gridBagLayout2 = new GridBagLayout();
    public JLabel elementLB = new JLabel();
    public JComboBox elementCB = new JComboBox();
    public JButton browseSchemaButton;
    public JButton createSchemaButton;
    public JLabel filterLB = new JLabel();
    public JPanel servicePanel = new JPanel();
    public JLabel SchemaLB = new JLabel();
    public JTextField schemaLoc = new JTextField();
    public JCheckBox opaqueCB = new JCheckBox();
    public Border m_border = BorderFactory.createLineBorder(Color.GRAY);
    public String m_servicePanelLB;
    public int m_nextRow;
    public int m_leftpad;
    public int m_fieldsep;
    public int m_vertical_pad;
    ToolBar btnPnl = new ToolBar();
    public static EmptyBorder s_emptyBorder = new EmptyBorder(2, 2, 2, 2);
    public static EtchedBorder s_etchedBorder = new EtchedBorder();

    public CommonSchemaPanel(Project project, String projectDirectoryPath, ResourceBundle rbundle, Frame parentFrame, AdapterWizardContext wcontext, String serviceName, boolean hasBorder, String panelBorderText, DocumentListener doclisten, boolean hasOpaque, boolean futureUse, String futureUse2) {
        try {
            this.m_project = project;
            this.m_projectDirectoryPath = projectDirectoryPath;
            this.m_bundle = rbundle;
            this.m_parentFrame = parentFrame;
            this.m_wcontext = wcontext;
            this.m_serviceName = serviceName;
            this.m_hasBorder = hasBorder;
            this.m_panelBorderText = panelBorderText;
            this.m_doclisten = doclisten;
            this.m_hasOpaque = hasOpaque;
            this.m_scaProject = SCAProject.getSCAProject((Project)this.m_project);
            if (!AdapterWizardContext.IS_STANDALONE_TESTING) {
                this.m_newSchemaDirUrl = this.m_scaProject.getXSDRoot();
                this.m_newSchemaDirPath = SCAProject.getScaSchemaDirectoryPath((Project)this.m_project);
                this.m_wsdlDirUrl = this.m_scaProject.getWSDLRoot();
            }
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.m_servicePanelLB = this.m_panelBorderText;
        String opaqueCBTX = this.m_bundle.getString("FA_SC_OPAQUE_CHECKBOX");
        String opaqueCBTip = this.m_bundle.getString("FA_SC_OPAQUE_CHECKBOX_TIP");
        String schemaLocText = this.m_bundle.getString("FA_SC_SCHEMA_LOCATION_PROMPT");
        String Schematip = this.m_bundle.getString("FA_SC_SCHEMA_LOCATION_TIP");
        String elementText = this.m_bundle.getString("FA_SC_ELEMENT_PROMPT");
        String externSchemaText = this.m_bundle.getString("FA_SC_EXTERNAL_FORMAT_BUTTON");
        String externSchemaTip = this.m_bundle.getString("FA_SC_EXTERNAL_FORMAT_TIP");
        String browseSchemaButtonText = this.m_bundle.getString("FA_SC_BROWSE_TEXT");
        String browseSchemaButtonTip = this.m_bundle.getString("FA_SC_BROWSE_TIP");
        this.setLayout(this.gridBagLayout1);
        if (this.m_hasBorder) {
            this.setBorder(BorderFactory.createTitledBorder(this.m_border, this.m_servicePanelLB));
        }
        this.SchemaLB.setText(StringUtils.stripMnemonic((String)schemaLocText));
        this.SchemaLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)schemaLocText));
        this.SchemaLB.setLabelFor(this.schemaLoc);
        this.schemaLoc.setToolTipText(Schematip);
        this.schemaLoc.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)schemaLocText));
        this.schemaLoc.getAccessibleContext().setAccessibleDescription(Schematip);
        this.schemaLoc.getDocument().addDocumentListener(this.m_doclisten);
        this.schemaLoc.addFocusListener(this);
        this.elementLB.setText(StringUtils.stripMnemonic((String)elementText));
        this.elementLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)elementText));
        this.elementLB.setLabelFor(this.elementCB);
        this.elementCB.setPreferredSize(new Dimension(250, 20));
        this.elementCB.addActionListener(this);
        this.createSchemaButton = UIHelper.createModelerButton((Icon)new ImageIcon(UIHelper.loadImage((String)"images/gear.gif", UIHelper.class)));
        this.createSchemaButton.setToolTipText(externSchemaText);
        this.createSchemaButton.setBorder(s_emptyBorder);
        this.createSchemaButton.addMouseListener(this);
        this.createSchemaButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)externSchemaText));
        this.createSchemaButton.getAccessibleContext().setAccessibleDescription(externSchemaTip);
        this.createSchemaButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)externSchemaText));
        this.createSchemaButton.addActionListener(this);
        this.browseSchemaButton = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.browseSchemaButton.setToolTipText(browseSchemaButtonText);
        this.browseSchemaButton.setBorder(s_emptyBorder);
        this.browseSchemaButton.addMouseListener(this);
        this.browseSchemaButton.setRequestFocusEnabled(false);
        this.browseSchemaButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)browseSchemaButtonText));
        this.browseSchemaButton.setToolTipText(browseSchemaButtonTip);
        this.browseSchemaButton.getAccessibleContext().setAccessibleDescription(browseSchemaButtonTip);
        this.browseSchemaButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)browseSchemaButtonText));
        this.browseSchemaButton.addActionListener(this);
        this.btnPnl.setSpacing(3);
        this.btnPnl.add((Component)this.browseSchemaButton);
        this.btnPnl.add((Component)this.createSchemaButton);
        this.opaqueCB.setText(StringUtils.stripMnemonic((String)opaqueCBTX));
        this.opaqueCB.setToolTipText(opaqueCBTip);
        this.opaqueCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)opaqueCBTX));
        this.opaqueCB.addItemListener(this);
        this.m_leftpad = 5;
        this.m_fieldsep = 10;
        this.m_vertical_pad = 5;
        if (this.m_hasOpaque) {
            this.add((Component)this.opaqueCB, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(this.m_leftpad, 0, 0, 0), 0, 0));
        }
        this.add((Component)this.SchemaLB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(this.m_vertical_pad, this.m_leftpad, 0, 0), 0, 0));
        this.add((Component)this.schemaLoc, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(this.m_vertical_pad, this.m_fieldsep, 0, 0), 0, 0));
        this.add((Component)this.btnPnl, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(this.m_vertical_pad, this.m_leftpad, 0, 5), 0, 0));
        this.add((Component)this.elementLB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(this.m_vertical_pad, this.m_leftpad, this.m_vertical_pad, 0), 0, 0));
        this.add((Component)this.elementCB, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(this.m_vertical_pad, this.m_fieldsep, this.m_vertical_pad, 0), 0, 0));
        this.m_nextRow = 4;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src != this.elementCB) {
            if (src == this.browseSchemaButton) {
                this.handleBrowseSchema();
            } else if (src == this.createSchemaButton) {
                this.handleCreateSchema();
            }
        }
    }

    private void handleBrowseSchema() {
        this.m_lasturl = this.schemaLoc.getText().trim();
        Context jdevcontext = Context.newIdeContext();
        if (jdevcontext != null) {
            TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this));
            CompoundDataSource ds = new CompoundDataSource();
            ds.addDataSource((TreeExplorerDataSource)new ProjectSchemaDataSource(jdevcontext, false, true));
            ds.addDataSource((TreeExplorerDataSource)new ProjectWSDLDataSource(jdevcontext, false, true, false));
            chooser.getTypeExplorer().setSchemaImportHandler((SchemaImportHandler)new AdapterWizardSchemaImportHandler(new JDevBPELProject(this.m_project)));
            MapperWSDLImportHandler wimph = new MapperWSDLImportHandler(jdevcontext);
            wimph.setTargetDirLocation(this.m_wsdlDirUrl);
            chooser.getTypeExplorer().setWSDLImportHandler((WSDLImportHandler)wimph);
            chooser.setTargetSchemaDirLocation(this.m_newSchemaDirUrl);
            chooser.setTargetWSDLDirLocation(this.m_wsdlDirUrl);
            int rcint = chooser.display((TreeExplorerDataSource)ds);
            if (rcint == 0) {
                this.m_schemaHasError = false;
                TypeObject m_elementTypeObj = chooser.getTypeObject();
                URL fileUrl = (URL)m_elementTypeObj.getData("RESOURCE_URL_KEY");
                String file_type = (String)m_elementTypeObj.getData("FILE_TYPE_KEY");
                String file_name = CommonSchemaPanel.convertUriRelativeProject(CommonSchemaPanel.getBaseURL(this.m_projectDirectoryPath), fileUrl);
                if (file_type.equals("SCHEMA_FILE") && file_name.toLowerCase().endsWith("xsd")) {
                    this.loadSchemaElements(file_name, true);
                    String elname = m_elementTypeObj.getQName().getLocalPart();
                    for (int ii = this.elementCB.getItemCount(); ii > 0; --ii) {
                        QNameDisplay qn1 = (QNameDisplay)this.elementCB.getItemAt(ii - 1);
                        if (!elname.equals(qn1.toString())) continue;
                        this.elementCB.setSelectedItem(qn1);
                        break;
                    }
                } else {
                    this.elementCB.removeAllItems();
                    this.elementCB.addItem(new QNameDisplay(m_elementTypeObj.getQName()));
                }
                this.schemaLoc.setText(file_name);
                this.m_lasturl = this.schemaLoc.getText().trim();
                this.schemaLoc.requestFocus();
            }
        }
    }

    public void loadSchemaElements(String urlstr_in, boolean errorAlert) {
        this.elementCB.removeAllItems();
        String urlstr = CommonSchemaPanel.convertRelativeToAbsolutePathForProject(this.m_projectDirectoryPath, urlstr_in);
        URL u1 = URLFactory.newURL((String)urlstr);
        URL defaultSchema = this.m_scaProject.getDefaultSchemaUrl();
        if (u1.equals(defaultSchema)) {
            this.addSchemaElement(SCAProject.SINGLE_STRING_ELEMENT_QNAME);
            return;
        }
        OracleSchema[] xsdSchema = null;
        try {
            OracleSchemaFactory orclSchemaFactory = new OracleSchemaFactory();
            orclSchemaFactory.clearCache();
            xsdSchema = orclSchemaFactory.buildSchemas(u1);
        }
        catch (Exception ex) {
            if (errorAlert) {
                ex.printStackTrace();
                MessageFormat msgformat = new MessageFormat(this.m_bundle.getString("CM_SC_SCHEMA_LOCATION_ERROR_MSG"));
                Object[] obj = new Object[]{urlstr};
                MultiLineOptionPane.showMessageDialog((Component)this.m_parentFrame, (Object)msgformat.format(obj), (String)this.m_bundle.getString("CM_SC_URL_ERROR_TITLE"), (int)0);
                this.invalidSchema();
            }
            return;
        }
        String targetNamespace = null;
        for (int j = 0; j < xsdSchema.length; ++j) {
            Collection col = xsdSchema[j].getElementDefs();
            if (targetNamespace == null) {
                targetNamespace = xsdSchema[j].getTargetNamespace();
            }
            for (ElementDef elementDef : col) {
                this.elementCB.addItem(new QNameDisplay(elementDef.getQualifiedName()));
            }
        }
        if (this.elementCB.getItemCount() == 0 && errorAlert) {
            MessageFormat msgformat = new MessageFormat(this.m_bundle.getString("CM_SC_SCHEMA_ELEMENT_ERROR_MSG"));
            Object[] obj = new Object[]{urlstr};
            MultiLineOptionPane.showMessageDialog((Component)this.m_parentFrame, (Object)msgformat.format(obj), (String)this.m_bundle.getString("CM_SC_URL_ERROR_TITLE"), (int)0);
            this.invalidSchema();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleCreateSchema() {
        block8: {
            block9: {
                block7: {
                    this.m_lasturl = this.schemaLoc.getText().trim();
                    ninfo = null;
                    tempstr = this.schemaLoc.getText().trim();
                    if (tempstr == null || tempstr.length() <= 0 || tempstr.equals("xsd/singleString.xsd")) break block7;
                    sepchar = File.separator;
                    sepchar = "/";
                    if (tempstr.contains(sepchar)) {
                        tempstr = tempstr.substring(tempstr.lastIndexOf(sepchar) + 1);
                    }
                    ninfo = InvokeNxsdWizard.runWizard(this.m_parentFrame, this.m_newSchemaDirPath, tempstr);
                    break block8;
                }
                if (this.m_wcontext == null) break block9;
                if (!this.m_wcontext._service_type.equals("Apps")) break block9;
                m_aqcontext = (AQAdapterContext)this.m_wcontext._ascontext;
                if (m_aqcontext._OAspecialType == null) ** GOTO lbl-1000
                if (m_aqcontext._OAspecialType.equals("ECXMSG")) {
                    ninfo = InvokeNxsdWizard.runWizard(this.m_parentFrame, this.m_newSchemaDirPath, this.m_wcontext._connection);
                } else lbl-1000:
                // 2 sources

                {
                    ninfo = InvokeNxsdWizard.runWizard(this.m_parentFrame, this.m_newSchemaDirPath, this.m_wcontext._write_service_name, false);
                }
                break block8;
            }
            ninfo = InvokeNxsdWizard.runWizard(this.m_parentFrame, this.m_newSchemaDirPath, this.m_serviceName, false);
        }
        if (ninfo != null) {
            this.m_schemaHasError = false;
            this.elementCB.removeAllItems();
            qnd = new QNameDisplay(ninfo.getTargetNamespace(), ninfo.getRootElement());
            this.elementCB.addItem(qnd);
            this.elementCB.setSelectedItem(qnd);
            if (this.m_project != null) {
                nxsdUrl = URLFactory.newURL((String)("file:" + this.m_newSchemaDirPath + "/" + ninfo.getNxsdFileName()));
                projUrl = URLFactory.newURL((String)("file:" + this.m_projectDirectoryPath + "/"));
                tempstr = URLFileSystem.toRelativeSpec((URL)nxsdUrl, (URL)projUrl);
                this.schemaLoc.setText(tempstr);
                try {
                    nxsdNode = NodeFactory.findOrCreate(XmlSchemaNode.class, (URL)nxsdUrl);
                    this.m_project.add((Element)nxsdNode, true);
                }
                catch (Exception except) {
                    except.printStackTrace();
                    msgformat = new MessageFormat(this.m_bundle.getString("CM_WZ_PROJECT_FILE_ERROR_MSG"));
                    obj = new Object[]{nxsdUrl.getFile(), except.getLocalizedMessage()};
                    MultiLineOptionPane.showMessageDialog((Component)this.m_parentFrame, (Object)msgformat.format(obj), (String)this.m_bundle.getString("CM_WZ_PROJECT_FILE_ERROR_TITLE"), (int)0);
                }
            }
            this.m_lasturl = this.schemaLoc.getText().trim();
        }
    }

    private void invalidSchema() {
        this.m_schemaHasError = true;
        new FocusRequester(this.schemaLoc);
    }

    public boolean checkPanel() {
        if (this.m_hasOpaque && this.opaqueCB.isSelected()) {
            return true;
        }
        String tempstr2 = this.schemaLoc.getText().trim();
        return tempstr2 != null && tempstr2.length() > 0 && !this.m_schemaHasError && this.elementCB.getItemCount() > 0;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
        if (src.equals(this.schemaLoc)) {
            this.m_schemaHasError = false;
            String locstr = this.schemaLoc.getText().trim();
            if (locstr.length() == 0) {
                return;
            }
            if (locstr.endsWith("wsdl")) {
                return;
            }
            String urlstr = CommonSchemaPanel.convertUriRelativeProject(this.m_projectDirectoryPath, locstr);
            if (urlstr == null) {
                MessageFormat msgformat = new MessageFormat(this.m_bundle.getString("FA_SC_SCHEMA_LOCATION_ERROR_MSG"));
                Object[] obj = new Object[]{urlstr, this.m_projectDirectoryPath};
                MultiLineOptionPane.showMessageDialog((Component)this.m_parentFrame, (Object)msgformat.format(obj), (String)this.m_bundle.getString("CM_SC_URL_ERROR_TITLE"), (int)0);
                this.invalidSchema();
                return;
            }
            if (!locstr.equals(urlstr)) {
                this.schemaLoc.setText(urlstr);
            }
            if (this.elementCB.getItemCount() == 0 || !locstr.equals(this.m_lasturl)) {
                this.loadSchemaElements(urlstr, true);
                this.m_lasturl = locstr;
            }
            this.m_doclisten.changedUpdate(null);
        }
    }

    protected void invokeGraphicalXPathBuilder(XPathEditorPane editorPane) {
        Context context = EditorManager.getEditorManager().getCurrentEditor().getContext();
    }

    public void setEnabledAll(boolean value) {
        this.SchemaLB.setEnabled(value);
        this.schemaLoc.setEnabled(value);
        this.elementLB.setEnabled(value);
        this.elementCB.setEnabled(value);
        this.browseSchemaButton.setEnabled(value);
        this.createSchemaButton.setEnabled(value);
    }

    public static String convertRelativeToAbsolutePathForProject(String projectDirectoryPath, String relativeFileName) {
        if (!SCAProject.isFilePathRelative((String)relativeFileName)) {
            return relativeFileName;
        }
        String dirpath = projectDirectoryPath;
        if (!dirpath.endsWith(File.separator)) {
            dirpath = dirpath + File.separator;
        }
        URL dirurl = URLFactory.newURL((String)dirpath);
        URL furl = URLFactory.newURL((URL)dirurl, (String)relativeFileName);
        return SCAProject.getFilePath((URL)furl);
    }

    public static String convertUriRelativeProject(String projectDirectoryPath, String inloc) {
        if (SCAProject.isFilePathRelative((String)inloc)) {
            return inloc;
        }
        URL dirurl = CommonSchemaPanel.getBaseURL(projectDirectoryPath);
        URL inurl = URLFactory.newURL((String)inloc);
        return CommonSchemaPanel.convertUriRelativeProject(dirurl, inurl);
    }

    public static String convertUriRelativeProject(URL dirurl, URL inurl) {
        String filestr = null;
        filestr = URLFileSystem.isBaseURLFor((URL)dirurl, (URL)inurl) ? URLFileSystem.toRelativeSpec((URL)inurl, (URL)dirurl) : URLUtil.toString((URL)inurl);
        return filestr;
    }

    public static URL getBaseURL(String directoryPath) {
        String dirpath = directoryPath;
        if (!dirpath.endsWith(File.separator)) {
            dirpath = dirpath + File.separator;
        }
        return URLFactory.newURL((String)dirpath);
    }

    public static String string_replaceAll(String strin, char oldchar, char newchar) {
        char[] tempstr = strin.toCharArray();
        String strout = "";
        for (int ii = 0; ii < tempstr.length; ++ii) {
            strout = tempstr[ii] == oldchar ? strout + newchar : strout + tempstr[ii];
        }
        return strout;
    }

    public boolean isUserInputValid() {
        String schemaLocStr = this.schemaLoc.getText().trim();
        if (this.opaqueCB.isSelected()) {
            return true;
        }
        return schemaLocStr != null && schemaLocStr.length() > 0 && !this.m_schemaHasError;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.opaqueCB) {
            if (e.getStateChange() == 1) {
                this.setEnabledAll(false);
                this.m_doclisten.changedUpdate(null);
            } else {
                this.setEnabledAll(true);
                this.schemaLoc.grabFocus();
                this.m_doclisten.changedUpdate(null);
            }
        }
    }

    public boolean isOpaqueSchemaSelected() {
        return this.opaqueCB.isSelected();
    }

    public String getSchemaLocation() {
        return this.schemaLoc.getText().trim();
    }

    public String getSchemaElement() {
        return ((QNameDisplay)this.elementCB.getSelectedItem()).toString();
    }

    public String getSchemaElementNamespaceURI() {
        return ((QNameDisplay)this.elementCB.getSelectedItem()).getNamespaceURI();
    }

    public void setOpaqueSchemaSelected(boolean selected) {
        if (selected && !this.opaqueCB.isSelected()) {
            this.opaqueCB.doClick();
        } else if (this.opaqueCB.isSelected()) {
            this.opaqueCB.doClick();
        }
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    public void setSchemaLocationText(String schemaLocation) {
        this.schemaLoc.setText(schemaLocation);
    }

    public void addSchemaElement(QName qName) {
        QNameDisplay qnd = new QNameDisplay(qName);
        this.elementCB.addItem(qnd);
    }

    public void addSchemaElement(QualifiedName qualifiedName) {
        QNameDisplay qnd = new QNameDisplay(qualifiedName);
        this.elementCB.addItem(qnd);
    }

    public void setSelectedSchemaElement(String elementName) {
        int size;
        if (elementName != null && (size = this.elementCB.getItemCount()) > 0) {
            for (int i = 0; i < size; ++i) {
                QNameDisplay curItem = (QNameDisplay)this.elementCB.getItemAt(i);
                if (!elementName.equals(curItem.toString())) continue;
                this.elementCB.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JButton button;
        Object object = e.getSource();
        if (object instanceof JButton && (button = (JButton)object).isEnabled()) {
            button.setBorder(s_etchedBorder);
            button.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object object = e.getSource();
        if (object instanceof JButton) {
            JButton button = (JButton)object;
            button.setBorder(s_emptyBorder);
            button.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public String setSchemaForOperation(String wsdlRelAddr, Definition def1, PortType portt1, String operationName, boolean isOutput) {
        List impL;
        String namespace;
        String schemaURI;
        List operations = portt1.getOperations();
        Operation oper1 = null;
        if (operationName != null) {
            for (Operation toper : operations) {
                if (!toper.getName().equals(operationName)) continue;
                oper1 = toper;
                break;
            }
            if (oper1 == null) {
                throw new RuntimeException("FileAdapterSchemaPage.setSchemaForOperation could not find operation: " + operationName);
            }
        } else {
            oper1 = (Operation)operations.get(0);
        }
        QName elname = null;
        if (isOutput) {
            Output out1 = oper1.getOutput();
            this.m_message = out1.getMessage();
        } else {
            Input in1 = oper1.getInput();
            this.m_message = in1.getMessage();
        }
        this.m_part = (Part)this.m_message.getParts().values().iterator().next();
        QName pqname = this.m_part.getTypeName();
        if (pqname == null) {
            elname = pqname = this.m_part.getElementName();
        }
        if ((schemaURI = WizardWSDLUtil.getSchemaLocation(def1, namespace = pqname.getNamespaceURI())) == null && wsdlRelAddr != null) {
            try {
                SCAProject scaproj = SCAProject.getSCAProject((Project)this.m_wcontext._project);
                URL wsdlUrl = scaproj.getScaUrl(wsdlRelAddr);
                URI wsdlUri = wsdlUrl.toURI();
                URI sURI = WSDLUtil.getSchemaURI((URI)wsdlUri, (String)namespace);
                while (sURI.getPath().endsWith(".wsdl") && !(sURI = WSDLUtil.getSchemaURI((URI)(wsdlUri = sURI), (String)namespace)).equals(wsdlUri)) {
                }
                if (sURI != null) {
                    schemaURI = CommonSchemaPanel.convertUriRelativeProject(scaproj.getSCARoot(), sURI.toURL());
                }
            }
            catch (Exception exp1) {
                // empty catch block
            }
        }
        if (schemaURI == null && (impL = def1.getImports(namespace)) != null && impL.size() > 0) {
            Import imp = (Import)impL.get(0);
            schemaURI = imp.getLocationURI();
        }
        if (schemaURI != null) {
            if (wsdlRelAddr != null && !SCAProject.isFilePathRelative((String)wsdlRelAddr) && SCAProject.isFilePathRelative((String)schemaURI)) {
                schemaURI = wsdlRelAddr.substring(0, wsdlRelAddr.lastIndexOf("/") + 1) + schemaURI;
            }
            this.schemaLoc.setText(schemaURI);
            this.m_lasturl = schemaURI;
            if (!schemaURI.toLowerCase().endsWith("wsdl")) {
                this.loadSchemaElements(schemaURI, false);
            }
            for (int ii = this.elementCB.getItemCount(); ii > 0; --ii) {
                QNameDisplay eldef = (QNameDisplay)this.elementCB.getItemAt(ii - 1);
                if (!pqname.getNamespaceURI().equals(eldef.getNamespaceURI()) || !pqname.getLocalPart().equals(eldef.getLocalPart())) continue;
                this.elementCB.setSelectedItem(eldef);
                break;
            }
            if (elname != null && schemaURI.toLowerCase().endsWith("wsdl")) {
                QNameDisplay qnd = new QNameDisplay(elname);
                this.elementCB.addItem(qnd);
                this.elementCB.setSelectedItem(qnd);
            }
        }
        return namespace;
    }
}

