/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.text.MessageFormat;
import javax.naming.Context;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.server.connection.AppServer;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.jdeveloper.server.dt.panels.AppServerConnectionsPanel;
import oracle.rc.asadapter.connection.AppServerConnection;
import oracle.rc.asadapter.connection.AppServerProvider;
import oracle.rc.asadapter.connection.ConnectionDescriptor;
import oracle.rc.asadapter.connection.Presentation;
import oracle.rc.asadapter.connection.PresentationType;
import oracle.rc.asadapter.weblogic.connection.Weblogic10Descriptor;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.utils.PreviewUtil;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaAddress;

public class AppServerConnectionPage
extends techAdapterWizardPage
implements ActionListener,
DocumentListener,
FocusListener {
    public static final String MCF_MANAGED_CONNECTION_FACTORY = "ManagedConnectionFactory";
    public static final String MCF_MANAGED_CONNECTION_FACTORY_JMS = "oracle.tip.adapter.jms.JmsManagedConnectionFactory";
    public static final String MCF_CONNECTION_FACTORY_LOCATION = "mcf.ConnectionFactoryLocation";
    public static final String MCF_FACTORY_PROPERTIES = "mcf.FactoryProperties";
    public static final String MCF_IS_TOPIC = "mcf.IsTopic";
    public static final String MCF_IS_TRANSACTED = "mcf.IsTransacted";
    public static final String MCF_USERNAME = "mcf.UserName";
    public static final String MCF_USERNAME_LOWERCASE = "mcf.Username";
    public static final String MCF_PASSWORD = "mcf.Password";
    public static final String NAMING_FACTORY = "java.naming.factory.initial";
    public static final String NAMING_URL = "java.naming.provider.url";
    public static final String NAMING_PRINCIPAL = "java.naming.security.principal";
    public static final String NAMING_CREDENTIALS = "java.naming.security.credentials";
    private String prevConnName = "";
    private MultiLineLabel introLabel;
    private MultiLineLabel jndiInstanceIntroLabel;
    private JLabel jndiNameLabel = new JLabel();
    private JTextField jndiNameTextField = new JTextField();
    private ConnNode currentConnNode = null;
    private JPanel spacer = new JPanel();
    boolean invalidConnectionNameForUpdate = false;
    private AppServerConnectionsPanel appConnPanel;
    private JPanel appConnDetailsPanel;
    private JLabel appConnUserLabel;
    private JLabel appConnUser;
    private JLabel appConnHostLabel;
    private JLabel appConnHost;

    public AppServerConnectionPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("bpmjdev_adp_wiz_jms_conn_filemem");
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String introText = this.getTranslatedString("CM_APP_CN_INTRO_PROMPT");
        String jndiPrompt = this.getTranslatedString("CM_APP_CN_JNDI_NAME");
        String jndiNameTip = this.getTranslatedString("CM_APP_JNDI_TIP");
        String jndiIntroText = null;
        String appConnPanelUserTxt = this.getTranslatedString("CM_APP_CN_USER_NAME");
        String appConnPanelHostTxt = this.getTranslatedString("CM_APP_CN_HOST_NAME");
        if (!this.m_wcontext._service_type.equals("Jms")) {
            jndiIntroText = this.getTranslatedString("JMS_CN_INTRO_PROMPT");
        }
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(431, 326));
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.appConnPanel = new AppServerConnectionsPanel(AppServerManager.getInstance());
        this.appConnPanel.setConnectionPrompt(null);
        this.appConnPanel.getConnectionsCombo().addFocusListener(this);
        this.appConnPanel.getConnectionsCombo().addActionListener(this);
        this.m_page.setInitialFocus((Component)this.appConnPanel.getConnectionsCombo());
        this.appConnDetailsPanel = new JPanel(new GridBagLayout());
        this.appConnDetailsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.appConnUserLabel = new JLabel(appConnPanelUserTxt);
        this.appConnHostLabel = new JLabel(appConnPanelHostTxt);
        this.appConnUser = new JLabel();
        this.appConnHost = new JLabel();
        this.appConnDetailsPanel.add((Component)this.appConnUserLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.appConnDetailsPanel.add((Component)this.appConnUser, new GridBagConstraints(1, 0, 2, 1, 50.0, 0.0, 18, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.appConnDetailsPanel.add((Component)this.appConnHostLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.appConnDetailsPanel.add((Component)this.appConnHost, new GridBagConstraints(1, 1, 2, 1, 50.0, 0.0, 18, 2, new Insets(5, 10, 5, 0), 0, 0));
        this.jndiInstanceIntroLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), jndiIntroText);
        this.jndiNameLabel.setText(StringUtils.stripMnemonic((String)jndiPrompt));
        this.jndiNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)jndiPrompt));
        this.jndiNameLabel.setLabelFor(this.jndiNameTextField);
        this.jndiNameTextField.setSize(new Dimension(20, 20));
        this.jndiNameTextField.setPreferredSize(new Dimension(20, 20));
        this.jndiNameTextField.setToolTipText(jndiNameTip);
        this.jndiNameTextField.getAccessibleContext().setAccessibleDescription(jndiNameTip);
        this.jndiNameTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)jndiPrompt));
        this.jndiNameTextField.getDocument().addDocumentListener(this);
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.appConnPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.appConnDetailsPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jndiInstanceIntroLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jndiNameLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jndiNameTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 30, 0), 0, 0));
        this.add((Component)this.spacer, new GridBagConstraints(0, 5, 1, 1, 0.0, 2.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        if ("Jms".equals(this.m_wcontext._service_type)) {
            this.jndiInstanceIntroLabel.setVisible(false);
            this.jndiNameLabel.setVisible(false);
            this.jndiNameTextField.setVisible(false);
        } else {
            this.updateJNDIControls();
        }
        this.updateControls();
        if (this.m_wcontext._read_service != null) {
            this.initFromExistingWSDL();
        }
    }

    public void setIntroLabel(String introTxt) {
        this.introLabel.setText(introTxt);
    }

    protected void initFromExistingWSDL() {
        if (this.m_wcontext._read_jca_address != null) {
            if (!this.m_wcontext.isStandalone() && !AdapterWizardContext.IS_STANDALONE_TESTING) {
                String connName;
                this.m_wcontext._uiConnectionName = connName = this.m_wcontext._read_jca_address.getUiConnectionName();
                AppServer selAppServ = null;
                AppServerConnection conn = null;
                try {
                    selAppServ = AppServerManager.getInstance().getAppServer(connName);
                    conn = selAppServ.getConnection();
                    this.invalidConnectionNameForUpdate = false;
                    this.appConnPanel.setConnectionName(connName);
                }
                catch (Exception e) {
                    this.invalidConnectionNameForUpdate = true;
                }
                if (selAppServ != null) {
                    Platform p = selAppServ.getPlatform();
                    PlatformType ptype = p.getType();
                    if (ptype.equals((Object)PlatformType.WEBLOGIC)) {
                        Weblogic10Descriptor desc = (Weblogic10Descriptor)ConnectionDescriptor.newInstance(Weblogic10Descriptor.class, (AppServerProvider)conn.getAppServerProvider());
                        this.currentConnNode = new ConnNode(connName, (ConnectionDescriptor)desc);
                    }
                    if (this.currentConnNode != null) {
                        try {
                            this.setConnectionContext();
                            this.m_wcontext._connDescriptor = this.currentConnNode.getConnectionObject();
                        }
                        catch (Exception e) {
                            this.m_wcontext._wizard.setCursor(new Cursor(0));
                            e.printStackTrace();
                            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_CN_CREATE_CONNECTION_ERROR_MSG"));
                            Object[] obj = new Object[]{connName};
                            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_CN_CONNECTION_ERROR_TITLE"), (int)0);
                        }
                    }
                }
            }
            if (this.jndiNameTextField.isVisible()) {
                String jndiName = this.m_wcontext._read_jca_address.getAdapterInstanceJndi();
                this.jndiNameTextField.setText(jndiName);
            }
        }
        this.updateControls();
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.m_wcontext._wizard.setCursor(new Cursor(3));
        if (this.jndiNameTextField.isVisible()) {
            this.m_wcontext._jndiName = this.jndiNameTextField.getText().trim();
        }
        if (this.m_wcontext._appServerConnection != null) {
            try {
                this.m_wcontext._appServerConnection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String connName = this.appConnPanel.getConnectionName();
        if (this.currentConnNode != null) {
            try {
                this.setConnectionContext();
                this.m_wcontext._uiConnectionName = this.currentConnNode.toString();
                this.m_wcontext._connDescriptor = this.currentConnNode.getConnectionObject();
            }
            catch (Exception e) {
                this.m_wcontext._wizard.setCursor(new Cursor(0));
                e.printStackTrace();
                MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_CN_CREATE_CONNECTION_ERROR_MSG"));
                Object[] obj = new Object[]{connName};
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_CN_CONNECTION_ERROR_TITLE"), (int)0);
                this.appConnPanel.getConnectionsCombo().requestFocus();
                ((Cancelable)event).cancel();
            }
        }
        this.m_wcontext._wizard.setCursor(new Cursor(0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.appConnPanel.getConnectionsCombo()) {
            this.updateJNDIControls();
        }
        this.updateControls();
    }

    private void setConnectionContext() throws Exception {
        Context jndiCtx;
        String connName = this.currentConnNode.name;
        AppServer as = AppServerManager.getInstance().getAppServer(connName);
        AppServerConnection conn = as.getConnection();
        Presentation pres = conn.getPresentation(PresentationType.JNDI);
        this.m_wcontext._appServerConnection = jndiCtx = (Context)pres.get();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateControls();
    }

    private void updateControls() {
        String connName = this.appConnPanel.getConnectionName();
        String jndiName = this.jndiNameTextField.getText();
        if (connName != null && !connName.trim().equals("")) {
            this.setCurrentConnectionNode(connName);
        }
        if (this.currentConnNode != null) {
            this.appConnHost.setText(this.currentConnNode.getConnectionObject().get("JMX_CONNECTOR_HOST"));
            this.appConnUser.setText(this.currentConnNode.getConnectionObject().getUserName());
        }
        if (connName == null || connName.trim().equals("")) {
            this.m_page.setCanAdvance(false);
        } else if (this.jndiNameTextField.isVisible() && (jndiName == null || jndiName.trim().equals(""))) {
            this.m_page.setCanAdvance(false);
        } else {
            this.m_page.setCanAdvance(true);
        }
    }

    private void updateJNDIControls() {
        String connName = this.appConnPanel.getConnectionName();
        if (connName == null || connName.trim().equals("")) {
            return;
        }
        if (this.jndiNameTextField.isVisible()) {
            String prevJNDIName = this.jndiNameTextField.getText();
            if (prevJNDIName == null || prevJNDIName.trim().equals("")) {
                this.jndiNameTextField.setText("eis/" + this.m_wcontext._service_type + "/" + connName);
            } else if (prevJNDIName.endsWith(this.prevConnName)) {
                this.jndiNameTextField.setText(prevJNDIName.substring(0, prevJNDIName.indexOf(this.prevConnName)) + connName);
            }
            this.prevConnName = connName;
        }
    }

    private <ConnDesc> void setCommonMCFAttributes(JcaAddress jcaa, ConnDesc connDesc) {
        try {
            if (!this.m_wcontext.isStandalone() && connDesc != null) {
                String username = null;
                String password = null;
                if (connDesc instanceof Weblogic10Descriptor) {
                    Weblogic10Descriptor desc = (Weblogic10Descriptor)connDesc;
                    username = desc.getUserName();
                    password = desc.getPassword();
                }
                String mcfFactoryPropsValue = "";
                jcaa.setAttributeValue(MCF_FACTORY_PROPERTIES, mcfFactoryPropsValue);
                if (this.m_wcontext._service_type.equals("Jms")) {
                    jcaa.setAttributeValue(MCF_USERNAME_LOWERCASE, username);
                }
                jcaa.setAttributeValue(MCF_PASSWORD, password);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JcaAddress jcaa = (JcaAddress)this.m_wcontext._extReg.createExtension(JcaAddress.PARENT_CLASS, JcaAddress.FIELD_ELEMENT_TYPE);
        this.m_wcontext._write_port.addExtensibilityElement((ExtensibilityElement)jcaa);
        this.m_wcontext._write_jca_address = jcaa;
        if (this.jndiNameTextField.isVisible()) {
            jcaa.setAdapterInstanceJndi(this.m_wcontext._jndiName);
        }
        if (this.currentConnNode != null) {
            JMSContext jmsContext;
            jcaa.setUiConnectionName(this.m_wcontext._uiConnectionName);
            if (this.m_wcontext._service_type == "Jms" && (jmsContext = (JMSContext)this.m_wcontext._ascontext) != null) {
                if (jmsContext.b2bContext != null) {
                    jcaa.setAttributeValue("UIJmsProvider", jmsContext.jmsProvider);
                }
                if (PreviewUtil.isInPreviewMode()) {
                    jcaa.setAttributeValue(MCF_MANAGED_CONNECTION_FACTORY, MCF_MANAGED_CONNECTION_FACTORY_JMS);
                    jcaa.setAttributeValue(MCF_CONNECTION_FACTORY_LOCATION, jmsContext.mcfConnectionFactoryLocation);
                    String isTopicVal = "";
                    isTopicVal = jmsContext.selectedDestinationObject.isTopic() ? "true" : "false";
                    jcaa.setAttributeValue(MCF_IS_TOPIC, isTopicVal);
                    jcaa.setAttributeValue(MCF_IS_TRANSACTED, "false");
                    this.setCommonMCFAttributes(jcaa, this.currentConnNode.getConnectionObject());
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.invalidConnectionNameForUpdate && e.getSource().equals(this.appConnPanel.getConnectionsCombo())) {
            this.invalidConnectionNameForUpdate = false;
            String connName = this.m_wcontext._read_jca_address.getUiConnectionName();
            String wsdlpath = this.m_wcontext._update_wsdl_path;
            String jcapath = "";
            try {
                jcapath = this.getJCAFilePath(this.m_wcontext.getFilePath(), this.m_wcontext._update_wsdl_path);
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (wsdlpath.length() > 132) {
                String temp_str = FileAdapterSchemaPage.string_replaceAll(wsdlpath, '/', '\\');
                wsdlpath = temp_str.substring(temp_str.lastIndexOf("\\") + 1);
            }
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_CN_APPCONN_NOT_FOUND_MSG"));
            Object[] obj = new Object[]{connName, jcapath};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_CN_CONNECTION_ERROR_TITLE"), (int)0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private String getJCAFilePath(String jcaDir, String wsdlFilePath) throws Exception {
        String TARGET = "binding.jca";
        String jcaFilePath = null;
        String piValue = SCAControllerImpl.getWsdlProcessingInstruction((String)wsdlFilePath);
        if (piValue != null) {
            String jcaFilename = piValue.trim();
            jcaFilePath = jcaFilename != null && !jcaFilename.equals("") && jcaDir != null && !jcaDir.trim().equals("") ? jcaDir + File.separator + jcaFilename : jcaFilename;
        }
        return jcaFilePath;
    }

    private void setCurrentConnectionNode(String connName) {
        AppServer selAppServ = AppServerManager.getInstance().getAppServer(connName);
        AppServerConnection conn = selAppServ.getConnection();
        Platform p = selAppServ.getPlatform();
        PlatformType ptype = p.getType();
        if (ptype.equals((Object)PlatformType.WEBLOGIC)) {
            Weblogic10Descriptor desc = (Weblogic10Descriptor)ConnectionDescriptor.newInstance(Weblogic10Descriptor.class, (AppServerProvider)conn.getAppServerProvider());
            this.currentConnNode = new ConnNode(connName, (ConnectionDescriptor)desc);
        }
    }

    private class ConnNode {
        private String name;
        private ConnectionDescriptor connDesc;

        public ConnNode(String name, ConnectionDescriptor connDesc) {
            this.name = name;
            this.connDesc = connDesc;
        }

        public ConnectionDescriptor getConnectionObject() {
            return this.connDesc;
        }

        public String toString() {
            return this.name;
        }
    }
}

