/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.CommitNotifier;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.TabbedPanel;
import oracle.ide.panels.Traversable;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.FinishPanel;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;

public class BaseWizardLauncher
implements CommitNotifier {
    public static final String CONTEXT_KEY = "Context";
    public static final String WIZARD_NAME_KEY = "WizardName";
    private ArrayList m_stepList = new ArrayList();
    private boolean m_showStepNumber;
    private String m_wizardTitle;
    private boolean m_welcomePageAdded;
    private boolean m_finishPageAdded;
    private Namespace m_data = new Namespace();
    private EventListenerList m_listeners;

    public BaseWizardLauncher(Context initContext) {
        if (initContext != null) {
            this.m_data.put(CONTEXT_KEY, (Object)initContext);
        }
    }

    public BaseWizardLauncher(Context initContext, String wizardTitle) {
        this(initContext);
        this.m_wizardTitle = wizardTitle;
    }

    public void initLauncher(Context context) {
    }

    public boolean runWizard() {
        return false;
    }

    public final void setWizardTitle(String title) {
        this.m_wizardTitle = title;
    }

    public final String getWizardTitle() {
        return this.m_wizardTitle;
    }

    public final Namespace getNamespace() {
        return this.m_data;
    }

    public boolean addWelcomePage(String welcomePageClassStr, String helpID, String pageTitle) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(welcomePageClassStr);
        }
        catch (Exception e) {
            return false;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)pageTitle)) {
            step.setPageTitle(pageTitle);
        }
        this.addWelcomeStep(step, helpID);
        return true;
    }

    public void addWelcomePage(String welcomeText, String descriptiveText, String saveKey, String helpId) {
        Class[] argTypeArray = new Class[4];
        for (int i = 0; i < 4; ++i) {
            argTypeArray[i] = String.class;
        }
        Object[] argValueArray = new Object[]{this.m_wizardTitle, welcomeText, descriptiveText, saveKey};
        this.addWelcomeStep(new Step(WelcomePanel.class, argTypeArray, argValueArray), helpId);
    }

    public void addFinishPage(String helpID) {
        this.addFinishPage("oracle.jdevimpl.wizard.project.DefaultFinishPage", helpID, null);
    }

    public void addFinishPage(String finishText, String descText, String title, String helpId) {
        Class[] argTypes = new Class[]{String.class, String.class};
        Object[] argVals = new Object[]{finishText, descText};
        Step step = new Step(FinishPanel.class, argTypes, argVals);
        if (!ModelUtil.hasLength((String)title)) {
            title = "Finish";
        }
        step.setPageTitle(title);
        this.addFinishStep(step, helpId);
    }

    public boolean addFinishPage(String finishPageClassStr, String helpID, String pageTitle) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(finishPageClassStr);
        }
        catch (Exception e) {
            return false;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)pageTitle)) {
            step.setPageTitle(pageTitle);
        }
        this.addFinishStep(step, helpID);
        return true;
    }

    public boolean addPage(String pageClass) {
        return this.addPage(pageClass, null, null);
    }

    public boolean addPage(String pageClass, String helpID) {
        return this.addPage(pageClass, helpID, null);
    }

    public boolean addPage(String pageClassStr, String helpID, String pageTitle) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(pageClassStr);
        }
        catch (Exception e) {
            return false;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)helpID)) {
            step.setHelpID(helpID);
        }
        if (ModelUtil.hasLength((String)pageTitle)) {
            step.setPageTitle(pageTitle);
        }
        this.m_stepList.add(step);
        return true;
    }

    public boolean addPage(String pageClassStr, String helpID, String pageTitle, Class[] constructorArgTypes, Object[] constructorArgs) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(pageClassStr);
        }
        catch (Exception e) {
            return false;
        }
        Step step = new Step(clazz, constructorArgTypes, constructorArgs);
        if (ModelUtil.hasLength((String)helpID)) {
            step.setHelpID(helpID);
        }
        if (ModelUtil.hasLength((String)pageTitle)) {
            step.setPageTitle(pageTitle);
        }
        this.m_stepList.add(step);
        return true;
    }

    public boolean runGenericWizard() {
        FSMWizard fsmWiz = new FSMWizard(this.getTraversableSteps(), this.m_data);
        fsmWiz.setWizardTitle(this.m_wizardTitle);
        fsmWiz.setShowStepNumber(this.m_showStepNumber);
        fsmWiz.setWelcomePageAdded(this.m_welcomePageAdded);
        fsmWiz.setFinishPageAdded(this.m_finishPageAdded);
        Image wizardImg = this.getWizardImage();
        if (wizardImg != null) {
            fsmWiz.updateImage(wizardImg);
        }
        if (ModelUtil.hasLength((String)this.getWizardTitle())) {
            this.m_data.put(WIZARD_NAME_KEY, (Object)this.getWizardTitle());
        }
        if (this.m_listeners != null) {
            CommitListener[] cListeners = (CommitListener[])this.m_listeners.getListeners(CommitListener.class);
            for (int i = 0; i < cListeners.length; ++i) {
                fsmWiz.addCommitListener(cListeners[i]);
            }
        }
        WizardDialog wd = fsmWiz.getDialog((Frame)Ide.getMainWindow());
        return WizardLauncher.runDialog((JDialog)wd);
    }

    public boolean getShowStepNumber() {
        return this.m_showStepNumber;
    }

    public void setShowStepNumber(boolean showStepNumber) {
        this.m_showStepNumber = showStepNumber;
    }

    public void addCommitListener(CommitListener commitListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new EventListenerList();
        }
        this.m_listeners.add(CommitListener.class, commitListener);
    }

    public void removeCommitListener(CommitListener commitListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(CommitListener.class, commitListener);
        }
    }

    public boolean doEidtAction() {
        this.initBeforeEdit();
        Navigable[] navs = this.getNavigablePages();
        if (navs == null || navs.length == 0) {
            return false;
        }
        TabbedPanel panel = new TabbedPanel(navs);
        TDialogLauncher launcher = new TDialogLauncher(this.getParentComponent(), this.getWizardTitle(), (Traversable)panel, this.m_data);
        launcher.setInitialSize(480, 400);
        return launcher.showDialog();
    }

    protected final Step[] getTraversableSteps() {
        if (!this.m_finishPageAdded) {
            this.addFinishPage(null);
        }
        return this.m_stepList.toArray(new Step[this.m_stepList.size()]);
    }

    protected Navigable[] getNavigablePages() {
        return null;
    }

    protected void initBeforeEdit() {
    }

    protected Component getParentComponent() {
        return Ide.getMainWindow();
    }

    protected Image getWizardImage() {
        return null;
    }

    private void addWelcomeStep(Step step, String helpId) {
        if (ModelUtil.hasLength((String)helpId)) {
            step.setHelpID(helpId);
        }
        this.m_stepList.add(0, step);
        this.m_welcomePageAdded = true;
    }

    private void addFinishStep(Step step, String helpId) {
        if (ModelUtil.hasLength((String)helpId)) {
            step.setHelpID(helpId);
        }
        this.m_stepList.add(step);
        this.m_finishPageAdded = true;
    }
}

