/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bam.connection.test;

import com.collaxa.cube.engine.sensor.sa.publisher.bam.BAMServerConnection;
import java.io.InputStream;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.bam.connection.BAMConnection;
import oracle.tip.tools.ide.pm.modules.bam.connection.test.Executable;
import oracle.tip.tools.ide.pm.modules.bam.connection.test.ExecutionResult;
import oracle.tip.tools.ide.pm.modules.bam.connection.test.FailureExecutionResult;
import oracle.tip.tools.ide.pm.modules.bam.connection.test.SuccessExecutionResult;
import oracle.tip.tools.ide.pm.modules.bam.connection.test.ValidateConnection;

public class ValidateBAMConnection
extends ValidateConnection
implements Executable {
    private static final String BAM_NAME = "Validate BAM Server Connection";
    protected String mDomainName;
    protected boolean mIsSecure = false;

    @Override
    public String getName() {
        return BAM_NAME;
    }

    public ValidateBAMConnection(String hostName, String port, String domainName, String userName, String password, boolean isSecure) {
        super(hostName, port, userName, password);
        this.mDomainName = domainName;
        this.mIsSecure = isSecure;
    }

    @Override
    public ExecutionResult execute() {
        boolean bool = false;
        ExecutionResult er = new FailureExecutionResult(BPELStringTranslator.getString("DLG_ERR_BAM_CONN_TEST_USER_PASS"));
        try {
            bool = this.validateBAMConnection(this.mHostname, this.mPort, this.mDomainName, this.mUsername, this.mPassword, this.mIsSecure);
            er = bool ? new SuccessExecutionResult(BPELStringTranslator.getString("DLG_MSG_BAM_CONN_TEST_USER_PASS")) : new FailureExecutionResult(BPELStringTranslator.getString("DLG_ERR_BAM_CONN_TEST_USER_PASS"));
        }
        catch (Exception ex) {
            er = new FailureExecutionResult(ex.getMessage());
            ex.printStackTrace();
        }
        er.setMessageTranslator(this.mTranslator);
        return er;
    }

    private boolean validateBAMConnection(String hostName, String port, String domainName, String userName, String password, boolean mIsSecure) throws Exception {
        BAMServerConnection serverConnection = null;
        try {
            serverConnection = new BAMServerConnection(this.mHostname, this.mPort, mIsSecure);
            serverConnection.setCredentials(this.mUsername, this.mPassword, this.mDomainName);
            serverConnection.testConnection();
            InputStream in = serverConnection.getInputStream(BAMConnection.BAM_DIR + "inspection.wsil");
            return in != null;
        }
        catch (Exception ex) {
            if (ex.getMessage().indexOf("Authentication Failed for") > 0) {
                throw new Exception(BPELStringTranslator.formatString("DLG_ERR_BAM_CONN_USER", this.mUsername));
            }
            if (ex.getMessage().indexOf("Server is not set up correctly") > 0) {
                throw new Exception(BPELStringTranslator.formatString("DLG_ERR_BAM_CONN_SETUP", this.mHostname));
            }
            if (ex.getMessage().indexOf("Port out of range") > 0) {
                throw new Exception(BPELStringTranslator.formatString("DLG_ERR_BAM_CONN_PORT", this.mPort));
            }
            if (ex.getMessage().indexOf("host name not found in DNS") > 0) {
                throw new Exception(BPELStringTranslator.formatString("DLG_ERR_BAM_CONN_DNS", this.mHostname));
            }
            if (ex.getMessage().indexOf("URL is invalid") > 0) {
                throw new Exception(BPELStringTranslator.formatString("DLG_ERR_BAM_CONN_URL", "http://" + this.mHostname + ":" + this.mPort + BAMConnection.BAM_DIR + "inspection.wsil"));
            }
            throw ex;
        }
    }
}

