/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bam.connection.test;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.SwingPropertyChangeSupport;
import oracle.tip.tools.ide.pm.modules.bam.connection.test.DefaultExecutionResult;
import oracle.tip.tools.ide.pm.modules.bam.connection.test.Executable;
import oracle.tip.tools.ide.pm.modules.bam.connection.test.ExecutionResult;
import oracle.tip.tools.ide.pm.modules.bam.connection.test.FailureExecutionResult;
import oracle.tip.tools.ide.pm.modules.bam.connection.test.TestSuite;

public class ConnectionTester {
    protected StringBuffer mFinalMsg;
    protected Map mMap;
    protected TestSuite[] mTestSuiteArray;
    protected final String mHostname;
    protected final String mPort;
    protected final String mDomain;
    protected final String mUsername;
    protected final String mPassword;
    protected String mApplicationServerName;
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    private Object lock = new Object();
    protected boolean moveForward = true;
    public static final String TRACK = "Track Progress";
    protected boolean mIsSecure = false;

    public ConnectionTester(String pHostname, String port, String domain, String pUsername, String password, boolean isSecure) {
        this.mApplicationServerName = null;
        this.mIsSecure = isSecure;
        this.mHostname = pHostname;
        this.mPort = port;
        this.mDomain = domain;
        this.mUsername = pUsername;
        this.mPassword = password;
        this.mTestSuiteArray = this.initTestSuites();
        this.initMap();
    }

    public ConnectionTester(String pApplicationServerName, String pHostname, String port, String pUsername, String password) {
        this(pApplicationServerName, pHostname, port, null, pUsername, password);
    }

    public ConnectionTester(String pApplicationServerName, String pHostname, String port, String domain, String pUsername, String password) {
        this.mApplicationServerName = pApplicationServerName;
        this.mHostname = pHostname;
        this.mPort = port;
        this.mDomain = domain;
        this.mUsername = pUsername;
        this.mPassword = password;
        this.mTestSuiteArray = this.initTestSuites();
        this.initMap();
    }

    public void stop() {
        this.moveForward = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener pListener) {
        this.pcs.addPropertyChangeListener(pListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener pListener) {
        this.pcs.removePropertyChangeListener(pListener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener pListener) {
        this.pcs.addPropertyChangeListener(property, pListener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener pListener) {
        this.pcs.removePropertyChangeListener(property, pListener);
    }

    protected void firePropertyChange(int pDone, int pRemaining) {
        this.pcs.firePropertyChange(TRACK, pDone, pRemaining);
    }

    public boolean isSuccess() {
        Set lSet = this.mMap.keySet();
        Iterator iter = lSet.iterator();
        while (iter.hasNext()) {
            ExecutionResult er = (ExecutionResult)this.mMap.get(iter.next());
            if (er.isExecutionSuccess()) continue;
            return false;
        }
        return true;
    }

    public String getFinalMessage() {
        return this.mFinalMsg.toString();
    }

    protected TestSuite[] initTestSuites() {
        return new TestSuite[0];
    }

    protected void initMap() {
        this.mMap = new LinkedHashMap();
        for (int i = 0; i < this.mTestSuiteArray.length; ++i) {
            Executable[] execArray = this.mTestSuiteArray[i].getExecutables();
            for (int j = 0; j < execArray.length; ++j) {
                this.mMap.put(execArray[j], new DefaultExecutionResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map execute() {
        int executed = 0;
        ExecutionResult er = null;
        this.mFinalMsg = new StringBuffer();
        block7: for (int i = 0; i < this.mTestSuiteArray.length && this.moveForward; ++i) {
            Executable[] execArray = this.mTestSuiteArray[i].getExecutables();
            for (int j = 0; j < execArray.length && this.moveForward; ++j) {
                try {
                    ++executed;
                    er = execArray[j].execute();
                    this.mMap.put(execArray[j], er);
                    continue;
                }
                catch (Exception ex) {
                    er = new FailureExecutionResult(ex);
                    ex.printStackTrace();
                    continue;
                }
                catch (Throwable t) {
                    Exception ex = new Exception(t.getMessage());
                    er = new FailureExecutionResult(ex);
                    ex.printStackTrace();
                    continue;
                }
                finally {
                    if (!er.isExecutionSuccess()) {
                        executed += execArray.length - j - 1;
                        this.mFinalMsg.append(this.mTestSuiteArray[i].getMessage(false));
                        this.mFinalMsg.append("\n");
                        continue block7;
                    }
                    if (j == execArray.length - 1) {
                        this.mFinalMsg.append(this.mTestSuiteArray[i].getMessage(true));
                        this.mFinalMsg.append("\n");
                    }
                    this.firePropertyChange(executed, this.mMap.size() - executed);
                }
            }
        }
        return this.mMap;
    }

    public static void main(String[] argv) {
        String lHostname = "localhost";
        String lPort = "8888";
        String lUsername = "admin";
        String lPassword = "welcome";
        ConnectionTester ct = new ConnectionTester(null, lHostname, lPort, lUsername, lPassword);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pEvent) {
                int lCompleted = (Integer)pEvent.getOldValue();
                int lRemaining = (Integer)pEvent.getNewValue();
                int lTotal = lCompleted + lRemaining;
                System.out.println("% complete:   " + 100 * lCompleted / lTotal);
            }
        };
        ct.addPropertyChangeListener(pcl);
        Map lMap = ct.execute();
        Set lKeySet = lMap.keySet();
        for (Executable e : lKeySet) {
            ExecutionResult er = (ExecutionResult)lMap.get(e);
            System.out.println(e.getName() + ": " + er.isExecutionSuccess() + ": " + er.getMessage());
        }
    }
}

