/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bam.connection;

import com.collaxa.cube.engine.sensor.sa.publisher.bam.BAMServerConnection;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import oracle.tip.tools.ide.common.encryption.EncryptionException;
import oracle.tip.tools.ide.common.encryption.EncryptionHandler;
import oracle.tip.tools.ide.common.encryption.StringEncrypter;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.utils.URLFetcher;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class BAMConnection
implements Cloneable,
EncryptionHandler,
URLFetcher {
    private String m_username;
    private String m_password;
    private String m_hostname;
    private String m_port;
    private String m_domain;
    private String m_connName;
    private String m_protocol;
    public static String BAM_DIR = "/OracleBAMWS/WebServices/Wsil/DataObjects/";
    BAMServerConnection m_serverConnection = null;

    public Object clone() {
        BAMConnection lConnection = new BAMConnection();
        lConnection.setHostName(this.m_hostname);
        lConnection.setPassword(this.m_password);
        lConnection.setPort(this.m_port);
        lConnection.setUserName(this.m_username);
        lConnection.setDomain(this.m_domain);
        lConnection.setProtocol(this.getProtocol());
        return lConnection;
    }

    public BAMConnection() {
    }

    public BAMConnection(String hostName, String port, String domainName, String user, String pass, String connName, boolean useSSL) {
        this.m_hostname = hostName;
        this.m_domain = domainName;
        this.m_port = port;
        this.m_username = user;
        this.m_password = pass;
        this.m_connName = connName;
        this.m_protocol = useSSL ? "https" : "http";
    }

    public String getDomain() {
        return this.m_domain;
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public boolean isSecure() {
        if (this.m_protocol != null) {
            return this.m_protocol.equals("https");
        }
        return false;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public void useSSL(boolean flag) {
        this.m_protocol = flag ? "https" : "http";
    }

    public String getUserName() {
        return this.m_username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getHostName() {
        return this.m_hostname;
    }

    public String getPort() {
        return this.m_port;
    }

    public String getConnName() {
        return this.m_connName;
    }

    public void setConnName(String connName) {
        this.m_connName = connName;
    }

    public void setUserName(String username) {
        this.m_username = username;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void setHostName(String hostname) {
        this.m_hostname = hostname;
    }

    public void setProtocol(String protocol) {
        this.m_protocol = protocol;
    }

    public void setPort(String port) {
        this.m_port = port;
    }

    public void encrypt(StringEncrypter pEncrypter) throws EncryptionException {
        this.m_password = pEncrypter.encrypt(this.m_password);
    }

    public void decrypt(StringEncrypter pEncrypter) throws EncryptionException {
        this.m_password = pEncrypter.decrypt(this.m_password);
    }

    public InputStream getURL(URL url) {
        String urlStr = url.getPath();
        try {
            if (this.m_serverConnection == null) {
                this.m_serverConnection = new BAMServerConnection(this.m_hostname, this.m_port, this.isSecure());
                this.m_serverConnection.setCredentials(this.m_username, this.m_password, this.m_domain);
                this.m_serverConnection.testConnection();
            }
            return this.m_serverConnection.getInputStream(urlStr);
        }
        catch (Exception ex) {
            String msg = "";
            msg = ex.getMessage().indexOf("Authentication Failed for") > 0 ? BPELStringTranslator.formatString("DLG_ERR_BAM_CONN_USER", this.m_username) : (ex.getMessage().indexOf("Server is not set up correctly") > 0 ? BPELStringTranslator.formatString("DLG_ERR_BAM_CONN_SETUP", this.m_hostname) : (ex.getMessage().indexOf("Port out of range") > 0 ? BPELStringTranslator.formatString("DLG_ERR_BAM_CONN_PORT", this.m_port) : (ex.getMessage().indexOf("host name not found in DNS") > 0 ? BPELStringTranslator.formatString("DLG_ERR_BAM_CONN_DNS", this.m_hostname) : (ex.getMessage().indexOf("URL is invalid") > 0 ? BPELStringTranslator.formatString("DLG_ERR_BAM_CONN_URL", this.m_protocol + "://" + this.m_hostname + ":" + this.m_port + url.toString()) : ex.getMessage()))));
            MultiLineOptionPane.showMessageDialog(null, (Object)msg, (String)BPELStringTranslator.getString("XXERROR"), (int)0);
            ex.printStackTrace();
            return null;
        }
    }

    private String getURLPrefix(URL url) {
        return url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
    }

    public URL getURL(URL url, String location) {
        String urlStr = this.getURLPrefix(url) + BAM_DIR + location;
        URL returnUrl = null;
        try {
            returnUrl = new URL(location);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (returnUrl == null) {
            try {
                returnUrl = new URL(urlStr);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        return url;
    }

    public static String getDOName(URL url) {
        String urlStr = null;
        try {
            urlStr = URLDecoder.decode(url.toString(), "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            urlStr = url.toString();
        }
        int index = urlStr.lastIndexOf(BAM_DIR);
        int index2 = urlStr.lastIndexOf(".");
        return urlStr.substring((index += BAM_DIR.length()) - 1, index2);
    }

    public String getName(URL url) {
        return BAMConnection.getDOName(url);
    }
}

