/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bam;

import com.collaxa.cube.engine.sensor.sa.publisher.bam.DataObjectKeys;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import oracle.bali.xml.gui.jdev.StandardXmlVisualEditor;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.bam.common.connection.BAMConnection;
import oracle.tip.tools.ide.bam.common.connection.BAMConnectionLookup;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.SchemaResolvedObj;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.sensor.IActivityConfig;
import oracle.tip.tools.ide.common.bpelparser.sensor.IActivityVariableConfig;
import oracle.tip.tools.ide.common.bpelparser.sensor.ISensor;
import oracle.tip.tools.ide.common.bpelparser.sensor.ISensorAction;
import oracle.tip.tools.ide.common.bpelparser.sensor.SensorActionPublishTypeEnum;
import oracle.tip.tools.ide.common.bpelparser.sensor.impl.BAMSensorAction;
import oracle.tip.tools.ide.common.bpelparser.sensor.impl.SensorActionImpl;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.PopupListener;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorer;
import oracle.tip.tools.ide.common.utils.ContentUtil;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.FileUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.utils.UIUtil;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.URLFetcher;
import oracle.tip.tools.ide.common.utils.WSDLImport;
import oracle.tip.tools.ide.common.utils.WSDLPartData;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.view.JDevBPELEditor;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.bam.BAMBatchParamDialog;
import oracle.tip.tools.ide.pm.modules.bam.BAMDOChooser;
import oracle.tip.tools.ide.pm.modules.bam.BAMDOChooserPopupListener;
import oracle.tip.tools.ide.pm.modules.bam.BAMDODataSource;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.tip.tools.ide.tx.addin.MapperCreator;
import oracle.tip.tools.ide.tx.addin.MapperSource;
import oracle.tip.tools.ide.tx.addin.MapperTarget;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;

public class BAMSensorActionDialog
extends BPELBaseDialog
implements ActionListener {
    static final String INSERT = "Insert";
    static final String UPDATE = "Update";
    static final String DELETE = "Delete";
    static final String UPSERT = "Upsert";
    static final boolean SELECT_ALL = false;
    static final boolean REMOVE_ALL = true;
    static final String s_sensorText = BPELStringTranslator.getString("DLG_INST_BAM_SENSOR_COMBO");
    static final String s_sensorNotFoundText = BPELStringTranslator.getString("DLG_ERR_NO_SENSOR_FOUND");
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected JButton m_browseDO;
    protected JButton m_browseXSL;
    protected JButton m_browseMapper;
    protected JButton m_editBtn;
    protected JButton m_batchButton;
    protected JButton m_btnSelectOne;
    protected JButton m_btnSelectAll;
    protected JButton m_btnRemoveOne;
    protected JButton m_btnRemoveAll;
    protected JList m_inputList;
    protected JList m_selectedList;
    protected JComboBox m_opCombo;
    protected JComboBox m_sensorCombo;
    protected JTextField m_nameField;
    protected JTextField m_doField;
    protected JTextField m_mapField;
    protected JTextField m_filterField;
    protected JTextField m_jndiField;
    protected JFrame m_frame;
    protected JCheckBox m_enableCheckBox;
    protected JCheckBox m_batchCheckBox;
    protected JLabel m_opInst;
    protected BPELXmlModel m_model;
    protected Variable m_var;
    protected String m_mapperRelative;
    protected ISensorAction m_sensorAction = null;
    protected URL m_doURL = null;
    protected Properties m_properties;
    protected Properties m_sensorProperties;
    protected String m_elementName;
    protected String m_elementNamespace;
    protected URL m_bamLocalURL;
    protected Vector m_doKeys;
    protected boolean m_bEditing = false;
    protected boolean m_batchDefault = true;
    protected int m_batchLowerLimit;
    protected int m_batchUpperLimit;
    protected int m_batchTimeout;
    protected boolean m_batchStatus;
    protected int m_retVal = 1;
    protected Context m_context = null;
    protected URL m_prjDirURL;
    protected URL m_graphURL;
    protected URLFetcher m_urlFetcher;
    protected ISensor m_lastSensor = null;
    protected XMLDocument m_doc = null;
    protected URIForNamespaceCache m_URIForNamespaceCache;
    protected List<ISensor> m_sensors;
    private Comparator<URI> URIComparator = new Comparator<URI>(){

        @Override
        public int compare(URI first, URI second) {
            String firstExtension = this.getExtension(first);
            String secondExtension = this.getExtension(second);
            if (firstExtension != null) {
                if (secondExtension != null) {
                    int extCompareTo = secondExtension.compareTo(firstExtension);
                    if (extCompareTo == 0) {
                        int firstdotIndex = first.toString().lastIndexOf(46);
                        String firsturiNoExt = first.toString().substring(0, firstdotIndex);
                        int seconddotIndex = second.toString().lastIndexOf(46);
                        String seconduriNoExt = second.toString().substring(0, seconddotIndex);
                        return firsturiNoExt.compareTo(seconduriNoExt);
                    }
                    return extCompareTo;
                }
                return 1;
            }
            if (secondExtension != null) {
                return -1;
            }
            return 0;
        }

        private String getExtension(URI uri) {
            int lastIndex = uri.toString().lastIndexOf(46);
            return uri.toString().substring(lastIndex + 1);
        }
    };
    private static final String s_varNSStr = "xmlns:sensor=\"http://xmlns.oracle.com/bpel/sensorDataPlaceHolder\"";
    private static final String s_varNSStrNew = "xmlns:sensor=\"\\$namespace\"";
    private static final String s_varImport = "<!-- \\$importSensorVar -->";
    private static final String s_varImportNew = "<xsd:import namespace=\"\\$namespace\" schemaLocation=\"\\$url\"/>";
    private static final String s_varAnyType1 = "<xsd:element name=\"data\" type=\"xsd:anyType\" minOccurs=\"0\"/> <!-- DO NOT MODIFY: fault data type -->";
    private static final String s_varAnyType2 = "<xsd:element name=\"data\" type=\"xsd:anyType\"/> <!-- DO NOT MODIFY: sensor variable data type -->";
    private static final String s_varAnyTypeNew = "<xsd:element name=\"data\">\n  <xsd:complexType>\n    <xsd:sequence>\n      <xsd:element ref=\"sensor:\\$element\" minOccurs=\"0\"/>\n    </xsd:sequence>\n  </xsd:complexType>\n</xsd:element>\n";

    public BAMSensorActionDialog(JFrame f, BPELXmlModel model, List<ISensor> sensors) {
        super(f, BPELStringTranslator.getString("EDITOR_SENS_ACT_DLG"), true);
        this.m_sensors = sensors;
        this.m_model = model;
        this.initCaches();
        this.m_frame = f;
        UIUtil.enableCloseOnEscapeKey((JDialog)((Object)this));
        this.m_context = EditorManager.getEditorManager().getCurrentEditor().getContext();
        if (this.m_context.getProject() != null) {
            this.m_prjDirURL = this.m_model.getBPELProject().getBPELDirectoryURL();
            Editor t = EditorManager.getEditorManager().getCurrentEditor();
            if (!(t instanceof StandardXmlVisualEditor)) {
                return;
            }
            Component c = t.getGUI();
            if (!(c instanceof JDevBPELEditor)) {
                return;
            }
            JDevBPELEditor editor = (JDevBPELEditor)c;
            this.m_graphURL = editor.getGraphURL();
        }
        this.createControls();
    }

    public void setSensorAction(ISensorAction action) {
        this.m_sensorAction = action;
        this.parseSensorAction();
    }

    public ISensorAction getSensorAction() {
        return this.m_sensorAction;
    }

    public static List<BAMConnection> getBAMConnections() {
        try {
            return new BAMConnectionLookup().getAppResConnections();
        }
        catch (Exception ex) {
            GraphUtils.displayMessage(null, (String)ex.getMessage(), (int)0);
            return new ArrayList<BAMConnection>(0);
        }
    }

    public int create() {
        this.m_bEditing = false;
        this.setTitle(BPELStringTranslator.getString("EDITOR_SENS_ACT_DLG_CREATE"));
        BAMSensorAction action = new BAMSensorAction();
        try {
            action.setName(BPELModelUtil.generateUniqueName((Process)this.m_model.getProcess(), (String)"SensorAction", ISensorAction.class));
            this.setSensorAction((ISensorAction)action);
            this.m_nameField.setText(this.m_sensorAction.getName());
            this.m_jndiField.setText("eis/bam/rmi");
            String mapFile = FileUtils.generateUniqFilename((String)(this.m_prjDirURL.getFile() + File.separator + "bam"), (String)(this.m_sensorAction.getName() + ".xsl"));
            this.m_mapperRelative = "bam" + File.separator + mapFile;
            this.m_mapField.setText(this.m_mapperRelative);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.getContentPane(), "bpmjdev_create_bamsensor_action");
        return this.display((ISensorAction)action);
    }

    public int edit(ISensorAction action) {
        this.m_bEditing = true;
        this.setSensorAction(action);
        this.setTitle(BPELStringTranslator.getString("EDITOR_SENS_ACT_DLG_EDIT") + action.getName());
        this.m_mapField.setText(this.m_mapperRelative);
        this.m_nameField.setEnabled(true);
        this.m_enableCheckBox.setSelected(action.isEnabled());
        this.m_filterField.setText(action.getFilter());
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.getContentPane(), "bpmjdev_create_bamsensor_action");
        return this.display(action);
    }

    private int display(ISensorAction action) {
        Vector<ISensor> sensors = this.getSensors();
        if (sensors.size() == 0) {
            GraphUtils.displayMessage((Component)((Object)this), (String)s_sensorNotFoundText, (int)2);
        } else {
            UIHelper.setComboBox(new DefaultComboBoxModel<ISensor>(sensors), (JComboBox)this.m_sensorCombo);
            this.setSensorAction(action);
        }
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createControls() {
        this.init();
        JPanel btnPnl = this.createButtonPanel();
        JPanel opPnl = this.createOpPanel();
        JPanel namePnl = this.createNamePanel();
        JPanel mapperPnl = this.createMapperPanel();
        JPanel jndiPnl = this.createJndiPanel();
        JPanel filterPanel = this.createFilterPanel();
        JPanel batchPanel = this.createBatchPanel();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)container, (Component)namePnl, (int)0, (int)row++, (int)4, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)opPnl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)mapperPnl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)filterPanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)jndiPnl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)batchPanel, (int)0, (int)row++, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)new JPanel(), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)container, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)btnPnl, (int)1, (int)row, (int)1, (int)1, (int)14, (int)0, (Insets)new Insets(10, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    public boolean validateSensorAction() {
        return true;
    }

    private boolean validateJndi() {
        String jndi = this.m_jndiField.getText();
        if (jndi.length() == 0 || jndi.indexOf(34) != -1) {
            GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("DLG_ERR_BAD_JNDI", "Invald JNDI"), (int)0);
            return false;
        }
        return true;
    }

    private boolean continueOnBadMapperFile() {
        int okCancel = MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)"The mapper file is not compatible with the sensor variable and BAM data object. Do you want to contine?", (String)BPELStringTranslator.getString("WARNING"), (int)2, (int)2, null);
        return okCancel == 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        URL mapperURL = null;
        if (src == this.m_okBtn || src == this.m_editBtn || src == this.m_browseMapper || src == this.m_sensorCombo) {
            if (!this.validateSensorAction() || !this.validateJndi()) {
                return;
            }
            try {
                mapperURL = new URL(this.m_prjDirURL, this.m_mapField.getText());
            }
            catch (MalformedURLException ex) {
                MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)"Invalid mapper file name");
                return;
            }
        }
        if (src == this.m_okBtn) {
            this.m_var = this.getSensorVar((ISensor)this.m_sensorCombo.getSelectedItem());
            if (URLFileSystem.exists((URL)mapperURL)) {
                if (this.isMapperCompatible(mapperURL) || this.continueOnBadMapperFile()) {
                    this.saveChanges();
                    this.dispose();
                }
            } else {
                this.startMapper();
            }
        } else if (src == this.m_browseMapper) {
            this.m_var = this.getSensorVar((ISensor)this.m_sensorCombo.getSelectedItem());
            if (URLFileSystem.exists((URL)mapperURL)) {
                int okCancel = MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)BPELStringTranslator.getString("DLG_WARN_MAPPER_FILE_EXIST"), (String)BPELStringTranslator.getString("WARNING"), (int)2, (int)2, null);
                if (okCancel == 0) {
                    this.startMapper();
                }
            } else {
                this.startMapper();
            }
        } else if (src == this.m_editBtn) {
            this.m_var = this.getSensorVar((ISensor)this.m_sensorCombo.getSelectedItem());
            if (URLFileSystem.exists((URL)mapperURL)) {
                if (this.isMapperCompatible(mapperURL) || this.continueOnBadMapperFile()) {
                    this.saveChanges();
                    this.editMapperFile();
                }
            } else {
                this.startMapper();
            }
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        } else if (src == this.m_browseDO) {
            this.handleBrowseWSDL();
        } else if (src == this.m_browseXSL) {
            URLChooser chooser = DialogUtil.newURLChooser();
            chooser.setSelectionScope(0);
            chooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(BPELStringTranslator.getString("EDITOR_TRFM_XSFLFIE"), new String[]{".xsl", ".xslt"}));
            int ret = chooser.showOpenDialog((Component)((Object)this));
            if (ret == 0) {
                URL url = chooser.getSelectedURL();
                this.m_mapField.setText("bam" + File.separator + URLFileSystem.getFileName((URL)url));
            }
        } else if (src == this.m_btnSelectOne) {
            this.moveSelectedValues(this.m_inputList, this.m_selectedList);
        } else if (src == this.m_btnSelectAll) {
            this.moveAllValues(false);
        } else if (src == this.m_btnRemoveOne) {
            this.moveSelectedValues(this.m_selectedList, this.m_inputList);
        } else if (src == this.m_btnRemoveAll) {
            this.moveAllValues(true);
        } else if (src == this.m_batchCheckBox) {
            this.m_batchStatus = this.m_batchCheckBox.isSelected();
            this.m_batchButton.setEnabled(this.m_batchCheckBox.isSelected());
        } else if (src == this.m_batchButton) {
            this.getBatchParams();
        } else if (src == this.m_sensorCombo) {
            ISensor curSensor = (ISensor)this.m_sensorCombo.getSelectedItem();
            if (curSensor == this.m_lastSensor) {
                return;
            }
            Variable var = this.getSensorVar(curSensor);
            try {
                MapperInfo mapperInfo = this.getMapperInfo(var, mapperURL);
                if (mapperInfo.m_srcURL != null && mapperInfo.m_srcURL.toString().endsWith(".wsdl")) {
                    MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)BPELStringTranslator.getString("DLG_ERR_VAR_WSDL_NOT_SUPPORTED"), (String)BPELStringTranslator.getString("XXERROR"), (int)0);
                    this.m_sensorCombo.setSelectedItem(this.m_lastSensor);
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.updateButtons(true);
            this.m_lastSensor = curSensor;
        }
        this.enableDisableControls();
    }

    protected void helpInvoked() {
        oracle.tip.tools.ide.pm.modules.help.HelpSystem.showHelp("bpmjdev_create_bamsensor_action");
    }

    private void getBatchParams() {
        BAMBatchParamDialog dlg = new BAMBatchParamDialog(this.m_frame, this.m_batchLowerLimit, this.m_batchUpperLimit, this.m_batchTimeout, this.m_batchDefault);
        if (dlg.display() == 1) {
            this.m_batchLowerLimit = dlg.getLowerLimit();
            this.m_batchUpperLimit = dlg.getUpperLimit();
            this.m_batchTimeout = dlg.getTimeout();
            this.m_batchDefault = dlg.isDefault();
        }
    }

    private void parseSensorAction() {
        Properties properties = this.m_sensorAction.getProperties();
        this.m_doc = this.transformJCAFile();
        String bamOp = "";
        String doName = "";
        String inBatch = "";
        String host = "";
        String keys = "";
        String jndi = "eis/bam/rmi";
        if (properties != null && this.m_doc != null) {
            try {
                bamOp = this.getNodeValue("OperationType");
                doName = this.getNodeValue("DataObjectName");
                inBatch = this.getNodeValue("InBatch");
                host = this.getNodeValue("HostName");
                keys = this.getNodeValue("Keys");
                jndi = this.getJndi();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bamOp != null && !bamOp.equals("")) {
                this.m_opCombo.setSelectedItem(bamOp);
            }
            this.m_mapperRelative = (String)properties.get("bamTransform");
            this.m_doField.setText(doName);
            this.m_browseDO.setEnabled(true);
            this.m_jndiField.setText(jndi);
            FileInputStream doIn = null;
            try {
                int port = 8888;
                String protocol = "http";
                this.m_doURL = new URL(protocol + "://" + host + ":" + port + "/OracleBAMWS/WebServices/Wsil/DataObjects/" + doName.substring(1) + ".wsdl");
                File file = new File(this.m_prjDirURL.getFile(), "bam/" + doName + ".wsdl");
                this.m_bamLocalURL = file.toURI().toURL();
                doIn = new FileInputStream(file);
                DataObjectKeys doKeys = new DataObjectKeys((InputStream)doIn);
                this.m_doKeys = doKeys.parseKeys();
                this.m_elementName = doKeys.getDataObjectSchemaRootName();
                this.m_elementNamespace = doKeys.getDataObjectNamespace();
            }
            catch (Exception e) {
                this.m_doURL = null;
                this.m_bamLocalURL = null;
                this.m_doKeys = null;
                e.printStackTrace();
            }
            String doKeysStr = (String)properties.get("bamDataObjectKey");
            if (doKeysStr == null || doKeysStr.length() == 0) {
                doKeysStr = keys;
            }
            DefaultListModel selectedModel = this.getSelectedModel(doKeysStr);
            this.m_selectedList.setModel(selectedModel);
            this.m_inputList.setModel(this.getInputModel(this.m_doKeys, selectedModel));
            if (inBatch != null) {
                this.m_batchCheckBox.setSelected(inBatch.equals("true"));
            }
            this.enableDisableControls();
        }
        this.m_nameField.setText(this.m_sensorAction.getName());
        if (this.m_bEditing) {
            ISensor sensor = this.getSensor();
            this.m_sensorCombo.setSelectedItem(sensor);
            this.updateButtons(true);
        }
    }

    private DefaultListModel getSelectedModel(String str) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        if (str == null || str.length() == 0) {
            return model;
        }
        int prevIndex = 0;
        int i = 0;
        while (true) {
            int index;
            if ((index = str.indexOf(",", prevIndex)) < 0) break;
            model.add(i++, str.substring(prevIndex, index));
            prevIndex = index + 1;
        }
        model.add(i, str.substring(prevIndex));
        return model;
    }

    private void init() {
        this.setSize(500, 700);
        this.setLocationRelativeTo(this.getParent());
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("BAM_OK_BUTTON"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("BAM_CANCEL_BUTTON"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        this.m_browseDO = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("TOOLTIP_BROWSE_DO"));
        this.m_browseDO.addActionListener(this);
        this.m_browseXSL = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("EDITOR_TRFM_BWS_MAPPING"));
        this.m_browseXSL.addActionListener(this);
        this.m_browseMapper = UIHelper.createModelerButton((Icon)ImageCache.getIcon("add16"));
        this.m_browseMapper.setToolTipText(BPELStringTranslator.getString("EDITOR_TRFM_CRT_MAPPING"));
        this.m_browseMapper.addActionListener(this);
        this.m_editBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("edit16"));
        this.m_editBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_TRFM_EDT_MAPPING"));
        this.m_editBtn.addActionListener(this);
        this.m_sensorCombo = new JComboBox();
        this.m_sensorCombo.addActionListener(this);
        this.m_batchButton = new JButton(BPELStringTranslator.getString("BTN_SET_BATCH_PARAM") + "...");
        this.m_btnSelectOne = new JButton(ImageCache.getIcon("application/bpel/shuttleright.png"));
        this.m_btnSelectAll = new JButton(ImageCache.getIcon("application/bpel/shuttlerightall.png"));
        this.m_btnRemoveOne = new JButton(ImageCache.getIcon("application/bpel/shuttleleft.png"));
        this.m_btnRemoveAll = new JButton(ImageCache.getIcon("application/bpel/shuttleleftall.png"));
        this.m_btnSelectOne.setEnabled(false);
        this.m_btnSelectAll.setEnabled(false);
        this.m_btnRemoveOne.setEnabled(false);
        this.m_btnRemoveAll.setEnabled(false);
        this.m_jndiField = new JTextField();
        this.m_batchCheckBox = new JCheckBox(BPELStringTranslator.getString("CHK_ENABLE_BATCH"));
        this.m_batchCheckBox.setMnemonic(66);
        this.m_enableCheckBox = new JCheckBox(BPELStringTranslator.getString("EDITOR_SENS_ACT_PNL_ENABLE"));
        this.m_enableCheckBox.setMnemonic(69);
        this.m_btnSelectOne.addActionListener(this);
        this.m_btnSelectAll.addActionListener(this);
        this.m_btnRemoveOne.addActionListener(this);
        this.m_btnRemoveAll.addActionListener(this);
        this.m_batchButton.addActionListener(this);
        this.m_batchCheckBox.setSelected(true);
        this.m_enableCheckBox.setSelected(true);
        this.m_inputList = new JList();
        this.m_selectedList = new JList();
        DefaultListModel<String> inputModel = new DefaultListModel<String>();
        inputModel.addElement(BPELStringTranslator.getString("LIST_ITEM_NO_SELECTED_KEYS"));
        inputModel.addElement(" ");
        inputModel.addElement(" ");
        DefaultListModel<String> selectedModel = new DefaultListModel<String>();
        selectedModel.addElement(BPELStringTranslator.getString("LIST_ITEM_NO_AVAILABLE_KEYS"));
        selectedModel.addElement(" ");
        selectedModel.addElement(" ");
        this.m_selectedList.setModel(selectedModel);
        this.m_inputList.setModel(inputModel);
        this.m_inputList.addMouseListener(new ActionMouseListener(true));
        this.m_selectedList.addMouseListener(new ActionMouseListener(false));
        String[] opComboItems = new String[]{INSERT, UPDATE, DELETE, UPSERT};
        this.m_opCombo = new JComboBox<String>(opComboItems);
        this.m_opCombo.setSelectedItem(UPSERT);
        this.m_opCombo.setEnabled(false);
        this.m_opCombo.addActionListener(this);
        this.m_doField = new JTextField();
        this.m_doField.setEnabled(false);
        this.m_nameField = new JTextField();
        this.m_mapField = new JTextField();
        this.m_filterField = new JTextField();
        this.m_properties = new Properties();
        this.m_sensorProperties = new Properties();
        this.resetBatchParams();
        this.m_opInst = new JLabel("");
        this.m_opInst.setForeground(Color.blue);
        this.updateButtons(false);
    }

    private void resetBatchParams() {
        this.m_batchLowerLimit = 1000;
        this.m_batchUpperLimit = 5000;
        this.m_batchTimeout = 50;
        this.m_batchStatus = false;
    }

    private JPanel createButtonPanel() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        return btnPnl;
    }

    private JPanel createOpPanel() {
        JPanel opPnl = new JPanel();
        opPnl.setBorder(BorderFactory.createTitledBorder(BPELStringTranslator.getString("BORDER_BAM_OP_KEYS")));
        opPnl.setLayout(new GridBagLayout());
        JPanel selectionPnl = this.createSelectionPanel();
        JLabel opLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)opLabel, (Component)this.m_opCombo, (String)BPELStringTranslator.getString("LBL_OPERATION"));
        GraphUtils.addComponent((Container)opPnl, (Component)opLabel, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)opPnl, (Component)this.m_opCombo, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)opPnl, (Component)this.m_opInst, (int)1, (int)1, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)opPnl, (Component)selectionPnl, (int)0, (int)2, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        return opPnl;
    }

    private JPanel createSelectionPanel() {
        JPanel shuttlePnl = new JPanel(new GridLayout(4, 1, 0, 5));
        shuttlePnl.add(this.m_btnSelectOne);
        shuttlePnl.add(this.m_btnSelectAll);
        shuttlePnl.add(this.m_btnRemoveOne);
        shuttlePnl.add(this.m_btnRemoveAll);
        JPanel container = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)container, (Component)shuttlePnl, (int)0, (int)0, (int)1, (int)1, (int)10, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.5);
        JPanel selectionPanel = new JPanel(new GridBagLayout());
        JPanel inputPanel = this.createScrollPane(this.m_inputList, BPELStringTranslator.getString("LIST_TITLE_AVAILABLE_KEYS"));
        JPanel selectedPanel = this.createScrollPane(this.m_selectedList, BPELStringTranslator.getString("LIST_TITLE_SELECTED_KEYS"));
        Font f = UIManager.getFont("Label.font");
        int fontHeight = GraphUtils.getFontHeight((Font)f);
        GraphUtils.addComponent((Container)selectionPanel, (Component)inputPanel, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)selectionPanel, (Component)container, (int)1, (int)0, (int)1, (int)1, (int)10, (int)3, (Insets)new Insets(fontHeight + 2, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)1.0);
        GraphUtils.addComponent((Container)selectionPanel, (Component)selectedPanel, (int)2, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return selectionPanel;
    }

    private JPanel createScrollPane(JList list, String title) {
        JScrollPane pane = new JScrollPane(list);
        pane.setSize(50, 50);
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)pane, (String)title);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)panel, (Component)label, (int)0, (int)0, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(0, 0, 2, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)pane, (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return panel;
    }

    private JPanel createNamePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel nameLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)nameLbl, (Component)this.m_nameField, (String)BPELStringTranslator.getString("LBL_ACTION_NAME"));
        JLabel sensorInst = new JLabel(s_sensorText);
        JLabel sensorLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)sensorLbl, (Component)this.m_sensorCombo, (String)BPELStringTranslator.getString("LBL_SELECT_SENSOR"));
        JLabel doLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)doLabel, (Component)this.m_doField, (String)BPELStringTranslator.getString("LBL_DO"));
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_browseDO);
        int row = 0;
        GraphUtils.addComponent((Container)panel, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_nameField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_enableCheckBox, (int)2, (int)row++, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)sensorInst, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)sensorLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_sensorCombo, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)new JLabel(BPELStringTranslator.getString("DLG_INST_BAM_DO")), (int)0, (int)row++, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)doLabel, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_doField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_browseDO, (int)2, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        return panel;
    }

    private JPanel createMapperPanel() {
        JPanel panel = new JPanel();
        JLabel mapLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)mapLbl, (Component)this.m_mapField, (String)BPELStringTranslator.getString("LBL_MAP_FILE"));
        panel.setLayout(new GridBagLayout());
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_browseXSL);
        tb.add((Component)this.m_browseMapper);
        tb.add((Component)this.m_editBtn);
        GraphUtils.addComponent((Container)panel, (Component)mapLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_mapField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)tb, (int)2, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)new JLabel(BPELStringTranslator.getString("DLG_INST_BAM_MAP")), (int)0, (int)1, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        return panel;
    }

    private JPanel createJndiPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel jndiLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)jndiLbl, (Component)this.m_jndiField, (String)BPELStringTranslator.getString("LBL_JNDI"));
        GraphUtils.addComponent((Container)panel, (Component)jndiLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_jndiField, (int)1, (int)0, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        return panel;
    }

    private JPanel createFilterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel filterLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)filterLbl, (Component)this.m_filterField, (String)BPELStringTranslator.getString("EDITOR_SENS_ACT_PNL_FILTER"));
        GraphUtils.addComponent((Container)panel, (Component)filterLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_filterField, (int)1, (int)0, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        return panel;
    }

    private JPanel createBatchPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)panel, (Component)this.m_batchCheckBox, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        return panel;
    }

    private void saveChanges() {
        this.m_var = this.getSensorVar((ISensor)this.m_sensorCombo.getSelectedItem());
        this.m_retVal = 0;
        this.m_mapperRelative = this.m_mapField.getText();
        if (this.m_sensorAction == null) {
            this.m_sensorAction = new SensorActionImpl();
        }
        this.m_sensorAction.setName(this.m_nameField.getText());
        this.m_sensorAction.setFilter(this.m_filterField.getText().trim());
        ArrayList<String> sensorNames = new ArrayList<String>();
        ISensor sensor = (ISensor)this.m_sensorCombo.getSelectedItem();
        if (!this.m_bEditing) {
            sensor.addSensorAction(this.m_sensorAction);
        } else {
            ISensor lastSensor = this.getSensor();
            if (lastSensor != null) {
                lastSensor.removeSensorAction(this.m_sensorAction);
            }
            this.setSensor();
            sensor.addSensorAction(this.m_sensorAction);
        }
        sensorNames.add(sensor.getSensorName());
        this.m_sensorAction.setSensorNames(sensorNames);
        this.m_sensorAction.setPublishName("OracleBam");
        try {
            this.m_sensorAction.setSensorActionPublishType(new SensorActionPublishTypeEnum(5));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String bamServer = this.m_doURL.getProtocol() + "://" + this.m_doURL.getHost() + ":" + this.m_doURL.getPort() + "/OracleBAMWS/WebServices/Wsil/DataObjects/" + "DataObject/DataObjectOperations.asmx";
        if (this.m_sensorProperties == null) {
            this.m_sensorProperties = new Properties();
        }
        if (this.m_properties == null) {
            this.m_properties = new Properties();
        }
        this.m_sensorProperties.put("bamServer", bamServer);
        String bamOperation = (String)this.m_opCombo.getSelectedItem();
        this.m_sensorProperties.put("bamOperation", bamOperation);
        while (this.m_mapperRelative.indexOf(92) >= 0) {
            this.m_mapperRelative = this.m_mapperRelative.replace('\\', '/');
        }
        this.m_sensorProperties.put("bamDataObjectKey", this.getKeysString());
        this.m_sensorProperties.put("DataObjectName", this.getDOName(this.m_doURL));
        if (this.m_batchCheckBox.isSelected()) {
            this.m_sensorProperties.put("InBatch", "true");
        } else {
            this.m_sensorProperties.put("InBatch", "false");
        }
        this.m_sensorAction.setEnabled(this.m_enableCheckBox.isSelected());
        this.m_sensorProperties.put("JNDI", this.m_jndiField.getText());
        this.m_properties.put("jcaFileName", "bam/" + this.m_nameField.getText() + ".jcabam");
        this.m_properties.put("bamTransform", this.m_mapperRelative);
        this.saveToJCAFile();
        this.m_sensorAction.setProperties(this.m_properties);
    }

    private String constructJCAFile() {
        BAMConnection conn = (BAMConnection)this.m_urlFetcher;
        boolean isNewJcaFile = conn != null;
        String opType = (String)this.m_opCombo.getSelectedItem();
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("\n");
        sb.append("<adapter-config name=\"BamAdapterService\" xmlns=\"http://platform.integration.oracle/blocks/adapter/fw/metadata\" xmlns:wsdl-ref=\"http://xmlns.oracle.com/bam\">");
        sb.append("\n");
        if (isNewJcaFile) {
            if (conn.getName() != null && conn.getName().length() > 0) {
                sb.append("<connection-factory location=\"" + this.m_sensorProperties.getProperty("JNDI") + "\"" + ">");
                this.m_sensorProperties.put("JNDI", "eis/bam/rmi");
                this.m_sensorProperties.put("InstanceName", conn.getName());
                sb.append("\n");
                this.m_sensorProperties.put("HostName", conn.getBAMServerHost());
                this.m_sensorProperties.put("PortNumber", conn.getBAMServerPort());
                this.m_sensorProperties.put("UserName", conn.getUser());
                this.m_sensorProperties.put("Password", conn.getPassword());
                sb.append("</connection-factory>");
                sb.append("\n");
                sb.append("<endpoint-interaction operation=\"writetoBAM\">");
                sb.append("\n");
                sb.append("<interaction-spec className=\"oracle.bam.adapter.adc.ADCInteractionSpec\">");
                sb.append("\n");
                sb.append("<property name=\"DataObjectName\" value=\"" + this.getDOName(this.m_doURL) + "\"" + "/>");
                sb.append("\n");
                sb.append("<property name=\"InBatch\" value=\"" + (String)this.m_sensorProperties.get("InBatch") + "\"" + "/>");
                sb.append("\n");
                sb.append("<property name=\"OperationType\" value=\"" + opType + "\"" + "/>");
                sb.append("\n");
                sb.append("<property name=\"Keys\" value=\"" + this.getKeysString() + "\"" + "/>");
            } else {
                GraphUtils.displayMessage(null, (String)"No BAM connection in BAMSensorActionDialog", (int)0);
            }
        } else {
            sb.append("<connection-factory location=\"" + this.m_sensorProperties.getProperty("JNDI") + "\"" + ">");
            sb.append("\n");
            sb.append("</connection-factory>");
            sb.append("\n");
            sb.append("<endpoint-interaction operation=\"writetoBAM\">");
            sb.append("\n");
            sb.append("<interaction-spec className=\"oracle.bam.adapter.adc.ADCInteractionSpec\">");
            sb.append("\n");
            sb.append("<property name=\"DataObjectName\" value=\"" + (String)this.m_sensorProperties.get("DataObjectName") + "\"" + "/>");
            sb.append("\n");
            sb.append("<property name=\"InBatch\" value=\"" + (String)this.m_sensorProperties.get("InBatch") + "\"" + "/>");
            sb.append("\n");
            sb.append("<property name=\"OperationType\" value=\"" + opType + "\"" + "/>");
            sb.append("\n");
            sb.append("<property name=\"Keys\" value=\"" + this.getKeysString() + "\"" + "/>");
        }
        sb.append("\n");
        sb.append("</interaction-spec>");
        sb.append("\n");
        sb.append("</endpoint-interaction>");
        sb.append("\n");
        sb.append("</adapter-config>");
        this.m_sensorAction.setSensorProperties(this.m_sensorProperties);
        return sb.toString();
    }

    private String getNodeValue(String name) {
        String value = "";
        try {
            Node node = this.m_doc.selectSingleNode("//*[@name='" + name + "']", (NSResolver)this.m_doc);
            if (node != null) {
                value = node.getAttributes().getNamedItem("value").getNodeValue();
            }
        }
        catch (Exception e) {
            System.out.println("get node value error: " + e.getMessage());
        }
        return value;
    }

    private String getJndi() {
        String value = "eis/bam/rmi";
        try {
            Node node = this.m_doc.getElementsByTagName("connection-factory").item(0);
            if (node != null) {
                value = node.getAttributes().getNamedItem("location").getNodeValue();
            }
        }
        catch (Exception e) {
            System.out.println("error getting jndi: " + e.getMessage());
        }
        return value;
    }

    private void saveToJCAFile() {
        try {
            URL url = null;
            url = URLFactory.newURL((URL)this.m_prjDirURL, (String)"bam");
            if (url != null) {
                File file = new File(URLFileSystem.getPath((URL)url));
                file = new File(file.getAbsolutePath() + File.separator + this.m_nameField.getText() + ".jcabam");
                OutputStream out = URLFileSystem.openOutputStream((URL)file.toURL());
                PrintStream p = new PrintStream(out, false, "UTF-8");
                p.print(this.constructJCAFile());
                p.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error writing to jca file");
        }
    }

    private XMLDocument transformJCAFile() {
        XMLDocument doc = null;
        try {
            URL url = null;
            url = URLFactory.newURL((URL)this.m_prjDirURL, (String)"bam");
            if (url != null) {
                String decodedString;
                File file = new File(URLFileSystem.getPath((URL)url));
                if (!(file = new File(file.getAbsolutePath() + File.separator + this.m_sensorAction.getName() + ".jcabam")).exists()) {
                    return null;
                }
                FileInputStream in = new FileInputStream(file);
                BufferedReader oBufferedReader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                String strComplete = "";
                while ((decodedString = oBufferedReader.readLine()) != null) {
                    strComplete = strComplete + decodedString;
                }
                oBufferedReader.close();
                DOMParser oDOMParser = new DOMParser();
                oDOMParser.parse((Reader)new StringReader(strComplete));
                doc = oDOMParser.getDocument();
            }
        }
        catch (Exception e) {
            System.err.println("Error tranform jca file");
        }
        return doc;
    }

    private ISensor getSensor() {
        List sensorNames = this.m_sensorAction.getSensorNames();
        if (sensorNames == null || sensorNames.size() < 1) {
            return null;
        }
        String sensorName = (String)sensorNames.get(0);
        for (int i = 0; i < this.m_sensorCombo.getItemCount(); ++i) {
            ISensor sensor = (ISensor)this.m_sensorCombo.getItemAt(i);
            if (!sensor.getSensorName().equals(sensorName)) continue;
            return sensor;
        }
        return null;
    }

    private void setSensor() {
        ISensor sensor = (ISensor)this.m_sensorCombo.getSelectedItem();
        ArrayList<String> sensorNames = this.m_sensorAction.getSensorNames();
        if (sensorNames == null || sensorNames.size() < 1) {
            sensorNames = new ArrayList<String>();
            sensorNames.add(sensor.getSensorName());
            this.m_sensorAction.setSensorNames(sensorNames);
            sensor.addSensorAction(this.m_sensorAction);
        }
    }

    private String getDOName(URL url) {
        String urlStr = null;
        try {
            urlStr = URLDecoder.decode(url.toString(), "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            urlStr = url.toString();
        }
        int index = urlStr.lastIndexOf("/OracleBAMWS/WebServices/Wsil/DataObjects/");
        int index2 = urlStr.lastIndexOf(".");
        return urlStr.substring((index += "/OracleBAMWS/WebServices/Wsil/DataObjects/".length()) - 1, index2);
    }

    protected void handleBrowseWSDL() {
        BAMDOChooser browser = new BAMDOChooser(GraphUtils.getFrame((Component)((Object)this)), true);
        browser.setTitle(BPELStringTranslator.getString("DLG_TITLE_BAM_CHOOSER"));
        try {
            BAMDODataSource ds = new BAMDODataSource();
            TreeExplorer explorer = browser.getExplorer();
            if (explorer != null) {
                BAMDOChooserPopupListener popupListener = new BAMDOChooserPopupListener();
                explorer.addPopupListener((PopupListener)popupListener);
                BAMDOChooserPopupListener.NewBAMConnectionAction action = new BAMDOChooserPopupListener.NewBAMConnectionAction(explorer);
                explorer.setToolBarActions(new Action[]{action});
            }
            browser.display(ds);
            if (browser.getReturnValue() == 0) {
                this.m_doURL = browser.getUrl();
                String name = this.getDOName(this.m_doURL);
                this.m_doField.setText(name);
                this.m_urlFetcher = browser.getURLFetcher();
                InputStream in = this.m_urlFetcher.getURL(this.m_doURL);
                DataObjectKeys doKeys = new DataObjectKeys(in);
                this.m_elementName = doKeys.getDataObjectSchemaRootName();
                this.m_elementNamespace = doKeys.getDataObjectNamespace();
                in.close();
                in = this.m_urlFetcher.getURL(this.m_doURL);
                this.copyWSDL(this.m_doURL, in);
                in.close();
                this.m_doKeys = doKeys.parseKeys();
                if (!this.m_doField.getText().equals("")) {
                    this.m_opCombo.setEnabled(true);
                }
                if (this.m_doKeys != null && this.m_doKeys.size() > 0) {
                    this.m_inputList.setModel(this.getInputModel(this.m_doKeys, (DefaultListModel)this.m_selectedList.getModel()));
                }
                this.updateButtons(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GraphUtils.displayMessage((Component)((Object)this), (String)ex.getMessage(), (int)0);
        }
    }

    protected void editMapperFile() {
        if (!ModelUtil.hasLength((String)this.m_mapField.getText())) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)BPELStringTranslator.getString("EDITOR_TRFM_NO_MAPPER_FILE"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), null);
            return;
        }
        String mapperText = this.m_mapField.getText().trim();
        URL url = null;
        try {
            url = new URL(mapperText);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (url == null) {
            Context context = EditorManager.getEditorManager().getCurrentEditor().getContext();
            url = URLFactory.newURL((URL)this.m_prjDirURL, (String)mapperText);
            if (url == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)BPELStringTranslator.getString("EDITOR_TRFM_INVALID_FNAME_FMT"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), null);
                return;
            }
            File file = new File(URLFileSystem.getPath((URL)url));
            if (!file.exists()) {
                boolean _failed = true;
                if (!file.getName().endsWith(".xsl") && (file = new File(file.getAbsolutePath() + ".xsl")).exists()) {
                    url = URLFactory.newURL((URL)this.m_prjDirURL, (String)file.getName());
                    _failed = false;
                }
                if (_failed) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)BPELStringTranslator.getString("EDITOR_TRFM_MAPPER_FILE_NOT_EXIST"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), null);
                    return;
                }
            }
        }
        final URL mapperURL = url;
        Runnable openFileRunnable = new Runnable(){

            @Override
            public void run() {
                EditorManager.getEditorManager().openDefaultEditorInFrame(mapperURL);
            }
        };
        SwingUtilities.invokeLater(openFileRunnable);
        this.dispose();
    }

    private DefaultListModel getInputModel(Vector doKeys, DefaultListModel selectedModel) {
        int i;
        DefaultListModel model = new DefaultListModel();
        for (i = 0; i < doKeys.size(); ++i) {
            model.add(i, doKeys.get(i));
        }
        if (selectedModel != null) {
            for (i = 0; i < selectedModel.getSize(); ++i) {
                if (model.removeElement(selectedModel.get(i))) continue;
                selectedModel.remove(i--);
            }
        }
        return model;
    }

    private void copyWSDL(URL url, InputStream in) {
        String str = "/OracleBAMWS/WebServices/Wsil/DataObjects/";
        try {
            String urlStr = URLDecoder.decode(url.toString(), "UTF-8");
            String file = url.getFile();
            int index = urlStr.indexOf(str);
            String fileName = urlStr.substring(index += str.length() - 1);
            this.m_bamLocalURL = new URL(this.m_prjDirURL, "bam/" + fileName);
            URLFileSystem.copy((InputStream)in, (URL)this.m_bamLocalURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Variable getSensorVar(ISensor sensor) {
        Process process = this.m_model.getProcess();
        int sensorType = sensor.getKind().getKind();
        Variable var = null;
        if (sensorType == 3) {
            String activityName = sensor.getTarget();
            IActivityConfig config = (IActivityConfig)sensor.getConfiguration();
            IActivityVariableConfig[] varConfigs = config.getVariable();
            if (varConfigs == null || varConfigs.length != 1) {
                return null;
            }
            IActivityVariableConfig varConfig = varConfigs[0];
            String varName = varConfig.getTarget().substring(1);
            int index = varName.indexOf("/");
            if (index > 1) {
                varName = varName.substring(0, index);
            }
            Activity activity = BPELModelUtil.getActivityForName((Activity)this.m_model.getProcess(), (String)activityName);
            var = BPELModelUtil.getVariableForName((Activity)activity, (String)varName);
        } else if (sensorType == 2) {
            String varName = sensor.getTarget().substring(1);
            int index = varName.indexOf("/");
            if (index > 0) {
                varName = varName.substring(0, index);
            }
            var = BPELModelUtil.getVariableForName((Process)process, (String)varName, (boolean)true);
        }
        return var;
    }

    private void startMapper() {
        try {
            final URL mapperURL = new URL(this.m_prjDirURL, this.m_mapField.getText());
            File file = new File(mapperURL.getFile());
            file.delete();
            MapperInfo mapperInfo = this.getMapperInfo(this.m_var, mapperURL);
            ArrayList<MapperSource> mapperSources = new ArrayList<MapperSource>(1);
            mapperSources.add(new MapperSource(mapperInfo.m_bSourceXSD ? 1 : 2, mapperInfo.m_srcURL, mapperInfo.m_srcQName));
            final ArrayList<MapperTarget> mapperTargets = new ArrayList<MapperTarget>(1);
            mapperTargets.add(new MapperTarget(2, this.m_bamLocalURL, new QName(this.m_elementNamespace, this.m_elementName)));
            URL outURL = this.replaceTemplates(mapperInfo.m_srcQName, mapperInfo.m_srcURL);
            if (outURL == null) {
                return;
            }
            final ArrayList<String> newMapSources = new ArrayList<String>(1);
            newMapSources.add("hello");
            this.getMapperSource(newMapSources, outURL);
            Runnable rd = new Runnable(){

                @Override
                public void run() {
                    new MapperCreator(BAMSensorActionDialog.this.m_context).createMapper(mapperURL, newMapSources, mapperTargets, true);
                }
            };
            SwingUtilities.invokeLater(rd);
            this.saveChanges();
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isMapperCompatible(URL mapperURL) {
        return true;
    }

    private MapperInfo getMapperInfo(Variable var, URL wsdlURL) {
        MapperInfo info = new MapperInfo();
        String sourceElement = "";
        String sourceNS = "";
        boolean bSourceIsElement = true;
        if (var != null) {
            QName elemQName = var.getElement();
            QName msgQName = var.getMessageType();
            if (elemQName != null) {
                info.m_srcQName = var.getElement();
                sourceElement = info.m_srcQName.getLocalPart();
                sourceNS = info.m_srcQName.getNamespaceURI();
            } else {
                List partList = WSDLPartData.getParts((QName)msgQName, (Process)this.m_model.getProcess(), (boolean)true);
                WSDLPartData part = (WSDLPartData)partList.get(0);
                sourceElement = part.getPartType();
                sourceNS = part.getTargetNamespace();
                if (part.getPartXSDType() == 2) {
                    info.m_srcPartName = new QName(part.getPartName());
                    bSourceIsElement = false;
                }
                info.m_srcQName = new QName(sourceNS, sourceElement);
            }
        }
        info.m_tarURL = wsdlURL;
        URI sourceURI = null;
        List list = null;
        list = this.m_URIForNamespaceCache.getURIForNamespaceURI(this.m_context.getProject(), sourceNS);
        if (list != null && list.size() > 0) {
            sourceURI = this.resolveElement(list, sourceElement, sourceNS, true);
        }
        if (sourceURI == null) {
            list = WSDLUtil.getImports((Definition)this.m_model.getBPELProject().getWSDLFileDefinition());
            sourceURI = this.getURIFromNamespace(list, sourceNS, sourceElement, bSourceIsElement);
        }
        if (sourceURI == null) {
            sourceURI = this.getURIFromNamespaceInPLWSDL(sourceNS, sourceElement, bSourceIsElement);
        }
        try {
            if (sourceURI == null) {
                return info;
            }
            info.m_srcURL = sourceURI.toURL();
            info.m_bSourceXSD = ContentUtil.isXSDDocument((URL)info.m_srcURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return info;
    }

    protected final URI getURIFromNamespaceInPLWSDL(String namespace, String elementName, boolean bIsElement) {
        int size;
        Process process = this.m_model.getProcess();
        DeploymentFile depFile = this.m_model.getBPELProject().getDeploymentFile();
        List plList = BPELModelUtil.getPartnerLinkWSDLLocations((Process)process, (DeploymentFile)depFile);
        ArrayList<URI> list = new ArrayList<URI>();
        if (plList != null) {
            for (int i = 0; i < plList.size(); ++i) {
                try {
                    URI uri = (URI)plList.get(i);
                    URI retURI = WSDLUtil.getSchemaURI((URI)uri, (String)namespace);
                    if (retURI == null) continue;
                    list.add(retURI);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if ((size = list.size()) == 0) {
            return null;
        }
        return this.resolveElement(list, elementName, namespace, bIsElement);
    }

    protected final URI getURIFromNamespace(List list, String namespace, String elementName, boolean bIsElement) {
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<URI> ulist = new ArrayList<URI>();
        for (int i = 0; i < list.size(); ++i) {
            WSDLImport imp = (WSDLImport)list.get(i);
            if (!imp.getNamespaceURI().equals(namespace)) continue;
            try {
                ulist.add(new URI(URIUtil.escapeURIString((String)imp.getLocationURI())));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int size = ulist.size();
        if (size == 0) {
            return null;
        }
        return this.resolveElement(ulist, elementName, namespace, bIsElement);
    }

    protected URI resolveElement(List list, String elementName, String namespaceURI, boolean bIsElement) {
        String tmpElem = "actionData";
        String tmpNamespace = "http://xmlns.oracle.com/bpel/sensor";
        Collections.sort(list, this.URIComparator);
        for (int i = 0; i < list.size(); ++i) {
            try {
                URI uri = (URI)list.get(i);
                if (ContentUtil.isXSDDocument((URL)uri.toURL())) {
                    DOMParser parser = new DOMParser();
                    parser.parse(uri.toURL());
                    XMLDocument doc = parser.getDocument();
                    XSDBuilder xsdBuilder = new XSDBuilder();
                    XMLSchema schema = xsdBuilder.build(doc, uri.toURL());
                    if (bIsElement) {
                        if (schema.getElement(namespaceURI, elementName) == null || !(namespaceURI == null ? "" : namespaceURI).equals(doc.getDocumentElement().getAttribute("targetNamespace")) || schema.getElement(tmpNamespace, tmpElem) != null) continue;
                        return uri;
                    }
                    XMLSchemaNode schemaNode = schema.getSchemaByTargetNS(namespaceURI);
                    XSDNode[] xsdNodes = schemaNode.getComplexTypeSet();
                    if (xsdNodes == null) continue;
                    for (int j = 0; j < xsdNodes.length; ++j) {
                        if (xsdNodes[j].getName() == null || !elementName.equals(xsdNodes[j].getName())) continue;
                        return uri;
                    }
                    continue;
                }
                Object obj = WSDLUtil.resolvedSchema((URI)uri, (String)namespaceURI, (String)elementName, (boolean)bIsElement);
                if (obj == null) continue;
                if (obj instanceof WSDLUtil.WSDLSchemaWrapper) {
                    return ((WSDLUtil.WSDLSchemaWrapper)obj).getURI();
                }
                return uri;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private void moveSelectedValues(JList fromList, JList toList) {
        Object[] values = fromList.getSelectedValues();
        if (values.length != 0) {
            int i;
            DefaultListModel model = (DefaultListModel)toList.getModel();
            for (i = 0; i < values.length; ++i) {
                model.addElement(values[i]);
            }
            model = (DefaultListModel)fromList.getModel();
            for (i = 0; i < values.length; ++i) {
                model.removeElement(values[i]);
            }
        }
    }

    private void moveAllValues(boolean flag) {
        if (this.m_doKeys != null && this.m_doKeys.size() > 0 && flag) {
            this.m_inputList.setModel(this.getInputModel(this.m_doKeys, null));
            this.m_selectedList.setModel(new DefaultListModel());
        }
        if (this.m_doKeys != null && this.m_doKeys.size() > 0 && !flag) {
            this.m_selectedList.setModel(this.getInputModel(this.m_doKeys, null));
            this.m_inputList.setModel(new DefaultListModel());
        }
    }

    private void enableDisableControls() {
        DefaultListModel selectedModel;
        DefaultListModel inputModel = (DefaultListModel)this.m_inputList.getModel();
        String bamOperation = (String)this.m_opCombo.getSelectedItem();
        if (bamOperation.equals(INSERT) || inputModel.size() <= 0) {
            this.m_btnSelectAll.setEnabled(false);
            this.m_btnSelectOne.setEnabled(false);
            if (bamOperation.equals(INSERT)) {
                this.m_opInst.setText(BPELStringTranslator.getString("DLG_INST_BAM_KEYS"));
                this.moveAllValues(true);
            }
        } else {
            this.m_opInst.setText("");
            this.m_btnSelectAll.setEnabled(true);
            this.m_btnSelectOne.setEnabled(true);
        }
        if ((selectedModel = (DefaultListModel)this.m_selectedList.getModel()).size() > 0) {
            this.m_btnRemoveAll.setEnabled(true);
            this.m_btnRemoveOne.setEnabled(true);
        }
        this.m_opCombo.setEnabled(true);
        boolean enable = !this.m_doField.getText().equals("") && (this.m_opCombo.getSelectedItem().equals(INSERT) || this.m_selectedList.getModel().getSize() > 0);
        this.updateButtons(enable);
    }

    private void updateButtons(boolean flag) {
        this.m_okBtn.setEnabled(flag);
        this.m_editBtn.setEnabled(flag);
        this.m_browseMapper.setEnabled(flag);
    }

    private Vector<ISensor> getSensors() {
        return new Vector<ISensor>(this.m_sensors);
    }

    private String getKeysString() {
        DefaultListModel model = (DefaultListModel)this.m_selectedList.getModel();
        int size = model.getSize();
        StringBuffer strBuf = new StringBuffer("");
        for (int i = 0; i < size; ++i) {
            strBuf.append((String)model.get(i));
            if (i == size - 1) continue;
            strBuf.append(",");
        }
        return strBuf.toString();
    }

    private Vector filterSensors(Vector sensors) {
        Process process = this.m_model.getProcess();
        Vector outVector = new Vector();
        if (sensors != null) {
            for (int i = 0; i < sensors.size(); ++i) {
                if (!BAMSensorAction.isValidSensor((ISensor)((ISensor)sensors.get(i)), (Process)process)) continue;
                Variable var = this.getSensorVar((ISensor)sensors.get(i));
                if (var == null) {
                    outVector.add(sensors.get(i));
                    continue;
                }
                try {
                    URL mapperURL = new URL(this.m_prjDirURL, "tmp.txt");
                    MapperInfo mapperInfo = this.getMapperInfo(var, mapperURL);
                    if (mapperInfo.m_srcURL != null && mapperInfo.m_srcURL.toString().endsWith(".wsdl")) {
                        continue;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                outVector.add(sensors.get(i));
            }
        }
        return outVector;
    }

    private boolean isTemplate(URL url, QName qname) {
        try {
            String elemName = qname.getLocalPart();
            String namespace = qname.getNamespaceURI();
            XSDBuilder xsdBuilder = new XSDBuilder();
            XMLSchema schema = xsdBuilder.build(url);
            if (schema.getElement(namespace, elemName) != null) {
                namespace = "http://xmlns.oracle.com/bpel/sensor";
                elemName = "actionData";
                if (schema.getElement(namespace, elemName) != null) {
                    // empty if block
                }
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private URL replaceTemplates(QName qname, URL srcURL) {
        if (qname == null) {
            try {
                URLFileSystem.copy((URL)BAMSensorActionDialog.getClassLoader().getResource("oracle/tip/tools/ide/pm/addin/bam/Sensor.xsd"), (URL)new URL(this.m_prjDirURL, "SensorActionData.xsd"));
                URL url = new URL(this.m_prjDirURL, "SensorActionData.xsd");
                return url;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        String str = srcURL.toString();
        if (str.endsWith(".wsdl")) {
            MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)BPELStringTranslator.getString("DLG_ERR_VAR_WSDL_NOT_SUPPORTED"), (String)BPELStringTranslator.getString("XXERROR"), (int)0);
            return null;
        }
        String elemName = qname.getLocalPart();
        String namespace = qname.getNamespaceURI();
        XSDElement obj = null;
        try {
            XSDBuilder xsdBuilder = new XSDBuilder();
            XMLSchema schema = xsdBuilder.build(srcURL);
            obj = schema.getElement(qname.getNamespaceURI(), elemName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        URL outURL = null;
        try {
            URLFileSystem.copy((URL)BAMSensorActionDialog.getClassLoader().getResource("oracle/tip/tools/ide/pm/addin/bam/Sensor.xsd"), (URL)new URL(this.m_prjDirURL, "SensorActionData.xsd"));
            URL url = new URL(this.m_prjDirURL, "SensorActionData.xsd");
            String sensorDataXSD = FileUtils.readFile((String)url.getFile());
            sensorDataXSD = sensorDataXSD.replaceFirst(s_varNSStr, s_varNSStrNew);
            sensorDataXSD = sensorDataXSD.replaceFirst(s_varImport, s_varImportNew);
            sensorDataXSD = sensorDataXSD.replaceFirst(s_varAnyType1, s_varAnyTypeNew);
            sensorDataXSD = sensorDataXSD.replaceFirst(s_varAnyType2, s_varAnyTypeNew);
            sensorDataXSD = sensorDataXSD.replaceAll("\\$namespace", namespace);
            sensorDataXSD = sensorDataXSD.replaceAll("\\$element", elemName);
            String relativeURLStr = URLFileSystem.toRelativeSpec((URL)srcURL, (URL)this.m_prjDirURL, (boolean)true);
            sensorDataXSD = sensorDataXSD.replaceFirst("\\$url", relativeURLStr != null ? relativeURLStr : srcURL.toExternalForm());
            String warmingMessage = "<!-- *** The following line is a place holder. Do not remove it. It must remain as is, including any whitespace.  If you change this, please let BAM sensor action developer know. -->";
            sensorDataXSD = sensorDataXSD.replace(warmingMessage, "");
            outURL = new URL(this.m_prjDirURL, "SensorAction" + this.m_sensorAction.getName() + ".xsd");
            FileUtils.writeFile((String)sensorDataXSD, (String)outURL.getFile());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return outURL;
    }

    private static ClassLoader getClassLoader() {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        return classLoader;
    }

    private List getMapperSource(List mapperSources, URL outURL) {
        try {
            mapperSources.remove(0);
            mapperSources.add(new MapperSource(1, outURL, new QName("http://xmlns.oracle.com/bpel/sensor", "actionData")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapperSources;
    }

    private void initCaches() {
        this.m_URIForNamespaceCache = new URIForNamespaceCache();
    }

    @Override
    protected void handleHelp(Component comp) {
        String topicId = oracle.tip.tools.ide.pm.modules.help.HelpSystem.getHelpTopicId(this.getClass().getName());
        oracle.tip.tools.ide.pm.modules.help.HelpSystem.showHelp((Component)((Object)this), topicId);
    }

    private class ActionMouseListener
    extends MouseAdapter {
        boolean bFlag = true;

        public ActionMouseListener(boolean flag) {
            this.bFlag = flag;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (this.bFlag) {
                    BAMSensorActionDialog.this.moveSelectedValues(BAMSensorActionDialog.this.m_inputList, BAMSensorActionDialog.this.m_selectedList);
                } else {
                    BAMSensorActionDialog.this.moveSelectedValues(BAMSensorActionDialog.this.m_selectedList, BAMSensorActionDialog.this.m_inputList);
                }
                BAMSensorActionDialog.this.enableDisableControls();
            }
        }
    }

    private class MapperInfo {
        public QName m_srcQName;
        public URL m_srcURL;
        public URL m_tarURL;
        public QName m_srcPartName;
        public boolean m_bSourceXSD;

        private MapperInfo() {
        }
    }

    private static class URIForNamespaceCache {
        private Map<String, List> urisForNamespaceMap = new HashMap<String, List>();

        private URIForNamespaceCache() {
        }

        public List getURIForNamespaceURI(Project prj, String sourceNS) {
            ArrayList uriList = this.urisForNamespaceMap.get(sourceNS);
            if (uriList == null) {
                uriList = SchemaResolvedObj.getURIForNamespaceURI((Project)prj, (String)sourceNS);
                uriList = new ArrayList(new LinkedHashSet(uriList));
                this.urisForNamespaceMap.put(sourceNS, uriList);
            }
            return uriList;
        }
    }
}

