/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bam;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import oracle.tip.tools.ide.bam.common.connection.BAMConnection;
import oracle.tip.tools.ide.common.datasources.wsil.WSILTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.bam.BAMSensorActionDialog;

public class BAMDODataSource
implements TreeExplorerDataSource {
    private static final String DEFAULT = "default";
    private static final Icon[] icons = new Icon[]{WSILTreeExplorerTreeNode.WSIL_ICON};
    private List m_rootList = new ArrayList();

    public BAMDODataSource() {
        this(BAMSensorActionDialog.getBAMConnections());
    }

    public BAMDODataSource(List<BAMConnection> connections) {
        WSILTreeExplorerTreeNode defaultNode = null;
        if (connections != null && connections.size() > 0) {
            for (int i = 0; i < connections.size(); ++i) {
                BAMConnection connection = connections.get(i);
                defaultNode = this.getServerRootNode(connection);
                if (defaultNode == null) continue;
                defaultNode.setIcons(icons);
                defaultNode.add((MutableTreeNode)new DummyNode(DEFAULT));
                this.m_rootList.add(defaultNode);
            }
        }
    }

    private WSILTreeExplorerTreeNode getServerRootNode(BAMConnection conn) {
        try {
            URL url = BAMDODataSource.getURL(conn);
            return new WSILTreeExplorerTreeNode(url, conn.getURLFetcher(), conn.getName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static URL getURL(BAMConnection conn) throws MalformedURLException {
        URL url = BAMDODataSource.getURL(conn.getWebTierHost(), "", conn.getWebTierHostPort() + "", conn.getUser(), conn.getPassword(), conn.getWebTierProtocol());
        return url;
    }

    private static URL getURL(String host, String domain, String port, String user, String pass, String protocol) {
        URL url = null;
        String urlStr = protocol + "://" + host + ":" + port + "/OracleBAMWS/WebServices/Wsil/DataObjects/inspection.wsil";
        try {
            url = new URL(urlStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return url;
    }

    public TreeExplorerTreeNode[] getRoots() {
        if (this.m_rootList != null) {
            return this.m_rootList.toArray(new TreeExplorerTreeNode[0]);
        }
        return new TreeExplorerTreeNode[0];
    }
}

