/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bam;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.ide.Context;
import oracle.ide.util.Namespace;
import oracle.jdeveloper.rescat2.RescatContextRegistry;
import oracle.jdeveloper.rescat2.nodes.RescatContext;
import oracle.tip.tools.ide.bam.common.connection.BAMConnection;
import oracle.tip.tools.ide.bam.common.dt.resource.BAMDCResourceBundle;
import oracle.tip.tools.ide.bam.common.logging.BAMLogger;
import oracle.tip.tools.ide.bam.rc.connection.ConnWizardLauncher;
import oracle.tip.tools.ide.bam.rc.connection.ConnectionFactory;
import oracle.tip.tools.ide.bam.rc.connection.WizardConnection;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.treeexplorer.DefaultPopupListener;
import oracle.tip.tools.ide.common.ui.treeexplorer.DefaultTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorer;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.bam.BAMDODataSource;
import oracle.tip.tools.ide.pm.modules.bam.BAMSensorActionDialog;

public class BAMDOChooserPopupListener
extends DefaultPopupListener {
    private List m_list = new ArrayList();
    protected static Namespace _data = new Namespace();
    private static final String APPFLAG = "AppFlag";
    private static final String ENABLE_APPFLAG = "EnableAppFlag";

    public List getPopupMenuItems(TreeExplorer explorer, TreePath path) {
        this.m_list = super.getPopupMenuItems(explorer, path);
        DefaultTreeExplorerTreeNode treeNode = (DefaultTreeExplorerTreeNode)path.getLastPathComponent();
        if (treeNode.isRoot()) {
            NewBAMConnectionAction action = new NewBAMConnectionAction(explorer, BPELStringTranslator.getString("TOOLTIP_CREATE_BAM_CONN"));
            this.m_list.add(action);
        }
        return this.m_list;
    }

    public static class NewBAMConnectionAction
    extends AbstractAction {
        private TreeExplorer m_explorer;
        private Logger m_oLogger = BAMLogger.createLogger((String)this.getClass().getName());

        public NewBAMConnectionAction(TreeExplorer explorer, String text) {
            super(text, GlobalImageCache.getIcon((String)"workstation_network.png"));
            this.putValue("ShortDescription", text);
            this.m_explorer = explorer;
        }

        public NewBAMConnectionAction(TreeExplorer explorer) {
            this(explorer, "");
            this.putValue("ShortDescription", BPELStringTranslator.getString("TOOLTIP_CREATE_BAM_CONN"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.createNewBAMConnection();
        }

        protected Referenceable createReferenceFromDescriptor(WizardConnection bamConnection) {
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute connname = new BasicAttribute("CONNECTION_NAME", bamConnection.getConnName());
            attrs.put(connname);
            BasicAttribute connmode = new BasicAttribute("CONNECTION_MODE", bamConnection.getConnMode());
            attrs.put(connmode);
            BasicAttribute server = new BasicAttribute("WEBTIER_SERVER", bamConnection.getHostName());
            attrs.put(server);
            BasicAttribute port = new BasicAttribute("WEBTIER_SERVER_PORT", bamConnection.getPort());
            attrs.put(port);
            BasicAttribute user = new BasicAttribute("USER_NAME", bamConnection.getUsername());
            attrs.put(user);
            SecureRefAddr oPw = new SecureRefAddr("PASSWORD", bamConnection.getPassword());
            BasicAttribute oBAMServerHost = new BasicAttribute("BAM_SERVER_HOST", bamConnection.getBAMServerHost());
            attrs.put(oBAMServerHost);
            BasicAttribute oBAMServerPort = new BasicAttribute("BAM_SERVER_PORT", bamConnection.getBAMServerPort());
            attrs.put(oBAMServerPort);
            BasicAttribute oBAMWebTierProtocol = new BasicAttribute("BAM_WEBTIER_PROTOCOL", bamConnection.getProtocol());
            attrs.put(oBAMWebTierProtocol);
            BasicAttribute oAppFlag = new BasicAttribute(BAMDOChooserPopupListener.APPFLAG, bamConnection.getAppFlag() + "");
            attrs.put(oAppFlag);
            BasicAttribute oEnableAppFlag = new BasicAttribute(BAMDOChooserPopupListener.ENABLE_APPFLAG, bamConnection.getEnableAppFlag() + "");
            attrs.put(oEnableAppFlag);
            ConnectionFactory connFactory = new ConnectionFactory();
            Referenceable ref = null;
            try {
                ref = connFactory.newInstance(bamConnection.getConnName(), (Attributes)attrs, new SecureRefAddr[]{oPw});
            }
            catch (Exception ex) {
                this.m_oLogger.log(Level.WARNING, "BAMProviderWizard.createReferenceFromDescriptor,Could not insert into Connection Factory, Exception: " + ex.getMessage());
            }
            return ref;
        }

        private javax.naming.Context getConnectionContext(javax.naming.Context connectionCtx, WizardConnection oBAMConnection) {
            RescatContextRegistry registry = RescatContextRegistry.getInstance();
            RescatContext rescatCtx = null;
            rescatCtx = oBAMConnection.getAppFlag() ? registry.getActiveWorkspaceContext() : registry.getResourcePaletteContext();
            if (rescatCtx != null) {
                connectionCtx = rescatCtx.getConnectionContext();
            }
            return connectionCtx;
        }

        protected void createNewBAMConnection() {
            Object conn = null;
            javax.naming.Context connectionCtx = null;
            try {
                Context context = Context.newIdeContext();
                ConnWizardLauncher bamConnWizardLauncher = new ConnWizardLauncher(context, BAMDCResourceBundle.getString((String)"BAM_CONN_TITLE"));
                boolean ret = false;
                if (bamConnWizardLauncher != null) {
                    bamConnWizardLauncher.setConnectionContext(connectionCtx);
                    ConnWizardLauncher.setActionCreate((Namespace)_data, (boolean)true);
                    bamConnWizardLauncher.initLauncher(context);
                    ret = bamConnWizardLauncher.runWizard();
                }
                if (ret) {
                    WizardConnection oBAMConnection = bamConnWizardLauncher.getBAMConnection();
                    String connName = oBAMConnection.getConnName();
                    Referenceable ref = this.createReferenceFromDescriptor(oBAMConnection);
                    connectionCtx = this.getConnectionContext(connectionCtx, oBAMConnection);
                    try {
                        if (conn == null) {
                            connectionCtx.bind(connName, (Object)ref);
                        }
                        AdfJndiContext adfCtx = (AdfJndiContext)connectionCtx;
                        adfCtx.save();
                    }
                    catch (NamingException ex) {
                        ex.printStackTrace();
                        this.m_oLogger.log(Level.WARNING, "BAMProviderWizard.invokeCreate, NamingException: " + connName);
                    }
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        List<BAMConnection> connections = BAMSensorActionDialog.getBAMConnections();
                        if (connections != null && connections.size() > 0) {
                            NewBAMConnectionAction.this.m_explorer.getRoot().removeAllChildren();
                            NewBAMConnectionAction.this.m_explorer.setDataSource((TreeExplorerDataSource)new BAMDODataSource(connections));
                            NewBAMConnectionAction.this.m_explorer.load();
                        }
                    }
                };
                SwingUtilities.invokeLater(r);
            }
            catch (Exception ex) {
                MultiLineOptionPane.showMessageDialog(null, (Object)ex.getMessage());
            }
        }
    }
}

