/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.datasources.wsil.WSILTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.DialogCancelListener;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.DefaultTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorer;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.utils.URLFetcher;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class BAMDOChooser
extends JDialog
implements ActionListener,
PropertyChangeListener,
DialogCancelListener {
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected TreeExplorer m_explorer;
    protected int m_retVal = 2;

    public BAMDOChooser(JFrame f, boolean flag) {
        this(f, BPELStringTranslator.getString("DLG_TITLE_BAM_CHOOSER"), flag);
    }

    public BAMDOChooser(JFrame f, String title, boolean flag) {
        super(f, title, flag);
        this.getGlassPane().addMouseListener(new MouseAdapter(){});
        this.getGlassPane().addMouseMotionListener(new MouseMotionAdapter(){});
        this.getGlassPane().addKeyListener(new KeyAdapter(){});
        this.createControls();
        this.layoutControls();
        this.updateButtons();
        this.attachHelpListener();
        UIHelper.attachDialogCancelListener((JDialog)this, (DialogCancelListener)this);
    }

    public void enableUserInput(final boolean bEnable) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Component glass = BAMDOChooser.this.getGlassPane();
                glass.setVisible(!bEnable);
                if (bEnable) {
                    glass.setCursor(Cursor.getDefaultCursor());
                } else {
                    glass.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public int getReturnValue() {
        return this.m_retVal;
    }

    public TreeExplorer getExplorer() {
        return this.m_explorer;
    }

    public URL getUrl() {
        DefaultTreeExplorerTreeNode node;
        URL url = null;
        if (this.m_explorer != null && (node = this.m_explorer.getSelectedNode()) instanceof WSILTreeExplorerTreeNode) {
            url = ((WSILTreeExplorerTreeNode)node).getUrl();
        }
        return url;
    }

    public URLFetcher getURLFetcher() {
        DefaultTreeExplorerTreeNode node;
        URLFetcher urlFetcher = null;
        if (this.m_explorer != null && (node = this.m_explorer.getSelectedNode()) instanceof WSILTreeExplorerTreeNode) {
            urlFetcher = ((WSILTreeExplorerTreeNode)node).getURLFetcher();
        }
        return urlFetcher;
    }

    public int display(final TreeExplorerDataSource ds) {
        if (ds != null) {
            this.enableUserInput(false);
            this.m_explorer.showWaitPanel();
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, BPELStringTranslator.getString("NODE_BAM_DO_EXPLORER"));
                        TextInfo info2 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, BPELStringTranslator.getString("NODE_BAM_DO_EXPLORER"));
                        TextInfo[] expanded = new TextInfo[]{info1};
                        TextInfo[] compact = new TextInfo[]{info2};
                        NodeText nodeText = new NodeText(expanded, compact);
                        Icon[] icons = new Icon[]{GlobalImageCache.getIcon((String)"browse16")};
                        WSILTreeExplorerTreeNode root = new WSILTreeExplorerTreeNode(icons, nodeText, MessageBundleUtil.getCommonString((String)"WSIL_DISPLAYS_AVAILABLE_WSDL_FILES", (String)"Displays available WSDL files."));
                        BAMDOChooser.this.m_explorer.setDataSource(ds);
                        BAMDOChooser.this.m_explorer.setRoot((DefaultTreeExplorerTreeNode)root);
                        BAMDOChooser.this.m_explorer.load();
                    }
                    finally {
                        BAMDOChooser.this.enableUserInput(true);
                        BAMDOChooser.this.m_explorer.showExplorerPanel();
                    }
                }
            };
            new Thread(r).start();
        }
        this.show();
        return this.m_retVal;
    }

    protected void createControls() {
        this.m_okBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_okBtn, (String)MessageBundleUtil.getCommonString((String)"M_OK", (String)"&OK"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_cancelBtn, (String)MessageBundleUtil.getCommonString((String)"M_CANCEL", (String)"&Cancel"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_helpBtn, (String)MessageBundleUtil.getCommonString((String)"M_HELP", (String)"&Help"));
        this.m_helpBtn.addActionListener(this);
        this.m_explorer = new TreeExplorer(BPELStringTranslator.getString("LBL_DO"));
        this.m_explorer.setDescriptionPanelVisible(false);
        this.m_explorer.setBorder(null);
        this.m_explorer.addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        UIHelper.addComponent((Container)c, (Component)this.m_explorer, (int)0, (int)0, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        UIHelper.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)btnPnl, (int)1, (int)1, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 480);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void updateButtons() {
        DefaultTreeExplorerTreeNode node = this.m_explorer.getSelectedNode();
        this.m_okBtn.setEnabled(this.m_explorer.isNodeSelected() && !node.hasChildren());
    }

    public void handleOK() {
        this.m_retVal = 0;
        this.dispose();
    }

    public void handleCancel() {
        this.m_retVal = 2;
        this.dispose();
    }

    protected void helpInvoked() {
        HelpSystem help = HelpSystem.getHelpSystem();
        help.registerClientWindow((Window)this);
        help.goTo("bpmjdev_bam_object_chooser");
        help.unregisterClientWindow((Window)this);
    }

    protected void attachHelpListener() {
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                BAMDOChooser.this.helpInvoked();
            }
        };
        JRootPane rootPane = this.getRootPane();
        KeyStroke f1 = KeyStroke.getKeyStroke(112, 0, false);
        rootPane.getInputMap(2).put(f1, "F1_KEY");
        rootPane.getActionMap().put("F1_KEY", f1Action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "TYPE_SELECTION_CHANGED") {
            this.updateButtons();
        }
    }

    public void cancelOccurred(JDialog dlg) {
        this.handleCancel();
    }
}

