/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bam;

import com.sun.crypto.provider.SunJCE;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.ide.Context;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.rescat2.RescatContextRegistry;
import oracle.jdeveloper.rescat2.nodes.RescatContext;
import oracle.tip.tools.ide.bam.common.connection.BAMConnectionLookup;
import oracle.tip.tools.ide.bam.common.dt.resource.BAMDCResourceBundle;
import oracle.tip.tools.ide.bam.common.logging.BAMLogger;
import oracle.tip.tools.ide.bam.rc.connection.ConnectionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BAMConnectionPlugin {
    public static final String BAM_DIR = "/OracleBAM/";
    public static final String CONN_PAR_CONNECTION_NAME = "CONNECTION_NAME";
    public static final String CONN_PAR_CONNECTION_MODE = "CONNECTION_MODE";
    public static final String CONN_PAR_WEBTIER_SEVER = "WEBTIER_SERVER";
    public static final String CONN_PAR_WEBTIER_SEVER_PORT = "WEBTIER_SERVER_PORT";
    public static final String CONN_PAR_USER_NAME = "USER_NAME";
    public static final String CONN_PAR_PASSWORD = "PASSWORD";
    public static final String CONN_PAR_JCA_JNDI_SOAP = "JCA_JNDI_SOAP";
    public static final String CONN_PAR_JCA_JNDI_RMI = "JCA_JNDI_RMI";
    public static final String CONN_PAR_BAM_SERVER_HOST = "BAM_SERVER_HOST";
    public static final String CONN_PAR_BAM_SERVER_PORT = "BAM_SERVER_PORT";
    public static final String CONN_PAR_BAM_SERVER_PROTOCOL = "BAM_WEBTIER_PROTOCOL";
    public static final String CONN_PAR_DEFAULT_PORT = "9001";
    public static final String CONN_PAR_ENABLE_APP_FLAG = "EnableAppFlag";
    public static final String CONN_PAR_APP_FLAG = "AppFlag";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String CONN_MODE_BASIC = "BASIC";
    public static final String CONN_MODE_ADVANCED = "ADVANCED";
    public static final String BPEL_XML_RELATIVE_PATH = "bpel" + File.separator + "bpel.xml";
    private List<BAMConnection> bamConnections = new ArrayList<BAMConnection>();
    private Logger m_oLogger = BAMLogger.createLogger((String)this.getClass().getName());

    public void migrateBAMConnection(Workspace workspace, Project project) {
        this.captureBAMConnections(project.getBaseDirectory());
        this.registryBAMConnections(workspace, project);
    }

    public void captureBAMConnections(String srcDir) {
        try {
            String strBPEL = srcDir + File.separator + BPEL_XML_RELATIVE_PATH;
            File fileBPEL = new File(strBPEL);
            if (fileBPEL != null && fileBPEL.isFile()) {
                this.bamConnections = this.getBAMCONNConnections(strBPEL);
            }
        }
        catch (Exception e) {
            this.m_oLogger.log(Level.WARNING, "locateBAMConnArtifact exception: " + e.getMessage());
        }
    }

    private Referenceable createReferenceFromDescriptor(BAMConnection bamConnection) {
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute connname = new BasicAttribute(CONN_PAR_CONNECTION_NAME, bamConnection.getConnName());
        attrs.put(connname);
        BasicAttribute connmode = new BasicAttribute(CONN_PAR_CONNECTION_MODE, CONN_MODE_BASIC);
        attrs.put(connmode);
        BasicAttribute server = new BasicAttribute(CONN_PAR_WEBTIER_SEVER, bamConnection.getHostName());
        attrs.put(server);
        BasicAttribute enableApp = new BasicAttribute(CONN_PAR_ENABLE_APP_FLAG, "true");
        attrs.put(enableApp);
        BasicAttribute port = new BasicAttribute(CONN_PAR_WEBTIER_SEVER_PORT, CONN_PAR_DEFAULT_PORT);
        attrs.put(port);
        BasicAttribute user = new BasicAttribute(CONN_PAR_USER_NAME, bamConnection.getUserName());
        attrs.put(user);
        BasicAttribute app = new BasicAttribute(CONN_PAR_APP_FLAG, "true");
        attrs.put(app);
        SecureRefAddr oPw = new SecureRefAddr(CONN_PAR_PASSWORD, bamConnection.getPassword());
        BasicAttribute oBAMServerHost = new BasicAttribute(CONN_PAR_BAM_SERVER_HOST, bamConnection.getHostName());
        attrs.put(oBAMServerHost);
        BasicAttribute oBAMServerPort = new BasicAttribute(CONN_PAR_BAM_SERVER_PORT, CONN_PAR_DEFAULT_PORT);
        attrs.put(oBAMServerPort);
        BasicAttribute oBAMWebTierProtocol = new BasicAttribute(CONN_PAR_BAM_SERVER_PROTOCOL, bamConnection.getProtocol());
        attrs.put(oBAMWebTierProtocol);
        ConnectionFactory connFactory = new ConnectionFactory();
        Referenceable ref = null;
        try {
            ref = connFactory.newInstance(bamConnection.getConnName(), (Attributes)attrs, new SecureRefAddr[]{oPw});
        }
        catch (Exception ex) {
            this.m_oLogger.log(Level.WARNING, "createReferenceFromDescriptor exception: " + ex.getMessage());
        }
        return ref;
    }

    private String uniqueConnName() {
        String formatedName;
        String uniqueName = formatedName = BAMDCResourceBundle.getInstance().getString("BAM_CONNECTION_MIGRATED");
        try {
            uniqueName = new BAMConnectionLookup().uniqueConnName(formatedName);
        }
        catch (NamingException e) {
            this.m_oLogger.log(Level.WARNING, "could not obtain unique name for BAM connection.\nException message: " + e.getMessage());
        }
        return uniqueName;
    }

    private List<BAMConnection> getBAMCONNConnections(String strBPELFile) {
        File fileBAMConn = new File(strBPELFile);
        Document docBAMCONNFile = null;
        ArrayList<BAMConnection> oListBAMConns = new ArrayList<BAMConnection>();
        if (fileBAMConn.isFile()) {
            DocumentBuilder builder = null;
            try {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException pex) {
                builder = null;
                return oListBAMConns;
            }
            try {
                docBAMCONNFile = builder.parse(new File(strBPELFile));
            }
            catch (SAXException saxex) {
                builder = null;
            }
            catch (IOException ioex) {
                docBAMCONNFile = null;
            }
            NodeList oNodeList = null;
            try {
                oNodeList = docBAMCONNFile.getChildNodes();
            }
            catch (Exception ex) {
                this.m_oLogger.log(Level.WARNING, "getBAMCONNConnections exception: " + ex.getMessage());
            }
            for (int i = 0; i < oNodeList.getLength(); ++i) {
                BAMConnection oBAMConnection = new BAMConnection();
                NodeList oChildNodes = oNodeList.item(i).getChildNodes();
                for (int j = 0; j < oChildNodes.getLength(); ++j) {
                    Node _oChildNode = oChildNodes.item(j);
                    if (_oChildNode.getNodeName() != "BPELProcess") continue;
                    NodeList _oChildNodes = _oChildNode.getChildNodes();
                    for (int k = 0; k < _oChildNodes.getLength(); ++k) {
                        Node oChildNode = _oChildNodes.item(k);
                        if (oChildNode.getNodeName() != "preferences") continue;
                        NodeList oBAMChildNodes = oChildNode.getChildNodes();
                        for (int h = 0; h < oBAMChildNodes.getLength(); ++h) {
                            Node oBAMChildNode = oBAMChildNodes.item(h);
                            if (!oBAMChildNode.getNodeName().equalsIgnoreCase("property")) continue;
                            String strNameVal = oBAMChildNode.getAttributes().getNamedItem("name").getTextContent();
                            if (strNameVal.equalsIgnoreCase("bamserver.hostname")) {
                                oBAMConnection.setHostName(oBAMChildNode.getTextContent());
                                continue;
                            }
                            if (strNameVal.equalsIgnoreCase("bamserver.protocol")) {
                                oBAMConnection.setProtocol(oBAMChildNode.getTextContent());
                                continue;
                            }
                            if (strNameVal.equalsIgnoreCase("bamserver.username")) {
                                oBAMConnection.setUserName(oBAMChildNode.getTextContent());
                                continue;
                            }
                            if (strNameVal.equalsIgnoreCase("bamserver.password")) {
                                String strEncryptedPw;
                                String strDecriptedPw = strEncryptedPw = oBAMChildNode.getTextContent();
                                String strEncryptionAttr = oBAMChildNode.getAttributes().getNamedItem("encryption").getTextContent();
                                if (!"plaintext".equals(strEncryptionAttr)) {
                                    try {
                                        strDecriptedPw = CXLegacyPassowrdDecrypter.decrypt("CRYPT{" + strEncryptedPw + "}");
                                    }
                                    catch (Exception e) {
                                        strDecriptedPw = "";
                                        this.m_oLogger.log(Level.WARNING, "getBAMCONNConnections encrypt exception: " + e.getMessage() + "\npassword set to empty String");
                                    }
                                }
                                oBAMConnection.setPassword(strDecriptedPw);
                                continue;
                            }
                            if (strNameVal.equalsIgnoreCase("bamserver.domain")) {
                                oBAMConnection.setDomain(oBAMChildNode.getTextContent());
                                continue;
                            }
                            if (!strNameVal.equalsIgnoreCase("bamserver.port")) continue;
                            oBAMConnection.setPort(oBAMChildNode.getTextContent());
                        }
                    }
                }
                if (oBAMConnection.getHostName() == null) continue;
                oListBAMConns.add(oBAMConnection);
            }
        }
        return oListBAMConns;
    }

    public void registryBAMConnections(final Workspace workspace, Project project) {
        if (this.bamConnections.size() > 0) {
            project.addNodeListener(new NodeListener(){

                public void nodeOpened(NodeEvent event) {
                    try {
                        Context context = Context.newIdeContext();
                        context.setWorkspace(workspace);
                        context.setProject((Project)event.getNode());
                        RescatContextRegistry registry = RescatContextRegistry.getInstance();
                        RescatContext rescatCtx = registry.getWorkspaceContext(workspace);
                        if (rescatCtx == null) {
                            rescatCtx = registry.getResourcePaletteContext();
                        }
                        BAMConnection oConn = (BAMConnection)BAMConnectionPlugin.this.bamConnections.get(BAMConnectionPlugin.this.bamConnections.size() - 1);
                        oConn.setConnName(BAMConnectionPlugin.this.uniqueConnName());
                        AdfJndiContext connCtx = rescatCtx.getConnectionContext();
                        Referenceable ref = BAMConnectionPlugin.this.createReferenceFromDescriptor(oConn);
                        connCtx.bind(oConn.getConnName(), (Object)ref);
                        rescatCtx.flushChanges();
                        connCtx.save();
                    }
                    catch (Exception ex) {
                        BAMConnectionPlugin.this.m_oLogger.log(Level.WARNING, "save connection exception: " + ex.getMessage());
                    }
                }
            });
        }
    }

    private static class Base64DecoderStream
    extends FilterInputStream {
        byte[] mBuffer;
        int mSize;
        int mIndex;
        static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        static final byte[] pem_convert_array = new byte[256];
        byte[] mDecodeBuffer = new byte[4];

        public Base64DecoderStream(InputStream is) {
            super(is);
            this.mBuffer = new byte[3];
        }

        @Override
        public int read() throws IOException {
            if (this.mIndex >= this.mSize) {
                this.decode();
                if (this.mSize == 0) {
                    return -1;
                }
                this.mIndex = 0;
            }
            return this.mBuffer[this.mIndex++] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int i;
            for (i = 0; i < len; ++i) {
                int j = this.read();
                if (j == -1) {
                    if (i != 0) break;
                    i = -1;
                    break;
                }
                b[off + i] = (byte)j;
            }
            return i;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int available() throws IOException {
            return this.in.available() * 3 / 4 + (this.mSize - this.mIndex);
        }

        private void decode() throws IOException {
            this.mSize = 0;
            int i = 0;
            while (i < 4) {
                int j = this.in.read();
                if (j == -1) {
                    if (i == 0) {
                        return;
                    }
                    throw new IOException("Error in encoded stream, got " + i);
                }
                if ((j < 0 || j >= 256 || j != 61) && pem_convert_array[j] == -1) continue;
                this.mDecodeBuffer[i++] = (byte)j;
            }
            byte b1 = pem_convert_array[this.mDecodeBuffer[0] & 0xFF];
            byte b2 = pem_convert_array[this.mDecodeBuffer[1] & 0xFF];
            this.mBuffer[this.mSize++] = (byte)(b1 << 2 & 0xFC | b2 >>> 4 & 3);
            if (this.mDecodeBuffer[2] == 61) {
                return;
            }
            b1 = b2;
            b2 = pem_convert_array[this.mDecodeBuffer[2] & 0xFF];
            this.mBuffer[this.mSize++] = (byte)(b1 << 4 & 0xF0 | b2 >>> 2 & 0xF);
            if (this.mDecodeBuffer[3] == 61) {
                return;
            }
            byte b3 = b2;
            b2 = pem_convert_array[this.mDecodeBuffer[3] & 0xFF];
            this.mBuffer[this.mSize++] = (byte)(b3 << 6 & 0xC0 | b2 & 0x3F);
        }

        public static byte[] decode(byte[] ab) {
            return Base64DecoderStream.decode(ab, 0, ab.length);
        }

        public static byte[] decode(byte[] ab, int off, int len) {
            int didx;
            int slen;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(len);
            for (int i = 0; i < len; ++i) {
                byte b = ab[off + i];
                if ((b < 0 || b >= 256 || b != 61) && pem_convert_array[b] == -1) continue;
                baos.write(b);
            }
            byte[] data = baos.toByteArray();
            int tail = slen = data.length;
            while (data[tail - 1] == 61) {
                --tail;
            }
            byte[] dest = new byte[tail - slen / 4];
            for (int idx = 0; idx < slen; ++idx) {
                data[idx] = pem_convert_array[data[idx] & 0xFF];
            }
            int sidx = 0;
            int dlen = dest.length - 2;
            for (didx = 0; didx < dlen; didx += 3) {
                dest[didx] = (byte)(data[sidx] << 2 & 0xFC | data[sidx + 1] >>> 4 & 3);
                dest[didx + 1] = (byte)(data[sidx + 1] << 4 & 0xF0 | data[sidx + 2] >>> 2 & 0xF);
                dest[didx + 2] = (byte)(data[sidx + 2] << 6 & 0xC0 | data[sidx + 3] & 0x3F);
                sidx += 4;
            }
            if (didx < dest.length) {
                dest[didx] = (byte)(data[sidx] << 2 & 0xFC | data[sidx + 1] >>> 4 & 3);
            }
            if (++didx < dest.length) {
                dest[didx] = (byte)(data[sidx + 1] << 4 & 0xF0 | data[sidx + 2] >>> 2 & 0xF);
            }
            return dest;
        }

        static {
            for (int i = 0; i < 255; ++i) {
                Base64DecoderStream.pem_convert_array[i] = -1;
            }
            for (int j = 0; j < pem_array.length; ++j) {
                Base64DecoderStream.pem_convert_array[Base64DecoderStream.pem_array[j]] = (byte)j;
            }
        }
    }

    private static class des {
        private static final String CIPHER_KEY = "01AE399D61D40E14C03D91AC03B3E702";
        protected static final String CIPHER_TRANSFORMATION = "DESede/ECB/PKCS5Padding";

        private des() {
        }

        public static String decrypt(byte[] cipherText) throws Exception {
            Cipher cipher = des.getCipher(2);
            return new String(cipher.doFinal(cipherText));
        }

        private static Cipher getCipher(int mode) throws Exception {
            SunJCE sunJCE = new SunJCE();
            Security.addProvider(sunJCE);
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec pbSpec = new DESedeKeySpec(CIPHER_KEY.getBytes());
            SecretKey key = keyFac.generateSecret(pbSpec);
            cipher.init(mode, key);
            return cipher;
        }
    }

    private static class CXLegacyPassowrdDecrypter {
        private static final String PREFIX = "CRYPT{";
        private static final String SUFFIX = "}";

        private CXLegacyPassowrdDecrypter() {
        }

        public static String decrypt(String cipherText) throws Exception {
            if (cipherText == null) {
                return null;
            }
            if (cipherText.startsWith(PREFIX) && cipherText.endsWith(SUFFIX)) {
                String key = cipherText.substring(PREFIX.length(), cipherText.length() - SUFFIX.length());
                byte[] bkey = key.getBytes();
                String clearKey = des.decrypt(Base64DecoderStream.decode(bkey, 0, bkey.length));
                return clearKey;
            }
            return cipherText;
        }
    }

    class BAMConnection {
        private String m_username;
        private String m_password;
        private String m_hostname;
        private String m_port;
        private String m_domain;
        private String m_connName;
        private String m_protocol;

        public BAMConnection() {
        }

        public BAMConnection(String hostName, String port, String domainName, String user, String pass, String connName, boolean useSSL) {
            this.m_hostname = hostName;
            this.m_domain = domainName;
            this.m_port = port;
            this.m_username = user;
            this.m_password = pass;
            this.m_connName = connName;
            this.m_protocol = useSSL ? BAMConnectionPlugin.HTTPS_PROTOCOL : BAMConnectionPlugin.HTTP_PROTOCOL;
        }

        public String getDomain() {
            return this.m_domain;
        }

        public void setDomain(String domain) {
            this.m_domain = domain;
        }

        public boolean isSecure() {
            if (this.m_protocol != null) {
                return this.m_protocol.equals(BAMConnectionPlugin.HTTPS_PROTOCOL);
            }
            return false;
        }

        public String getProtocol() {
            return this.m_protocol;
        }

        public void useSSL(boolean flag) {
            this.m_protocol = flag ? BAMConnectionPlugin.HTTPS_PROTOCOL : BAMConnectionPlugin.HTTP_PROTOCOL;
        }

        public String getUserName() {
            return this.m_username;
        }

        public String getPassword() {
            return this.m_password;
        }

        public String getHostName() {
            return this.m_hostname;
        }

        public String getPort() {
            return this.m_port;
        }

        public String getConnName() {
            return this.m_connName;
        }

        public void setConnName(String connName) {
            this.m_connName = connName;
        }

        public void setUserName(String username) {
            this.m_username = username;
        }

        public void setPassword(String password) {
            this.m_password = password;
        }

        public void setHostName(String hostname) {
            this.m_hostname = hostname;
        }

        public void setProtocol(String protocol) {
            this.m_protocol = protocol;
        }

        public void setPort(String port) {
            this.m_port = port;
        }
    }
}

