/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bam;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class BAMBatchParamDialog
extends JDialog
implements ActionListener {
    protected NumberTextField m_lowerField;
    protected NumberTextField m_upperField;
    protected NumberTextField m_timeoutField;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected Number m_lower;
    protected Number m_upper;
    protected Number m_timeout;
    protected boolean m_default = true;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    protected int m_retVal = 2;
    protected JCheckBox m_defaultCheckBox;
    private int m_defaultLower = 1000;
    private int m_defaultUpper = 5000;
    private int m_defaultTimeout = 50;

    public BAMBatchParamDialog(JFrame frame, int lower, int upper, int timeout, boolean isDefault) {
        super(frame, BPELStringTranslator.getString("BATCH_PARAMETERS"), true);
        this.m_lower = new Integer(lower);
        this.m_upper = new Integer(upper);
        this.m_timeout = new Integer(timeout);
        this.m_default = isDefault;
        this.createControls();
        this.layoutControls();
        this.setLocationRelativeTo(frame);
    }

    protected void createControls() {
        this.m_defaultCheckBox = new JCheckBox(BPELStringTranslator.getString("CHK_USE_DEFAULT_BATCH_PARAM"));
        this.m_defaultCheckBox.addActionListener(this);
        this.m_defaultCheckBox.setSelected(this.m_default);
        this.m_lowerField = new NumberTextField();
        this.m_lowerField.setNumber(this.m_lower);
        this.m_upperField = new NumberTextField();
        this.m_upperField.setNumber(this.m_upper);
        this.m_timeoutField = new NumberTextField();
        this.m_timeoutField.setNumber(this.m_timeout);
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL"));
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn.addActionListener(this);
        if (this.m_default) {
            this.m_lowerField.setEnabled(false);
            this.m_upperField.setEnabled(false);
            this.m_timeoutField.setEnabled(false);
        }
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        this.setSize(350, 210);
        this.setTitle(BPELStringTranslator.getString("BATCH_PARAMETERS"));
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)container, (Component)this.m_defaultCheckBox, (int)0, (int)0, (int)2, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)new JLabel(BPELStringTranslator.getString("LBL_BATCH_LOW_LIMIT")), (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)this.m_lowerField, (int)1, (int)1, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)new JLabel(BPELStringTranslator.getString("LBL_BATCH_HIGH_LIMIT")), (int)0, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)this.m_upperField, (int)1, (int)2, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)new JLabel(BPELStringTranslator.getString("LBL_TIMEOUT")), (int)0, (int)3, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)1.0);
        GraphUtils.addComponent((Container)container, (Component)this.m_timeoutField, (int)1, (int)3, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)container, (Component)this.m_helpBtn, (int)0, (int)4, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(10, 10, 10, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)container, (Component)btnPnl, (int)1, (int)4, (int)1, (int)1, (int)14, (int)0, (Insets)new Insets(10, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    public int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_defaultCheckBox) {
            this.m_lowerField.setEnabled(!this.m_defaultCheckBox.isSelected());
            this.m_upperField.setEnabled(!this.m_defaultCheckBox.isSelected());
            this.m_timeoutField.setEnabled(!this.m_defaultCheckBox.isSelected());
            this.m_lowerField.setText(this.m_defaultLower + "");
            this.m_upperField.setText(this.m_defaultUpper + "");
            this.m_timeoutField.setText(this.m_defaultTimeout + "");
        }
        if (src == this.m_okBtn) {
            if (this.validateParams()) {
                this.dispose();
                this.m_retVal = 1;
            }
        } else if (src == this.m_cancelBtn) {
            this.m_retVal = 2;
            this.dispose();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void helpInvoked() {
        HelpSystem help = HelpSystem.getHelpSystem();
        help.registerClientWindow((Window)this);
        help.goTo("bpmjdev_bam_batch_props");
        help.unregisterClientWindow((Window)this);
    }

    public int getLowerLimit() {
        return this.m_lower.intValue();
    }

    public int getUpperLimit() {
        return this.m_upper.intValue();
    }

    public int getTimeout() {
        return this.m_timeout.intValue();
    }

    public boolean isDefault() {
        return this.m_defaultCheckBox.isSelected();
    }

    protected boolean validateParams() {
        this.m_lower = this.m_lowerField.getNumber();
        this.m_upper = this.m_upperField.getNumber();
        this.m_timeout = this.m_timeoutField.getNumber();
        return true;
    }
}

