/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.ide.bpel.jdeveloper;

import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpeldesigner.util.WSDLPropertyUtil;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ide.bpel.BPELProjectUtil;
import oracle.tip.tools.ide.common.ide.jdeveloper.JDevProject;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.model.SCAComposite;
import oracle.tip.tools.ide.fabric.model.SCAModelBuilder;
import oracle.tip.tools.ide.fabric.model.SCAModelBuilderException;
import oracle.tip.tools.ide.pm.modules.sca.ide.BPELDesignerDeploymentFile;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;

public class JDevBPELProject
extends JDevProject
implements BPELProject {
    protected String m_processName;
    protected SCAProject m_scaProject;
    protected DeploymentFile m_deploymentFile;

    public JDevBPELProject(Project project, String processName) {
        super(project);
        this.m_scaProject = SCAProject.getSCAProject((Project)project);
        this.m_processName = processName;
    }

    public JDevBPELProject(Project p) {
        super(p);
        this.m_scaProject = SCAProject.getSCAProject((Project)p);
    }

    public Object getSCAProject() {
        return this.m_scaProject;
    }

    public String getProcessName() {
        return this.m_processName;
    }

    public URL getBPELDirectoryURL() {
        return this.m_scaProject.getSCARoot();
    }

    public URL getDeploymentFileURL() {
        return URLFactory.newURL((URL)this.getBPELDirectoryURL(), (String)(this.m_processName + ".componentType"));
    }

    public URL getGraphicsFileURL() {
        return URLFactory.newURL((URL)this.getDesignerDirectoryURL(), (String)(this.m_processName + "_" + "graphics.xml"));
    }

    public URL getThumbnailDirectory() {
        URL thumbDir = URLFactory.newDirURL((URL)this.getBPELDirectoryURL(), (String)this.m_processName);
        if (!URLFileSystem.exists((URL)thumbDir)) {
            URLFileSystem.mkdir((URL)thumbDir);
        }
        return URLFactory.newDirURL((URL)thumbDir, (String)"thumbnail");
    }

    public DeploymentFile getDeploymentFile() {
        if (this.m_deploymentFile == null) {
            this.m_deploymentFile = new BPELDesignerDeploymentFile(this.m_processName, this.m_project);
        }
        return this.m_deploymentFile;
    }

    public URL getWSDLFileURL(String processName) {
        if (this.m_project != null) {
            String key = processName + "_wsdl";
            HashStructure hash = this.m_project.getProperties();
            String wsdlFile = hash.getString(key);
            if (wsdlFile != null) {
                return URLFactory.newURL((URL)this.getWSDLRoot(), (String)wsdlFile);
            }
            return URLFactory.newURL((URL)this.getWSDLRoot(), (String)(processName + ".wsdl"));
        }
        return null;
    }

    public URL getWSDLRoot() {
        return this.m_scaProject.getWSDLRoot();
    }

    public URL getBPELFileURL() {
        if (this.getProjectData("bpelFileURL") != null) {
            return (URL)this.getProjectData("bpelFileURL");
        }
        if (this.m_processName != null) {
            return URLFactory.newURL((URL)this.getBPELDirectoryURL(), (String)(this.m_processName + ".bpel"));
        }
        if (this.m_project != null) {
            String processName = this.m_project.getProperty("ProcessName");
            return URLFactory.newURL((URL)this.getBPELDirectoryURL(), (String)(processName + ".bpel"));
        }
        return null;
    }

    public URL getXSDRoot() {
        return this.m_scaProject.getXSDRoot();
    }

    public URL getXSLRoot() {
        return this.m_scaProject.getXSLRoot();
    }

    public void storeProjectData(String key, Object value) {
        if (this.m_processName != null) {
            key = this.m_processName + "_" + key;
        }
        super.storeProjectData(key, value);
    }

    public Object getProjectData(String key) {
        Object o = null;
        if (this.m_processName != null && !key.equals("HashStructure") && (o = super.getProjectData(this.m_processName + "_" + key)) != null) {
            return o;
        }
        return super.getProjectData(key);
    }

    public SCAComposite getSCAComposite() {
        SCAProject project = this.m_scaProject;
        if (project == null) {
            return null;
        }
        Project prj = project.getProject();
        SCAModelBuilder modelBuilder = SCAModelBuilder.getSCAModelBuilder((Project)prj);
        try {
            return modelBuilder.getSCAComposite();
        }
        catch (SCAModelBuilderException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getResourceUsageCount(URL resourceURL) {
        if (resourceURL == null) {
            return -1;
        }
        String fileName = URLFileSystem.getFileName((URL)resourceURL);
        if (fileName == null) {
            return -1;
        }
        if ((fileName = fileName.toLowerCase().trim()).endsWith(".wsdl")) {
            SCAController controller = JDevSCAIntegrationUtil.getSCAController((Project)this.getProjectContext());
            return controller.getWsdlUsageCount(resourceURL);
        }
        return -1;
    }

    public URL getDesignerDirectoryURL() {
        return URLFactory.newDirURL((URL)this.getBPELDirectoryURL(), (String)".designer");
    }

    public URL getProjectURL() {
        URL projUrl = super.getProjectURL();
        if (projUrl != null) {
            return projUrl;
        }
        return URLFileSystem.getParent((URL)((URL)this.getProjectData("bpelFileURL")));
    }

    public URL getThumbnailURL() {
        return URLFactory.newURL((URL)this.getThumbnailDirectory(), (String)"thumbnail.jpg");
    }

    public void setProject(Project p) {
        this.m_project = p;
        this.m_scaProject = SCAProject.getSCAProject((Project)p);
    }

    public Project getProject() {
        return this.m_project;
    }

    public Definition getWSDLFileDefinition() {
        try {
            String processName = this.getProcessName();
            URL u = this.getWSDLFileURL(processName);
            if (u != null && Helper.exists((URL)u)) {
                return WSDLUtil.parseWSDL((URL)u);
            }
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public URL getSensorActionURL() {
        return BPELProjectUtil.getSensorActionURL((BPELProject)this);
    }

    public URL getSensorsURL() {
        return BPELProjectUtil.getSensorsURL((BPELProject)this);
    }

    public URL getPropertiesWSDLURL() {
        return WSDLPropertyUtil.getPropertyWSDL((BPELProject)this, (boolean)true);
    }
}

