/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.headless;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.JFrame;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.ParserContext;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.view.NodeRendererFactory;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.CollaxaNodeRendererFactory;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.w3c.dom.Document;

public class HeadlessBPELDesigner {
    public URL loadProcess(URL bpelFile, URL imageFile) throws Exception {
        BPELParser.setXMLEditingFramework((boolean)false);
        BPELStringTranslator.initialize();
        Document doc = XMLHelper.loadDocument((URL)bpelFile);
        Process process = (Process)BPELParser.createImplementation(Process.class);
        process.setDOMElement(doc.getDocumentElement());
        ParserContext parserContext = process.createParserContext();
        parserContext.setProcessURL(bpelFile);
        process.readFromElement(doc.getDocumentElement(), parserContext, true);
        GraphModel graphModel = new ModelBuilder().build(process);
        BPELGraphPane graph = new BPELGraphPane();
        graph.setNodeRendererFactory((NodeRendererFactory)new CollaxaNodeRendererFactory());
        boolean bUseframe = false;
        if (bUseframe) {
            JFrame f = new JFrame();
            f.setBounds(10, 10, 600, 600);
            f.getContentPane().add((Component)((Object)graph));
            graph.setModel(graphModel);
            f.pack();
            graph.saveImageToFile(new URL("file:/c:/horst/headless.jpg"));
        } else {
            graph.setModel(graphModel);
            graph.clearCachedDimensions();
            graph.expandDiagram();
            Dimension d = graph.getPreferredSize();
            graph.setSize(d);
            Rectangle bounds = graph.getBounds();
            GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            GraphicsConfiguration config = device.getDefaultConfiguration();
            BufferedImage pageImage = config.createCompatibleImage(d.width, d.height);
            Graphics offGraphics = pageImage.getGraphics();
            offGraphics.setColor(Color.white);
            offGraphics.fillRect(0, 0, bounds.width, bounds.height);
            offGraphics.setClip(0, 0, bounds.width, bounds.height);
            graph.paint(offGraphics);
            JPEGTranscoder trans = new JPEGTranscoder();
            trans.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.9));
            BufferedImage jpgImg = trans.createImage(pageImage.getWidth(null), pageImage.getHeight(null));
            Graphics2D g2d = jpgImg.createGraphics();
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, jpgImg.getWidth(null), jpgImg.getHeight(null));
            g2d.drawImage(pageImage, null, 0, 0);
            BufferedOutputStream ostream = new BufferedOutputStream(URLFileSystem.openOutputStream((URL)imageFile));
            trans.writeImage(jpgImg, new TranscoderOutput((OutputStream)ostream));
            ((OutputStream)ostream).flush();
            ((OutputStream)ostream).close();
        }
        return bpelFile;
    }

    public static void main(String[] args) {
        HeadlessBPELDesigner.test();
    }

    public static void test() {
        HeadlessBPELDesigner designer = new HeadlessBPELDesigner();
        try {
            URL bpelFile = new URL("file:/C:/JDeveloper/mywork/Application12/SOAComposite1/AsyncProcess1.bpel");
            URL imageFile = new URL("file:/c:/horst/headless2.jpg");
            designer.loadProcess(bpelFile, imageFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

