/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.processtree;

import java.awt.Color;
import java.awt.Component;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.ui.BaseTreeCellRenderer;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeCellRenderer;
import oracle.tip.tools.ide.pm.gui.processtree.ActivityInfo;
import oracle.tip.tools.ide.pm.gui.processtree.ProcessTreeNodeTypes;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ProcessTreeCellRenderer
extends BaseTreeCellRenderer
implements Accessible,
ProcessTreeNodeTypes {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon folderIcon;
        this.m_bHasFocus = hasFocus;
        this.m_bSelected = selected;
        this.m_iconLst.clear();
        this.m_textLst.clear();
        Icon icon = folderIcon = expanded ? ImageCache.getIcon("application/bpel/folder.png") : ImageCache.getIcon("application/bpel/folder_closed.png");
        if (!(value instanceof DefaultMutableTreeNode)) {
            return this;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node instanceof DummyNode) {
            TextInfo info = this.createTextInfo(" " + BPELStringTranslator.getString("LOADING"), this.m_font, Color.black);
            this.m_iconLst.add(GlobalImageCache.getIcon((String)"hourglass.png"));
            this.m_textLst.add(info);
            return this;
        }
        Object userObj = node.getUserObject();
        if (userObj instanceof ExplorerTreeNode) {
            String text = userObj.toString();
            TextInfo info = this.createTextInfo(text, this.m_font, Color.black);
            this.m_textLst.add(info);
            ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)userObj;
            switch (explorerTreeNode.m_type) {
                case 2: {
                    ActivityInfo actInfo = (ActivityInfo)explorerTreeNode.m_data;
                    Activity activity = actInfo.getActivity();
                    this.m_iconLst.add(ExplorerTreeCellRenderer.getActivityIcon(activity));
                    if (!actInfo.isSensored()) break;
                    this.m_iconLst.add(ImageCache.getIcon("activity_sensor_node"));
                    break;
                }
            }
        }
        if (this.m_iconLst.size() == 0) {
            this.m_iconLst.add(folderIcon);
        }
        String tip = this.getTipText();
        this.setText(tip);
        this.setToolTipText(tip);
        return this;
    }
}

