/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.processtree;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Catch;
import oracle.tip.tools.ide.common.bpelparser.iface.CatchAll;
import oracle.tip.tools.ide.common.bpelparser.iface.CompensationHandler;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.EventHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.FaultHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.OnAlarm;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.JTreeCellRendererExtendor;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.gui.processtree.ActivityInfo;
import oracle.tip.tools.ide.pm.gui.processtree.ProcessTreeCellRenderer;
import oracle.tip.tools.ide.pm.gui.processtree.ProcessTreeNodeTypes;

public class ProcessTree
extends JPanel
implements ProcessTreeNodeTypes {
    protected JTree m_tree;
    protected Process m_process;

    public ProcessTree() {
        this.createControls();
        this.layoutControls();
    }

    public void load(Process p) {
        this.m_process = p;
        final TreeModel model = this.buildTreeModel();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ProcessTree.this.m_tree.setModel(model);
                UIHelper.expandTree((JTree)ProcessTree.this.m_tree);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public Activity getSelectedActivity() {
        TreePath p = this.m_tree.getSelectionPath();
        if (p == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)p.getLastPathComponent();
        ExplorerTreeNode en = (ExplorerTreeNode)node.getUserObject();
        if (en.m_type == 2) {
            ActivityInfo info = (ActivityInfo)en.getUserData();
            return info.getActivity();
        }
        return null;
    }

    protected void createControls() {
        this.m_tree = new JTree();
        this.m_tree.setRowHeight(18);
        this.m_tree.setCellRenderer((TreeCellRenderer)((Object)new ProcessTreeCellRenderer()));
        new JTreeCellRendererExtendor(this.m_tree);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)new JScrollPane(this.m_tree), (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected TreeModel buildTreeModel() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        ExplorerTreeNode explorerNode = new ExplorerTreeNode("BPEL Process", 0, (Object)this.m_process);
        rootNode.setUserObject(explorerNode);
        DefaultMutableTreeNode structureNode = new DefaultMutableTreeNode();
        explorerNode = new ExplorerTreeNode("Activities", 1, null);
        structureNode.setUserObject(explorerNode);
        DefaultMutableTreeNode node = this.buildActivityStructure(this.m_process);
        structureNode.add(node);
        rootNode.add(structureNode);
        return new DefaultTreeModel(rootNode);
    }

    protected DefaultMutableTreeNode buildActivityStructure(Process process) {
        DefaultMutableTreeNode processNode = new DefaultMutableTreeNode();
        ExplorerTreeNode explorerNode = new ExplorerTreeNode("Process " + process.getName(), 2, (Object)new ActivityInfo((Activity)process));
        processNode.setUserObject(explorerNode);
        this.populateChildActivitiesNode(processNode, (ContainerActivity)process);
        return processNode;
    }

    protected void populateChildActivitiesNode(DefaultMutableTreeNode parent, ContainerActivity parentActivity) {
        List activitiesLst = parentActivity.getActivityList();
        if (activitiesLst == null) {
            return;
        }
        for (Activity a : activitiesLst) {
            String txt = BPELModelUtil.getTypeForActivity((Activity)a);
            if (a.getName() != null) {
                txt = txt + " - " + a.getName();
            }
            ActivityInfo info = new ActivityInfo(a);
            DefaultMutableTreeNode activityNode = new DefaultMutableTreeNode(new ExplorerTreeNode(txt, 2, (Object)info));
            if (a instanceof ContainerActivity) {
                ContainerActivity c = (ContainerActivity)a;
                this.populateChildActivitiesNode(activityNode, c);
            }
            parent.add(activityNode);
        }
        if (parentActivity instanceof Scope) {
            Scope s = (Scope)parentActivity;
            this.populateFaultHandlers(parent, s.getFaultHandlers());
            this.populateCompensationHandler(parent, s.getCompensationHandler());
            this.populateEventHandlers(parent, s.getEventHandlers());
        }
    }

    protected void populateEventHandlers(DefaultMutableTreeNode parent, EventHandlers eventHandlers) {
        ActivityInfo info;
        if (eventHandlers == null || parent == null) {
            return;
        }
        DefaultMutableTreeNode eventHandlersNode = new DefaultMutableTreeNode(new ExplorerTreeNode("EVENT_HANDLERS", 3, (Object)eventHandlers));
        parent.add(eventHandlersNode);
        for (OnAlarm o : eventHandlers.getOnAlarms()) {
            info = new ActivityInfo((Activity)o);
            DefaultMutableTreeNode onAlarmNode = new DefaultMutableTreeNode(new ExplorerTreeNode("OnAlarm", 2, (Object)info));
            eventHandlersNode.add(onAlarmNode);
            this.populateChildActivitiesNode(onAlarmNode, (ContainerActivity)o);
        }
        for (OnAlarm o : eventHandlers.getOnMessages()) {
            info = new ActivityInfo((Activity)o);
            DefaultMutableTreeNode onMessageNode = new DefaultMutableTreeNode(new ExplorerTreeNode("Onmessage", 2, (Object)info));
            eventHandlersNode.add(onMessageNode);
            this.populateChildActivitiesNode(onMessageNode, (ContainerActivity)o);
        }
    }

    protected void populateCompensationHandler(DefaultMutableTreeNode parent, CompensationHandler compHandler) {
        if (compHandler == null || parent == null) {
            return;
        }
        ActivityInfo info = new ActivityInfo((Activity)compHandler);
        DefaultMutableTreeNode compHandlerNode = new DefaultMutableTreeNode(new ExplorerTreeNode("COMPENSATION_HANDLER", 4, (Object)info));
        parent.add(compHandlerNode);
        this.populateChildActivitiesNode(compHandlerNode, (ContainerActivity)compHandler);
    }

    protected void populateFaultHandlers(DefaultMutableTreeNode parent, FaultHandlers faultHandlers) {
        CatchAll catchAll;
        if (faultHandlers == null || parent == null) {
            return;
        }
        DefaultMutableTreeNode faultHandlersNode = null;
        List catches = faultHandlers.getCatches();
        if (catches != null) {
            faultHandlersNode = new DefaultMutableTreeNode(new ExplorerTreeNode("FaultHandlers", 5, (Object)faultHandlers));
            parent.add(faultHandlersNode);
            for (Catch o : catches) {
                ActivityInfo info = new ActivityInfo((Activity)o);
                DefaultMutableTreeNode catchNode = new DefaultMutableTreeNode(new ExplorerTreeNode("Catch", 2, (Object)info));
                faultHandlersNode.add(catchNode);
                this.populateChildActivitiesNode(catchNode, (ContainerActivity)o);
            }
        }
        if ((catchAll = faultHandlers.getCatchAll()) != null) {
            if (faultHandlersNode == null) {
                faultHandlersNode = new DefaultMutableTreeNode(new ExplorerTreeNode("FaultHandlers", 5, (Object)faultHandlers));
                parent.add(faultHandlersNode);
            }
            ActivityInfo info = new ActivityInfo((Activity)catchAll);
            DefaultMutableTreeNode catchAllNode = new DefaultMutableTreeNode(new ExplorerTreeNode("CATCH_ALL", 2, (Object)info));
            faultHandlersNode.add(catchAllNode);
            this.populateChildActivitiesNode(catchAllNode, (ContainerActivity)catchAll);
        }
    }
}

