/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.generalpurpose;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class TablePanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JButton m_createBtn;
    protected JButton m_removeBtn;
    protected JButton m_editBtn;
    protected JTable m_table;
    protected JLabel m_tableLbl;
    protected ToolBar m_toolBar;
    protected Insets m_insets;

    public TablePanel(BaseTableModel tabModel) {
        this(tabModel, new Insets(0, 0, 0, 0));
    }

    public TablePanel() {
        this(new BaseTableModel(), new Insets(0, 0, 0, 0));
    }

    public void setTableLabelText(String s) {
        BPELStringTranslator.setLabel(this.m_tableLbl, this.m_table, s);
    }

    public TablePanel(BaseTableModel tabModel, Insets insets) {
        this.m_insets = insets;
        this.m_table = new JTable((TableModel)tabModel);
        this.m_tableLbl = new JLabel();
        this.m_createBtn = UIHelper.createToolBarButton((int)0);
        this.m_removeBtn = UIHelper.createToolBarButton((int)2);
        this.m_editBtn = UIHelper.createToolBarButton((int)1);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_createBtn);
        btnPnl.add(this.m_removeBtn);
        this.m_createBtn.addActionListener(this);
        this.m_editBtn.addActionListener(this);
        this.m_removeBtn.addActionListener(this);
        this.m_toolBar = new ToolBar();
        this.m_toolBar.setBorderInsets(new Insets(0, 0, 0, 0));
        this.m_toolBar.add((Component)this.m_createBtn);
        this.m_toolBar.add((Component)this.m_editBtn);
        this.m_toolBar.add((Component)this.m_removeBtn);
        this.setLayout(new GridBagLayout());
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.layoutControls();
    }

    public void layoutControls() {
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_tableLbl, (int)0, (int)0, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(this.m_insets.top, this.m_insets.left, 2, this.m_insets.right), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_toolBar, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(this.m_insets.top, 0, 0, this.m_insets.right), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.m_table), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, this.m_insets.left, this.m_insets.bottom, this.m_insets.right), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    public JTable getTable() {
        return this.m_table;
    }

    public void updateButtons() {
        ListSelectionModel model = this.m_table.getSelectionModel();
        this.m_removeBtn.setEnabled(!model.isSelectionEmpty());
        this.m_editBtn.setEnabled(!model.isSelectionEmpty());
    }

    public void performAdd() {
    }

    protected void doEdit(int row) {
    }

    public void performRemove() {
        TableModel model = this.m_table.getModel();
        if (model instanceof BaseTableModel) {
            BaseTableModel tabModel = (BaseTableModel)model;
            int[] rows = this.m_table.getSelectedRows();
            tabModel.removeRows(rows);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_createBtn) {
            this.performAdd();
        } else if (src == this.m_removeBtn) {
            this.performRemove();
        } else if (src == this.m_editBtn) {
            this.doEdit(this.m_table.getSelectedRow());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }
}

