/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.caches.VariableDocumentCache;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ElementAnyTypeExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeDataSource;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.RecursiveElementTypeExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.DynamicSchemaInfo;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.ResolvedDocumentCacheKey;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.ResolvedDocumentObj;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.SchemaResolvedObj;
import oracle.tip.tools.ide.common.bpeldesigner.models.wsdl.PartItem;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.common.utils.WSDLPartData;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.common.xsdgrammar.SchemaBuilder;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.gui.explorer.VariableElementTypeExplorerTreeNode;
import org.w3c.dom.Element;

public class VariableMessagePartExplorerTreeNode
extends ExplorerTreeNode
implements ExplorerTreeDataSource {
    protected MessagePart m_part;
    protected Variable m_variable;
    protected Activity m_activity;
    protected Process m_process;
    protected BPELProject m_project;
    protected WSDLPartData m_wsdlPartData;
    protected BPELXmlModel m_mainModel;

    public VariableMessagePartExplorerTreeNode(String text, int type, Object data, BPELXmlModel mainModel, Variable var, Activity a) {
        super(text, type, data);
        this.m_mainModel = mainModel;
        this.m_activity = a;
        this.m_variable = var;
        this.m_process = mainModel.getProcess();
        this.m_project = mainModel.getBPELProject();
        this.m_part = (MessagePart)data;
    }

    public WSDLPartData getWSDLPartData() {
        return this.m_wsdlPartData;
    }

    public void setWSDLPartData(WSDLPartData part) {
        this.m_wsdlPartData = part;
    }

    public DefaultMutableTreeNode[] getChildNodes() {
        Variable var = this.m_variable;
        String rootElement = null;
        SchemaResolvedObj obj = null;
        String namespaceURI = null;
        PartItem part = new PartItem(this.m_wsdlPartData.getPartName(), this.m_wsdlPartData.getTargetNamespace(), this.m_wsdlPartData.getPartType(), this.m_wsdlPartData.getPartXSDType());
        try {
            boolean isElement = true;
            if (part != null) {
                rootElement = part.getPartType();
                namespaceURI = part.getNamespaceURI();
                isElement = part.getPartXSDType() != 2;
            } else {
                QName qname = var.getElement();
                if (qname == null) {
                    return new DefaultMutableTreeNode[0];
                }
                rootElement = qname.getLocalPart();
                namespaceURI = qname.getNamespaceURI();
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                return new DefaultMutableTreeNode[0];
            }
            WSDLModel wsdlModel = this.m_mainModel.getWSDLModel();
            obj = wsdlModel.resolveNamespace(this.m_process, namespaceURI, rootElement, isElement);
            if (obj == null) {
                return new DefaultMutableTreeNode[0];
            }
            QName rootQName = null;
            QName typeQName = null;
            if (part != null && part.getPartXSDType() == 2) {
                rootQName = new QName("", part.getPart());
                typeQName = new QName(namespaceURI, part.getPartType());
            } else {
                rootQName = new QName(namespaceURI, rootElement);
            }
            ResolvedDocumentCacheKey key = new ResolvedDocumentCacheKey(rootQName, typeQName);
            ResolvedDocumentObj rObj = null;
            MapperNSResolver resolver = this.m_process.getNSResolver();
            NSResolverFactory.fillNSFromProcess((MapperNSResolver)resolver, (Activity)this.m_activity, (Process)this.m_process);
            if (rObj == null) {
                rObj = SchemaResolvedObj.buildResolvedDocument((SchemaResolvedObj)obj, (QName)rootQName, (QName)typeQName, (MapperNSResolver)resolver);
                VariableDocumentCache.putResolvedDocumentObj((URL)this.m_project.getBPELFileURL(), (ResolvedDocumentCacheKey)key, (ResolvedDocumentObj)rObj);
            }
            if (rObj != null && rObj.getDocument() != null) {
                DefaultMutableTreeNode root = this.buildTreeNodes(rObj.getDocument().getDocumentElement(), rObj, resolver);
                ArrayList<TreeNode> l = new ArrayList<TreeNode>();
                for (int i = 0; i < root.getChildCount(); ++i) {
                    l.add(root.getChildAt(i));
                }
                return l.toArray(new DefaultMutableTreeNode[0]);
            }
        }
        catch (MalformedURLException me) {
            me.printStackTrace();
            ExplorerTreeNode n = new ExplorerTreeNode("Bad URL encountered!", 31, (Object)me);
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(n);
            return new DefaultMutableTreeNode[]{treeNode};
        }
        catch (Exception sge) {
            sge.printStackTrace();
            ExplorerTreeNode n = new ExplorerTreeNode("Problem building schema!", 31, (Object)sge);
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(n);
            return new DefaultMutableTreeNode[]{treeNode};
        }
        return new DefaultMutableTreeNode[0];
    }

    protected DefaultMutableTreeNode buildTreeNodes(Element parentElem, ResolvedDocumentObj rObj, MapperNSResolver resolver) {
        boolean bRecursiveNode = SchemaBuilder.isRecursiveStop((Element)parentElem);
        boolean bExpandStopped = SchemaBuilder.isExpandStopped((Element)parentElem);
        boolean bSupportAnyType = false;
        DynamicSchemaInfo info = (DynamicSchemaInfo)this.getData("ANYTYPE_SCHEMA_INFO_KEY");
        if (info != null) {
            QName qname = new QName(parentElem.getAttribute("namespace"), parentElem.getAttribute("localName"));
            if (SchemaBuilder.isAnyType((Element)parentElem) && info.getAnyTypeQName() != null && qname.equals(info.getAnyTypeQName())) {
                bSupportAnyType = true;
            }
        }
        ElementAnyTypeExplorerTreeNode parentNode = null;
        if (bRecursiveNode || bExpandStopped) {
            parentNode = new RecursiveElementTypeExplorerTreeNode(parentElem.getTagName(), 28, (Object)parentElem, rObj.getGrammarInfo(), bRecursiveNode, bExpandStopped);
        } else if (bSupportAnyType) {
            parentNode = new ElementAnyTypeExplorerTreeNode(parentElem.getTagName(), 28, (Object)parentElem);
            parentNode.storeData((Object)"ANYTYPE_SCHEMA_INFO_KEY", (Object)info);
        } else {
            parentNode = new ExplorerTreeNode(parentElem.getTagName(), 28, (Object)parentElem);
        }
        parentNode.storeData((Object)"UI_DOM_KEY", (Object)rObj.getDocument());
        parentNode.storeData((Object)"RESOLVER_KEY", (Object)resolver);
        DefaultMutableTreeNode parentTreeNode = new DefaultMutableTreeNode(parentNode);
        if (bRecursiveNode || bExpandStopped || bSupportAnyType) {
            parentTreeNode.add((MutableTreeNode)new DummyNode());
        } else {
            VariableElementTypeExplorerTreeNode.buildEntityKeyNode(parentTreeNode, parentElem, rObj.getGrammarInfo().getSchemaGrammars());
            Iterator it = XMLHelper.getChildElementIterator((Element)parentElem);
            while (it.hasNext()) {
                Element e = (Element)it.next();
                DefaultMutableTreeNode childTreeNode = this.buildTreeNodes(e, rObj, resolver);
                parentTreeNode.add(childTreeNode);
            }
        }
        return parentTreeNode;
    }
}

