/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.caches.VariableDocumentCache;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeDataSource;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.util.ConversionUtil;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.utils.WSDLPartData;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.gui.explorer.VariableElementTypeExplorerTreeNode;
import oracle.tip.tools.ide.pm.gui.explorer.VariableMessagePartExplorerTreeNode;

public class VariableExplorerTreeNode
extends ExplorerTreeNode
implements ExplorerTreeDataSource {
    protected Variable m_variable;
    protected Activity m_activity;
    protected MapperNSResolver m_resolver;
    protected Process m_process;
    protected BPELXmlModel m_bpelModel;

    public VariableExplorerTreeNode(String text, int type, Object data, BPELXmlModel bpelModel, Activity a) {
        super(text, type, data);
        this.m_activity = a;
        this.m_bpelModel = bpelModel;
        this.m_process = this.m_bpelModel.getProcess();
        this.m_variable = (Variable)data;
        this.m_resolver = this.m_process.getNSResolver();
        NSResolverFactory.fillNSFromProcess((MapperNSResolver)this.m_resolver, (Activity)this.m_activity, (Process)this.m_process);
        if (this.m_resolver != null) {
            this.storeData("RESOLVER_KEY", this.m_resolver);
        }
    }

    public static NamespaceResolver getNSResolver(Activity activity, Process process) {
        return NSResolverFactory.getPMNSResolver((Activity)activity, (Process)process);
    }

    public DefaultMutableTreeNode[] getChildNodes() {
        ArrayList<DefaultMutableTreeNode> nodes;
        block13: {
            Object dynaSchema;
            QName elemQName;
            block11: {
                ArrayList<WSDLPartData> partList;
                QName msgQName;
                BPELProject project;
                WSDLModel wsdlModel;
                block12: {
                    wsdlModel = this.m_bpelModel.getWSDLModel();
                    project = this.m_bpelModel.getBPELProject();
                    nodes = new ArrayList<DefaultMutableTreeNode>();
                    msgQName = this.m_variable.getMessageType();
                    elemQName = this.m_variable.getElement();
                    dynaSchema = this.getData("DynaSchema");
                    if (msgQName == null) break block11;
                    partList = VariableDocumentCache.getMessagePartsForVariable((URL)this.m_bpelModel.getBPELProject().getBPELFileURL(), (QName)msgQName);
                    if (partList == null) break block12;
                    for (int i = 0; i < partList.size(); ++i) {
                        WSDLPartData part = (WSDLPartData)partList.get(i);
                        MessagePart msgPart = ConversionUtil.createMessagePart((WSDLPartData)part);
                        VariableMessagePartExplorerTreeNode explorerNode = new VariableMessagePartExplorerTreeNode(part.getPartName(), 27, msgPart, this.m_bpelModel, this.m_variable, this.m_activity);
                        explorerNode.setWSDLPartData(part);
                        explorerNode.storeData("RESOLVER_KEY", this.m_resolver);
                        if (dynaSchema != null) {
                            explorerNode.storeData("ANYTYPE_SCHEMA_INFO_KEY", dynaSchema);
                        }
                        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode((Object)explorerNode);
                        newNode.add((MutableTreeNode)new DummyNode());
                        nodes.add(newNode);
                    }
                    break block13;
                }
                String realNamespace = msgQName.getNamespaceURI();
                List list = wsdlModel.getWSDLFilesWithNamespace(msgQName.getNamespaceURI(), project, this.m_process);
                Iterator it = list.iterator();
                boolean bShown = false;
                partList = new ArrayList<WSDLPartData>();
                while (it.hasNext() && !bShown) {
                    URI wsdlURI = (URI)it.next();
                    try {
                        WSDLPartData[] parts = WSDLUtil.getParts((URI)wsdlURI, (String)msgQName.getLocalPart(), (String)realNamespace);
                        if (parts == null) continue;
                        bShown = true;
                        for (int i = 0; i < parts.length; ++i) {
                            WSDLPartData part = parts[i];
                            partList.add(part);
                            MessagePart msgPart = ConversionUtil.createMessagePart((WSDLPartData)part);
                            VariableMessagePartExplorerTreeNode explorerNode = new VariableMessagePartExplorerTreeNode(part.getPartName(), 27, msgPart, this.m_bpelModel, this.m_variable, this.m_activity);
                            explorerNode.setWSDLPartData(part);
                            explorerNode.storeData("RESOLVER_KEY", this.m_resolver);
                            if (dynaSchema != null) {
                                explorerNode.storeData("ANYTYPE_SCHEMA_INFO_KEY", dynaSchema);
                            }
                            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode((Object)explorerNode);
                            newNode.add((MutableTreeNode)new DummyNode());
                            nodes.add(newNode);
                        }
                    }
                    catch (Exception e) {
                        ExplorerTreeNode n = new ExplorerTreeNode("Could not retrieve message parts!", 31, (Object)e);
                        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(n);
                        return new DefaultMutableTreeNode[]{treeNode};
                    }
                }
                if (partList.size() <= 0) break block13;
                VariableDocumentCache.putMessagePartsForVariable((URL)project.getBPELFileURL(), (QName)msgQName, partList);
                break block13;
            }
            if (elemQName != null) {
                DefaultMutableTreeNode[] elementNodes;
                VariableElementTypeExplorerTreeNode elementDataSource = new VariableElementTypeExplorerTreeNode("Element Name Here!", 29, this.m_variable, this.m_bpelModel, this.m_variable, this.m_activity);
                if (dynaSchema != null) {
                    elementDataSource.storeData("ANYTYPE_SCHEMA_INFO_KEY", dynaSchema);
                }
                if ((elementNodes = elementDataSource.getChildNodes()) != null) {
                    for (int i = 0; i < elementNodes.length; ++i) {
                        DefaultMutableTreeNode elementNode = elementNodes[i];
                        nodes.add(elementNode);
                    }
                }
            }
        }
        return nodes.toArray(new DefaultMutableTreeNode[0]);
    }
}

