/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.namespace.QName;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Type;
import oracle.tip.tools.ide.common.bpeldesigner.caches.VariableDocumentCache;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ElementAnyTypeExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeDataSource;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.RecursiveElementTypeExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.DynamicSchemaInfo;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.ResolvedDocumentCacheKey;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.ResolvedDocumentObj;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.SchemaResolvedObj;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.datasources.schema.ComplexTypeExplorerTreeNode;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.common.xsdgrammar.SchemaBuilder;
import oracle.tip.tools.ide.common.xsdgrammar.SchemaGrammar;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VariableElementTypeExplorerTreeNode
extends ExplorerTreeNode
implements ExplorerTreeDataSource {
    protected Variable m_variable;
    protected Activity m_activity;
    protected BPELXmlModel m_bpelModel;

    public VariableElementTypeExplorerTreeNode(String text, int type, Object data, BPELXmlModel m, Variable var, Activity a) {
        super(text, type, data);
        this.m_activity = a;
        this.m_variable = var;
        this.m_bpelModel = m;
    }

    public DefaultMutableTreeNode[] getChildNodes() {
        Variable var = this.m_variable;
        String rootElement = null;
        SchemaResolvedObj obj = null;
        String namespaceURI = null;
        try {
            Process process;
            QName qname = var.getElement();
            if (qname == null) {
                return new DefaultMutableTreeNode[0];
            }
            rootElement = qname.getLocalPart();
            namespaceURI = qname.getNamespaceURI();
            if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                return new DefaultMutableTreeNode[0];
            }
            WSDLModel wsdlModel = this.m_bpelModel.getWSDLModel();
            obj = wsdlModel.resolveNamespace(process = this.m_bpelModel.getProcess(), namespaceURI, rootElement, true);
            if (obj == null) {
                return new DefaultMutableTreeNode[0];
            }
            QName rootQName = null;
            QName typeQName = null;
            rootQName = new QName(namespaceURI, rootElement);
            ResolvedDocumentCacheKey key = new ResolvedDocumentCacheKey(rootQName, typeQName);
            ResolvedDocumentObj rObj = null;
            MapperNSResolver resolver = process.getNSResolver();
            NSResolverFactory.fillNSFromProcess((MapperNSResolver)resolver, (Activity)this.m_activity, (Process)process);
            if (rObj == null) {
                rObj = SchemaResolvedObj.buildResolvedDocument((SchemaResolvedObj)obj, (QName)rootQName, typeQName, (MapperNSResolver)resolver);
                BPELProject prj = this.m_bpelModel.getBPELProject();
                VariableDocumentCache.putResolvedDocumentObj((URL)prj.getBPELFileURL(), (ResolvedDocumentCacheKey)key, (ResolvedDocumentObj)rObj);
            }
            if (rObj != null && rObj.getDocument() != null) {
                DefaultMutableTreeNode root = this.buildTreeNodes(rObj.getDocument().getDocumentElement(), rObj, resolver);
                ArrayList<TreeNode> l = new ArrayList<TreeNode>();
                for (int i = 0; i < root.getChildCount(); ++i) {
                    l.add(root.getChildAt(i));
                }
                return l.toArray(new DefaultMutableTreeNode[0]);
            }
        }
        catch (MalformedURLException me) {
            me.printStackTrace();
            ExplorerTreeNode n = new ExplorerTreeNode("Bad URL encountered!", 31, (Object)me);
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(n);
            return new DefaultMutableTreeNode[]{treeNode};
        }
        catch (Exception sge) {
            sge.printStackTrace();
            ExplorerTreeNode n = new ExplorerTreeNode("Problem building schema!", 31, (Object)sge);
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(n);
            return new DefaultMutableTreeNode[]{treeNode};
        }
        return new DefaultMutableTreeNode[0];
    }

    protected DefaultMutableTreeNode buildTreeNodes(Element parentElem, ResolvedDocumentObj rObj, MapperNSResolver resolver) {
        boolean bRecursiveNode = SchemaBuilder.isRecursiveStop((Element)parentElem);
        boolean bExpandStopped = SchemaBuilder.isExpandStopped((Element)parentElem);
        boolean bSupportAnyType = false;
        DynamicSchemaInfo info = (DynamicSchemaInfo)this.getData("ANYTYPE_SCHEMA_INFO_KEY");
        if (info != null) {
            QName qname = new QName(parentElem.getAttribute("namespace"), parentElem.getAttribute("localName"));
            if (SchemaBuilder.isAnyType((Element)parentElem) && info.getAnyTypeQName() != null && qname.equals(info.getAnyTypeQName())) {
                bSupportAnyType = true;
            }
        }
        ElementAnyTypeExplorerTreeNode parentNode = null;
        if (bRecursiveNode || bExpandStopped) {
            parentNode = new RecursiveElementTypeExplorerTreeNode(parentElem.getTagName(), 28, (Object)parentElem, rObj.getGrammarInfo(), bRecursiveNode, bExpandStopped);
        } else if (bSupportAnyType) {
            parentNode = new ElementAnyTypeExplorerTreeNode(parentElem.getTagName(), 28, (Object)parentElem);
            parentNode.storeData((Object)"ANYTYPE_SCHEMA_INFO_KEY", (Object)info);
        } else {
            parentNode = new ExplorerTreeNode(parentElem.getTagName(), 28, (Object)parentElem);
        }
        parentNode.storeData((Object)"UI_DOM_KEY", (Object)rObj.getDocument());
        parentNode.storeData((Object)"RESOLVER_KEY", (Object)resolver);
        DefaultMutableTreeNode parentTreeNode = new DefaultMutableTreeNode(parentNode);
        if (bRecursiveNode || bExpandStopped || bSupportAnyType) {
            parentTreeNode.add((MutableTreeNode)new DummyNode());
        } else {
            VariableElementTypeExplorerTreeNode.buildEntityKeyNode(parentTreeNode, parentElem, rObj.getGrammarInfo().getSchemaGrammars());
            Iterator it = XMLHelper.getChildElementIterator((Element)parentElem);
            while (it.hasNext()) {
                Element e = (Element)it.next();
                DefaultMutableTreeNode childTreeNode = this.buildTreeNodes(e, rObj, resolver);
                parentTreeNode.add(childTreeNode);
            }
        }
        return parentTreeNode;
    }

    public static void buildEntityKeyNode(DefaultMutableTreeNode parentTreeNode, Element e, SchemaGrammar[] grammars) {
        String schemaType = e.getAttribute("schemaType");
        if (schemaType.indexOf("attribute") >= 0) {
            return;
        }
        QName typeQN = new QName(e.getAttribute("namespace"), e.getAttribute("localName"));
        Annotation ann = null;
        List list = null;
        for (SchemaGrammar g : grammars) {
            ElementDef def = g.getElementDefByQName(new QName(e.getAttribute("namespace"), e.getAttribute("localName")));
            if (def != null) {
                ann = def.getAnnotation();
                list = ComplexTypeExplorerTreeNode.findEntityKeys((Annotation)ann);
                if (list != null && list.size() > 0) break;
                Type type = def.getType();
                if (type == null) continue;
                ann = type.getAnnotation();
                list = ComplexTypeExplorerTreeNode.findEntityKeys((Annotation)ann);
                break;
            }
            String typeName = e.getAttribute("type");
            Type type = null;
            if (Helper.hasValue((String)typeName)) {
                type = g.getTypeByName(typeName);
            }
            if (type == null) continue;
            ann = type.getAnnotation();
            list = ComplexTypeExplorerTreeNode.findEntityKeys((Annotation)ann);
            break;
        }
        if ((list = ComplexTypeExplorerTreeNode.findEntityKeys(ann)) == null || list.size() == 0) {
            return;
        }
        for (Node key : list) {
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(new ExplorerTreeNode(XMLHelper.getElementAsText((Element)((Element)key), (boolean)true), 43, (Object)key));
            parentTreeNode.add(typeNode);
        }
    }
}

