/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.wsdl.Definition;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.util.BPELModelerUtil;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.ImportDialog;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.partnerlink.PartnerLinkChooser;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;

public class SchemaImportDialog
extends ImportDialog {
    protected JTextField m_partnerLinkField;
    protected JComboBox m_partnerLinkCB;
    protected JButton m_partnerLinkBrowseBtn;
    protected BPELGraphPane m_graph;
    protected Activity m_process;
    protected JButton m_helpBtn;

    public SchemaImportDialog(JFrame f, String title, int type, BPELGraphPane graph) {
        super(f, title, type);
        this.m_impType = type;
        this.m_graph = graph;
        if (this.m_graph != null) {
            this.m_process = ((BPELGraphModel)this.m_graph.getModel()).getProcess();
            this.populatePartnerLinks();
        }
    }

    protected void createControls() {
        super.createControls();
        this.m_partnerLinkCB = new JComboBox();
        this.m_partnerLinkCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("wsdl_node")));
        this.m_partnerLinkCB.addActionListener((ActionListener)((Object)this));
        if (this.m_impType == 0) {
            BPELStringTranslator.setButton(this.m_jdevAddCB, MessageBundleUtil.getCommonString((String)"COPY_SCHEMA_TO_PROJECT", (String)"&Copy schema file to project"));
        } else {
            BPELStringTranslator.setButton(this.m_jdevAddCB, MessageBundleUtil.getCommonString((String)"COPY_WSDL_TO_PROJECT", (String)"&Copy WSDL file to project"));
        }
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener((ActionListener)((Object)this));
    }

    protected void layoutControls() {
        JLabel urlLbl = new JLabel();
        BPELStringTranslator.setLabel(urlLbl, this.m_urlField, MessageBundleUtil.getCommonString((String)"M_URL", (String)"&URL:"));
        JLabel plLbl = new JLabel();
        BPELStringTranslator.setLabel(plLbl, this.m_partnerLinkField, MessageBundleUtil.getCommonString((String)"M_IMPORT_INTO", (String)"&Import Into:"));
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_browseBtn);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        UIHelper.addComponent((Container)c, (Component)urlLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)this.m_urlField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)tb, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)this.m_jdevAddCB, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)plLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)this.m_partnerLinkCB, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 5, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row, (int)2, (int)1, (int)14, (int)0, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        this.setSize(400, 160);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void handlePartnerLinkBrowse() {
        PartnerLinkChooser dlg = new PartnerLinkChooser(GraphUtils.getFrame((Component)((Object)this)), this.m_graph, this.m_process);
        if (dlg.display() == 0) {
            PartnerLink pl = dlg.getSelectedPartnerLink();
            if (pl != null) {
                this.m_partnerLinkField.setText(pl.getName());
            } else {
                this.m_partnerLinkField.setText("");
            }
        }
    }

    protected void populatePartnerLinks() {
        BPELProject prj = this.m_graph.getBPELProject();
        Map map = BPELModelerUtil.getWSDLURIsForPartnerLinks((Process)((Process)this.m_process), (DeploymentFile)prj.getDeploymentFile());
        if (map == null) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)"In order to save property/property alias, you must have a partner link located under the current project directory.", (int)0);
            return;
        }
        Object[] objs = map.keySet().toArray();
        for (int i = 0; i < objs.length; ++i) {
            try {
                Object name = objs[i];
                URI u = (URI)map.get(name);
                if (URLFileSystem.isBaseURLFor((URL)prj.getBPELDirectoryURL(), (URL)u.toURL())) continue;
                map.remove(name);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Object[] values = map.values().toArray();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                String url = null;
                try {
                    url = URLFileSystem.getFileName((URL)((URI)values[i]).toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                model.addElement(url);
            }
        }
        this.m_partnerLinkCB.setModel(model);
    }

    public void saveWSDLFile() {
        URL importURL = null;
        String ns = null;
        URL url = this.getURL();
        if (url == null) {
            UIHelper.displayErrorMessage((Component)((Object)this), (String)MessageBundleUtil.getCommonString((String)"ID_INVALID_URL", (String)"Invalid URL!"));
            return;
        }
        importURL = this.getAddToProject() ? URLFactory.newURL((URL)this.m_graph.getBPELProject().getXSDRoot(), (String)URLFileSystem.getFileName((URL)url)) : url;
        String wsdlFile = (String)this.m_partnerLinkCB.getSelectedItem();
        if (wsdlFile != null) {
            URL wsdlURL = URLFactory.newURL((URL)this.m_graph.getBPELProject().getWSDLRoot(), (String)wsdlFile);
            try {
                if (this.m_impType == 0) {
                    XSDBuilder builder = new XSDBuilder();
                    XMLSchema schema = builder.build(importURL);
                    ns = schema.getSchemaTargetNS();
                } else {
                    Definition def = WSDLUtil.parseWSDL((URL)importURL);
                    ns = def.getTargetNamespace();
                }
                WSDLUtil.addImportToWSDL((BPELProject)this.m_graph.getBPELProject(), (URL)wsdlURL, (URL)importURL, (String)ns);
            }
            catch (Exception ex) {
                if (url.getProtocol().startsWith("http")) {
                    return;
                }
                ex.printStackTrace();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src != this.m_helpBtn) {
            super.actionPerformed(e);
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void helpInvoked() {
        String topicId = HelpSystem.getHelpTopicId(SchemaImportDialog.class.getName());
        HelpSystem.showHelp((Window)((Object)this), (Component)((Object)this), topicId);
    }
}

