/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;
import oracle.tip.tools.ide.pm.gui.explorer.PropertyAliasTreeCellPanel;

public class PropertyAliasTreeCellPanelMouseListener
extends MouseAdapter {
    protected PropertyAliasTreeCellPanel m_expanded;
    protected PropertyAliasTreeCellPanel m_collapsed;
    protected ExplorerTree m_explorer;

    public PropertyAliasTreeCellPanelMouseListener(PropertyAliasTreeCellPanel expanded, PropertyAliasTreeCellPanel collapsed, ExplorerTree explorer) {
        this.m_expanded = expanded;
        this.m_collapsed = collapsed;
        this.m_explorer = explorer;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.handleMouseClick(e);
    }

    protected void handleMouseClick(MouseEvent e) {
        int y;
        int x = e.getX();
        TreePath p = this.m_explorer.m_tree.getPathForLocation(x, y = e.getY());
        if (p != null) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)p.getLastPathComponent();
            if (!(n.getUserObject() instanceof ExplorerTreeNode)) {
                return;
            }
            ExplorerTreeNode explorerNode = (ExplorerTreeNode)n.getUserObject();
            if (explorerNode.m_type != 20) {
                return;
            }
            Boolean bIsExpanded = (Boolean)explorerNode.getData((Object)"EXPANDED");
            PropertyAliasTreeCellPanel pnl = bIsExpanded != false ? this.m_expanded : this.m_collapsed;
            Rectangle r = this.m_explorer.m_tree.getPathBounds(p);
            Rectangle btnBounds = new Rectangle(r.x + pnl.m_insidePnl.getBounds().x + pnl.m_expandLbl.getBounds().x, r.y + pnl.m_insidePnl.getBounds().y + pnl.m_expandLbl.getBounds().y, pnl.m_expandLbl.getBounds().width, pnl.m_expandLbl.getBounds().height);
            if (btnBounds.contains(x, y)) {
                if (bIsExpanded.booleanValue()) {
                    explorerNode.storeData((Object)"EXPANDED", (Object)new Boolean(false));
                    explorerNode.setShowDetails(false);
                } else {
                    explorerNode.storeData((Object)"EXPANDED", (Object)new Boolean(true));
                    explorerNode.setShowDetails(true);
                }
                this.m_explorer.updateNodeDisplay((DefaultMutableTreeNode)p.getLastPathComponent());
            }
        }
    }
}

