/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.net.URL;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeDataSource;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.datasources.schema.SchemaDataSource;
import oracle.tip.tools.ide.common.datasources.schema.SchemaTypeExplorerTreeNode;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.typeexplorer.ExceptionTreeNode;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorerTreeNode;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerTreeNode;
import oracle.tip.tools.ide.common.utils.SchemaInfo;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;

public class ProjectSchemaExplorerTreeNode
extends ExplorerTreeNode
implements ExplorerTreeDataSource {
    protected URL m_url;
    protected SchemaInfo m_schemaInfo;
    protected boolean m_bShowElements;
    protected boolean m_bShowComplex;
    protected int m_sourceType = -1;
    protected BPELGraphPane m_graph;
    protected SchemaDataSource m_dataSource;

    public ProjectSchemaExplorerTreeNode(String text, int type, URL data, boolean bShowComplex, boolean bShowElements) {
        super(text, type, (Object)data);
        this.m_bShowComplex = bShowComplex;
        this.m_bShowElements = bShowElements;
        this.m_url = data;
        this.m_dataSource = new SchemaDataSource(data, bShowComplex, bShowElements, 1);
    }

    public DefaultMutableTreeNode[] getChildNodes() {
        ArrayList<DefaultMutableTreeNode> lst = new ArrayList<DefaultMutableTreeNode>();
        TreeExplorerTreeNode[] roots = this.m_dataSource.getRoots();
        if (roots.length == 0) {
            return new DefaultMutableTreeNode[0];
        }
        TreeExplorerTreeNode root = roots[0];
        try {
            for (TreeExplorerTreeNode child : root.getChildren()) {
                DefaultMutableTreeNode node = this.getExplorerTreeNode((TypeExplorerTreeNode)child);
                if (node == null) continue;
                lst.add(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lst.toArray(new DefaultMutableTreeNode[lst.size()]);
    }

    private DefaultMutableTreeNode getExplorerTreeNode(TypeExplorerTreeNode typeNode) {
        if (typeNode instanceof SchemaTypeExplorerTreeNode) {
            SchemaTypeExplorerTreeNode schemaNode = (SchemaTypeExplorerTreeNode)typeNode;
            URL u = (URL)schemaNode.getDataValue("RESOURCE_URL_KEY");
            if (u != null) {
                ProjectSchemaExplorerTreeNode importSchemaNode = new ProjectSchemaExplorerTreeNode(URLFileSystem.getFileName((URL)u), 15, u, true, true);
                DefaultMutableTreeNode resultNode = new DefaultMutableTreeNode((Object)importSchemaNode);
                DummyNode dummy = new DummyNode(MessageBundleUtil.getCommonString((String)"DEFAULT", (String)"default"));
                resultNode.add((MutableTreeNode)dummy);
                return resultNode;
            }
            return null;
        }
        if (typeNode instanceof ExceptionTreeNode) {
            ExceptionTreeNode exNode = (ExceptionTreeNode)typeNode;
            ExplorerTreeNode explorerNode = new ExplorerTreeNode("Exception", 31, (Object)exNode.getException());
            return new DefaultMutableTreeNode(explorerNode);
        }
        TypeObject obj = (TypeObject)typeNode.getNodeData();
        if (obj == null) {
            return null;
        }
        int type = obj.getType();
        if (type == 1) {
            type = 34;
        } else if (type == 2) {
            type = 35;
        }
        ExplorerTreeNode explorerNode = new ExplorerTreeNode(typeNode.getDisplayName(), type, (Object)typeNode.getNodeText());
        return new DefaultMutableTreeNode(explorerNode);
    }
}

