/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PartnerLinkType;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Role;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeDataSource;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.util.BPELModelerUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.PartnerLinkWSDLUtil;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeUtil;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class PLExplorerTreeNode
extends ExplorerTreeNode
implements ExplorerTreeDataSource {
    protected BPELGraphPane m_graph;
    protected PartnerLink m_partnerLink;

    public PLExplorerTreeNode(String text, int type, Object data) {
        super(text, type, data);
    }

    private String computeWarning(PartnerLink l) {
        BPELGraphModel m;
        ValidationReport report;
        if (l != null && (report = l.getValidationReport(new ValidationContext((m = (BPELGraphModel)this.m_graph.getModel()).getProcess()), false)) != null && report.getState() == 1) {
            return "<html><body><b>" + BPELStringTranslator.getString("WARNING") + "</b>" + report.toString() + "</body></html>";
        }
        return null;
    }

    public void setGraph(BPELGraphPane graph) {
        this.m_graph = graph;
    }

    public BPELGraphPane getGraphPane() {
        return this.m_graph;
    }

    public PartnerLink getPartnerLink() {
        return this.m_partnerLink;
    }

    public void setPartnerLink(PartnerLink partnerLink) {
        this.m_partnerLink = partnerLink;
        this.m_warning = this.computeWarning(this.m_partnerLink);
    }

    public DefaultMutableTreeNode[] getChildNodes() {
        List<DefaultMutableTreeNode> roles = this.populateRoles();
        return roles.toArray(new DefaultMutableTreeNode[roles.size()]);
    }

    protected List<DefaultMutableTreeNode> populateRoles() {
        URI uri;
        ArrayList<DefaultMutableTreeNode> roleLst = new ArrayList<DefaultMutableTreeNode>();
        String wsdlLoc = this.m_partnerLink.getWSDLLocation();
        if (wsdlLoc == null || wsdlLoc.length() == 0) {
            return roleLst;
        }
        try {
            uri = new URI(URIUtil.escapeURIString((String)wsdlLoc));
        }
        catch (Exception e) {
            return roleLst;
        }
        QName partnerLinkType = this.m_partnerLink.getPartnerLinkType();
        if (partnerLinkType == null) {
            return roleLst;
        }
        Definition def = null;
        Map nsMap = null;
        try {
            def = WSDLUtil.parseWSDLDocument((URI)uri);
            nsMap = BPELModelerUtil.getWSDLNamespaceMap((URI)uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            ExplorerTreeNode n = new ExplorerTreeNode("Error parsing WSDL!", 31, (Object)e);
            roleLst.add(new DefaultMutableTreeNode(n));
            return roleLst;
        }
        Map map = PartnerLinkWSDLUtil.getPartnerLinkTypes((Definition)def);
        if (map != null && map.size() > 0) {
            String modelNamespace = partnerLinkType.getNamespaceURI();
            String modelLocalPart = partnerLinkType.getLocalPart();
            Iterator it = map.keySet().iterator();
            PartnerLinkType wsdlPartnerLinkType = null;
            while (it.hasNext()) {
                QName qName = (QName)it.next();
                String wsdlNamespace = qName.getNamespaceURI();
                String wsdlLocalPart = qName.getLocalPart();
                if (modelNamespace == null || modelLocalPart == null || wsdlNamespace == null || wsdlLocalPart == null || !wsdlNamespace.equalsIgnoreCase(modelNamespace) || !wsdlLocalPart.equalsIgnoreCase(modelLocalPart)) continue;
                wsdlPartnerLinkType = (PartnerLinkType)map.get(qName);
                break;
            }
            if (wsdlPartnerLinkType == null) {
                return roleLst;
            }
            Map rolesMap = wsdlPartnerLinkType.getRoles();
            for (Role r : rolesMap.values()) {
                PortType wsdlPortType = r.getPortType();
                String pt = "PortType - " + wsdlPortType.getQName().getLocalPart();
                ExplorerTreeNode portTypeObj = new ExplorerTreeNode(pt, 37, (Object)wsdlPortType);
                portTypeObj.storeData((Object)"def", (Object)def);
                portTypeObj.storeData((Object)"uri", (Object)uri);
                DefaultMutableTreeNode portTypeNode = new DefaultMutableTreeNode(portTypeObj);
                ExplorerTreeNode roleObj = new ExplorerTreeNode("Role - " + r.getName(), 36, (Object)r);
                roleObj.storeData((Object)"uri", (Object)uri);
                DefaultMutableTreeNode roleNode = new DefaultMutableTreeNode(roleObj);
                roleNode.add(portTypeNode);
                roleLst.add(roleNode);
                this.populateOperations(portTypeNode, wsdlPortType, nsMap);
            }
        }
        return roleLst;
    }

    protected void populateOperations(DefaultMutableTreeNode portTypeNode, PortType portType, Map namespaceMap) {
        for (Operation op : portType.getOperations()) {
            ExplorerTreeUtil.buildOperationNode(this.m_graph, portTypeNode, op, namespaceMap);
        }
    }
}

