/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.OperationDataPanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class OperationDialog
extends BPELBaseDialog
implements ActionListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private JButton m_okBtn;
    private JButton m_cancelBtn;
    protected OperationDataPanel m_operationPanel;
    protected BPELGraphPane m_graph;
    protected PartnerLink m_link;
    protected Definition m_def;
    protected int m_retVal = 1;
    protected boolean m_bEditing = false;
    protected URI m_uri;
    protected PortType m_pt;

    public OperationDialog(JFrame f, Definition def, URI uri, PortType pt, BPELGraphPane graph, boolean bEditing) {
        super(f, "Operation", true);
        this.m_def = def;
        this.m_uri = uri;
        this.m_pt = pt;
        this.m_graph = graph;
        this.m_bEditing = bEditing;
        this.createAndLayoutControls();
        this.updateButtons();
    }

    public Operation getOperation() {
        return this.m_operationPanel.getOperation();
    }

    public String getOperationName() {
        return this.m_operationPanel.m_nameField.getText();
    }

    public void saveToModel() {
        this.m_operationPanel.saveToModel();
    }

    public int create() {
        this.setTitle("Create Operation");
        return this.display();
    }

    public int edit(Operation op) {
        this.setTitle(BPELStringTranslator.getString("EDIT_OPERTATION", "Edit Operation"));
        this.m_operationPanel.setOperation(op);
        return this.display();
    }

    private int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createAndLayoutControls() {
        this.m_operationPanel = new OperationDataPanel(this.m_def, this.m_uri, this.m_pt, this.m_graph, this.m_bEditing);
        DocumentListener lst = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                OperationDialog.this.updateButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OperationDialog.this.updateButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OperationDialog.this.updateButtons();
            }
        };
        this.m_operationPanel.m_nameField.getDocument().addDocumentListener(lst);
        this.m_operationPanel.m_inputField.getDocument().addDocumentListener(lst);
        this.m_operationPanel.m_inputNameField.getDocument().addDocumentListener(lst);
        this.m_operationPanel.m_outputNameField.getDocument().addDocumentListener(lst);
        this.m_operationPanel.m_outputField.getDocument().addDocumentListener(lst);
        this.m_operationPanel.m_faultNameField.getDocument().addDocumentListener(lst);
        this.m_operationPanel.m_faultField.getDocument().addDocumentListener(lst);
        this.m_operationPanel.m_inputBorder.addActionListener((ActionListener)this);
        this.m_operationPanel.m_outputBorder.addActionListener((ActionListener)this);
        this.m_operationPanel.m_faultBorder.addActionListener((ActionListener)this);
        this.m_operationPanel.addPropertyChangeListener(this);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_operationPanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(375, 450);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(true);
    }

    protected boolean isValidData() {
        return this.m_operationPanel.isDataValid();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            if (!this.isValidData()) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)"There are invalid data, Please check again!");
                return;
            }
            this.saveToModel();
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_operationPanel.m_inputBorder || src == this.m_operationPanel.m_outputBorder || src == this.m_operationPanel.m_faultBorder) {
            this.updateButtons();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.m_operationPanel) {
            this.updateButtons();
        }
    }
}

