/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooserListener;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorer;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.ui.CheckBoxBorder;
import oracle.tip.tools.ide.common.ui.DoubleClickListener;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.ImageColumnTableCellRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.fault.FaultDialog;
import oracle.tip.tools.ide.pm.gui.explorer.FaultTableModel;
import oracle.tip.tools.ide.pm.gui.explorer.MessageTypeDataSource;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class OperationDataPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final String TYPE_SELECTED = "TYPE_SELECTED";
    protected JTextField m_nameField;
    protected JTextField m_inputNameField;
    protected JTextField m_outputNameField;
    protected JTextField m_faultNameField;
    protected JTextField m_inputField;
    protected JTextField m_outputField;
    protected JTextField m_faultField;
    protected JButton m_inputBrowseBtn;
    protected JButton m_outputBrowseBtn;
    protected JButton m_faultBrowseBtn;
    protected JButton m_addFaultBtn;
    protected JButton m_removeFaultBtn;
    protected JButton m_editFaultBtn;
    protected JTable m_faultTable;
    protected CheckBoxBorder m_inputBorder;
    protected CheckBoxBorder m_outputBorder;
    protected CheckBoxBorder m_faultBorder;
    protected TreeExplorerDataSource m_simpleDataSource;
    protected TreeExplorerDataSource m_messageTypeDataSource;
    protected TreeExplorerDataSource m_elementDataSource;
    protected TypeObject m_messageTypeTypeObject;
    protected TypeObject m_elementTypeObject;
    protected TypeObject m_simpleTypeObject;
    protected URL m_nodeURL;
    protected BPELGraphPane m_graph;
    protected Definition m_def;
    protected QName m_inputMsg;
    protected QName m_outputMsg;
    protected URI m_uri;
    protected PortType m_pt;
    protected Operation m_operation;
    protected String m_origOpName;
    protected boolean m_bEditing = false;

    public OperationDataPanel(Definition def, URI uri, PortType pt, BPELGraphPane graph, boolean bEditing) {
        this.m_def = def;
        this.m_uri = uri;
        this.m_pt = pt;
        this.m_graph = graph;
        this.m_bEditing = bEditing;
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        this.m_messageTypeDataSource = new MessageTypeDataSource(p, this.m_graph.getBPELProject());
        this.createControls();
        this.layoutControls();
    }

    public Operation getOperation() {
        return this.m_operation;
    }

    public void setOperation(Operation op) {
        this.m_operation = op;
        if (op != null) {
            this.m_nameField.setText(op.getName());
        }
        this.loadProperties(op);
    }

    protected void loadProperties(Operation op) {
        Input input = op.getInput();
        Output output = op.getOutput();
        Map faultmap = op.getFaults();
        if (input != null) {
            this.m_inputBorder.setSelected(true);
            this.m_inputNameField.setText(input.getName());
            this.m_inputMsg = input.getMessage().getQName();
            this.m_inputField.setText(input.getMessage().getQName().toString());
        } else {
            this.m_inputBorder.setSelected(false);
        }
        if (output != null) {
            this.m_outputBorder.setSelected(true);
            this.m_outputNameField.setText(output.getName());
            this.m_outputMsg = output.getMessage().getQName();
            this.m_outputField.setText(output.getMessage().getQName().toString());
        } else {
            this.m_outputBorder.setSelected(false);
        }
        if (faultmap != null && faultmap.size() > 0) {
            this.m_faultBorder.setSelected(true);
            if (faultmap != null) {
                Vector<Fault> data = new Vector<Fault>();
                FaultTableModel model = (FaultTableModel)((Object)this.m_faultTable.getModel());
                for (Fault fault : faultmap.values()) {
                    data.addElement(fault);
                }
                model.setData(data);
            }
        } else {
            this.m_faultBorder.setSelected(false);
        }
    }

    public boolean isDataValid() {
        FaultTableModel model;
        Vector data;
        String s = this.m_nameField.getText();
        if (s == null || s.length() == 0) {
            return false;
        }
        if (this.m_inputBorder.isSelected() && this.m_inputMsg == null) {
            return false;
        }
        if (this.m_outputBorder.isSelected() && this.m_outputMsg == null) {
            return false;
        }
        return !this.m_faultBorder.isSelected() || (data = (model = (FaultTableModel)((Object)this.m_faultTable.getModel())).getData()).size() != 0;
    }

    public void saveToModel() {
        if (this.m_messageTypeTypeObject != null) {
            URL url = (URL)this.m_messageTypeTypeObject.getData("RESOURCE_URL_KEY");
            this.m_def = WSDLUtil.addImportToWSDL((URI)this.m_uri, (URL)url, (Definition)this.m_def);
        }
        if (!this.m_bEditing) {
            String opname = this.m_nameField.getText();
            this.m_operation = this.m_def.createOperation();
            this.m_operation.setName(opname);
            PortType pt = this.m_def.getPortType(this.m_pt.getQName());
            this.m_operation.setUndefined(false);
            pt.addOperation(this.saveOp(this.m_operation));
        } else {
            String newName = this.m_nameField.getText();
            Operation op = this.m_def.createOperation();
            op.setName(newName);
            op.setUndefined(false);
            PortType pt = this.m_def.getPortType(this.m_pt.getQName());
            List oplst = pt.getOperations();
            for (Object o : oplst) {
                Operation oper = (Operation)o;
                if (!oper.getName().equals(this.m_operation.getName())) continue;
                oplst.remove(oper);
                break;
            }
            this.m_operation = this.saveOp(op);
            pt.addOperation(this.m_operation);
        }
        try {
            WSDLUtil.saveWSDLFile((URL)this.m_uri.toURL(), (Definition)this.m_def);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public Operation saveOp(Operation op) {
        Message msg;
        String inputname = null;
        String outputname = null;
        if (this.m_inputBorder.isSelected()) {
            inputname = this.m_inputNameField.getText();
            Input input = this.m_def.createInput();
            msg = this.m_def.getMessage(this.m_inputMsg);
            if (Helper.hasValue((String)inputname)) {
                input.setName(inputname);
            }
            input.setMessage(msg);
            op.setInput(input);
        }
        if (this.m_outputBorder.isSelected()) {
            outputname = this.m_outputNameField.getText();
            Output output = this.m_def.createOutput();
            msg = this.m_def.getMessage(this.m_outputMsg);
            if (Helper.hasValue((String)outputname)) {
                output.setName(outputname);
            }
            output.setMessage(msg);
            op.setOutput(output);
        }
        if (this.m_faultBorder.isSelected()) {
            FaultTableModel model = (FaultTableModel)((Object)this.m_faultTable.getModel());
            Vector data = model.getData();
            for (int i = 0; i < data.size(); ++i) {
                Fault fault = (Fault)data.elementAt(i);
                op.addFault(fault);
            }
        }
        return op;
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_inputNameField = new JTextField();
        this.m_faultNameField = new JTextField();
        this.m_outputNameField = new JTextField();
        this.m_inputField = new JTextField();
        this.m_inputField.setEditable(false);
        this.m_faultField = new JTextField();
        this.m_faultField.setEditable(false);
        this.m_outputField = new JTextField();
        this.m_outputField.setEditable(false);
        this.m_inputBrowseBtn = UIHelper.createBrowseButton((String)MessageBundleUtil.getCommonString((String)"TOP_BROWSE_MESSAGE_TYPES", (String)"Browse Message Types"));
        this.m_inputBrowseBtn.addActionListener(this);
        this.m_outputBrowseBtn = UIHelper.createBrowseButton((String)MessageBundleUtil.getCommonString((String)"TOP_BROWSE_ELEMENTS", (String)"Browse Elements"));
        this.m_outputBrowseBtn.addActionListener(this);
        this.m_faultBrowseBtn = UIHelper.createBrowseButton((String)MessageBundleUtil.getCommonString((String)"TOP_BROWSE_XML_SCHEMA_TYPES", (String)"Browse XML Schema Types"));
        this.m_faultBrowseBtn.addActionListener(this);
        this.m_addFaultBtn = UIHelper.createModelerButton((String)BPELStringTranslator.getString("ADD_BUTTON_TEXT_RES_D"), (Icon)ImageCache.getIcon("add16"));
        BPELStringTranslator.setButton(this.m_addFaultBtn, BPELStringTranslator.getString("ADD_BUTTON_TEXT_RES_D"));
        this.m_addFaultBtn.setToolTipText(BPELStringTranslator.getString("ADD_BUTTON_TEXT"));
        this.m_addFaultBtn.addActionListener(this);
        this.m_removeFaultBtn = UIHelper.createModelerButton((String)BPELStringTranslator.getString("DEL_BUTTON_TEXT_RES_T"), (Icon)ImageCache.getIcon("delete16"));
        BPELStringTranslator.setButton(this.m_removeFaultBtn, BPELStringTranslator.getString("DEL_BUTTON_TEXT_RES_T"));
        this.m_removeFaultBtn.setToolTipText(BPELStringTranslator.getString("DEL_BUTTON_TEXT"));
        this.m_removeFaultBtn.addActionListener(this);
        this.m_editFaultBtn = UIHelper.createModelerButton((String)BPELStringTranslator.getString("EDIT_BUTTON_TEXT_RES_E"), (Icon)ImageCache.getIcon("edit16"));
        BPELStringTranslator.setButton(this.m_editFaultBtn, BPELStringTranslator.getString("EDIT_BUTTON_TEXT_RES_E"));
        this.m_editFaultBtn.setToolTipText(BPELStringTranslator.getString("EDIT_BUTTON_TEXT"));
        this.m_editFaultBtn.addActionListener(this);
        this.m_faultTable = new JTable((TableModel)((Object)new FaultTableModel()));
        GrayCellRenderer r = new GrayCellRenderer();
        this.m_faultTable.getSelectionModel().addListSelectionListener(this);
        TableColumnModel colModel = this.m_faultTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer((TableCellRenderer)new ImageColumnTableCellRenderer(GlobalImageCache.getIcon((String)"fault16.png")));
            }
            col.setCellRenderer(r);
            col.setPreferredWidth(120);
        }
        this.m_faultTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = OperationDataPanel.this.m_faultTable.rowAtPoint(origin);
                int column = OperationDataPanel.this.m_faultTable.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    OperationDataPanel.this.handleEditFault();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    protected JPanel createInputPanel() {
        JLabel nameLbl = new JLabel(BPELStringTranslator.getString("EDITOR_PS_NAME", "Name:"));
        JLabel messageLbl = new JLabel(BPELStringTranslator.getString("MESSAGE:", "Message:"));
        ToolBar inputTB = new ToolBar();
        inputTB.add((Component)this.m_inputBrowseBtn);
        JPanel p = new JPanel(new GridBagLayout());
        this.m_inputBorder = new CheckBoxBorder((JComponent)p, " " + BPELStringTranslator.getString("INPUT", "Input") + " ");
        p.setBorder((Border)this.m_inputBorder);
        int row = 0;
        GraphUtils.addComponent((Container)p, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_inputNameField, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)messageLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)p, (Component)this.m_inputField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)p, (Component)inputTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        return p;
    }

    protected JPanel createOutputPanel() {
        JLabel nameLbl = new JLabel(BPELStringTranslator.getString("EDITOR_PS_NAME", "Name:"));
        JLabel messageLbl = new JLabel(BPELStringTranslator.getString("MESSAGE:", "Message:"));
        ToolBar outputTB = new ToolBar();
        outputTB.add((Component)this.m_outputBrowseBtn);
        JPanel p = new JPanel(new GridBagLayout());
        this.m_outputBorder = new CheckBoxBorder((JComponent)p, " " + BPELStringTranslator.getString("OUTPUT", "Output") + " ");
        p.setBorder((Border)this.m_outputBorder);
        int row = 0;
        GraphUtils.addComponent((Container)p, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_outputNameField, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)messageLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)p, (Component)this.m_outputField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)p, (Component)outputTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        return p;
    }

    protected JPanel createFaultPanel() {
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_addFaultBtn);
        tb.add((Component)this.m_editFaultBtn);
        tb.add((Component)this.m_removeFaultBtn);
        JPanel p = new JPanel(new GridBagLayout());
        this.m_faultBorder = new CheckBoxBorder((JComponent)p, " " + BPELStringTranslator.getString("FAULT", "Fault") + " ");
        p.setBorder((Border)this.m_faultBorder);
        JScrollPane sp = new JScrollPane(this.m_faultTable);
        sp.getViewport().setBackground(Color.white);
        int row = 0;
        GraphUtils.addComponent((Container)p, (Component)tb, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)sp, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        this.m_faultBorder.setSelected(false);
        return p;
    }

    protected void layoutControls() {
        JLabel nameLbl = new JLabel(BPELStringTranslator.getString("EDITOR_PS_NAME"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.createInputPanel(), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.createOutputPanel(), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.createFaultPanel(), (int)0, (int)row++, (int)2, (int)1, (int)18, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleMessageTypeBrowse(Object src) {
        final TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this));
        TypeChooserListener listener = new TypeChooserListener(){

            public void typeSelectionOccurred() {
                chooser.getOkButton().setEnabled(false);
                TypeObject to = chooser.getTypeObject();
                if (to != null) {
                    chooser.getOkButton().setEnabled(to.getType() == 3);
                }
            }
        };
        chooser.setTypeChooserListener(listener);
        TypeExplorer explorer = chooser.getTypeExplorer();
        explorer.removeAllDoubleClickListener();
        DoubleClickListener lst = new DoubleClickListener(){

            public void onDoubleClick(Object src) {
                TypeObject to = chooser.getTypeObject();
                if (to != null && to.getType() == 3) {
                    chooser.handleOK();
                }
            }
        };
        explorer.addDoubleClickListener(lst);
        if (chooser.display(this.m_messageTypeDataSource) == 0) {
            this.m_messageTypeTypeObject = chooser.getTypeObject();
            if (src == this.m_inputBrowseBtn) {
                this.m_inputMsg = this.m_messageTypeTypeObject.getQName();
                this.m_inputField.setText(this.m_messageTypeTypeObject.getQName().toString());
            } else if (src == this.m_outputBrowseBtn) {
                this.m_outputMsg = this.m_messageTypeTypeObject.getQName();
                this.m_outputField.setText(this.m_messageTypeTypeObject.getQName().toString());
            }
            this.firePropertyChange(TYPE_SELECTED, null, this.m_messageTypeTypeObject.getQName());
        }
    }

    protected void handleAddFault() {
        ArrayList<Fault> list = new ArrayList<Fault>();
        FaultDialog dlg = new FaultDialog(GraphUtils.getFrame((Component)this), this.m_def, this.m_graph);
        FaultTableModel model = (FaultTableModel)((Object)this.m_faultTable.getModel());
        Vector data = model.getData();
        for (int i = 0; i < data.size(); ++i) {
            Fault fault = (Fault)data.elementAt(i);
            list.add(fault);
        }
        if (dlg.create(list) != 0) {
            return;
        }
        Fault newRow = dlg.getFault();
        model.getData().addElement(newRow);
        model.refresh();
        this.updateButtons();
    }

    protected void handleEditFault() {
        ListSelectionModel model = this.m_faultTable.getSelectionModel();
        if (model.isSelectionEmpty()) {
            return;
        }
        int row = model.getLeadSelectionIndex();
        FaultTableModel tableModel = (FaultTableModel)((Object)this.m_faultTable.getModel());
        Fault data = (Fault)tableModel.getRowData(row);
        FaultDialog dlg = new FaultDialog(GraphUtils.getFrame((Component)this), this.m_def, this.m_graph);
        Vector v = tableModel.getData();
        ArrayList<Fault> list = new ArrayList<Fault>();
        for (int i = 0; i < v.size(); ++i) {
            Fault fault = (Fault)v.elementAt(i);
            list.add(fault);
        }
        if (dlg.edit(list, data) == 0) {
            tableModel.refresh();
        }
    }

    protected void handleRemoveFault() {
        TableModel model = this.m_faultTable.getModel();
        if (model instanceof BaseTableModel) {
            BaseTableModel tabModel = (BaseTableModel)model;
            int[] rows = this.m_faultTable.getSelectedRows();
            tabModel.removeRows(rows);
            this.updateButtons();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addFaultBtn) {
            this.handleAddFault();
        } else if (src == this.m_editFaultBtn) {
            this.handleEditFault();
        } else if (src == this.m_removeFaultBtn) {
            this.handleRemoveFault();
        } else if (src == this.m_inputBrowseBtn || src == this.m_outputBrowseBtn) {
            this.handleMessageTypeBrowse(src);
        }
    }

    protected void updateButtons() {
        ListSelectionModel model = this.m_faultTable.getSelectionModel();
        this.m_removeFaultBtn.setEnabled(!model.isSelectionEmpty());
        this.m_editFaultBtn.setEnabled(!model.isSelectionEmpty());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    class GrayCellRenderer
    extends DefaultTableCellRenderer {
        GrayCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!table.isEnabled()) {
                this.setForeground(Color.gray);
            } else {
                this.setForeground(Color.black);
            }
            return c;
        }
    }
}

