/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ImageColumnTableCellRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.common.utils.MessageType;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.MessagePartDialog;
import oracle.tip.tools.ide.pm.gui.explorer.MessagePartTableModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class MessageTypePanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JButton m_addPartBtn;
    protected JButton m_removePartBtn;
    protected JButton m_editPartBtn;
    protected JToolBar m_toolBar;
    protected JTextField m_nameField;
    protected JTable m_partsTable;
    protected BPELGraphPane m_graph;
    protected JCheckBox m_showNamespaceURICB;
    protected MessageType m_messageType;
    protected String m_oldName = "";

    public MessageTypePanel(BPELGraphPane graph) {
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    public void saveToModel() {
        if (this.m_messageType == null) {
            this.m_messageType = new MessageType();
        }
        this.m_messageType.setName(this.m_nameField.getText());
        this.m_messageType.clearParts();
        MessagePartTableModel model = (MessagePartTableModel)((Object)this.m_partsTable.getModel());
        Vector v = model.getData();
        for (int i = 0; i < v.size(); ++i) {
            this.m_messageType.addPart((MessagePart)v.elementAt(i));
        }
    }

    public boolean isDataValid() {
        return Helper.hasValue((String)this.m_nameField.getText());
    }

    public void setMessageType(MessageType type) {
        this.m_messageType = type;
        if (this.m_messageType != null) {
            this.m_nameField.setText(this.m_messageType.getName());
        }
        MessagePartTableModel model = (MessagePartTableModel)((Object)this.m_partsTable.getModel());
        model.getData().removeAllElements();
        for (MessagePart p : type.getParts()) {
            model.getData().addElement(p);
        }
        model.refresh();
    }

    public MessageType getMessageType() {
        return this.m_messageType;
    }

    protected void createControls() {
        this.m_addPartBtn = UIHelper.createToolBarButton((int)3);
        this.m_addPartBtn.addActionListener(this);
        this.m_removePartBtn = UIHelper.createToolBarButton((int)2);
        this.m_removePartBtn.addActionListener(this);
        this.m_editPartBtn = UIHelper.createToolBarButton((int)1);
        this.m_editPartBtn.addActionListener(this);
        this.m_nameField = new JTextField();
        this.m_nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MessageTypePanel.this.firePropertyChange("NAME_CHANGED", MessageTypePanel.this.m_oldName, MessageTypePanel.this.m_nameField.getText());
                MessageTypePanel.this.m_oldName = MessageTypePanel.this.m_nameField.getText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MessageTypePanel.this.firePropertyChange("NAME_CHANGED", MessageTypePanel.this.m_oldName, MessageTypePanel.this.m_nameField.getText());
                MessageTypePanel.this.m_oldName = MessageTypePanel.this.m_nameField.getText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MessageTypePanel.this.firePropertyChange("NAME_CHANGED", MessageTypePanel.this.m_oldName, MessageTypePanel.this.m_nameField.getText());
                MessageTypePanel.this.m_oldName = MessageTypePanel.this.m_nameField.getText();
            }
        });
        this.m_partsTable = new JTable((TableModel)((Object)new MessagePartTableModel()));
        this.m_partsTable.getSelectionModel().addListSelectionListener(this);
        TableColumnModel colModel = this.m_partsTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer((TableCellRenderer)new ImageColumnTableCellRenderer(ImageCache.getIcon("message_part_node")));
            }
            col.setPreferredWidth(120);
        }
        this.m_partsTable.setAutoResizeMode(0);
        this.m_partsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = MessageTypePanel.this.m_partsTable.rowAtPoint(origin);
                int column = MessageTypePanel.this.m_partsTable.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    MessageTypePanel.this.editPart();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.m_showNamespaceURICB = new JCheckBox(BPELStringTranslator.getString("EDITOR_MSG_TYPE_PNL_NS_URI"), true);
        this.m_showNamespaceURICB.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_addPartBtn);
        btnPnl.add(this.m_removePartBtn);
        ToolBar toolBar = new ToolBar();
        toolBar.add((Component)this.m_addPartBtn);
        toolBar.add((Component)this.m_editPartBtn);
        toolBar.add((Component)this.m_removePartBtn);
        JPanel propsPnl = new JPanel(new GridBagLayout());
        propsPnl.setBorder(new TitledBorder(BPELStringTranslator.getString("EDITOR_MSG_TYPE_PNL_MSG_PARTS")));
        GraphUtils.addComponent((Container)propsPnl, (Component)toolBar, (int)0, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(2, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)propsPnl, (Component)GraphUtils.getScrollPane((Component)this.m_partsTable), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)propsPnl, (Component)this.m_showNamespaceURICB, (int)0, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(2, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setLayout(new GridBagLayout());
        int row = 0;
        JLabel lblName = new JLabel();
        BPELStringTranslator.setLabel(lblName, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        GraphUtils.addComponent((Container)this, (Component)lblName, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)propsPnl, (int)0, (int)row, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void removeParts() {
        int[] rows = this.m_partsTable.getSelectedRows();
        if (rows != null && rows.length > 0) {
            MessagePartTableModel model = (MessagePartTableModel)((Object)this.m_partsTable.getModel());
            model.removeRows(rows);
        }
    }

    protected void editPart() {
        int[] rows = this.m_partsTable.getSelectedRows();
        if (rows != null && rows.length > 0) {
            int row = rows[0];
            MessagePartTableModel model = (MessagePartTableModel)((Object)this.m_partsTable.getModel());
            MessagePart part = (MessagePart)model.getRowData(row);
            MessagePartDialog dlg = new MessagePartDialog(GraphUtils.getFrame((Component)this), this.m_graph);
            if (dlg.edit(part) == 0) {
                model.getData().setElementAt(dlg.getMessagePart(), row);
                model.fireTableDataChanged();
            }
        }
    }

    protected void handleAdd() {
        MessagePartDialog dlg = new MessagePartDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        if (dlg.create() == 0) {
            MessagePart part = dlg.getMessagePart();
            MessagePartTableModel model = (MessagePartTableModel)((Object)this.m_partsTable.getModel());
            model.getData().addElement(part);
            model.fireTableDataChanged();
        }
    }

    protected void updateButtons() {
        this.m_addPartBtn.setEnabled(true);
        int numSelectedRows = this.m_partsTable.getSelectedRowCount();
        if (numSelectedRows > 0) {
            this.m_removePartBtn.setEnabled(true);
            this.m_editPartBtn.setEnabled(true);
        } else {
            this.m_removePartBtn.setEnabled(false);
            this.m_editPartBtn.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addPartBtn) {
            this.handleAdd();
        } else if (src == this.m_showNamespaceURICB) {
            MessagePartTableModel model = (MessagePartTableModel)((Object)this.m_partsTable.getModel());
            model.setExpandPrefixes(this.m_showNamespaceURICB.isSelected());
            model.fireTableDataChanged();
        } else if (src == this.m_editPartBtn) {
            this.editPart();
        } else if (src == this.m_removePartBtn) {
            this.removeParts();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }
}

