/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.caches.VariableDocumentCache;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.MessageType;
import oracle.tip.tools.ide.common.utils.WSDLMessage;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.MessageTypePanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class MessageTypeDialog
extends BPELBaseDialog
implements ActionListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected MessageTypePanel m_msgTypePanel;
    protected int m_retVal = 1;
    protected BPELGraphPane m_graph;
    protected boolean m_bEditing;

    public MessageTypeDialog(JFrame f, BPELGraphPane graph) {
        super(f, BPELStringTranslator.getString("EDITOR_MSG_TYPE_DS_MSG_TYPE"), true);
        this.m_graph = graph;
        this.createAndLayoutControls();
    }

    public MessageType getMessageType() {
        return this.m_msgTypePanel.getMessageType();
    }

    public int edit(MessageType type) {
        this.m_bEditing = true;
        this.m_msgTypePanel.setMessageType(type);
        this.setTitle(BPELStringTranslator.getString("EDITOR_MSG_TYPE_DLG_EDIT") + " - " + type.getName());
        return this.display();
    }

    public int create() {
        this.m_bEditing = false;
        this.setTitle(BPELStringTranslator.getString("EDITOR_MSG_TYPE_DLG_CRE"));
        return this.display();
    }

    public int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createAndLayoutControls() {
        this.m_msgTypePanel = new MessageTypePanel(this.m_graph);
        this.m_msgTypePanel.addPropertyChangeListener(this);
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_msgTypePanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 380);
        this.setLocationRelativeTo(this.getParent());
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.m_msgTypePanel.isDataValid());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.m_msgTypePanel) {
            this.updateButtons();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            if (!this.m_msgTypePanel.isDataValid()) {
                GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("EDITOR_MSG_TYPE_SETTINGS_INVALID"), (int)0);
                return;
            }
            if (this.m_bEditing) {
                String newName;
                MessageType type = this.m_msgTypePanel.getMessageType();
                String origName = type.getName();
                if (!origName.equalsIgnoreCase(newName = this.m_msgTypePanel.m_nameField.getText()) && this.nameExists(newName)) {
                    GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("EDITOR_MSG_TYPE_ALREADY_EXISTS"), (int)0);
                    return;
                }
                URL bpelURL = this.m_graph.getBPELProject().getBPELFileURL();
                VariableDocumentCache.clearMessagePartsCache((URL)bpelURL, (QName)new QName(type.getNamespace(), type.getName()));
            } else {
                String newName = this.m_msgTypePanel.m_nameField.getText();
                if (this.nameExists(newName)) {
                    GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("EDITOR_MSG_TYPE_ALREADY_EXISTS"), (int)0);
                    return;
                }
            }
            this.m_msgTypePanel.saveToModel();
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void helpInvoked() {
        this.handleHelp(this.m_msgTypePanel);
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected boolean nameExists(String name) {
        WSDLMessage[] messages = new WSDLMessage[]{};
        try {
            WSDLModel wsdlModel = this.m_graph.getBPELXmlModel().getWSDLModel();
            messages = wsdlModel.getMessages();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (messages != null) {
            for (WSDLMessage wsdlMessage : messages) {
                String s = wsdlMessage.getMessageName();
                if (s == null || !s.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }
}

