/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.schema.ProjectSchemaDataSource;
import oracle.tip.tools.ide.common.datasources.schema.SchemaDataSource;
import oracle.tip.tools.ide.common.datasources.schema.SchemaTypesDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.ProjectWSDLDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.WSDLDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.WSDLDataSourceObject;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorer;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.typeexplorer.WSDLImportHandler;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinkTypesDataSource;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ProjectSchemaImportHandler;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ProjectWSDLImportHandler;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class MessagePartTypePanel
extends JPanel
implements ActionListener {
    public static final String TYPE_SELECTED = "TYPE_SELECTED";
    private static Icon SIMPLE_TYPE_ICON = GlobalImageCache.getIcon((String)"simpletype16.png");
    private static Icon ELEMENT_TYPE_ICON = GlobalImageCache.getIcon((String)"element.png");
    protected TypeObject m_typeTypeObj;
    protected TypeObject m_elementTypeObj;
    protected JRadioButton m_elementRB;
    protected JRadioButton m_typeRB;
    protected JTextField m_elementField;
    protected JTextField m_typeField;
    protected JButton m_elementBrowseBtn;
    protected JButton m_typeBrowseBtn;
    protected TreeExplorerDataSource m_typeDataSource;
    protected TreeExplorerDataSource m_elementDataSource;
    protected BPELGraphPane m_graph;

    public MessagePartTypePanel(BPELGraphPane graph) {
        this.m_graph = graph;
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        CompoundDataSource compound = new CompoundDataSource();
        compound.addDataSource((TreeExplorerDataSource)new ProjectSchemaDataSource((IDEProject)graph.getBPELProject(), true, false));
        compound.addDataSource((TreeExplorerDataSource)new ProjectWSDLDataSource(graph.getBPELProject(), true, false, false));
        compound.addDataSource((TreeExplorerDataSource)new PartnerLinkTypesDataSource(process, true, false, false, true));
        compound.addDataSource((TreeExplorerDataSource)new SchemaTypesDataSource());
        this.m_typeDataSource = compound;
        compound = new CompoundDataSource();
        compound.addDataSource((TreeExplorerDataSource)new ProjectSchemaDataSource((IDEProject)graph.getBPELProject(), false, true));
        compound.addDataSource((TreeExplorerDataSource)new ProjectWSDLDataSource(graph.getBPELProject(), false, true, false));
        compound.addDataSource((TreeExplorerDataSource)new PartnerLinkTypesDataSource(process, false, true, false, true));
        this.m_elementDataSource = compound;
        this.setBorder(new TitledBorder(BPELStringTranslator.getString("EDITOR_COR_SET_TBL_MODEL_COL_TYPE")));
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    public boolean isSimpleTypeSelected() {
        return this.m_typeRB.isSelected();
    }

    public boolean isElementSelected() {
        return this.m_elementRB.isSelected();
    }

    public TypeObject getTypeObject() {
        if (this.isSimpleTypeSelected()) {
            return this.m_typeTypeObj;
        }
        if (this.isElementSelected()) {
            return this.m_elementTypeObj;
        }
        return null;
    }

    public void setType(QName qname) {
        this.m_typeTypeObj = new TypeObject(0, (Object)qname);
        String s = "{" + qname.getNamespaceURI() + "}" + qname.getLocalPart();
        this.m_typeField.setText(s);
        this.m_typeField.setCaretPosition(0);
        this.m_typeRB.doClick();
    }

    public void setElementType(QName qname) {
        this.m_elementTypeObj = new TypeObject(0, (Object)qname);
        String s = "{" + qname.getNamespaceURI() + "}" + qname.getLocalPart();
        this.m_elementField.setText(s);
        this.m_elementField.setCaretPosition(0);
        this.m_elementRB.doClick();
    }

    protected void createControls() {
        this.m_elementRB = new JRadioButton(BPELStringTranslator.getString("EDITOR_MSG_PART_TBL_MDL_ELEM"));
        BPELStringTranslator.setButton(this.m_elementRB, BPELStringTranslator.getString("EDITOR_MSG_PART_TPE_PNL_ELEM_RES"));
        this.m_elementRB.addActionListener(this);
        this.m_typeRB = new JRadioButton(BPELStringTranslator.getString("EDITOR_COR_SET_TBL_MODEL_COL_TYPE"), true);
        BPELStringTranslator.setButton(this.m_typeRB, BPELStringTranslator.getString("EDITOR_COR_SET_PNL_TYPE"));
        this.m_typeRB.addActionListener(this);
        ButtonGroup g = new ButtonGroup();
        g.add(this.m_elementRB);
        g.add(this.m_typeRB);
        this.m_typeField = new JTextField();
        this.m_typeField.setEditable(false);
        this.m_elementField = new JTextField();
        this.m_elementField.setEditable(false);
        this.m_elementBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("EDITOR_MSG_PART_TPE_PNL_BWS_ELEM"));
        this.m_elementBrowseBtn.addActionListener(this);
        this.m_typeBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_BWS_TYPE"));
        this.m_typeBrowseBtn.addActionListener(this);
    }

    protected void layoutControls() {
        ToolBar typeBrowseTB = new ToolBar();
        typeBrowseTB.add((Component)this.m_typeBrowseBtn);
        ToolBar elementBrowseTB = new ToolBar();
        elementBrowseTB.add((Component)this.m_elementBrowseBtn);
        this.setLayout(new GridBagLayout());
        int row = 0;
        UIHelper.addComponent((Container)this, (Component)new JLabel(SIMPLE_TYPE_ICON), (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)this.m_typeRB, (int)1, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)this.m_typeField, (int)2, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)typeBrowseTB, (int)3, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)new JLabel(ELEMENT_TYPE_ICON), (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)this.m_elementRB, (int)1, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)this.m_elementField, (int)2, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)elementBrowseTB, (int)3, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    protected void handleTypeBrowse() {
        TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this));
        TypeExplorer explorer = chooser.getTypeExplorer();
        explorer.setWSDLImportHandler((WSDLImportHandler)new ComplexTypeWSDLImporter(this.m_graph));
        explorer.setSchemaImportHandler((SchemaImportHandler)new ComplexTypeSchemaImporter(this.m_graph));
        if (chooser.display(this.m_typeDataSource) == 0) {
            this.m_typeTypeObj = chooser.getTypeObject();
            this.m_typeField.setText(this.m_typeTypeObj.getQName().toString());
            this.firePropertyChange(TYPE_SELECTED, null, this.m_typeTypeObj.getQName());
        }
    }

    protected void updateButtons() {
        this.m_typeField.setEnabled(this.m_typeRB.isSelected());
        this.m_typeBrowseBtn.setEnabled(this.m_typeRB.isSelected());
        this.m_typeField.setEnabled(this.m_typeRB.isSelected());
        this.m_typeBrowseBtn.setEnabled(this.m_typeRB.isSelected());
        this.m_elementField.setEnabled(this.m_elementRB.isSelected());
        this.m_elementBrowseBtn.setEnabled(this.m_elementRB.isSelected());
    }

    protected void handleElementTypeBrowse() {
        TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this));
        TypeExplorer explorer = chooser.getTypeExplorer();
        explorer.setWSDLImportHandler((WSDLImportHandler)new ElementWSDLImporter(this.m_graph));
        explorer.setSchemaImportHandler((SchemaImportHandler)new ElementSchemaImporter(this.m_graph));
        if (chooser.display(this.m_elementDataSource) == 0) {
            this.m_elementTypeObj = chooser.getTypeObject();
            this.m_elementField.setText(this.m_elementTypeObj.getQName().toString());
            this.firePropertyChange(TYPE_SELECTED, null, this.m_elementTypeObj.getQName());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_typeRB || src == this.m_elementRB) {
            this.updateButtons();
            this.firePropertyChange(TYPE_SELECTED, null, this.m_typeRB);
        } else if (src == this.m_typeBrowseBtn) {
            this.handleTypeBrowse();
        } else if (src == this.m_elementBrowseBtn) {
            this.handleElementTypeBrowse();
        }
    }

    class ComplexTypeSchemaImporter
    extends ProjectSchemaImportHandler {
        public ComplexTypeSchemaImporter(BPELGraphPane graph) {
            super(graph, true);
        }

        public SchemaDataSource getSchemaDataSource(URL url) {
            return new SchemaDataSource(url, true, false, 6);
        }
    }

    class ElementSchemaImporter
    extends ProjectSchemaImportHandler {
        public ElementSchemaImporter(BPELGraphPane graph) {
            super(graph, true);
        }

        public SchemaDataSource getSchemaDataSource(URL url) {
            return new SchemaDataSource(url, false, true, 5);
        }
    }

    class ComplexTypeWSDLImporter
    extends ProjectWSDLImportHandler {
        public ComplexTypeWSDLImporter(BPELGraphPane graph) {
            super(graph, true);
        }

        @Override
        public WSDLDataSource getWSDLDataSource(URL url) {
            WSDLDataSourceObject obj = new WSDLDataSourceObject();
            obj.setUrl(url);
            obj.setShowComplex(true);
            obj.setShowElements(false);
            obj.setSourceFileType(5);
            return new WSDLDataSource(obj);
        }
    }

    class ElementWSDLImporter
    extends ProjectWSDLImportHandler {
        public ElementWSDLImporter(BPELGraphPane graph) {
            super(graph, true);
        }

        @Override
        public WSDLDataSource getWSDLDataSource(URL url) {
            WSDLDataSourceObject obj = new WSDLDataSourceObject();
            obj.setUrl(url);
            obj.setShowComplex(false);
            obj.setShowElements(true);
            obj.setSourceFileType(5);
            return new WSDLDataSource(obj);
        }
    }
}

