/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class MessagePartTableModel
extends BaseTableModel {
    public static final int IMAGE_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int TYPE_COLUMN = 2;
    public static final int QNAME_COLUMN = 3;
    public static final int SCHEMA_LOCATION_COLUMN = 4;
    public boolean m_bExpandPrefix = true;

    public void setExpandPrefixes(boolean bExpand) {
        this.m_bExpandPrefix = bExpand;
    }

    public Object getValueAt(int row, int col) {
        MessagePart part = (MessagePart)this.getRowData(row);
        switch (col) {
            case 1: {
                return part.m_name;
            }
            case 2: {
                if (part.m_type == 2) {
                    return BPELStringTranslator.getString("EDITOR_MSG_PART_TBL_MDL_COMP");
                }
                if (part.m_type == 1) {
                    return BPELStringTranslator.getString("EDITOR_MSG_PART_TBL_MDL_ELEM");
                }
                if (part.m_type == 3) {
                    return BPELStringTranslator.getString("EDITOR_MSG_PART_TBL_MDL_SIMPLE");
                }
                return "";
            }
            case 3: {
                if (part.m_qname != null) {
                    if (this.m_bExpandPrefix) {
                        String ns = part.m_qname.getNamespaceURI();
                        String local = part.m_qname.getLocalPart();
                        String s = "";
                        if (ns != null) {
                            s = s + "{" + ns + "}";
                        }
                        s = s + local;
                        return s;
                    }
                    String prefix = part.m_qname.getPrefix();
                    String local = part.m_qname.getLocalPart();
                    if (prefix == null || prefix.length() == 0) {
                        return local;
                    }
                    return prefix + ":" + local;
                }
                return "";
            }
            case 4: {
                return part.m_schemaLocation;
            }
        }
        return null;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return BPELStringTranslator.getString("EDITOR_VAR_TBL_MDL_NAME");
            }
            case 3: {
                return BPELStringTranslator.getString("EDITOR_MSG_PART_TBL_MDL_QNAME");
            }
            case 2: {
                return BPELStringTranslator.getString("EDITOR_VAR_TBL_MDL_TYPE");
            }
            case 4: {
                return BPELStringTranslator.getString("EDITOR_MSG_PART_TBL_MDL_SCHEMA_LOC");
            }
        }
        return " ";
    }

    public int getColumnCount() {
        return 5;
    }
}

