/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.MessagePartTypePanel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class MessagePartPanel
extends JPanel
implements KeyListener,
PropertyChangeListener {
    public static final String NAME_CHANGED = "NAME_CHANGED";
    public static final String TYPE_CHANGED = "TYPE_CHANGED";
    protected JTextField m_nameField;
    protected MessagePartTypePanel m_typePanel;
    protected BPELGraphPane m_graph;
    protected MessagePart m_msgPart;

    public MessagePartPanel(BPELGraphPane graph) {
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
    }

    public void setMessagePart(MessagePart p) {
        this.m_msgPart = p;
        if (this.m_msgPart != null) {
            this.m_nameField.setText(p.getName());
            if (p.getType() == 1) {
                this.m_typePanel.setElementType(p.getQName());
            } else {
                this.m_typePanel.setType(p.getQName());
            }
        }
    }

    public MessagePart getMessagePart() {
        if (this.m_msgPart == null) {
            this.m_msgPart = new MessagePart();
        }
        this.m_msgPart.m_name = this.m_nameField.getText();
        TypeObject to = this.m_typePanel.getTypeObject();
        this.m_msgPart.setSchemaLocation((URL)to.getData("RESOURCE_URL_KEY"));
        this.m_msgPart.m_qname = to.getQName();
        if (this.m_typePanel.isElementSelected()) {
            this.m_msgPart.m_type = 1;
        } else if (this.m_typePanel.isSimpleTypeSelected()) {
            this.m_msgPart.m_type = to.getType() == 2 ? 2 : 3;
        }
        return this.m_msgPart;
    }

    public boolean isDataValid() {
        String s = this.m_nameField.getText();
        if (s == null || s.length() == 0) {
            return false;
        }
        return this.m_typePanel.getTypeObject() != null;
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MessagePartPanel.this.firePropertyChange(MessagePartPanel.NAME_CHANGED, null, MessagePartPanel.this.m_nameField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MessagePartPanel.this.firePropertyChange(MessagePartPanel.NAME_CHANGED, null, MessagePartPanel.this.m_nameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MessagePartPanel.this.firePropertyChange(MessagePartPanel.NAME_CHANGED, null, MessagePartPanel.this.m_nameField.getText());
            }
        });
        this.m_typePanel = new MessagePartTypePanel(this.m_graph);
        this.m_typePanel.addPropertyChangeListener(this);
    }

    protected void layoutControls() {
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_typePanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        String prop = evt.getPropertyName();
        if (src == this.m_typePanel && prop.equalsIgnoreCase("TYPE_SELECTED")) {
            this.firePropertyChange(TYPE_CHANGED, null, this.m_typePanel);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object src = e.getSource();
        if (src == this.m_nameField) {
            this.firePropertyChange(NAME_CHANGED, "", this.m_nameField.getText());
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

