/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.MessagePartPanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class MessagePartDialog
extends BPELBaseDialog
implements ActionListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private JButton m_okBtn;
    private JButton m_cancelBtn;
    private JButton m_helpBtn;
    protected MessagePartPanel m_partPanel;
    protected int m_retVal = 1;
    protected BPELGraphPane m_graph;

    public MessagePartDialog(JFrame f, BPELGraphPane graph) {
        super(f, BPELStringTranslator.getString("EDITOR_MSG_PART_DLG"), true);
        this.m_graph = graph;
        this.createAndLayoutControls();
        this.updateButtons();
    }

    public MessagePart getMessagePart() {
        return this.m_partPanel.getMessagePart();
    }

    public int edit(MessagePart part) {
        this.setTitle(BPELStringTranslator.getString("EDITOR_MSG_PART_DLG_EDIT") + part.getName());
        this.m_partPanel.setMessagePart(part);
        return this.display();
    }

    public int create() {
        this.setTitle(BPELStringTranslator.getString("EDITOR_MSG_PART_DLG_CREATE"));
        return this.display();
    }

    private int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createAndLayoutControls() {
        this.m_partPanel = new MessagePartPanel(this.m_graph);
        this.m_partPanel.addPropertyChangeListener(this);
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_partPanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(400, 200);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.m_partPanel.isDataValid());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void helpInvoked() {
        this.handleHelp(this.m_partPanel);
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.m_partPanel && (evt.getPropertyName().equalsIgnoreCase("NAME_CHANGED") || evt.getPropertyName().equalsIgnoreCase("TYPE_CHANGED"))) {
            this.updateButtons();
        }
    }
}

