/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.RecursiveElementTypeExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.ResolvedDocumentObj;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.SchemaResolvedObj;
import oracle.tip.tools.ide.common.bpeldesigner.models.wsdl.PartItem;
import oracle.tip.tools.ide.common.bpeldesigner.util.ConversionUtil;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.common.utils.WSDLPartData;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.common.xsdgrammar.SchemaBuilder;
import oracle.tip.tools.ide.pm.addin.logging.BPELModelerLogger;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.PartnerLinkNamespaceResolver;
import org.w3c.dom.Element;

public class ExplorerTreeUtil {
    public static DefaultMutableTreeNode buildOperationNode(BPELGraphPane graph, DefaultMutableTreeNode portTypeNode, Operation op, Map namespaceMap) {
        Message outputMsg;
        Output output;
        Message inputMsg;
        ExplorerTreeNode userObj = new ExplorerTreeNode("Operation - " + op.getName(), 38, (Object)op);
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(userObj);
        portTypeNode.add(opNode);
        Input input = op.getInput();
        if (input != null && (inputMsg = input.getMessage()) != null) {
            ExplorerTreeUtil.populateMessage(graph, opNode, inputMsg, namespaceMap);
        }
        if ((output = op.getOutput()) != null && (outputMsg = output.getMessage()) != null) {
            ExplorerTreeUtil.populateMessage(graph, opNode, outputMsg, namespaceMap);
        }
        ExplorerTreeUtil.populateFaults(opNode, op);
        return opNode;
    }

    public static void populateMessage(BPELGraphPane graph, DefaultMutableTreeNode opNode, Message msg, Map map) {
        ExplorerTreeNode userObj = new ExplorerTreeNode(msg.getQName().getLocalPart(), 41, (Object)msg);
        DefaultMutableTreeNode msgNode = new DefaultMutableTreeNode(userObj);
        opNode.add(msgNode);
        ExplorerTreeUtil.populateMessageParts(graph, msgNode, msg, map);
    }

    public static void populateMessageParts(BPELGraphPane graph, DefaultMutableTreeNode msgNode, Message msg, Map map) {
        QName msgQName = msg.getQName();
        BPELGraphModel graphModel = (BPELGraphModel)graph.getModel();
        Process process = graphModel.getProcess();
        BPELProject project = graph.getBPELProject();
        BPELXmlModel bpelModel = graphModel.getBPELXmlModel();
        WSDLModel wsdlModel = bpelModel.getWSDLModel();
        if (msgQName != null) {
            String realNamespace = msgQName.getNamespaceURI();
            List list = wsdlModel.getWSDLFilesWithNamespace(msgQName.getNamespaceURI(), project, process);
            Iterator it = list.iterator();
            boolean bShown = false;
            while (it.hasNext() && !bShown) {
                URI wsdlURI = (URI)it.next();
                try {
                    WSDLPartData[] parts = WSDLUtil.getParts((URI)wsdlURI, (String)msgQName.getLocalPart(), (String)realNamespace);
                    if (parts == null) continue;
                    bShown = true;
                    for (int i = 0; i < parts.length; ++i) {
                        WSDLPartData part = parts[i];
                        MessagePart msgPart = ConversionUtil.createMessagePart((WSDLPartData)part);
                        ExplorerTreeNode obj = new ExplorerTreeNode(msgPart.getName(), 42, (Object)msgPart);
                        DefaultMutableTreeNode partNode = new DefaultMutableTreeNode(obj);
                        msgNode.add(partNode);
                        ExplorerTreeUtil.populateMessagePartItem(partNode, part, map);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void populateMessagePartItem(DefaultMutableTreeNode partNode, WSDLPartData partData, Map map) {
        String rootElement = null;
        URI uri = null;
        SchemaResolvedObj sObj = null;
        String namespaceURI = null;
        PartItem part = new PartItem(partData.getPartName(), partData.getTargetNamespace(), partData.getPartType(), partData.getPartXSDType());
        for (DefaultMutableTreeNode parent = (DefaultMutableTreeNode)partNode.getParent(); parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
            ExplorerTreeNode tn = (ExplorerTreeNode)parent.getUserObject();
            if (tn.m_type != 36) continue;
            uri = (URI)tn.getData((Object)"uri");
            break;
        }
        if (uri == null) {
            return;
        }
        boolean isElement = true;
        if (part != null) {
            rootElement = part.getPartType();
            namespaceURI = part.getNamespaceURI();
            isElement = part.getPartXSDType() != 2;
        }
        try {
            Object obj = WSDLUtil.resolvedSchema(uri, (String)namespaceURI, (String)rootElement, (boolean)isElement);
            if (obj != null) {
                WSDLUtil.WSDLSchemaWrapper w;
                Element elem;
                sObj = obj instanceof URI ? new SchemaResolvedObj((URI)obj) : (obj instanceof List ? new SchemaResolvedObj((List)obj, uri) : (obj instanceof WSDLUtil.WSDLSchemaWrapper ? ((elem = (w = (WSDLUtil.WSDLSchemaWrapper)obj).getSchemaElement()) != null ? new SchemaResolvedObj(elem, w.getURI()) : new SchemaResolvedObj(w.getSchemaElementList(), w.getURI())) : new SchemaResolvedObj((Element)obj, uri)));
            }
            QName rootQName = null;
            QName typeQName = null;
            if (part != null && part.getPartXSDType() == 2) {
                rootQName = new QName("", part.getPart());
                typeQName = new QName(namespaceURI, part.getPartType());
            } else {
                rootQName = new QName(namespaceURI, rootElement);
            }
            PartnerLinkNamespaceResolver resolver = new PartnerLinkNamespaceResolver(map);
            ResolvedDocumentObj rObj = SchemaResolvedObj.buildResolvedDocument((SchemaResolvedObj)sObj, (QName)rootQName, typeQName, (MapperNSResolver)resolver);
            if (rObj != null && rObj.getDocument() != null) {
                DefaultMutableTreeNode root = ExplorerTreeUtil.buildResolvedSchemaTree(rObj.getDocument().getDocumentElement(), rObj, resolver);
                for (int i = 0; i < root.getChildCount(); ++i) {
                    partNode.add((DefaultMutableTreeNode)root.getChildAt(i));
                }
            }
        }
        catch (Exception e) {
            BPELModelerLogger.showUserError(e);
        }
    }

    public static DefaultMutableTreeNode buildResolvedSchemaTree(Element parentElem, ResolvedDocumentObj rObj, MapperNSResolver resolver) {
        boolean bRecursiveNode = SchemaBuilder.isRecursiveStop((Element)parentElem);
        boolean bExpandStopped = SchemaBuilder.isExpandStopped((Element)parentElem);
        RecursiveElementTypeExplorerTreeNode parentNode = bRecursiveNode || bExpandStopped ? new RecursiveElementTypeExplorerTreeNode(parentElem.getTagName(), 28, (Object)parentElem, rObj.getGrammarInfo(), bRecursiveNode, bExpandStopped) : new ExplorerTreeNode(parentElem.getTagName(), 28, (Object)parentElem);
        parentNode.storeData((Object)"UI_DOM_KEY", (Object)rObj.getDocument());
        parentNode.storeData((Object)"RESOLVER_KEY", (Object)resolver);
        DefaultMutableTreeNode parentTreeNode = new DefaultMutableTreeNode(parentNode);
        if (bRecursiveNode || bExpandStopped) {
            parentTreeNode.add((MutableTreeNode)new DummyNode());
        } else {
            Iterator it = XMLHelper.getChildElementIterator((Element)parentElem);
            while (it.hasNext()) {
                Element e = (Element)it.next();
                DefaultMutableTreeNode childTreeNode = ExplorerTreeUtil.buildResolvedSchemaTree(e, rObj, resolver);
                parentTreeNode.add(childTreeNode);
            }
        }
        return parentTreeNode;
    }

    public static void populateFaults(DefaultMutableTreeNode opNode, Operation op) {
        Map faultsMap = op.getFaults();
        if (faultsMap == null) {
            return;
        }
        for (Fault f : faultsMap.values()) {
            ExplorerTreeNode userObj = new ExplorerTreeNode(f.getName(), 40, (Object)f);
            DefaultMutableTreeNode faultNode = new DefaultMutableTreeNode(userObj);
            opNode.add(faultNode);
        }
    }
}

