/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.common.bpelparser.search.SearchData;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerSearchResultCellRenderer;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeSearchCallback;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeSearchResult;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ExplorerTreeSearchPanel
extends JPanel
implements ActionListener {
    public static final String QUERY_PANEL = "QUERY_PANEL";
    public static final String RESULTS_PANEL = "RESULTS_PANEL";
    protected CardPanel m_cardPnl;
    protected JList m_list;
    protected JComboBox m_textCombo;
    protected JButton m_searchBtn;
    protected JButton m_queryCloseBtn;
    protected JButton m_resultsCloseBtn;
    protected JButton m_queryBtn;
    protected JCheckBox m_searchNodeCB;
    protected JCheckBox m_matchCaseCB;
    protected JCheckBox m_wholeWordCB;
    protected JRadioButton m_globalRB;
    protected JRadioButton m_selectBranchRB;
    protected ExplorerTree m_explorer;
    protected JPanel m_queryPanel;
    protected boolean m_bKeyListenerAttached = false;

    public ExplorerTreeSearchPanel(ExplorerTree explorer) {
        this.m_explorer = explorer;
        this.createControls();
        this.layoutControls();
        this.attachEnterKeyListener();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(80, 150);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (!this.m_bKeyListenerAttached) {
            this.attachEnterKeyListener();
        }
    }

    protected void attachEnterKeyListener() {
        AbstractAction keyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                ExplorerTreeSearchPanel.this.handleSearch();
            }
        };
        JRootPane rootPane = this.m_explorer.getRootPane();
        if (rootPane != null) {
            KeyStroke f1 = KeyStroke.getKeyStroke(10, 0, false);
            rootPane.getInputMap(2).put(f1, "ENTER_KEY");
            rootPane.getActionMap().put("ENTER_KEY", keyAction);
            this.m_bKeyListenerAttached = true;
        }
    }

    protected void createControls() {
        this.m_matchCaseCB = new JCheckBox("Match Case");
        this.m_matchCaseCB.setOpaque(false);
        BPELStringTranslator.setButton(this.m_matchCaseCB, BPELStringTranslator.getString("COLLAXALAF_TEXT_MATCH_CASE"));
        this.m_wholeWordCB = new JCheckBox("Whole Word");
        this.m_wholeWordCB.setOpaque(false);
        BPELStringTranslator.setButton(this.m_wholeWordCB, BPELStringTranslator.getString("COLLAXALAF_TEXT_WHOLE_WORD"));
        this.m_searchNodeCB = new JCheckBox("Search Selected Node");
        BPELStringTranslator.setButton(this.m_searchNodeCB, BPELStringTranslator.getString("SEARCH_SEARCH_SELECTED_NODE"));
        this.m_searchBtn = new JButton("Search");
        this.m_searchBtn.addActionListener(this);
        this.m_searchBtn.setToolTipText(BPELStringTranslator.getString("SEARCH_SEARCH_BTN_WITHOUT_M"));
        BPELStringTranslator.setButton(this.m_searchBtn, BPELStringTranslator.getString("SEARCH_SEARCH_BTN"));
        this.m_queryCloseBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("navigate_cross.png"));
        this.m_queryCloseBtn.setToolTipText(BPELStringTranslator.getString("EXPLORER_CLOSE"));
        this.m_queryCloseBtn.addActionListener(this);
        this.m_resultsCloseBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("navigate_cross.png"));
        this.m_resultsCloseBtn.setToolTipText(BPELStringTranslator.getString("EXPLORER_CLOSE"));
        this.m_resultsCloseBtn.addActionListener(this);
        this.m_queryBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("find.png"));
        this.m_queryBtn.addActionListener(this);
        this.m_queryBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_EXP_SEARCH_BTN"));
        this.m_cardPnl = new CardPanel();
        this.m_list = new JList();
        this.m_list.setCellRenderer(new ExplorerSearchResultCellRenderer());
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ExplorerTreeSearchPanel.this.selectExplorerTreeNode();
                }
            }
        });
        this.m_textCombo = new JComboBox();
        this.m_textCombo.setEditable(true);
        this.m_cardPnl.add(RESULTS_PANEL, (Component)this.createResultsPanel());
        this.m_queryPanel = this.createQueryPanel();
        this.m_cardPnl.add(QUERY_PANEL, (Component)this.m_queryPanel);
        this.m_cardPnl.show(QUERY_PANEL);
    }

    protected void enablePanel(Container c, boolean enabled) {
        for (int counter = c.getComponentCount() - 1; counter >= 0; --counter) {
            Component child = c.getComponent(counter);
            child.setEnabled(enabled);
            if (!(child instanceof Container)) continue;
            this.enablePanel((Container)child, enabled);
        }
    }

    protected JPanel createResultsPanel() {
        JLabel l = new JLabel();
        BPELStringTranslator.setLabel(l, this.m_list, BPELStringTranslator.getString("SEARCH_RESULTS"));
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 0, 0));
        btnPnl.setOpaque(false);
        btnPnl.add(this.m_queryBtn);
        btnPnl.add(this.m_resultsCloseBtn);
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(0, 5, 2, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)btnPnl, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)GraphUtils.getScrollPane((Component)this.m_list), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected JPanel createQueryPanel() {
        JLabel searchForLbl = new JLabel();
        BPELStringTranslator.setLabel(searchForLbl, this.m_textCombo, BPELStringTranslator.getString("SEARCH_SEARCH_FOR"));
        JPanel con = new JPanel(new GridBagLayout());
        con.setBackground(Color.white);
        con.setBorder(new LineBorder(Color.lightGray));
        GraphUtils.addComponent((Container)con, (Component)searchForLbl, (int)0, (int)1, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(0, 5, 2, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)con, (Component)this.m_queryCloseBtn, (int)1, (int)1, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)con, (Component)this.m_textCombo, (int)0, (int)2, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)con, (Component)this.createOptionsPanel(), (int)0, (int)3, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)con, (Component)this.m_searchBtn, (int)1, (int)4, (int)1, (int)1, (int)12, (int)0, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)con, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected JPanel createOptionsPanel() {
        this.m_globalRB = new JRadioButton("Global");
        this.m_globalRB.setOpaque(false);
        BPELStringTranslator.setButton(this.m_globalRB, BPELStringTranslator.getString("SEARCH_GLOBAL"));
        this.m_selectBranchRB = new JRadioButton("Selected Branch");
        this.m_selectBranchRB.setOpaque(false);
        BPELStringTranslator.setButton(this.m_selectBranchRB, BPELStringTranslator.getString("SEARCH_SELECTED_BRANCH"));
        ButtonGroup g = new ButtonGroup();
        g.add(this.m_globalRB);
        g.add(this.m_selectBranchRB);
        this.m_selectBranchRB.doClick();
        JPanel scopePnl = new JPanel(new GridLayout(2, 1, 0, 5));
        scopePnl.setOpaque(false);
        scopePnl.setBackground(Color.red);
        scopePnl.add(this.m_selectBranchRB);
        scopePnl.add(this.m_globalRB);
        JPanel optionsPnl = new JPanel(new GridLayout(2, 1, 0, 5));
        optionsPnl.setOpaque(false);
        optionsPnl.add(this.m_matchCaseCB);
        optionsPnl.add(this.m_wholeWordCB);
        JPanel optionsContainer = new JPanel(new GridBagLayout());
        optionsContainer.setOpaque(false);
        optionsContainer.setBorder(new TitledBorder(BPELStringTranslator.getString("COLLAXALAF_TEXT_OPTIONS")));
        GraphUtils.addComponent((Container)optionsContainer, (Component)optionsPnl, (int)0, (int)0, (int)1, (int)1, (int)10, (int)0, (Insets)new Insets(0, 0, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        JPanel scopesContainer = new JPanel(new GridBagLayout());
        scopesContainer.setOpaque(false);
        scopesContainer.setBorder(new TitledBorder(BPELStringTranslator.getString("EXPLORER_SCOPE")));
        GraphUtils.addComponent((Container)scopesContainer, (Component)scopePnl, (int)0, (int)0, (int)1, (int)1, (int)10, (int)0, (Insets)new Insets(0, 0, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        GraphUtils.addComponent((Container)p, (Component)optionsContainer, (int)0, (int)0, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)scopesContainer, (int)1, (int)0, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_cardPnl, (int)0, (int)2, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleSearch() {
        Object item = this.m_textCombo.getSelectedItem();
        if (item == null) {
            return;
        }
        String text = item.toString();
        if (text == null || text.trim().length() == 0) {
            return;
        }
        SearchData data = new SearchData();
        data.m_searchStr = text;
        data.m_bMatchCase = this.m_matchCaseCB.isSelected();
        data.m_bWholeWord = this.m_wholeWordCB.isSelected();
        this.enablePanel(this.m_queryPanel, false);
        ExplorerTreeSearchCallback callback = new ExplorerTreeSearchCallback(){

            @Override
            public void searchFinished(SearchData data, List result) {
                ExplorerTreeSearchPanel.this.setSearchResults(result);
                ExplorerTreeSearchPanel.this.enablePanel(ExplorerTreeSearchPanel.this.m_queryPanel, true);
            }
        };
        if (this.m_globalRB.isSelected()) {
            this.m_explorer.search(data, (DefaultMutableTreeNode)this.m_explorer.getTree().getModel().getRoot(), callback);
        } else {
            this.m_explorer.search(data, this.m_explorer.getSelectedTreeNode(), callback);
        }
    }

    protected void setSearchResults(List result) {
        boolean bAdd = true;
        String text = this.m_textCombo.getSelectedItem().toString();
        DefaultComboBoxModel comboModel = (DefaultComboBoxModel)this.m_textCombo.getModel();
        for (int i = 0; i < comboModel.getSize(); ++i) {
            String s = (String)comboModel.getElementAt(i);
            if (!s.equals(text)) continue;
            bAdd = false;
            break;
        }
        if (bAdd) {
            comboModel.addElement(text);
        }
        DefaultListModel<ExplorerTreeSearchResult> model = new DefaultListModel<ExplorerTreeSearchResult>();
        for (DefaultMutableTreeNode tn : result) {
            ExplorerTreeSearchResult item = new ExplorerTreeSearchResult();
            item.setTreeNode(tn);
            model.addElement(item);
        }
        this.m_list.setModel(model);
        this.m_cardPnl.show(RESULTS_PANEL);
        if (model.size() > 0) {
            this.m_list.setSelectedIndex(0);
        }
        if (result.size() > 0) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)result.get(0);
            TreePath p = this.m_explorer.getTreePathForNode(treeNode);
            this.m_explorer.getTree().setSelectionPath(p);
            this.m_explorer.getTree().scrollPathToVisible(p);
            this.m_explorer.getTree().requestFocus();
        }
    }

    protected void selectExplorerTreeNode() {
        ExplorerTreeSearchResult result = (ExplorerTreeSearchResult)this.m_list.getSelectedValue();
        if (result != null) {
            DefaultMutableTreeNode tn = result.getTreeNode();
            this.m_explorer.selectNode(tn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_searchBtn) {
            this.handleSearch();
        } else if (src == this.m_resultsCloseBtn || src == this.m_queryCloseBtn) {
            this.m_explorer.hideSearchPanel();
        } else if (src == this.m_queryBtn) {
            this.m_cardPnl.show(QUERY_PANEL);
        }
    }
}

