/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeDataSource;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.DraggableJTree;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;

public class ExplorerTreeNodeExpander {
    protected ExplorerTree m_explorer;

    public ExplorerTreeNodeExpander(ExplorerTree explorer) {
        this.m_explorer = explorer;
    }

    public void expand(DefaultMutableTreeNode treeNode) {
        DraggableJTree tree = this.m_explorer.getTree();
        this.buildTreeStructure(treeNode);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
        if (parent != null) {
            TreePath parentPath = this.m_explorer.getTreePathForNode((DefaultMutableTreeNode)treeNode.getParent());
            GraphUtils.expandTree((JTree)tree, (TreePath)parentPath, (TreeNode)treeNode);
        } else {
            GraphUtils.expandTree((JTree)tree);
        }
    }

    private void buildTreeStructure(DefaultMutableTreeNode n) {
        ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)n.getUserObject();
        if (explorerTreeNode instanceof ExplorerTreeDataSource) {
            ExplorerTreeDataSource ds = (ExplorerTreeDataSource)explorerTreeNode;
            if (n.getChildCount() > 0 && n.getChildAt(0) instanceof DummyNode) {
                DefaultMutableTreeNode[] nodes;
                n.removeAllChildren();
                for (DefaultMutableTreeNode childNode : nodes = ds.getChildNodes()) {
                    n.add(childNode);
                }
            }
        }
        for (int i = 0; i < n.getChildCount(); ++i) {
            DefaultMutableTreeNode cn = (DefaultMutableTreeNode)n.getChildAt(i);
            this.buildTreeStructure(cn);
        }
    }
}

