/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.ProcessExplorer;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;

public class ExplorerTreeDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_cancelBtn;
    protected JButton m_okBtn;
    protected JButton m_helpBtn;
    protected ProcessExplorer m_processExplorer;
    protected int m_retVal = 1;
    protected BPELGraphPane m_graph;
    protected int m_mask;

    public ExplorerTreeDialog(JFrame f, String title, BPELGraphPane graph, int mask) {
        super(f, title, true);
        this.m_mask = mask;
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
    }

    protected void createControls() {
        this.m_processExplorer = new ProcessExplorer();
        this.m_processExplorer.getExplorerTree().setMask(this.m_mask);
        this.m_processExplorer.getExplorerTree().showFilterButton(false);
        this.m_processExplorer.getExplorerTree().showRootNode(false);
        this.m_processExplorer.setGraphPane(this.m_graph);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_okBtn.setVisible(false);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("EDITOR_VALID_BWS_CLOSE"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_processExplorer, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(500, 500);
        this.setLocationRelativeTo(this.getParent());
    }

    public int display() {
        this.loadControls();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void loadControls() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ExplorerTreeDialog.this.m_processExplorer.loadExplorer(null);
                Runnable swingRunner = new Runnable(){

                    @Override
                    public void run() {
                        ExplorerTreeDialog.this.m_processExplorer.getExplorerTree().expandEntireTree();
                        DefaultTreeModel model = (DefaultTreeModel)ExplorerTreeDialog.this.m_processExplorer.getExplorerTree().getTree().getModel();
                        DefaultMutableTreeNode n = (DefaultMutableTreeNode)model.getRoot();
                        if (n != null && n.getChildCount() > 0) {
                            ExplorerTreeDialog.this.m_processExplorer.getExplorerTree().selectNode((DefaultMutableTreeNode)n.getChildAt(0));
                        }
                        ExplorerTreeDialog.this.enableUserInput(true);
                    }
                };
                SwingUtilities.invokeLater(swingRunner);
            }
        };
        new Thread(r).start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.m_retVal = 0;
            this.m_processExplorer.getExplorerTree().dereference();
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void helpInvoked() {
        String topicId;
        switch (this.m_mask) {
            case 1: {
                topicId = "bpmjdev_variables";
                break;
            }
            case 4: {
                topicId = "bpmjdev_partnerlinks";
                break;
            }
            case 2: {
                topicId = "bpmjdev_messagetypes";
                break;
            }
            case 8: {
                topicId = "bpmjdev_corrsets";
                break;
            }
            case 64: {
                topicId = "bpmjdev_props";
                break;
            }
            case 128: {
                topicId = "bpmjdev_propalias";
                break;
            }
            case 512: {
                topicId = "bpmjdev_sensors";
                break;
            }
            case 256: {
                topicId = "bpmjdev_sensactions";
                break;
            }
            default: {
                topicId = "bpmjdev_default_page";
            }
        }
        HelpSystem.showHelp((Window)((Object)this), this.m_processExplorer, topicId);
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }
}

